/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.composite;

import com.devexperts.logging.Logging;
import com.opensr5.ConfigurationImage;
import com.rusefi.composite.CompositeEvent;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;

public class CompositeParser {
    private static final Logging log = Logging.getLogging(CompositeParser.class);
    private static long prevTime = 0L;
    private static long timeAdder = 0L;

    public static List<CompositeEvent> parse(byte[] response) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(response);
        byteBuffer.order(ByteOrder.BIG_ENDIAN);
        int ptr = 1;
        ArrayList<CompositeEvent> events = new ArrayList<CompositeEvent>();
        while (ptr + 5 <= response.length) {
            long timestamp = Integer.toUnsignedLong(byteBuffer.getInt(ptr));
            byte flags = byteBuffer.get(ptr + 4);
            boolean primaryTrigger = ConfigurationImage.getBit(flags, 0);
            boolean secondaryTrigger = ConfigurationImage.getBit(flags, 1);
            boolean trg = ConfigurationImage.getBit(flags, 2);
            boolean sync = ConfigurationImage.getBit(flags, 3);
            boolean coil = ConfigurationImage.getBit(flags, 4);
            boolean injector = ConfigurationImage.getBit(flags, 5);
            ptr += 5;
            if (timestamp < prevTime) {
                timeAdder += 0x100000000L;
            }
            prevTime = timestamp;
            long curTime = timeAdder + timestamp;
            events.add(new CompositeEvent(curTime, primaryTrigger, secondaryTrigger, trg, sync, coil, injector));
        }
        return events;
    }
}

