/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.core.net;

import com.devexperts.logging.Logging;
import com.rusefi.core.net.ConnectionAndMeta;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public enum PropertiesHolder {
    INSTANCE;

    private static final Logging log;
    private static final String IO_PROPERTIES = "/shared_io.properties";
    private volatile Properties properties;

    public static String getProperty(String key, String defaultValue) {
        return INSTANCE.getProperties().getProperty(key, defaultValue);
    }

    public static String getProperty(String key) {
        return INSTANCE.getProperties().getProperty(key);
    }

    public Properties getProperties() {
        if (this.properties == null) {
            this.properties = PropertiesHolder.getPropertiesForReal();
        }
        return this.properties;
    }

    private static Properties getPropertiesForReal() throws RuntimeException {
        Properties props = new Properties();
        try {
            InputStream stream = ConnectionAndMeta.class.getResourceAsStream(IO_PROPERTIES);
            if (stream == null) {
                if (new File(".").getCanonicalPath().contains("!\\")) {
                    throw new IllegalArgumentException("Use folder names without exclamation marks at the end");
                }
                throw new NullPointerException("Error opening resource stream /shared_io.properties");
            }
            props.load(stream);
            return props;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getBaseUrl() {
        String propertyFileValue = INSTANCE.getProperties().getProperty("auto_update_root_url");
        log.info("auto_update_root_url=" + propertyFileValue);
        String result = System.getProperty("RE_UPDATE_URL", propertyFileValue);
        log.info("auto_update_root_url getProperty=" + propertyFileValue);
        return result;
    }

    public static boolean getBoolean(String propertyName, Properties properties) {
        String flag = properties.getProperty(propertyName);
        return Boolean.TRUE.toString().equalsIgnoreCase(flag);
    }

    static {
        log = Logging.getLogging(PropertiesHolder.class);
    }
}

