/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ini.reader;

import com.devexperts.logging.Logging;
import com.opensr5.ini.DialogModel;
import com.opensr5.ini.GaugeCategoryModel;
import com.opensr5.ini.GaugeModel;
import com.opensr5.ini.ImmutableIniFileModel;
import com.opensr5.ini.IniFileMetaInfo;
import com.opensr5.ini.IniFileModel;
import com.opensr5.ini.RawIniFile;
import com.opensr5.ini.field.ArrayIniField;
import com.opensr5.ini.field.IniField;
import com.opensr5.ini.field.ScalarIniField;
import com.opensr5.ini.field.StringIniField;
import com.rusefi.ini.reader.EnumIniReaderHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IniFileReader {
    private static final Logging log = Logging.getLogging(IniFileReader.class);
    public static final String RUSEFI_INI_PREFIX = "rusefi";
    public static final String RUSEFI_INI_SUFFIX = ".ini";
    public static final String INI_FILE_PATH = System.getProperty("ini_file_path", "..");
    private static final String SECTION_PAGE = "page";
    private static final String FIELD_TYPE_SCALAR = "scalar";
    public static final String FIELD_TYPE_STRING = "string";
    private static final String FIELD_TYPE_ARRAY = "array";
    private static final String FIELD_TYPE_BITS = "bits";
    private final Map<String, List<String>> defines = new TreeMap<String, List<String>>();
    private String dialogId;
    private String dialogUiName;
    private final Map<String, DialogModel> dialogs = new TreeMap<String, DialogModel>();
    private final List<DialogModel.Field> fieldsOfCurrentDialog = new ArrayList<DialogModel.Field>();
    private final List<DialogModel.Command> commandsOfCurrentDialog = new ArrayList<DialogModel.Command>();
    private final Map<String, IniField> allIniFields = new TreeMap<String, IniField>(String.CASE_INSENSITIVE_ORDER);
    private final Map<String, IniField> secondaryIniFields = new TreeMap<String, IniField>(String.CASE_INSENSITIVE_ORDER);
    private final Map<String, IniField> allOutputChannels = new TreeMap<String, IniField>(String.CASE_INSENSITIVE_ORDER);
    public final Map<String, DialogModel.Field> fieldsInUiOrder = new LinkedHashMap<String, DialogModel.Field>();
    private final Map<String, String> tooltips = new TreeMap<String, String>();
    private final Map<String, String> protocolMeta = new TreeMap<String, String>();
    private boolean isConstantsSection;
    private boolean isOutputChannelsSection;
    private String currentYBins;
    private String currentXBins;
    private final Map<String, String> xBinsByZBins = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
    private final Map<String, String> yBinsByZBins = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
    private final IniFileMetaInfo metaInfo;
    private final String iniFilePath;
    private boolean isGaugeConfigurationsSection = false;
    private String currentGaugeCategory = null;
    private final Map<String, GaugeCategoryModel> gaugeCategories = new LinkedHashMap<String, GaugeCategoryModel>();
    private final List<GaugeModel> currentCategoryGauges = new ArrayList<GaugeModel>();
    private final Map<String, GaugeModel> allGauges = new TreeMap<String, GaugeModel>(String.CASE_INSENSITIVE_ORDER);
    private boolean isInSettingContextHelp = false;
    private boolean isInsidePageDefinition;
    private int blockingFactor;
    private static final Integer blockingFactorOverride = Integer.getInteger("blockingFactorOverride");
    private int currentPageIndex;

    public IniFileModel getIniFileModel() {
        return new ImmutableIniFileModel(this.metaInfo.getSignature(), this.getBlockingFactor(), this.defines, this.allIniFields, this.secondaryIniFields, this.allOutputChannels, this.protocolMeta, this.getMetaInfo(), this.getIniFilePath(), this.tooltips, this.fieldsInUiOrder, this.xBinsByZBins, this.yBinsByZBins, this.dialogs, this.gaugeCategories, this.allGauges);
    }

    IniFileReader(@Nullable IniFileMetaInfo metaInfo, String iniFilePath) {
        this.metaInfo = metaInfo;
        this.iniFilePath = iniFilePath;
    }

    public int getBlockingFactor() {
        if (blockingFactorOverride != null) {
            return blockingFactorOverride;
        }
        return this.blockingFactor;
    }

    public IniFileMetaInfo getMetaInfo() {
        return Objects.requireNonNull(this.metaInfo, "metaInfo");
    }

    public String getIniFilePath() {
        return Objects.requireNonNull(this.iniFilePath, "iniFilePath");
    }

    void finishDialog() {
        if (this.fieldsOfCurrentDialog.isEmpty() && this.commandsOfCurrentDialog.isEmpty()) {
            return;
        }
        if (this.dialogUiName == null) {
            this.dialogUiName = this.dialogId;
        }
        this.dialogs.put(this.dialogUiName, new DialogModel(this.dialogId, this.dialogUiName, this.fieldsOfCurrentDialog, this.commandsOfCurrentDialog));
        this.dialogId = null;
        this.fieldsOfCurrentDialog.clear();
        this.commandsOfCurrentDialog.clear();
    }

    void handleLine(RawIniFile.Line line) {
        String rawText = line.getRawText();
        try {
            LinkedList<String> list = new LinkedList<String>(Arrays.asList(line.getTokens()));
            if (!list.isEmpty() && list.get(0).equals("#define")) {
                this.defines.put(list.get(1), list.subList(2, list.size()));
                return;
            }
            if (!list.isEmpty() && list.get(0).equals(SECTION_PAGE)) {
                if (list.size() >= 2) {
                    this.currentPageIndex = Integer.parseInt(list.get(1));
                }
                this.isInsidePageDefinition = true;
                return;
            }
            if (this.isInSettingContextHelp) {
                if (rawText.contains("SettingContextHelpEnd")) {
                    this.isInSettingContextHelp = false;
                }
                if (list.size() == 2) {
                    this.tooltips.put(list.get(0), list.get(1));
                }
                return;
            }
            if (RawIniFile.Line.isCommentLine(rawText)) {
                return;
            }
            if (RawIniFile.Line.isPreprocessorDirective(rawText)) {
                return;
            }
            this.trim(list);
            if (list.isEmpty()) {
                return;
            }
            String first = list.getFirst();
            if (first.equalsIgnoreCase("blockingFactor")) {
                this.blockingFactor = Integer.parseInt(list.get(1));
            }
            if (first.startsWith("[") && first.endsWith("]")) {
                log.info("Section " + first);
                boolean wasGaugeSection = this.isGaugeConfigurationsSection;
                if (first.contains("[SettingContextHelp]")) {
                    this.isInsidePageDefinition = false;
                    this.isInSettingContextHelp = true;
                }
                this.isConstantsSection = first.equals("[Constants]");
                this.isOutputChannelsSection = first.equals("[OutputChannels]");
                this.isGaugeConfigurationsSection = first.equalsIgnoreCase("[GaugeConfigurations]");
                if (wasGaugeSection && !this.isGaugeConfigurationsSection) {
                    this.finishGaugeCategory();
                }
            }
            if (this.isConstantsSection) {
                if (this.isInsidePageDefinition) {
                    if (list.size() > 1) {
                        this.handleConstantFieldDefinition(list, line);
                    }
                    return;
                }
                if (list.size() > 1) {
                    this.protocolMeta.put(list.get(0), list.get(1));
                }
            } else {
                if (this.isOutputChannelsSection) {
                    this.handleOutputChannelDefinition(list);
                    return;
                }
                if (this.isGaugeConfigurationsSection) {
                    this.handleGaugeConfiguration(list);
                    return;
                }
            }
            switch (first) {
                case "field": {
                    this.handleField(list);
                    break;
                }
                case "commandButton": {
                    this.handleCommand(list);
                    break;
                }
                case "slider": {
                    this.handleSlider(list);
                    break;
                }
                case "dialog": {
                    this.handleDialog(list);
                    break;
                }
                case "table": {
                    this.handleTable(list);
                    break;
                }
                case "xBins": {
                    this.handleXBins(list);
                    break;
                }
                case "yBins": {
                    this.handleYBins(list);
                    break;
                }
                case "zBins": {
                    this.handleZBins(list);
                }
            }
        }
        catch (RuntimeException e) {
            throw new IllegalStateException("Failed to handle [" + rawText + "]: " + e, e);
        }
    }

    private void handleOutputChannelDefinition(LinkedList<String> list) {
        String channelType;
        if (list.size() < 2) {
            return;
        }
        String name = list.get(0);
        switch (channelType = list.get(1)) {
            case "scalar": {
                String scalarType = list.get(2);
                int offset = Integer.parseInt(list.get(3));
                this.allOutputChannels.put(name, new ScalarIniField(name, offset, scalarType, null, 1.0, "0", 0.0));
            }
        }
    }

    private void handleZBins(LinkedList<String> list) {
        list.removeFirst();
        String zBins = list.removeFirst();
        this.addField(zBins);
        if (this.currentXBins == null || this.currentYBins == null) {
            throw new IllegalStateException("X or Y missing for " + zBins);
        }
        this.xBinsByZBins.put(zBins, this.currentXBins);
        this.yBinsByZBins.put(zBins, this.currentYBins);
    }

    private void handleYBins(LinkedList<String> list) {
        list.removeFirst();
        this.currentYBins = list.removeFirst();
        this.addField(this.currentYBins);
    }

    private void handleXBins(LinkedList<String> list) {
        list.removeFirst();
        this.currentXBins = list.removeFirst();
        this.addField(this.currentXBins);
    }

    private void addField(String key) {
        DialogModel.Field field = new DialogModel.Field(key, key);
        this.fieldsInUiOrder.put(key, field);
    }

    private void handleTable(LinkedList<String> list) {
        list.removeFirst();
        String tableName = list.removeFirst();
    }

    private void handleConstantFieldDefinition(LinkedList<String> list, RawIniFile.Line line) {
        switch (list.get(1)) {
            case "scalar": {
                this.registerField(ScalarIniField.parse(list));
                break;
            }
            case "string": {
                this.registerField(StringIniField.parse(list));
                break;
            }
            case "array": {
                this.registerField(ArrayIniField.parse(list));
                break;
            }
            case "bits": {
                this.registerField(EnumIniReaderHelper.parse(list, line, this.defines));
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected " + list);
            }
        }
    }

    private void registerField(IniField field) {
        if (this.currentPageIndex != 1) {
            log.info("Skipping field from secondary page: " + field);
            this.secondaryIniFields.put(field.getName(), field);
            return;
        }
        if (this.allIniFields.containsKey(field.getName())) {
            return;
        }
        this.allIniFields.put(field.getName(), field);
    }

    private void handleSlider(LinkedList<String> list) {
        list.removeFirst();
        String uiFieldName = list.isEmpty() ? "" : list.removeFirst();
        String key = list.isEmpty() ? null : list.removeFirst();
        this.registerUiField(key, uiFieldName);
        log.debug("IniFileModel: Slider label=[" + uiFieldName + "] : key=[" + key + "]");
    }

    private void handleCommand(LinkedList<String> list) {
        list.removeFirst();
        String uiName = list.removeFirst();
        String command = list.removeFirst();
        this.commandsOfCurrentDialog.add(new DialogModel.Command(uiName, command));
    }

    private void handleField(LinkedList<String> list) {
        list.removeFirst();
        String uiFieldName = list.isEmpty() ? "" : list.removeFirst();
        String key = list.isEmpty() ? null : list.removeFirst();
        this.registerUiField(key, uiFieldName);
        log.debug("IniFileModel: Field label=[" + uiFieldName + "] : key=[" + key + "]");
    }

    private void registerUiField(String key, String uiFieldName) {
        DialogModel.Field field = new DialogModel.Field(key, uiFieldName);
        if (key != null) {
            this.fieldsOfCurrentDialog.add(field);
            if (!this.fieldsInUiOrder.containsKey(key) || this.fieldsInUiOrder.get(key).getUiName() == key) {
                this.fieldsInUiOrder.put(key, field);
            }
        }
    }

    private void handleDialog(LinkedList<String> list) {
        this.finishDialog();
        list.removeFirst();
        String keyword = list.removeFirst();
        String name = list.isEmpty() ? null : list.removeFirst();
        this.dialogId = keyword;
        this.dialogUiName = name;
        log.debug("IniFileModel: Dialog key=" + keyword + ": name=[" + name + "]");
    }

    private void trim(LinkedList<String> list) {
        while (!list.isEmpty() && list.getFirst().isEmpty()) {
            list.removeFirst();
        }
    }

    private void handleGaugeConfiguration(LinkedList<String> list) {
        if (list.size() < 2) {
            return;
        }
        String gaugeName = list.get(0);
        if (gaugeName.equalsIgnoreCase("gaugeCategory")) {
            this.finishGaugeCategory();
            this.currentGaugeCategory = list.get(1);
            return;
        }
        if (list.size() < 6) {
            log.warn("Skipping incomplete gauge definition: " + gaugeName + " (expected at least 6 fields, got " + list.size() + ")");
            return;
        }
        try {
            GaugeModel gauge = this.getGaugeModel(list, gaugeName);
            this.currentCategoryGauges.add(gauge);
            this.allGauges.put(gaugeName, gauge);
        }
        catch (NumberFormatException e) {
            log.warn("Failed to parse gauge: " + gaugeName + ": " + e.getMessage());
        }
        catch (IndexOutOfBoundsException e) {
            log.warn("Failed to parse gauge: " + gaugeName + ": " + e.getMessage());
        }
    }

    @NotNull
    private GaugeModel getGaugeModel(LinkedList<String> list, String gaugeName) {
        String channel = list.get(1);
        String title = list.get(2);
        String units = list.get(3);
        double lowValue = this.parseDouble(list.get(4));
        double highValue = this.parseDouble(list.get(5));
        double lowDangerValue = list.size() > 6 ? this.parseDouble(list.get(6)) : lowValue;
        double lowWarningValue = list.size() > 7 ? this.parseDouble(list.get(7)) : lowValue;
        double highWarningValue = list.size() > 8 ? this.parseDouble(list.get(8)) : highValue;
        double highDangerValue = list.size() > 9 ? this.parseDouble(list.get(9)) : highValue;
        int valueDecimalPlaces = list.size() > 10 ? this.parseInt(list.get(10)) : 0;
        int labelDecimalPlaces = list.size() > 11 ? this.parseInt(list.get(11)) : 0;
        return new GaugeModel(gaugeName, channel, title, units, lowValue, highValue, lowDangerValue, lowWarningValue, highWarningValue, highDangerValue, valueDecimalPlaces, labelDecimalPlaces);
    }

    void finishGaugeCategory() {
        if (this.currentGaugeCategory != null && !this.currentCategoryGauges.isEmpty()) {
            this.gaugeCategories.put(this.currentGaugeCategory, new GaugeCategoryModel(this.currentGaugeCategory, new ArrayList<GaugeModel>(this.currentCategoryGauges)));
            this.currentCategoryGauges.clear();
        }
        this.currentGaugeCategory = null;
    }

    private double parseDouble(String s) {
        return Double.parseDouble(s);
    }

    private int parseInt(String s) {
        return Integer.parseInt(s);
    }

    static {
        if (blockingFactorOverride != null) {
            log.info("blockingFactorOverride=" + blockingFactorOverride);
        }
    }
}

