/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.libopenblt;

import com.devexperts.logging.Logging;
import com.rusefi.libopenblt.XcpSettings;
import com.rusefi.libopenblt.transport.IXcpTransport;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;

public class XcpLoader {
    private static final Logging log = Logging.getLogging(XcpLoader.class);
    private static final byte XCPLOADER_CMD_CONNECT = -1;
    private static final byte XCPLOADER_CMD_GET_STATUS = -3;
    private static final byte XCPLOADER_CMD_GET_SEED = -8;
    private static final byte XCPLOADER_CMD_UNLOCK = -9;
    private static final byte XCPLOADER_CMD_SET_MTA = -10;
    private static final byte XCPLOADER_CMD_UPLOAD = -11;
    private static final byte XCPLOADER_CMD_PROGRAM_START = -46;
    private static final byte XCPLOADER_CMD_PROGRAM_CLEAR = -47;
    private static final byte XCPLOADER_CMD_PROGRAM = -48;
    private static final byte XCPLOADER_CMD_PROGRAM_RESET = -49;
    private static final byte XCPLOADER_CMD_PROGRAM_MAX = -55;
    private static final byte XCPLOADER_CMD_PID_RES = -1;
    private static final byte XCPLOADER_CMD_PID_ERR = -2;
    private static final byte XCPLOADER_ERR_CMD_UNKNOWN = 32;
    private static final int XCPLOADER_PACKET_SIZE_MAX = 255;
    private final IXcpTransport mTransport;
    private final XcpSettings mSettings;
    private TargetInfo mTargetInfo;

    public XcpLoader(IXcpTransport transport, XcpSettings settings) {
        this.mTransport = transport;
        this.mSettings = settings;
    }

    public void start() throws IOException {
        this.mTransport.connect();
        this.connect();
    }

    public void stop() throws IOException {
        this.sendCmdProgram(new byte[0]);
        this.sendCmdProgramReset();
        this.mTransport.disconnect();
    }

    private void connect() throws IOException {
        byte[] request = ByteBuffer.allocate(2).put((byte)-1).put((byte)0).array();
        byte[] response = this.mTransport.sendPacket(request, this.mSettings.timeoutT6, 8);
        if (response.length != 8) {
            throw new IOException("connect() failed due to incorrect length received: " + response.length);
        }
        if (response[0] != -1) {
            throw new IOException("connect() failed due to bad response ID received: " + response[0]);
        }
        TargetInfo ti = new TargetInfo();
        ti.byteOrder = (response[2] & 1) == 0 ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        ti.maxCto = response[3] & 0xFF;
        ti.maxDto = ti.byteOrder == ByteOrder.LITTLE_ENDIAN ? (response[4] & 0xFF) + (response[5] << 8) : (response[5] & 0xFF) + (response[4] << 8);
        if (ti.maxCto == 0) {
            throw new IllegalStateException("Controller returned invalid max CTO configuration: " + ti.maxDto);
        }
        if (ti.maxCto > 255) {
            ti.maxCto = 255;
        }
        if (ti.maxDto == 0 || ti.maxDto > 255) {
            throw new IllegalStateException("Controller returned invalid max DTO configuration: " + ti.maxDto);
        }
        ti.maxProgCto = this.programStart();
        this.mTargetInfo = ti;
    }

    private int programStart() throws IOException {
        byte[] request = ByteBuffer.allocate(1).put((byte)-46).array();
        byte[] response = this.mTransport.sendPacket(request, this.mSettings.timeoutT6, 7);
        if (response.length != 7) {
            throw new IOException("sendCmdProgramStart() failed due to incorrect length received: " + response.length);
        }
        if (response[0] != -1) {
            throw new IOException("sendCmdProgramStart() failed due to bad response ID received: " + response[0]);
        }
        int maxProgCto = response[3] & 0xFF;
        if (maxProgCto > 255) {
            throw new IllegalStateException("Controller returned invalid max prog CTO configuration: " + maxProgCto);
        }
        return maxProgCto;
    }

    public void clearMemory(int address, int len) throws IOException {
        this.setMta(address);
        byte[] request = ByteBuffer.allocate(8).order(this.mTargetInfo.byteOrder).put((byte)-47).put((byte)0).put((byte)0).put((byte)0).putInt(len).array();
        byte[] response = this.mTransport.sendPacket(request, this.mSettings.timeoutT4, 1);
        if (response.length != 1 || response[0] != -1) {
            throw new IOException("programClear failed for address=0x" + Integer.toString(address, 16) + " length=" + len);
        }
    }

    public void writeData(int address, byte[] data) throws IOException {
        int chunkSize;
        this.setMta(address);
        int offset = 0;
        for (int len = data.length; len > 0; len -= chunkSize) {
            int maxChunkSize = this.mTargetInfo.maxProgCto - 1;
            chunkSize = Math.min(maxChunkSize, len);
            byte[] chunk = Arrays.copyOfRange(data, offset, offset + chunkSize);
            if (chunkSize < maxChunkSize) {
                this.sendCmdProgram(chunk);
            } else {
                this.sendCmdProgramMax(chunk);
            }
            offset += chunkSize;
        }
    }

    private void sendCmdProgram(byte[] data) throws IOException {
        if (data.length > this.mTargetInfo.maxProgCto - 2 || this.mTargetInfo.maxProgCto > 255) {
            throw new IllegalStateException("CmdProgram: too much data: " + data.length);
        }
        byte[] request = ByteBuffer.allocate(2 + data.length).put((byte)-48).put((byte)data.length).put(data).array();
        byte[] response = this.mTransport.sendPacket(request, this.mSettings.timeoutT5, 1);
        if (response.length == 2 && response[0] == -2 && response[1] == 32) {
            throw new IOException("Non secure bootloader?!");
        }
        if (response.length == 1 && response[0] == -2) {
            throw new IOException("Error programming ECU. Non secure bootloader?!");
        }
        if (response.length != 1 || response[0] != -1) {
            throw new IOException("sendCmdProgram failed");
        }
    }

    private void sendCmdProgramMax(byte[] data) throws IOException {
        if (data.length != this.mTargetInfo.maxProgCto - 1 || this.mTargetInfo.maxProgCto > 255) {
            throw new IllegalStateException("CmdProgramMax: wrong data length: " + data.length);
        }
        byte[] request = ByteBuffer.allocate(1 + data.length).put((byte)-55).put(data).array();
        byte[] response = this.mTransport.sendPacket(request, this.mSettings.timeoutT5, 1);
        if (response.length == 2 && response[0] == -2 && response[1] == 32) {
            throw new IOException("Non secure bootloader?!");
        }
        if (response.length == 1 && response[0] == -2) {
            throw new IOException("Error programming ECU. Non secure bootloader?!");
        }
        if (response.length != 1 || response[0] != -1) {
            throw new IOException("sendCmdProgramMax failed");
        }
    }

    private void sendCmdProgramReset() throws IOException {
        byte[] response;
        byte[] request = ByteBuffer.allocate(1).put((byte)-49).array();
        try {
            response = this.mTransport.sendPacket(request, this.mSettings.timeoutT6, 1);
        }
        catch (IOException e) {
            log.info("sendCmdProgramReset not a problem: " + e);
            return;
        }
        if (response.length != 1) {
            throw new IOException("sendCmdProgramReset() failed due to incorrect length received: " + response.length);
        }
        if (response[0] != -1) {
            throw new IOException("sendCmdProgramReset() failed due to bad response ID received: " + response[0]);
        }
    }

    private void setMta(int address) throws IOException {
        byte[] request = ByteBuffer.allocate(8).order(this.mTargetInfo.byteOrder).put((byte)-10).put((byte)0).put((byte)0).put((byte)0).putInt(address).array();
        byte[] response = this.mTransport.sendPacket(request, this.mSettings.timeoutT1, 1);
        if (response.length != 1 || response[0] != -1) {
            throw new IOException("setMta failed for address " + address);
        }
    }

    private static class TargetInfo {
        ByteOrder byteOrder;
        int maxCto;
        int maxDto;
        int maxProgCto;

        private TargetInfo() {
        }
    }
}

