/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.maintenance.migration.migrators;

import com.opensr5.ini.field.ArrayIniField;
import com.opensr5.ini.field.IniField;
import com.rusefi.config.FieldType;
import com.rusefi.io.UpdateOperationCallbacks;
import com.rusefi.maintenance.migration.TuneMigrationContext;
import com.rusefi.maintenance.migration.migrators.AfrLambdaTableValuesConverter;
import com.rusefi.maintenance.migration.migrators.TuneMigrator;
import com.rusefi.tune.xml.Constant;
import java.util.Objects;
import java.util.Optional;

public enum AfrLambdaTableMigrator implements TuneMigrator
{
    INSTANCE;


    @Override
    public void migrateTune(TuneMigrationContext context) {
        Optional<IniField> prevField = context.getPrevIniFile().findIniField("lambdaTable");
        if (!prevField.isPresent()) {
            return;
        }
        Optional<IniField> updatedField = context.getUpdatedIniFile().findIniField("lambdaTable");
        if (!updatedField.isPresent()) {
            return;
        }
        Optional<ArrayIniField> prevArrayIniField = this.getValidatedTableArrayIniField(prevField.get(), context.getCallbacks());
        Optional<ArrayIniField> updatedArrayIniField = this.getValidatedTableArrayIniField(updatedField.get(), context.getCallbacks());
        if (prevArrayIniField.isPresent() && updatedArrayIniField.isPresent()) {
            ArrayIniField prevTableField = prevArrayIniField.get();
            ArrayIniField updatedTableField = updatedArrayIniField.get();
            if (Objects.equals(prevTableField.getRows(), updatedTableField.getRows()) && Objects.equals(prevTableField.getCols(), updatedTableField.getCols())) {
                Optional<String[][]> migratedValues;
                int updatedTableFieldCols = updatedTableField.getCols();
                Constant prevValue = context.getPrevTune().getConstantsAsMap().get("lambdaTable");
                if (prevValue != null && (migratedValues = AfrLambdaTableValuesConverter.INSTANCE.convertTableValues(prevTableField.getValues(prevValue.getValue()), context)).isPresent()) {
                    context.addMigration("lambdaTable", new Constant("lambdaTable", updatedTableField.getUnits(), updatedTableField.formatValue(migratedValues.get()), updatedTableField.getDigits(), Integer.toString(updatedTableField.getRows()), Integer.toString(updatedTableFieldCols)));
                }
            }
        }
    }

    private Optional<ArrayIniField> getValidatedTableArrayIniField(IniField field, UpdateOperationCallbacks callbacks) {
        if (!(field instanceof ArrayIniField)) {
            callbacks.logLine(String.format("WARNING! `%s` ini-field is expected to be `ArrayIniField` instead of %s", "lambdaTable", field.getClass().getName()));
            return Optional.empty();
        }
        ArrayIniField arrayField = (ArrayIniField)field;
        FieldType arrayFieldType = arrayField.getType();
        if (arrayFieldType != FieldType.UINT8) {
            callbacks.logLine(String.format("WARNING! `%s` ini-field is expected to be `UINT8` instead of `%s`", new Object[]{"lambdaTable", arrayFieldType}));
            return Optional.empty();
        }
        return Optional.of(arrayField);
    }
}

