/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.maintenance.migration.migrators;

import com.opensr5.ini.field.ArrayIniField;
import com.opensr5.ini.field.IniField;
import com.rusefi.maintenance.migration.TuneMigrationContext;
import com.rusefi.maintenance.migration.migrators.TableValuesConverter;
import com.rusefi.tune.xml.Constant;
import com.rusefi.tune.xml.Msq;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;

public enum AfrLambdaTableValuesConverter implements TableValuesConverter
{
    INSTANCE;

    private static final String AFR_UNITS = "afr";
    private static final String LAMBDA_UNITS = "lambda";
    private static final String STOICH_RATIO_PRIMARY_FIELD_NAME = "stoichRatioPrimary";

    @Override
    public Optional<String[][]> convertTableValues(String[][] prevValues, TuneMigrationContext context) {
        Msq prevTune = context.getPrevTune();
        Constant prevLambdaTableValue = prevTune.getConstantsAsMap().get("lambdaTable");
        Constant updatedLambdaTableValue = context.getUpdatedTune().getConstantsAsMap().get("lambdaTable");
        if (prevLambdaTableValue != null && updatedLambdaTableValue != null) {
            Optional<Double> prevStoichRatioPrimary;
            String updatedLambdaTableValueUnits;
            String prevLambdaTableValueUnits = prevLambdaTableValue.getUnits();
            if (Objects.equals(prevLambdaTableValueUnits, updatedLambdaTableValueUnits = updatedLambdaTableValue.getUnits())) {
                return Optional.of(prevValues);
            }
            Optional<ArrayIniField> prevLambdaTableIniField = this.getPrevLambdaTableIniField(context);
            if (prevLambdaTableIniField.isPresent() && (prevStoichRatioPrimary = this.getPrevStoichRatioPrimary(context)).isPresent()) {
                int prevValuesRowCount = prevValues.length;
                int prevValuesColumnCount = prevValues[0].length;
                String[][] convertedValues = new String[prevValuesRowCount][prevValuesColumnCount];
                for (int i = 0; i < prevValuesRowCount; ++i) {
                    for (int j = 0; j < prevValuesColumnCount; ++j) {
                        String prevValue = prevValues[i][j];
                        Optional<String> convertedValue = this.convertLambdaTableElementValue(prevValue, prevLambdaTableValueUnits, updatedLambdaTableValueUnits, updatedLambdaTableValue.getDigits(), prevStoichRatioPrimary.get(), context);
                        if (!convertedValue.isPresent()) {
                            return Optional.empty();
                        }
                        convertedValues[i][j] = convertedValue.get();
                    }
                }
                return Optional.of(convertedValues);
            }
        }
        return Optional.empty();
    }

    private Optional<String> convertLambdaTableElementValue(String prevElementValue, String prevUnits, String updatedUnits, String updatedDigits, double prevStoichRatioPrimary, TuneMigrationContext context) {
        Optional<Double> result = Optional.empty();
        try {
            double prevElement = Double.parseDouble(prevElementValue);
            if (AFR_UNITS.equalsIgnoreCase(prevUnits) && LAMBDA_UNITS.equalsIgnoreCase(updatedUnits)) {
                if (prevStoichRatioPrimary != 0.0) {
                    result = Optional.of(prevElement / prevStoichRatioPrimary);
                } else {
                    context.logWarn(String.format("We cannot migrate values of `%s` table when units are changed `%s` -> `%s` because of zero `%s` prev value", "lambdaTable", prevUnits, updatedUnits, STOICH_RATIO_PRIMARY_FIELD_NAME));
                }
            } else if (LAMBDA_UNITS.equalsIgnoreCase(prevUnits) && AFR_UNITS.equalsIgnoreCase(updatedUnits)) {
                result = Optional.of(prevElement * prevStoichRatioPrimary);
            } else {
                context.logWarn(String.format("We cannot migrate values of `%s` table when units are changed `%s` -> `%s`", "lambdaTable", prevUnits, updatedUnits));
            }
        }
        catch (NumberFormatException e) {
            context.logWarn(String.format("Invalid element in previous `%s` table field value: `%s`.", "lambdaTable", prevElementValue));
        }
        catch (NullPointerException e) {
            context.logWarn(String.format("Null element in previous `%s` table field value.", "lambdaTable"));
        }
        return result.map(value -> String.format(Locale.US, "%." + updatedDigits + "f", value));
    }

    private Optional<Double> getPrevStoichRatioPrimary(TuneMigrationContext context) {
        Optional<Double> result = Optional.empty();
        Constant prevStoichRatioPrimaryConstant = context.getPrevTune().getConstantsAsMap().get(STOICH_RATIO_PRIMARY_FIELD_NAME);
        if (prevStoichRatioPrimaryConstant != null) {
            String prevStoichRatioPrimaryValue = prevStoichRatioPrimaryConstant.getValue();
            try {
                result = Optional.of(Double.parseDouble(prevStoichRatioPrimaryValue));
            }
            catch (NumberFormatException e) {
                context.logWarn(String.format("Invalid  previous `%s` field value: `%s`.", STOICH_RATIO_PRIMARY_FIELD_NAME, prevStoichRatioPrimaryValue));
            }
            catch (NullPointerException e) {
                context.logWarn(String.format("To migrate changed `%s` units previous tune should contain non-null `%s` field value.", "lambdaRpmBins", STOICH_RATIO_PRIMARY_FIELD_NAME));
            }
        } else {
            context.logWarn(String.format("To migrate changed `%s` units prev tune should contain `%s` field value.", "lambdaRpmBins", STOICH_RATIO_PRIMARY_FIELD_NAME));
        }
        return result;
    }

    private Optional<ArrayIniField> getPrevLambdaTableIniField(TuneMigrationContext context) {
        Optional<ArrayIniField> result = Optional.empty();
        Optional<IniField> optionalPrevIniField = context.getPrevIniFile().findIniField("lambdaTable");
        if (optionalPrevIniField.isPresent()) {
            IniField prevIniField = optionalPrevIniField.get();
            if (prevIniField instanceof ArrayIniField) {
                result = Optional.of((ArrayIniField)prevIniField);
            } else {
                context.logWarn(String.format("`%s` prev ini-field is expected to be `ArrayIniField` instead of `%s`", "lambdaTable", prevIniField.getClass().getSimpleName()));
            }
        } else {
            context.logWarn(String.format("`%s` ini-field is missed in prev ini-file", "lambdaTable"));
        }
        return result;
    }
}

