/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.output;

import com.rusefi.ConfigField;
import com.rusefi.ReaderState;
import com.rusefi.output.ConfigStructure;
import com.rusefi.output.FieldIterator;
import java.util.List;

public abstract class FieldsStrategy {
    static final FieldsStrategy VOID = new FieldsStrategy(){

        @Override
        int writeOneField(FieldIterator iterator, String prefix, int tsPosition) {
            return iterator.adjustSize(tsPosition);
        }
    };

    public int run(ReaderState state, ConfigStructure structure, int structureStartingTsPosition) {
        if (state.isStackEmpty()) {
            return this.writeFields(structure.getTsFields(), "", structureStartingTsPosition);
        }
        return structureStartingTsPosition;
    }

    protected int writeFields(List<ConfigField> fields, String prefix, int tsPosition) {
        FieldIterator iterator = new FieldIterator(fields);
        return this.loopIterator(fields, prefix, tsPosition, iterator);
    }

    protected int loopIterator(List<ConfigField> fields, String prefix, int tsPosition, FieldIterator iterator) {
        for (int i = 0; i < fields.size(); ++i) {
            iterator.start(i);
            int currentPosition = tsPosition;
            tsPosition = this.writeOneField(iterator, prefix, tsPosition);
            iterator.end(currentPosition);
        }
        return tsPosition;
    }

    abstract int writeOneField(FieldIterator var1, String var2, int var3);
}

