/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.output;

import com.opensr5.ini.field.IniField;
import com.rusefi.ConfigField;
import com.rusefi.ConfigFieldImpl;
import com.rusefi.PinType;
import com.rusefi.ReaderState;
import com.rusefi.TokenUtils;
import com.rusefi.output.ConfigStructure;
import com.rusefi.output.FieldIterator;
import com.rusefi.output.FieldsStrategy;
import com.rusefi.output.JavaSensorsConsumer;
import com.rusefi.parse.Type;
import com.rusefi.parse.TypesHelper;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class TsOutput {
    private final StringBuilder settingContextHelp = new StringBuilder();
    private final boolean isConstantsSection;
    private final StringBuilder tsHeader = new StringBuilder();
    private final TreeSet<String> usedNames = new TreeSet(String.CASE_INSENSITIVE_ORDER);
    private final String temperatureCelsiusUnit = JavaSensorsConsumer.quote("C");
    private final String temperatureFahrenheitUnit = JavaSensorsConsumer.quote("F");
    private final Double temperatureToFahrenheitScale = 1.8;
    private final Double temperatureToFahrenheitTranslate = 17.77777;
    private final String pressureMetricUnit = JavaSensorsConsumer.quote("kPa");
    private final String pressureImperialUnit = JavaSensorsConsumer.quote("psi");
    private final Double pressureToPsiScale = 0.145038;
    private final Double pressureToPsiTranslate = 0.0;
    private final String speedMetricUnit = JavaSensorsConsumer.quote("kmh");
    private final String speedImperialUnit = JavaSensorsConsumer.quote("mph");
    private final Double KmhToMphScale = 0.62137119;
    private final Double KmhToMphTranslate = 0.0;

    public TsOutput(boolean longForm) {
        this.isConstantsSection = longForm;
    }

    public String getContent() {
        return this.tsHeader.toString();
    }

    public String getSettingContextHelp() {
        return this.settingContextHelp.toString();
    }

    public int run(final ReaderState state, ConfigStructure structure, int structureStartingTsPosition, final String temporaryLineComment, final String variableNamePrefix) {
        FieldsStrategy strategy = new FieldsStrategy(){

            int writeFieldJob(String nameWithPrefix, ConfigFieldImpl configField, ConfigField next, int tsPosition, int bitIndex, String prefix, ConfigStructure cs) {
                if (configField.getState().getTsCustomLine().containsKey(configField.getTypeName())) {
                    String bits = configField.getState().getTsCustomLine().get(configField.getTypeName());
                    if (!bits.startsWith("bits")) {
                        bits = TsOutput.this.handleTsInfo(configField, bits, 5);
                    }
                    bits = bits.replaceAll("@OFFSET@", "" + tsPosition);
                    TsOutput.this.tsHeader.append(nameWithPrefix + " = " + bits);
                    if (!configField.getName().equals(next.getName())) {
                        tsPosition += configField.getState().getTsCustomSize().get(configField.getTypeName()).intValue();
                    }
                } else if (configField.getArraySizes().length == 0) {
                    TsOutput.this.tsHeader.append(temporaryLineComment + nameWithPrefix + " = scalar, ");
                    TsOutput.this.tsHeader.append(TypesHelper.convertToTs(configField.getTypeName()) + ",");
                    TsOutput.this.tsHeader.append(" " + tsPosition + ",");
                    TsOutput.this.tsHeader.append(" " + TsOutput.this.handleTsInfo(configField, configField.getTsInfo(), 1));
                    if (!configField.getName().equals(next.getName())) {
                        tsPosition += configField.getSize(next);
                    }
                } else if (configField.getSize(next) != 0) {
                    TsOutput.this.tsHeader.append(nameWithPrefix + " = array, ");
                    TsOutput.this.tsHeader.append(TypesHelper.convertToTs(configField.getTypeName()) + ",");
                    TsOutput.this.tsHeader.append(" " + tsPosition + ",");
                    TsOutput.this.tsHeader.append(" [");
                    boolean first = true;
                    List list = Arrays.stream(configField.getArraySizes()).boxed().collect(Collectors.toList());
                    Collections.reverse(list);
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        int size = (Integer)iterator.next();
                        if (first) {
                            first = false;
                        } else {
                            TsOutput.this.tsHeader.append("x");
                        }
                        TsOutput.this.tsHeader.append(size);
                    }
                    TsOutput.this.tsHeader.append("], " + TsOutput.this.handleTsInfo(configField, configField.getTsInfo(), 1));
                    if (!configField.getName().equals(next.getName())) {
                        tsPosition += configField.getSize(next);
                    }
                }
                TsOutput.this.tsHeader.append("\n");
                return tsPosition;
            }

            @Override
            public int writeOneField(FieldIterator it, String prefix, int tsPosition) {
                ConfigFieldImpl configField = (ConfigFieldImpl)it.cf;
                ConfigField next = it.next;
                int bitIndex = it.bitState.get();
                String nameWithPrefix = prefix + variableNamePrefix + configField.getName();
                String originalUnits = configField.getUnits();
                String originalTsInfo = configField.getTsInfo();
                ConfigStructure cs = configField.getStructureType();
                if (!(TsOutput.this.usedNames.add(nameWithPrefix) || TsOutput.this.isConstantsSection || configField.isUnusedField())) {
                    throw new IllegalStateException(nameWithPrefix + " already present: " + configField);
                }
                if (configField.getName().startsWith("alignmentFill_at_")) {
                    return it.adjustSize(tsPosition);
                }
                if (configField.isDirective() && configField.getComment() != null) {
                    TsOutput.this.tsHeader.append(configField.getComment());
                    TsOutput.this.tsHeader.append("\n");
                    return tsPosition;
                }
                if (cs == null) {
                    PinType pinType;
                    String comment = "";
                    if (configField.getComment() != null && configField.getComment().trim().length() > 0) {
                        String commentContent = configField.getCommentTemplated();
                        comment = ConfigFieldImpl.unquote(commentContent);
                    }
                    if ((pinType = PinType.findByOutputEnum(configField.getTypeName())) != null) {
                        try {
                            String url = state.getVariableRegistry().applyVariables("@@PINOUT_URL@@");
                            if (comment != "") {
                                comment = comment + "\\n";
                            }
                            comment = comment + ConfigFieldImpl.unquote(url) + "?highlight=class~" + pinType.name().toLowerCase();
                        }
                        catch (IllegalStateException illegalStateException) {
                            // empty catch block
                        }
                    }
                    if (comment != "") {
                        TsOutput.this.settingContextHelp.append(temporaryLineComment + "\t" + nameWithPrefix + " = " + JavaSensorsConsumer.quote(comment) + "\n");
                    }
                }
                if (cs != null) {
                    String extraPrefix = cs.isWithPrefix() ? configField.getName() + "_" : "";
                    return this.writeFields(cs.getTsFields(), prefix + extraPrefix, tsPosition);
                }
                if (configField.isBit()) {
                    if (!configField.getName().startsWith("unusedBit_")) {
                        TsOutput.this.tsHeader.append(temporaryLineComment + nameWithPrefix + " = bits, U32,");
                        TsOutput.this.tsHeader.append(" " + tsPosition + ", [");
                        TsOutput.this.tsHeader.append(bitIndex + ":" + bitIndex);
                        TsOutput.this.tsHeader.append("]");
                        if (TsOutput.this.isConstantsSection) {
                            TsOutput.this.tsHeader.append(", \"" + configField.getFalseName() + "\", \"" + configField.getTrueName() + "\"");
                        }
                        TsOutput.this.tsHeader.append("\n");
                    }
                    return it.adjustSize(tsPosition);
                }
                if (originalUnits.startsWith("SPECIAL_CASE_TEMPERATURE")) {
                    configField.setTsInfo(TsOutput.this.formatTemperatureTsInfo(originalTsInfo, false));
                    int newIndex = this.writeFieldJob(nameWithPrefix, configField, next, tsPosition, bitIndex, nameWithPrefix, cs);
                    configField.setTsInfo(originalTsInfo);
                    return newIndex;
                }
                if (originalUnits.startsWith("SPECIAL_CASE_PRESSURE")) {
                    configField.setTsInfo(TsOutput.this.formatPressureTsInfo(originalTsInfo, false));
                    int newIndex = this.writeFieldJob(nameWithPrefix, configField, next, tsPosition, bitIndex, nameWithPrefix, cs);
                    configField.setTsInfo(originalTsInfo);
                    return newIndex;
                }
                if (originalUnits.startsWith("SPECIAL_CASE_SPEED")) {
                    configField.setTsInfo(TsOutput.this.formatSpeedTsInfo(originalTsInfo, false));
                    int newIndex = this.writeFieldJob(nameWithPrefix, configField, next, tsPosition, bitIndex, nameWithPrefix, cs);
                    configField.setTsInfo(originalTsInfo);
                    return newIndex;
                }
                return this.writeFieldJob(nameWithPrefix, configField, next, tsPosition, bitIndex, nameWithPrefix, cs);
            }
        };
        structureStartingTsPosition = strategy.run(state, structure, structureStartingTsPosition);
        if (state.isStackEmpty()) {
            this.tsHeader.append("; total TS size = " + structureStartingTsPosition + "\n");
        }
        return structureStartingTsPosition;
    }

    private double celsiusToFahrenheit(double celsius) {
        return celsius * this.temperatureToFahrenheitScale + 32.0;
    }

    private double kPaToPsi(double kPa) {
        return kPa * this.pressureToPsiScale;
    }

    private double KmhToMph(double Kmh) {
        return Kmh * this.KmhToMphScale;
    }

    public String formatTemperatureTsInfo(String tsInfo, boolean isImperial) {
        if (tsInfo == null || tsInfo.trim().isEmpty()) {
            return "";
        }
        String[] fields = TokenUtils.tokenizeWithBraces(tsInfo);
        Double scale = IniField.parseDouble(fields[1]);
        if (isImperial) {
            fields[0] = this.temperatureFahrenheitUnit;
            fields[1] = String.valueOf(this.temperatureToFahrenheitScale * scale);
            fields[2] = String.valueOf(this.temperatureToFahrenheitTranslate * scale);
            fields[3] = String.valueOf(this.celsiusToFahrenheit(IniField.parseDouble(fields[3])));
            fields[4] = String.valueOf(this.celsiusToFahrenheit(IniField.parseDouble(fields[4])));
        } else {
            fields[0] = this.temperatureCelsiusUnit;
        }
        return TokenUtils.tokensToString(fields);
    }

    public String formatPressureTsInfo(String tsInfo, boolean isImperial) {
        if (tsInfo == null || tsInfo.trim().isEmpty()) {
            return "";
        }
        String[] fields = TokenUtils.tokenizeWithBraces(tsInfo);
        Double scale = IniField.parseDouble(fields[1]);
        if (isImperial) {
            fields[0] = this.pressureImperialUnit;
            fields[1] = String.valueOf(this.pressureToPsiScale * scale);
            fields[2] = String.valueOf(this.pressureToPsiTranslate * scale);
            fields[3] = String.valueOf(this.kPaToPsi(IniField.parseDouble(fields[3])));
            fields[4] = String.valueOf(this.kPaToPsi(IniField.parseDouble(fields[4])));
        } else {
            fields[0] = this.pressureMetricUnit;
        }
        return TokenUtils.tokensToString(fields);
    }

    public String formatSpeedTsInfo(String tsInfo, boolean isImperial) {
        if (tsInfo == null || tsInfo.trim().isEmpty()) {
            return "";
        }
        String[] fields = TokenUtils.tokenizeWithBraces(tsInfo);
        Double scale = IniField.parseDouble(fields[1]);
        if (isImperial) {
            fields[0] = this.speedImperialUnit;
            fields[1] = String.valueOf(this.KmhToMphScale * scale);
            fields[2] = String.valueOf(this.KmhToMphTranslate * scale);
            fields[3] = String.valueOf(this.KmhToMph(IniField.parseDouble(fields[3])));
            fields[4] = String.valueOf(this.KmhToMph(IniField.parseDouble(fields[4])));
        } else {
            fields[0] = this.speedMetricUnit;
        }
        return TokenUtils.tokensToString(fields);
    }

    private String handleTsInfo(ConfigField configField, String tsInfo, int multiplierIndex) {
        if (tsInfo == null || tsInfo.trim().isEmpty()) {
            if (this.isConstantsSection) {
                if (configField.getTypeName().equalsIgnoreCase(Type.U16.cType) || configField.getTypeName().equalsIgnoreCase(Type.S16.cType)) {
                    return JavaSensorsConsumer.quote("") + ", 1, 0, 0, 32000, 0";
                }
                return JavaSensorsConsumer.quote("") + ", 1, 0, 0, 100, 0";
            }
            return JavaSensorsConsumer.quote("") + ", 1, 0";
        }
        try {
            String[] fields = TokenUtils.tokenizeWithBraces(tsInfo);
            if (fields.length > multiplierIndex) {
                double val = IniField.parseDouble(fields[multiplierIndex]);
                fields[multiplierIndex] = val == 0.0 ? " 0" : (val == 1.0 ? " 1" : " " + val);
            }
            if (!this.isConstantsSection) {
                String[] subarray = new String[3];
                System.arraycopy(fields, 0, subarray, 0, subarray.length);
                fields = subarray;
            }
            return TokenUtils.tokensToString(fields);
        }
        catch (Throwable e) {
            throw new IllegalStateException("While parsing [" + tsInfo + "] of " + configField, e);
        }
    }
}

