/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.proxy;

import com.devexperts.logging.Logging;
import com.rusefi.NamedThreadFactory;
import com.rusefi.binaryprotocol.IncomingDataBuffer;
import com.rusefi.core.FileUtil;
import com.rusefi.io.commands.HelloCommand;
import com.rusefi.io.tcp.BinaryProtocolServer;
import com.rusefi.io.tcp.TcpIoStream;
import com.rusefi.proxy.NetworkConnectorContext;
import com.rusefi.server.SessionDetails;
import java.io.IOException;
import java.net.Socket;

public class BaseBroadcastingThread {
    private static final Logging log = Logging.getLogging(BaseBroadcastingThread.class);
    private static final NamedThreadFactory BASE_BROADCASTING_THREAD = new NamedThreadFactory("network connector");
    private final Thread thread = BASE_BROADCASTING_THREAD.newThread(() -> {
        TcpIoStream stream = null;
        try {
            stream = new TcpIoStream("[network connector] ", socket, disconnectListener);
            IncomingDataBuffer in = stream.getDataBuffer();
            boolean isFirstHello = true;
            while (true) {
                int ioTimeout;
                if (isFirstHello) {
                    log.info("Waiting for proxy server to request session details");
                    ioTimeout = context.firstPacketTimeout();
                } else {
                    ioTimeout = context.consecutivePacketTimeout();
                }
                int length = BinaryProtocolServer.getPacketLength(in, () -> {
                    throw new UnsupportedOperationException();
                }, ioTimeout);
                BinaryProtocolServer.Packet packet = BinaryProtocolServer.readPromisedBytes(in, length);
                byte[] payload = packet.getPacket();
                byte command = payload[0];
                if (isFirstHello && command == 83) {
                    isFirstHello = false;
                    log.info("Replying to controller connector@proxy: " + sessionDetails);
                    new HelloCommand(sessionDetails.toJson()).handle(stream);
                    continue;
                }
                this.handleCommand(packet, stream);
            }
        }
        catch (IOException e) {
            log.error("exiting thread " + e);
            FileUtil.close(stream);
            return;
        }
    });

    public BaseBroadcastingThread(Socket socket, SessionDetails sessionDetails, TcpIoStream.DisconnectListener disconnectListener, NetworkConnectorContext context) {
    }

    protected void handleCommand(BinaryProtocolServer.Packet packet, TcpIoStream stream) throws IOException {
    }

    public void start() {
        this.thread.start();
    }
}

