/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.sensor_logs;

import com.devexperts.logging.Logging;
import com.rusefi.NamedThreadFactory;
import com.rusefi.core.Sensor;
import com.rusefi.core.SensorCentral;
import com.rusefi.sensor_logs.BinarySensorLog;
import com.rusefi.sensor_logs.SensorLog;
import com.rusefi.sensor_logs.SensorLogger;
import com.rusefi.tools.online.Online;
import com.rusefi.tools.online.UploadResult;
import com.rusefi.ui.AuthTokenPanel;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;

public class BinarySensorLogRestarter
implements SensorLog {
    private static final Logging log = Logging.getLogging(BinarySensorLogRestarter.class);
    private static final Executor UPLOAD_EXECUTOR = Executors.newSingleThreadExecutor(new NamedThreadFactory("BinarySensorLogRestarter"));
    private BinarySensorLog logger;
    private long seenRunning;

    @Override
    public double getSecondsSinceFileStart() {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized void writeSensorLogLine() {
        double rpm = SensorCentral.getInstance().getValue(Sensor.RPMValue);
        if (rpm > 200.0) {
            this.seenRunning = System.currentTimeMillis();
        }
        if (rpm == 0.0 && this.seenRunning > 0L && System.currentTimeMillis() - this.seenRunning > 5000L) {
            this.close();
        }
        if (this.logger == null) {
            Collection<Sensor> sensorsForLogging = BinarySensorLogRestarter.filterOutSensorsWithoutType(SensorLogger.SENSORS);
            this.logger = new BinarySensorLog<Sensor>(sensor -> SensorCentral.getInstance().getValue((Sensor)sensor), sensorsForLogging);
        }
        this.logger.writeSensorLogLine();
    }

    private static Collection<Sensor> filterOutSensorsWithoutType(Sensor[] sensors) {
        return Arrays.stream(sensors).filter(sensor -> sensor.getType() != null).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    public synchronized void close() {
        if (this.logger != null) {
            this.logger.close();
            String fileName = this.logger.getFileName();
            this.scheduleUpload(fileName);
        }
        this.logger = null;
        this.seenRunning = 0L;
    }

    private void scheduleUpload(final String fileName) {
        log.error("Will upload " + fileName);
        UPLOAD_EXECUTOR.execute(new Runnable(){

            @Override
            public void run() {
                UploadResult result = Online.upload(new File(fileName), AuthTokenPanel.getAuthToken());
                System.out.println(result.toString());
            }
        });
    }
}

