/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.tools.online;

import com.devexperts.logging.Logging;
import java.io.IOException;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class HttpUtil {
    private static final Logging log = Logging.getLogging(Logging.class);
    public static final String RUSEFI_PROXY_JSON_PROTOCOL = "http://";
    public static final int PROXY_JSON_API_HTTP_PORT = HttpUtil.getIntProperty("http.port", 8001);
    public static String RUSEFI_PROXY_HOSTNAME = System.getProperty("RUSEFI_PROXY_URL", "proxy.rusefi.com");
    public static String RUSEFI_ONLINE_JSON_API_PREFIX = "https://rusefi.com/online/api.php?method=";

    public static <T> T getJsonResponse(String responseString) throws org.json.simple.parser.ParseException {
        JSONParser parser = new JSONParser();
        return (T)parser.parse(responseString);
    }

    public static String getResponse(CloseableHttpResponse response) throws IOException {
        HttpEntity entity = response.getEntity();
        try {
            String responseString = EntityUtils.toString(entity, "UTF-8");
            log.info("responseString=" + responseString);
            return responseString;
        }
        catch (IOException | ParseException e) {
            log.info("Error decoding the response string!");
            e.printStackTrace();
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String executeGet(String url) throws IOException {
        SocketConfig socketConfig = SocketConfig.custom().setSoKeepAlive(true).setTcpNoDelay(true).build();
        PoolingHttpClientConnectionManager connectionManager = PoolingHttpClientConnectionManagerBuilder.create().setDefaultSocketConfig(socketConfig).build();
        CloseableHttpClient httpclient = HttpClients.custom().setConnectionManager(connectionManager).build();
        log.info("GET " + url);
        HttpGet httpget = new HttpGet(url);
        try {
            CloseableHttpResponse httpResponse = httpclient.execute(httpget);
            String string = HttpUtil.getResponse(httpResponse);
            return string;
        }
        finally {
            httpclient.close();
        }
    }

    public static JSONObject parse(String jsonString) {
        JSONObject jsonObject;
        JSONParser parser = new JSONParser();
        try {
            jsonObject = (JSONObject)parser.parse(jsonString);
        }
        catch (org.json.simple.parser.ParseException e) {
            throw new IllegalStateException(e);
        }
        return jsonObject;
    }

    public static int getIntProperty(String propertyName, int defaultValue) {
        return Integer.parseInt(System.getProperty(propertyName, Integer.toString(defaultValue)));
    }
}

