/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui;

import com.rusefi.core.preferences.storage.Node;
import com.rusefi.ui.MessagesPanel;
import com.rusefi.ui.RecentCommands;
import com.rusefi.ui.RpmLabel;
import com.rusefi.ui.UIContext;
import com.rusefi.ui.WarningPanel;
import com.rusefi.ui.util.URLLabel;
import com.rusefi.ui.widgets.AnyCommand;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class MessagesPane {
    private static final String HELP_URL = "http://rusefi.com/wiki/index.php?title=Manual:Software:dev_console_commands";
    private final JPanel content = new JPanel(new BorderLayout()){

        @Override
        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            return new Dimension(250, size.height);
        }
    };
    private final AnyCommand command;

    public MessagesPane(UIContext uiContext, Node config) {
        JPanel topPanel = new JPanel(new FlowLayout(0, 5, 0));
        this.command = AnyCommand.createArea(uiContext, config, config.getProperty("last_value"), true, false);
        MessagesPanel upperPanel = new MessagesPanel(this.command.getContent(), config);
        upperPanel.loadFont(config);
        JPanel middlePanel = new JPanel(new BorderLayout());
        middlePanel.add((Component)upperPanel.getMessagesScroll(), "Center");
        middlePanel.add(new RecentCommands(uiContext).getContent(), "East");
        this.content.add((Component)middlePanel, "Center");
        upperPanel.getButtonPanel().add(new RpmLabel(uiContext, 2).getContent());
        topPanel.add(upperPanel.getButtonPanel());
        topPanel.add(new URLLabel("Click here for online help", HELP_URL));
        this.content.add((Component)topPanel, "North");
        JPanel statsPanel = new JPanel(new FlowLayout(0));
        statsPanel.add(new RpmLabel(uiContext).getContent());
        statsPanel.add(new WarningPanel(config).getPanel(config));
        this.content.add((Component)statsPanel, "South");
    }

    public JComponent getContent() {
        return this.content;
    }

    public ActionListener getTabSelectedListener() {
        return e -> this.command.requestFocus();
    }
}

