/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui;

import com.devexperts.logging.Logging;
import com.rusefi.IoUtil;
import com.rusefi.core.preferences.storage.PersistentConfiguration;
import com.rusefi.core.ui.AutoupdateUtil;
import com.rusefi.io.CommandQueue;
import com.rusefi.ui.UIContext;
import com.rusefi.ui.util.UiUtils;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class RecentCommands {
    private static final Logging log = Logging.getLogging(RecentCommands.class);
    private static final int NUMBER_OF_COMMANDS = 40;
    private static final String KEY = "recent_commands";
    private static final String DELIMETER = "|";
    private static final String STOPENGINE = "stopengine";
    private static final String SHOWCONFIG = "showconfig";
    private static final String HELP = "help";
    private static final String SENSORINFO = "sensorinfo";
    private static final String IDLEINFO = "idleinfo";
    private static final String ALTINFO = "altinfo";
    private static final String TPSINFO = "tpsinfo";
    private static final String MAPINFO = "mapinfo";
    private static final String ACCELINFO = "accelinfo";
    private static final String CANINFO = "caninfo";
    private static final String TSINFO = "tsinfo";
    private static final String FUELINFO = "fuelinfo";
    private static final String SDINFO = "sdinfo";
    private static final String PINS = "pins";
    private static final Map<String, Icon> COMMAND_ICONS = new TreeMap<String, Icon>(String.CASE_INSENSITIVE_ORDER);
    private final JPanel content = new JPanel(new GridLayout(41, 1));
    private static final LinkedHashMap<Entry, Object> entries;
    private final AtomicBoolean reentrant = new AtomicBoolean();
    private final JScrollPane messagesScroll = new JScrollPane(this.content, 22, 30);
    private final UIContext uiContext;

    public RecentCommands(UIContext uiContext) {
        this.uiContext = uiContext;
        uiContext.getCommandQueue().addListener(command -> {
            if (!this.reentrant.get()) {
                this.add((String)command);
            }
        });
        String value = PersistentConfiguration.getConfig().getRoot().getProperty(KEY, null);
        if (value != null && value.trim().length() > 5) {
            this.unpack(value);
        } else {
            this.addDefaults();
        }
    }

    private void unpack(String value) {
        entries.clear();
        for (String command : value.split("\\|")) {
            this.add(command);
        }
    }

    private void addDefaults() {
        this.add(HELP);
        this.add(SHOWCONFIG);
        this.add(STOPENGINE);
        this.add(SENSORINFO);
        this.add("triggerinfo");
        this.add(TSINFO);
        this.add(CANINFO);
        this.add("writeconfig");
        this.add("rewriteconfig");
        this.add(IoUtil.getEnableCommand("injection"));
        this.add(IoUtil.getDisableCommand("injection"));
        this.add(IoUtil.getEnableCommand("ignition"));
        this.add(IoUtil.getDisableCommand("ignition"));
        this.add(IoUtil.getEnableCommand("self_stimulation"));
        this.add(IoUtil.getDisableCommand("self_stimulation"));
        this.add("blipidle 80 2000");
        this.add("set_idle_position 50");
        this.add("sparkbench 5 400 2");
        this.add("fuelbench 5 400 2");
        this.add(MAPINFO);
        this.add(ACCELINFO);
        this.add(FUELINFO);
        this.add(SDINFO);
        this.add(PINS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String command) {
        if (RecentCommands.isBoringCommand(command)) {
            return;
        }
        LinkedHashMap<Entry, Object> linkedHashMap = entries;
        synchronized (linkedHashMap) {
            entries.put(new Entry(command), null);
        }
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                RecentCommands.this.content.removeAll();
                JButton reset = new JButton(AutoupdateUtil.loadIcon("undo.jpg"));
                reset.setContentAreaFilled(false);
                reset.setFocusPainted(false);
                reset.setBorder(BorderFactory.createEmptyBorder());
                RecentCommands.this.content.add(UiUtils.wrap(reset));
                reset.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        entries.clear();
                        RecentCommands.this.addDefaults();
                    }
                });
                LinkedHashMap linkedHashMap = entries;
                synchronized (linkedHashMap) {
                    TreeSet sorted = new TreeSet(entries.keySet());
                    for (Entry entry : sorted) {
                        RecentCommands.this.content.add(RecentCommands.createButton(RecentCommands.this.uiContext, RecentCommands.this.reentrant, entry.command));
                    }
                }
                AutoupdateUtil.trueLayoutAndRepaint(RecentCommands.this.content.getParent());
            }
        });
        PersistentConfiguration.getConfig().getRoot().setProperty(KEY, this.pack());
    }

    public static boolean isBoringCommand(String command) {
        return command.startsWith(IoUtil.getSetCommand("date"));
    }

    public static JComponent createButton(final UIContext uiContext, final AtomicBoolean reentrant, final String command) {
        JButton button = new JButton(command);
        Icon icon = COMMAND_ICONS.get(command);
        if (icon != null) {
            button.setIcon(icon);
        }
        button.setBorder(BorderFactory.createEmptyBorder(3, 5, 0, 5));
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                reentrant.set(true);
                int timeout = CommandQueue.getTimeout(command);
                uiContext.getCommandQueue().write(command, timeout);
                reentrant.set(false);
            }
        });
        return UiUtils.wrap(button);
    }

    public Component getContent() {
        return this.messagesScroll;
    }

    public String pack() {
        StringBuilder sb = new StringBuilder();
        for (Entry command : entries.keySet()) {
            if (sb.length() != 0) {
                sb.append(DELIMETER);
            }
            sb.append(command.command);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getRecent(int index) {
        ArrayList<Entry> elements;
        index = Math.max(0, index);
        LinkedHashMap<Entry, Object> linkedHashMap = entries;
        synchronized (linkedHashMap) {
            elements = new ArrayList<Entry>(entries.keySet());
        }
        if (index >= elements.size()) {
            return ((Entry)elements.get(0)).command;
        }
        return ((Entry)elements.get(elements.size() - 1 - index)).command;
    }

    static {
        COMMAND_ICONS.put(STOPENGINE, AutoupdateUtil.loadIcon("stop.jpg"));
        ImageIcon infoIcon = AutoupdateUtil.loadIcon("info.png");
        COMMAND_ICONS.put(HELP, AutoupdateUtil.loadIcon("help.jpg"));
        COMMAND_ICONS.put(SENSORINFO, infoIcon);
        COMMAND_ICONS.put("triggerinfo", AutoupdateUtil.loadIcon("trigger.jpg"));
        COMMAND_ICONS.put(TSINFO, infoIcon);
        COMMAND_ICONS.put(MAPINFO, infoIcon);
        COMMAND_ICONS.put(CANINFO, infoIcon);
        COMMAND_ICONS.put(FUELINFO, infoIcon);
        COMMAND_ICONS.put(SDINFO, AutoupdateUtil.loadIcon("sdinfo.jpg"));
        COMMAND_ICONS.put(PINS, infoIcon);
        COMMAND_ICONS.put("writeconfig", AutoupdateUtil.loadIcon("writeconfig.jpg"));
        entries = new LinkedHashMap<Entry, Object>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<Entry, Object> eldest) {
                return this.size() > 40;
            }
        };
    }

    static class Entry
    implements Comparable<Entry> {
        private final String command;

        Entry(String command) {
            this.command = command;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entry entry = (Entry)o;
            return !(this.command == null ? entry.command != null : !this.command.equals(entry.command));
        }

        public int hashCode() {
            return this.command != null ? this.command.hashCode() : 0;
        }

        public String toString() {
            return "{command='" + this.command + '\'' + '}';
        }

        @Override
        public int compareTo(Entry o) {
            return this.command.compareTo(o.command);
        }
    }
}

