/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui;

import com.rusefi.core.ui.AutoupdateUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.MenuSelectionManager;

public class SizeSelectorPanel
extends JPanel {
    public static final int WIDTH = 5;
    public static final int HEIGHT = 3;
    private int selectedRow = 1;
    private int selectedColumn = 1;

    public SizeSelectorPanel(final SizeSelectorListener sizeSelectorListener) {
        super(new GridLayout(3, 5));
        MouseAdapter listener = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                Element selected = (Element)e.getSource();
                SizeSelectorPanel.this.selectedColumn = selected.column;
                SizeSelectorPanel.this.selectedRow = selected.row;
                AutoupdateUtil.trueLayoutAndRepaint(SizeSelectorPanel.this);
                AutoupdateUtil.trueLayoutAndRepaint(SizeSelectorPanel.this);
                System.out.println(SizeSelectorPanel.this.selectedColumn + " r=" + SizeSelectorPanel.this.selectedRow);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                MenuSelectionManager.defaultManager().clearSelectedPath();
                Element selected = (Element)e.getSource();
                sizeSelectorListener.onSelected(selected.row, selected.column);
            }
        };
        for (int r = 1; r <= 3; ++r) {
            for (int c = 1; c <= 5; ++c) {
                Element e = new Element(r, c);
                e.addMouseListener(listener);
                this.add(e);
            }
        }
    }

    static interface SizeSelectorListener {
        public void onSelected(int var1, int var2);
    }

    class Element
    extends JPanel {
        private final int row;
        private final int column;

        public Element(int row, int column) {
            this.row = row;
            this.column = column;
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(25, 25);
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            boolean isSelected = this.row <= SizeSelectorPanel.this.selectedRow && this.column <= SizeSelectorPanel.this.selectedColumn;
            g.setColor(isSelected ? Color.black : Color.white);
            g.drawOval(5, 5, 15, 15);
        }
    }
}

