/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.updater;

import com.devexperts.logging.Logging;
import com.opensr5.ini.IniFileModel;
import com.rusefi.ScannerHelper;
import com.rusefi.binaryprotocol.BinaryProtocol;
import com.rusefi.io.ConnectionStateListener;
import com.rusefi.io.IoStream;
import com.rusefi.io.LinkManager;
import com.rusefi.updater.OpenbltDetectorStrategy;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class PlainSerialPortScanner {
    private static final Logging log = Logging.getLogging(PlainSerialPortScanner.class);

    public static void findEcu(PlainSerialEcuConsumer consumer, int delayMillis) {
        Set<String> serialPorts = LinkManager.getCommPorts();
        List<Thread> threads = serialPorts.stream().map(port -> {
            String threadName = "PlainSerialPortScanner inspectPort " + port;
            Thread t = new Thread(() -> {
                try (LinkManager linkManager = new LinkManager().setNeedPullText(false).setNeedPullLiveData(false);){
                    linkManager.start((String)port, s -> {});
                    linkManager.getConnector().connectAndReadConfiguration(new BinaryProtocol.Arguments(false, false), new ConnectionStateListener((String)port, linkManager, consumer){
                        final /* synthetic */ String val$port;
                        final /* synthetic */ LinkManager val$linkManager;
                        final /* synthetic */ PlainSerialEcuConsumer val$consumer;
                        {
                            this.val$port = string;
                            this.val$linkManager = linkManager;
                            this.val$consumer = plainSerialEcuConsumer;
                        }

                        @Override
                        public void onConnectionEstablished() {
                            System.out.println("onConnectionEstablished " + this.val$port);
                            PlainSerialPortScanner.onConnectionEstablished(this.val$port, this.val$linkManager, this.val$consumer);
                        }

                        @Override
                        public void onConnectionFailed(String s) {
                            log.info("onConnectionFailed " + this.val$port);
                        }
                    });
                }
            });
            t.setName(threadName);
            t.setDaemon(true);
            t.start();
            return t;
        }).collect(Collectors.toList());
        try {
            Thread.sleep(delayMillis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ScannerHelper.interruptThreads(threads);
    }

    private static void onConnectionEstablished(String port, LinkManager linkManager, PlainSerialEcuConsumer consumer) {
        try {
            BinaryProtocol binaryProtocol = linkManager.getBinaryProtocol();
            Objects.requireNonNull(binaryProtocol, "binaryProtocol");
            IoStream stream = binaryProtocol.getStream();
            boolean hasOpenBlt = OpenbltDetectorStrategy.streamHasOpenBlt(stream);
            String signature = binaryProtocol.signature;
            linkManager.close();
            if (hasOpenBlt) {
                consumer.onFind(port, binaryProtocol.getIniFile());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static interface PlainSerialEcuConsumer {
        public void onFind(String var1, @NotNull IniFileModel var2);
    }
}

