/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.gauges;

import eu.hansolo.steelseries.gauges.AbstractLinear;
import eu.hansolo.steelseries.tools.ColorDef;
import eu.hansolo.steelseries.tools.CustomColorDef;
import eu.hansolo.steelseries.tools.Orientation;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RadialGradientPaint;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;

public abstract class AbstractLinearBargraph
extends AbstractLinear {
    public ColorDef getBarGraphColor() {
        return this.getModel().getValueColor();
    }

    public void setBarGraphColor(ColorDef BARGRAPH_COLOR) {
        this.getModel().setValueColor(BARGRAPH_COLOR);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    public Color getCustomBargraphColor() {
        return this.getModel().getCustomValueColor();
    }

    public void setCustomBarGraphColor(Color COLOR) {
        this.getModel().setCustomValueColorObject(new CustomColorDef(COLOR));
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    public CustomColorDef getCustomBarGraphColorObject() {
        return this.getModel().getCustomValueColorObject();
    }

    public boolean isPeakValueEnabled() {
        return this.getModel().isPeakValueVisible();
    }

    public void setPeakValueEnabled(boolean PEAK_VALUE_ENABLED) {
        this.getModel().setPeakValueVisible(PEAK_VALUE_ENABLED);
    }

    protected BufferedImage create_BARGRAPH_LED_Image(int WIDTH, int HEIGHT, ColorDef COLOR, Color[] CUSTOM_COLORS) {
        float RADIUS;
        int IMAGE_HEIGHT;
        int IMAGE_WIDTH;
        if (WIDTH <= 20 || HEIGHT <= 20) {
            return UTIL.createImage(1, 1, 3);
        }
        if (this.getOrientation() == Orientation.VERTICAL) {
            IMAGE_WIDTH = (int)((double)WIDTH * 0.1214285714);
            IMAGE_HEIGHT = (int)((double)HEIGHT * 0.0121359223);
        } else {
            IMAGE_HEIGHT = (int)((double)WIDTH * 0.0121359223);
            IMAGE_WIDTH = (int)((double)HEIGHT * 0.1214285714);
        }
        BufferedImage IMAGE = UTIL.createImage(IMAGE_WIDTH, IMAGE_HEIGHT, 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Rectangle2D.Double LED = new Rectangle2D.Double(0.0, 0.0, IMAGE_WIDTH, IMAGE_HEIGHT);
        Point2D.Double CENTER = new Point2D.Double(LED.getCenterX(), LED.getCenterY());
        float[] FRACTIONS = new float[]{0.0f, 1.0f};
        Color[] COLORS = CUSTOM_COLORS != null && CUSTOM_COLORS.length == 2 ? CUSTOM_COLORS : new Color[]{COLOR.LIGHT, COLOR.DARK};
        switch (this.getOrientation()) {
            default: {
                RADIUS = (float)(((RectangularShape)LED).getWidth() / 2.0);
                break;
            }
            case HORIZONTAL: {
                RADIUS = (float)(((RectangularShape)LED).getHeight() / 2.0);
            }
        }
        RadialGradientPaint GRADIENT = new RadialGradientPaint(CENTER, RADIUS, FRACTIONS, COLORS);
        G2.setPaint(GRADIENT);
        G2.fill(LED);
        G2.dispose();
        return IMAGE;
    }
}

