/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.gauges;

import eu.hansolo.steelseries.gauges.AbstractGauge;
import eu.hansolo.steelseries.gauges.Lcd;
import eu.hansolo.steelseries.tools.ColorDef;
import eu.hansolo.steelseries.tools.ConicalGradientPaint;
import eu.hansolo.steelseries.tools.CustomColorDef;
import eu.hansolo.steelseries.tools.Direction;
import eu.hansolo.steelseries.tools.ForegroundType;
import eu.hansolo.steelseries.tools.FrameType;
import eu.hansolo.steelseries.tools.GaugeType;
import eu.hansolo.steelseries.tools.KnobStyle;
import eu.hansolo.steelseries.tools.KnobType;
import eu.hansolo.steelseries.tools.LcdColor;
import eu.hansolo.steelseries.tools.NumberSystem;
import eu.hansolo.steelseries.tools.Orientation;
import eu.hansolo.steelseries.tools.PointerType;
import eu.hansolo.steelseries.tools.PostPosition;
import eu.hansolo.steelseries.tools.TicklabelOrientation;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;
import org.pushingpixels.trident.Timeline;
import org.pushingpixels.trident.TimelineScenario;
import org.pushingpixels.trident.callback.TimelineCallback;
import org.pushingpixels.trident.ease.Sine;
import org.pushingpixels.trident.ease.Spline;
import org.pushingpixels.trident.ease.TimelineEase;

public abstract class AbstractRadial
extends AbstractGauge
implements Lcd {
    protected static final float ANGLE_CONST = 0.0027777778f;
    private final Rectangle INNER_BOUNDS;
    private final Rectangle GAUGE_BOUNDS;
    private final Rectangle FRAMELESS_BOUNDS;
    private final Point2D FRAMELESS_OFFSET;
    private boolean transparentSectionsEnabled = false;
    private boolean transparentAreasEnabled = false;
    private boolean expandedSectionsEnabled = false;
    private Direction tickmarkDirection;
    private Point2D ledPosition;
    private Point2D userLedPosition;
    private String lcdUnitString;
    private double lcdValue = 0.0;
    private String lcdInfoString = "";
    private Timeline lcdTimeline = new Timeline(this);
    private boolean lcdTextVisible = true;
    private Timer LCD_BLINKING_TIMER;
    private Timeline timeline;
    private final TimelineEase STANDARD_EASING;
    private final TimelineEase RETURN_TO_ZERO_EASING;
    private TimelineCallback timelineCallback;
    private int horizontalAlignment = 0;
    private int verticalAlignment = 0;

    public AbstractRadial() {
        this.lcdUnitString = this.getUnitString();
        this.ledPosition = new Point2D.Double(0.6, 0.4);
        this.userLedPosition = new Point2D.Double(0.3, 0.4);
        this.INNER_BOUNDS = new Rectangle(200, 200);
        this.GAUGE_BOUNDS = new Rectangle(200, 200);
        this.FRAMELESS_BOUNDS = new Rectangle(200, 200);
        this.FRAMELESS_OFFSET = new Point2D.Double(0.0, 0.0);
        this.tickmarkDirection = Direction.CLOCKWISE;
        this.timeline = new Timeline(this);
        this.STANDARD_EASING = new Spline(0.5f);
        this.RETURN_TO_ZERO_EASING = new Sine();
        this.LCD_BLINKING_TIMER = new Timer(500, this);
        this.addComponentListener(this);
    }

    public GaugeType getGaugeType() {
        return this.getModel().getGaugeType();
    }

    public void setGaugeType(GaugeType GAUGE_TYPE) {
        this.getModel().setGaugeType(GAUGE_TYPE);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    public FrameType getFrameType() {
        return this.getModel().getFrameType();
    }

    public void setFrameType(FrameType FRAME_TYPE) {
        this.getModel().setFrameType(FRAME_TYPE);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    public ForegroundType getForegroundType() {
        return this.getModel().getForegroundType();
    }

    public void setForegroundType(ForegroundType FOREGROUND_TYPE) {
        this.getModel().setForegroundType(FOREGROUND_TYPE);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    public void setValueAnimated(double VALUE) {
        if (this.isEnabled()) {
            double TARGET_VALUE;
            if (this.timeline.getState() != Timeline.TimelineState.IDLE) {
                this.timeline.abort();
            }
            double d = VALUE < this.getMinValue() ? this.getMinValue() : (TARGET_VALUE = VALUE > this.getMaxValue() ? this.getMaxValue() : VALUE);
            if (!this.isAutoResetToZero()) {
                this.timeline.removeCallback(this.timelineCallback);
                this.timeline = new Timeline(this);
                this.timeline.addPropertyToInterpolate("value", this.getValue(), TARGET_VALUE);
                this.timeline.setEase(this.STANDARD_EASING);
                this.timeline.setDuration(this.getStdTimeToValue());
                this.timelineCallback = new TimelineCallback(){

                    @Override
                    public void onTimelineStateChanged(Timeline.TimelineState OLD_STATE, Timeline.TimelineState NEW_STATE, float OLD_VALUE, float NEW_VALUE) {
                        if (NEW_STATE == Timeline.TimelineState.IDLE) {
                            SwingUtilities.invokeLater(() -> AbstractRadial.this.repaint(AbstractRadial.this.getInnerBounds()));
                        }
                        if (AbstractRadial.this.getValue() > AbstractRadial.this.getMaxMeasuredValue()) {
                            AbstractRadial.this.setMaxMeasuredValue(AbstractRadial.this.getValue());
                        }
                    }

                    @Override
                    public void onTimelinePulse(float OLD_VALUE, float NEW_VALUE) {
                        if (AbstractRadial.this.getValue() > AbstractRadial.this.getMaxMeasuredValue()) {
                            AbstractRadial.this.setMaxMeasuredValue(AbstractRadial.this.getValue());
                        }
                        if (AbstractRadial.this.getValue() < AbstractRadial.this.getMinMeasuredValue()) {
                            AbstractRadial.this.setMinMeasuredValue(AbstractRadial.this.getValue());
                        }
                    }
                };
                this.timeline.addCallback(this.timelineCallback);
                this.timeline.play();
            } else {
                TimelineScenario.Sequence AUTOZERO_SCENARIO = new TimelineScenario.Sequence();
                Timeline TIMELINE_TO_VALUE = new Timeline(this);
                TIMELINE_TO_VALUE.addPropertyToInterpolate("value", this.getValue(), TARGET_VALUE);
                TIMELINE_TO_VALUE.setEase(this.RETURN_TO_ZERO_EASING);
                TIMELINE_TO_VALUE.setDuration(this.getRtzTimeToValue());
                TIMELINE_TO_VALUE.addCallback(new TimelineCallback(){

                    @Override
                    public void onTimelineStateChanged(Timeline.TimelineState oldState, Timeline.TimelineState newState, float oldValue, float newValue) {
                        if (oldState == Timeline.TimelineState.PLAYING_FORWARD && newState == Timeline.TimelineState.DONE) {
                            AbstractRadial.this.getModel().setPeakValue(AbstractRadial.this.getValue());
                            AbstractRadial.this.getModel().setPeakValueVisible(true);
                            if (AbstractRadial.this.getPeakTimer().isRunning()) {
                                AbstractRadial.this.stopPeakTimer();
                            }
                            AbstractRadial.this.startPeakTimer();
                            if (AbstractRadial.this.getValue() > AbstractRadial.this.getMaxMeasuredValue()) {
                                AbstractRadial.this.setMaxMeasuredValue(AbstractRadial.this.getValue());
                            }
                        }
                    }

                    @Override
                    public void onTimelinePulse(float oldValue, float newValue) {
                        if (AbstractRadial.this.getValue() > AbstractRadial.this.getMaxMeasuredValue()) {
                            AbstractRadial.this.setMaxMeasuredValue(AbstractRadial.this.getValue());
                        }
                        if (AbstractRadial.this.getValue() < AbstractRadial.this.getMinMeasuredValue()) {
                            AbstractRadial.this.setMinMeasuredValue(AbstractRadial.this.getValue());
                        }
                    }
                });
                Timeline TIMELINE_TO_ZERO = new Timeline(this);
                TIMELINE_TO_ZERO.addPropertyToInterpolate("value", TARGET_VALUE, 0.0);
                TIMELINE_TO_ZERO.setEase(this.RETURN_TO_ZERO_EASING);
                TIMELINE_TO_ZERO.setDuration(this.getRtzTimeBackToZero());
                ((TimelineScenario)AUTOZERO_SCENARIO).addScenarioActor(TIMELINE_TO_VALUE);
                ((TimelineScenario)AUTOZERO_SCENARIO).addScenarioActor(TIMELINE_TO_ZERO);
                AUTOZERO_SCENARIO.play();
            }
        }
    }

    public double getAngleStep() {
        return this.getModel().getAngleStep();
    }

    public double getLogAngleStep() {
        return this.getModel().getLogAngleStep();
    }

    public double getFreeAreaAngle() {
        return this.getModel().getFreeAreaAngle();
    }

    public double getRotationOffset() {
        return this.getModel().getRotationOffset();
    }

    public double getTickmarkOffset() {
        return this.getModel().getTickmarkOffset();
    }

    public int getMaxNoOfMinorTicks() {
        return this.getModel().getMaxNoOfMinorTicks();
    }

    public void setMaxNoOfMinorTicks(int MAX_NO_OF_MINOR_TICKS) {
        this.getModel().setMaxNoOfMinorTicks(MAX_NO_OF_MINOR_TICKS);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    public int getMaxNoOfMajorTicks() {
        return this.getModel().getMaxNoOfMajorTicks();
    }

    public void setMaxNoOfMajorTicks(int MAX_NO_OF_MAJOR_TICKS) {
        this.getModel().setMaxNoOfMajorTicks(MAX_NO_OF_MAJOR_TICKS);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public Point2D getLedPosition() {
        return this.ledPosition;
    }

    @Override
    public void setLedPosition(double X, double Y) {
        this.ledPosition.setLocation(X, Y);
        this.repaint(this.getInnerBounds());
    }

    public void setLedPosition(Point2D LED_POSITION) {
        this.ledPosition.setLocation(LED_POSITION);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public Point2D getUserLedPosition() {
        return this.userLedPosition;
    }

    @Override
    public void setUserLedPosition(double X, double Y) {
        this.userLedPosition.setLocation(X, Y);
        this.repaint(this.getInnerBounds());
    }

    public void setUserLedPosition(Point2D USER_LED_POSITION) {
        this.userLedPosition.setLocation(USER_LED_POSITION);
        this.repaint(this.getInnerBounds());
    }

    public Direction getTickmarkDirection() {
        return this.tickmarkDirection;
    }

    public void setTickmarkDirection(Direction DIRECTION) {
        this.tickmarkDirection = DIRECTION;
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    public PointerType getPointerType() {
        return this.getModel().getPointerType();
    }

    public void setPointerType(PointerType POINTER_TYPE) {
        this.getModel().setPointerType(POINTER_TYPE);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    public ColorDef getPointerColor() {
        return this.getModel().getPointerColor();
    }

    public void setPointerColor(ColorDef POINTER_COLOR) {
        this.getModel().setPointerColor(POINTER_COLOR);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    public boolean isPointerShadowVisible() {
        return this.getModel().isPointerShadowVisible();
    }

    public void setPointerShadowVisible(boolean POINTER_SHADOW_VISIBLE) {
        this.getModel().setPointerShadowVisible(POINTER_SHADOW_VISIBLE);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    public Color getCustomPointerColor() {
        return this.getModel().getCustomPointerColor();
    }

    public void setCustomPointerColor(Color COLOR) {
        this.getModel().setCustomPointerColorObject(new CustomColorDef(COLOR));
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    public CustomColorDef getCustomPointerColorObject() {
        return this.getModel().getCustomPointerColorObject();
    }

    public KnobType getKnobType() {
        return this.getModel().getKnobType();
    }

    public void setKnobType(KnobType KNOB_TYPE) {
        this.getModel().setKnobType(KNOB_TYPE);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    public KnobStyle getKnobStyle() {
        return this.getModel().getKnobStyle();
    }

    public void setKnobStyle(KnobStyle KNOB_STYLE) {
        this.getModel().setKnobStyle(KNOB_STYLE);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    public boolean isLcdVisible() {
        return this.getModel().isLcdVisible();
    }

    public void setLcdVisible(boolean LCD_VISIBLE) {
        this.getModel().setLcdVisible(LCD_VISIBLE);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    public boolean isLcdTextVisible() {
        return this.lcdTextVisible;
    }

    public boolean isRangeOfMeasuredValuesVisible() {
        return this.getModel().isRangeOfMeasuredValuesVisible();
    }

    public void setRangeOfMeasuredValuesVisible(boolean RANGE_OF_MEASURED_VALUES_VISIBLE) {
        this.getModel().setRangeOfMeasuredValuesVisible(RANGE_OF_MEASURED_VALUES_VISIBLE);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public boolean isValueCoupled() {
        return this.getModel().isValueCoupled();
    }

    @Override
    public void setValueCoupled(boolean VALUE_COUPLED) {
        this.getModel().setValueCoupled(VALUE_COUPLED);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public double getLcdValue() {
        return this.getModel().getLcdValue();
    }

    @Override
    public void setLcdValue(double LCD_VALUE) {
        if (this.getLcdNumberSystem() != NumberSystem.DEC && LCD_VALUE < 0.0) {
            this.setLcdNumberSystem(NumberSystem.DEC);
        }
        this.lcdValue = !this.isLogScale() ? LCD_VALUE : (LCD_VALUE > 1.0 ? LCD_VALUE : 1.0);
        this.getModel().setLcdValue(this.lcdValue);
        this.repaint(this.getLcdBounds());
    }

    @Override
    public void setLcdValueAnimated(double LCD_VALUE) {
        if (this.lcdTimeline.getState() == Timeline.TimelineState.PLAYING_FORWARD || this.lcdTimeline.getState() == Timeline.TimelineState.PLAYING_REVERSE) {
            this.lcdTimeline.abort();
        }
        this.lcdTimeline = new Timeline(this);
        this.lcdTimeline.addPropertyToInterpolate("lcdValue", this.lcdValue, LCD_VALUE);
        this.lcdTimeline.setEase(new Spline(0.5f));
        this.lcdTimeline.play();
    }

    @Override
    public double getLcdThreshold() {
        return this.getModel().getLcdThreshold();
    }

    @Override
    public void setLcdThreshold(double LCD_THRESHOLD) {
        this.getModel().setLcdThreshold(LCD_THRESHOLD);
        if (this.getModel().isLcdThresholdVisible()) {
            this.repaint(this.getInnerBounds());
        }
    }

    @Override
    public boolean isLcdThresholdVisible() {
        return this.getModel().isLcdThresholdVisible();
    }

    @Override
    public void setLcdThresholdVisible(boolean LCD_THRESHOLD_VISIBLE) {
        this.getModel().setLcdThresholdVisible(LCD_THRESHOLD_VISIBLE);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public boolean isLcdThresholdBehaviourInverted() {
        return this.getModel().isLcdThresholdBehaviourInverted();
    }

    @Override
    public void setLcdThresholdBehaviourInverted(boolean LCD_THRESHOLD_BEHAVIOUR_INVERTED) {
        this.getModel().setLcdThresholdBehaviourInverted(LCD_THRESHOLD_BEHAVIOUR_INVERTED);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public boolean isLcdBlinking() {
        return this.getModel().isLcdBlinking();
    }

    @Override
    public void setLcdBlinking(boolean LCD_BLINKING) {
        if (LCD_BLINKING) {
            this.LCD_BLINKING_TIMER.start();
        } else {
            this.LCD_BLINKING_TIMER.stop();
            this.lcdTextVisible = true;
        }
        this.getModel().setLcdBlinking(LCD_BLINKING);
    }

    @Override
    public String getLcdUnitString() {
        return this.lcdUnitString;
    }

    @Override
    public void setLcdUnitString(String UNIT_STRING) {
        this.lcdUnitString = UNIT_STRING;
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public boolean isLcdUnitStringVisible() {
        return this.getModel().isLcdUnitStringVisible();
    }

    @Override
    public void setLcdUnitStringVisible(boolean UNIT_STRING_VISIBLE) {
        this.getModel().setLcdUnitStringVisible(UNIT_STRING_VISIBLE);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public boolean isDigitalFont() {
        return this.getModel().isDigitalFontEnabled();
    }

    @Override
    public void setDigitalFont(boolean DIGITAL_FONT) {
        this.getModel().setDigitalFontEnabled(DIGITAL_FONT);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public boolean isCustomLcdUnitFontEnabled() {
        return this.getModel().isCustomLcdUnitFontEnabled();
    }

    @Override
    public void setCustomLcdUnitFontEnabled(boolean USE_CUSTOM_LCD_UNIT_FONT) {
        this.getModel().setCustomLcdUnitFontEnabled(USE_CUSTOM_LCD_UNIT_FONT);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public Font getCustomLcdUnitFont() {
        return this.getModel().getCustomLcdUnitFont();
    }

    @Override
    public void setCustomLcdUnitFont(Font CUSTOM_LCD_UNIT_FONT) {
        this.getModel().setCustomLcdUnitFont(CUSTOM_LCD_UNIT_FONT);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public int getLcdDecimals() {
        return this.getModel().getLcdDecimals();
    }

    @Override
    public void setLcdDecimals(int DECIMALS) {
        this.getModel().setLcdDecimals(DECIMALS);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public LcdColor getLcdColor() {
        return this.getModel().getLcdColor();
    }

    @Override
    public void setLcdColor(LcdColor LCD_COLOR) {
        this.getModel().setLcdColor(LCD_COLOR);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public Paint getCustomLcdBackground() {
        return this.getModel().getCustomLcdBackground();
    }

    @Override
    public void setCustomLcdBackground(Paint CUSTOM_LCD_BACKGROUND) {
        this.getModel().setCustomLcdBackground(CUSTOM_LCD_BACKGROUND);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public Paint createCustomLcdBackgroundPaint(Color[] LCD_COLORS) {
        return null;
    }

    @Override
    public boolean isLcdBackgroundVisible() {
        return this.getModel().isLcdBackgroundVisible();
    }

    @Override
    public void setLcdBackgroundVisible(boolean LCD_BACKGROUND_VISIBLE) {
        this.getModel().setLcdBackgroundVisible(LCD_BACKGROUND_VISIBLE);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public Color getCustomLcdForeground() {
        return this.getModel().getCustomLcdForeground();
    }

    @Override
    public void setCustomLcdForeground(Color CUSTOM_LCD_FOREGROUND) {
        this.getModel().setCustomLcdForeground(CUSTOM_LCD_FOREGROUND);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public String formatLcdValue(double VALUE) {
        StringBuilder DEC_BUFFER = new StringBuilder(16);
        DEC_BUFFER.append("0");
        if (this.getModel().getLcdDecimals() > 0) {
            DEC_BUFFER.append(".");
        }
        for (int i = 0; i < this.getModel().getLcdDecimals(); ++i) {
            DEC_BUFFER.append("0");
        }
        if (this.getModel().isLcdScientificFormatEnabled()) {
            DEC_BUFFER.append("E0");
        }
        DEC_BUFFER.trimToSize();
        DecimalFormat DEC_FORMAT = new DecimalFormat(DEC_BUFFER.toString(), new DecimalFormatSymbols(Locale.US));
        return DEC_FORMAT.format(VALUE);
    }

    @Override
    public boolean isLcdScientificFormat() {
        return this.getModel().isLcdScientificFormatEnabled();
    }

    @Override
    public void setLcdScientificFormat(boolean LCD_SCIENTIFIC_FORMAT) {
        this.getModel().setLcdScientificFormatEnabled(LCD_SCIENTIFIC_FORMAT);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public Font getLcdValueFont() {
        return this.getModel().getLcdValueFont();
    }

    @Override
    public void setLcdValueFont(Font LCD_VALUE_FONT) {
        this.getModel().setLcdValueFont(LCD_VALUE_FONT);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public Font getLcdUnitFont() {
        return this.getModel().getLcdUnitFont();
    }

    @Override
    public void setLcdUnitFont(Font LCD_UNIT_FONT) {
        this.getModel().setLcdUnitFont(LCD_UNIT_FONT);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public Font getLcdInfoFont() {
        return this.getModel().getLcdInfoFont();
    }

    @Override
    public void setLcdInfoFont(Font LCD_INFO_FONT) {
        this.getModel().setLcdInfoFont(LCD_INFO_FONT);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public String getLcdInfoString() {
        return this.lcdInfoString;
    }

    @Override
    public void setLcdInfoString(String LCD_INFO_STRING) {
        this.lcdInfoString = LCD_INFO_STRING;
        this.repaint(this.getInnerBounds());
    }

    @Override
    public NumberSystem getLcdNumberSystem() {
        return this.getModel().getNumberSystem();
    }

    @Override
    public void setLcdNumberSystem(NumberSystem NUMBER_SYSTEM) {
        this.getModel().setNumberSystem(NUMBER_SYSTEM);
        switch (NUMBER_SYSTEM) {
            case HEX: {
                this.lcdInfoString = "hex";
                break;
            }
            case OCT: {
                this.lcdInfoString = "oct";
                break;
            }
            default: {
                this.lcdInfoString = "";
            }
        }
        this.repaint(this.getInnerBounds());
    }

    @Override
    public abstract Rectangle getLcdBounds();

    @Override
    public void toggleDesign() {
        if (this.getActiveDesign().equals(this.getDesign1())) {
            this.setActiveDesign(this.getDesign2());
        } else {
            this.setActiveDesign(this.getDesign1());
        }
    }

    @Override
    public boolean isGlowVisible() {
        return this.getModel().isGlowVisible();
    }

    public void setGlowVisible(boolean GLOW_VISIBLE) {
        this.getModel().setGlowVisible(GLOW_VISIBLE);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    public Color getGlowColor() {
        return this.getModel().getGlowColor();
    }

    public void setGlowColor(Color GLOW_COLOR) {
        this.getModel().setGlowColor(GLOW_COLOR);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    public boolean isGlowing() {
        return this.getModel().isGlowing();
    }

    public void setGlowing(boolean GLOWING) {
        this.getModel().setGlowing(GLOWING);
        this.repaint(this.getInnerBounds());
    }

    public Paint getOuterFrameColor() {
        return FRAME_FACTORY.getOuterFrameColor();
    }

    public void setOuterFrameColor(Paint OUTER_FRAME_COLOR) {
        FRAME_FACTORY.setOuterFrameColor(OUTER_FRAME_COLOR);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    public Paint getInnerFrameColor() {
        return FRAME_FACTORY.getInnerFrameColor();
    }

    public void setInnerFrameColor(Paint INNER_FRAME_COLOR) {
        FRAME_FACTORY.setInnerFrameColor(INNER_FRAME_COLOR);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    public boolean getPostsVisible() {
        return this.getModel().getPostsVisible();
    }

    public void setPostsVisible(boolean POSTS_VISIBLE) {
        this.getModel().setPostsVisible(POSTS_VISIBLE);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    public TicklabelOrientation getTicklabelOrientation() {
        return this.getModel().getTicklabelOrientation();
    }

    public void setTicklabelOrientation(TicklabelOrientation TICKLABEL_ORIENTATION) {
        this.getModel().setTicklabelOrienatation(TICKLABEL_ORIENTATION);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    public boolean isTransparentSectionsEnabled() {
        return this.transparentSectionsEnabled;
    }

    public void setTransparentSectionsEnabled(boolean TRANSPARENT_SECTIONS_ENABLED) {
        this.transparentSectionsEnabled = TRANSPARENT_SECTIONS_ENABLED;
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    public boolean isTransparentAreasEnabled() {
        return this.transparentAreasEnabled;
    }

    public void setTransparentAreasEnabled(boolean TRANSPARENT_AREAS_ENABLED) {
        this.transparentAreasEnabled = TRANSPARENT_AREAS_ENABLED;
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    public boolean isExpandedSectionsEnabled() {
        return this.expandedSectionsEnabled;
    }

    public void setExpandedSectionsEnabled(boolean EXPANDED_SECTIONS_ENABLED) {
        this.expandedSectionsEnabled = EXPANDED_SECTIONS_ENABLED;
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    protected RadialGradientPaint createSection3DEffectGradient(int WIDTH, float RADIUS_FACTOR) {
        Color[] COLORS;
        float[] FRACTIONS;
        if (this.isExpandedSectionsEnabled()) {
            FRACTIONS = new float[]{0.0f, 0.7f, 0.75f, 0.96f, 1.0f};
            COLORS = new Color[]{new Color(0.0f, 0.0f, 0.0f, 1.0f), new Color(0.9f, 0.9f, 0.9f, 0.2f), new Color(1.0f, 1.0f, 1.0f, 0.5f), new Color(0.18431373f, 0.18431373f, 0.18431373f, 0.3f), new Color(0.0f, 0.0f, 0.0f, 0.2f)};
        } else {
            FRACTIONS = new float[]{0.0f, 0.89f, 0.955f, 1.0f};
            COLORS = new Color[]{new Color(0.0f, 0.0f, 0.0f, 0.0f), new Color(0.0f, 0.0f, 0.0f, 0.3f), new Color(1.0f, 1.0f, 1.0f, 0.6f), new Color(0.0f, 0.0f, 0.0f, 0.4f)};
        }
        Point2D.Double GRADIENT_CENTER = new Point2D.Double((double)WIDTH / 2.0, (double)WIDTH / 2.0);
        return new RadialGradientPaint(GRADIENT_CENTER, (float)WIDTH * RADIUS_FACTOR, FRACTIONS, COLORS);
    }

    protected RadialGradientPaint createArea3DEffectGradient(int WIDTH, float RADIUS_FACTOR) {
        float[] FRACTIONS = new float[]{0.0f, 0.6f, 1.0f};
        Color[] COLORS = new Color[]{new Color(1.0f, 1.0f, 1.0f, 0.75f), new Color(1.0f, 1.0f, 1.0f, 0.0f), new Color(0.0f, 0.0f, 0.0f, 0.3f)};
        Point2D.Double GRADIENT_CENTER = new Point2D.Double((double)WIDTH / 2.0, (double)WIDTH / 2.0);
        return new RadialGradientPaint(GRADIENT_CENTER, (float)WIDTH * RADIUS_FACTOR, FRACTIONS, COLORS);
    }

    protected BufferedImage create_FRAME_Image(int WIDTH) {
        switch (this.getFrameType()) {
            case ROUND: {
                return FRAME_FACTORY.createRadialFrame(WIDTH, this.getFrameDesign(), this.getCustomFrameDesign(), this.getFrameBaseColor(), this.isFrameBaseColorEnabled(), this.getFrameEffect());
            }
            case SQUARE: {
                return FRAME_FACTORY.createLinearFrame(WIDTH, this.getFrameDesign(), this.getCustomFrameDesign(), this.getFrameBaseColor(), this.isFrameBaseColorEnabled(), this.getFrameEffect());
            }
        }
        return FRAME_FACTORY.createRadialFrame(WIDTH, this.getFrameDesign(), this.getCustomFrameDesign(), this.getFrameBaseColor(), this.isFrameBaseColorEnabled(), this.getFrameEffect());
    }

    protected BufferedImage create_BACKGROUND_Image(int WIDTH) {
        return this.create_BACKGROUND_Image(WIDTH, "", "");
    }

    protected BufferedImage create_BACKGROUND_Image(int WIDTH, String TITLE, String UNIT_STRING) {
        return this.create_BACKGROUND_Image(WIDTH, TITLE, UNIT_STRING, null);
    }

    protected BufferedImage create_BACKGROUND_Image(int WIDTH, String TITLE, String UNIT_STRING, BufferedImage image) {
        if (WIDTH <= 0) {
            return null;
        }
        if (image == null) {
            image = UTIL.createImage(WIDTH, WIDTH, 3);
        }
        Graphics2D G2 = image.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int IMAGE_WIDTH = image.getWidth();
        int IMAGE_HEIGHT = image.getHeight();
        switch (this.getFrameType()) {
            case SQUARE: {
                BACKGROUND_FACTORY.createLinearBackground(WIDTH, WIDTH, this.getBackgroundColor(), this.getModel().getCustomBackground(), this.getModel().getTextureColor(), image);
                break;
            }
            default: {
                BACKGROUND_FACTORY.createRadialBackground(WIDTH, this.getBackgroundColor(), this.getModel().getCustomBackground(), this.getModel().getTextureColor(), image);
            }
        }
        if (this.isCustomLayerVisible()) {
            G2.drawImage((Image)UTIL.getScaledInstance(this.getCustomLayer(), IMAGE_WIDTH, IMAGE_HEIGHT, RenderingHints.VALUE_INTERPOLATION_BICUBIC), 0, 0, null);
        }
        FontRenderContext RENDER_CONTEXT = new FontRenderContext(null, true, true);
        if (!TITLE.isEmpty()) {
            if (this.isLabelColorFromThemeEnabled()) {
                G2.setColor(this.getModel().getBackgroundColor().LABEL_COLOR);
            } else {
                G2.setColor(this.getModel().getLabelColor());
            }
            if (this.isTitleAndUnitFontEnabled()) {
                G2.setFont(new Font(this.getTitleAndUnitFont().getFamily(), 0, (int)(0.04672897196261682 * (double)IMAGE_WIDTH)));
            } else {
                G2.setFont(new Font("Verdana", 0, (int)(0.04672897196261682 * (double)IMAGE_WIDTH)));
            }
            TextLayout TITLE_LAYOUT = new TextLayout(TITLE, G2.getFont(), RENDER_CONTEXT);
            Rectangle2D TITLE_BOUNDARY = TITLE_LAYOUT.getBounds();
            G2.drawString(TITLE, (float)(((double)IMAGE_WIDTH - TITLE_BOUNDARY.getWidth()) / 2.0), 0.3f * (float)IMAGE_HEIGHT + TITLE_LAYOUT.getAscent() - TITLE_LAYOUT.getDescent());
        }
        if (!UNIT_STRING.isEmpty()) {
            if (this.isLabelColorFromThemeEnabled()) {
                G2.setColor(this.getModel().getBackgroundColor().LABEL_COLOR);
            } else {
                G2.setColor(this.getModel().getLabelColor());
            }
            if (this.isTitleAndUnitFontEnabled()) {
                G2.setFont(new Font(this.getTitleAndUnitFont().getFamily(), 0, (int)(0.04672897196261682 * (double)IMAGE_WIDTH)));
            } else {
                G2.setFont(new Font("Verdana", 0, (int)(0.04672897196261682 * (double)IMAGE_WIDTH)));
            }
            TextLayout UNIT_LAYOUT = new TextLayout(UNIT_STRING, G2.getFont(), RENDER_CONTEXT);
            Rectangle2D UNIT_BOUNDARY = UNIT_LAYOUT.getBounds();
            G2.drawString(UNIT_STRING, (float)(((double)IMAGE_WIDTH - UNIT_BOUNDARY.getWidth()) / 2.0), 0.38f * (float)IMAGE_HEIGHT + UNIT_LAYOUT.getAscent() - UNIT_LAYOUT.getDescent());
        }
        G2.dispose();
        return image;
    }

    protected BufferedImage create_GLOW_Image(int WIDTH, Color GLOW_COLOR, boolean ON, GaugeType GAUGE_TYPE, boolean KNOBS, Orientation ORIENTATION) {
        switch (this.getFrameType()) {
            case ROUND: {
                return GLOW_FACTORY.createRadialGlow(WIDTH, GLOW_COLOR, ON, GAUGE_TYPE, KNOBS, ORIENTATION);
            }
            case SQUARE: {
                return GLOW_FACTORY.createLinearGlow(WIDTH, WIDTH, GLOW_COLOR, ON);
            }
        }
        return GLOW_FACTORY.createRadialGlow(WIDTH, GLOW_COLOR, ON, GAUGE_TYPE, KNOBS, ORIENTATION);
    }

    protected BufferedImage create_TITLE_Image(int WIDTH, String TITLE, String UNIT_STRING) {
        return this.create_TITLE_Image(WIDTH, TITLE, UNIT_STRING, null);
    }

    protected BufferedImage create_TITLE_Image(int WIDTH, String TITLE, String UNIT_STRING, BufferedImage image) {
        if (WIDTH <= 0) {
            return UTIL.createImage(1, 1, 3);
        }
        if (image == null) {
            image = UTIL.createImage(WIDTH, WIDTH, 3);
        }
        Graphics2D G2 = image.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int IMAGE_WIDTH = image.getWidth();
        int IMAGE_HEIGHT = image.getHeight();
        FontRenderContext RENDER_CONTEXT = new FontRenderContext(null, true, true);
        if (!TITLE.isEmpty()) {
            if (this.isLabelColorFromThemeEnabled()) {
                G2.setColor(this.getBackgroundColor().LABEL_COLOR);
            } else {
                G2.setColor(this.getLabelColor());
            }
            if (this.isTitleAndUnitFontEnabled()) {
                G2.setFont(new Font(this.getTitleAndUnitFont().getFamily(), this.getTitleAndUnitFont().getStyle(), this.getTitleAndUnitFont().getSize()));
            } else {
                G2.setFont(new Font("Verdana", 0, (int)(0.04672897196261682 * (double)IMAGE_WIDTH)));
            }
            TextLayout TITLE_LAYOUT = new TextLayout(TITLE, G2.getFont(), RENDER_CONTEXT);
            Rectangle2D TITLE_BOUNDARY = TITLE_LAYOUT.getBounds();
            G2.drawString(TITLE, (float)(((double)IMAGE_WIDTH - TITLE_BOUNDARY.getWidth()) / 2.0), 0.3f * (float)IMAGE_HEIGHT + TITLE_LAYOUT.getAscent() - TITLE_LAYOUT.getDescent());
        }
        if (!UNIT_STRING.isEmpty()) {
            if (this.isLabelColorFromThemeEnabled()) {
                G2.setColor(this.getBackgroundColor().LABEL_COLOR);
            } else {
                G2.setColor(this.getLabelColor());
            }
            if (this.isTitleAndUnitFontEnabled()) {
                G2.setFont(new Font(this.getTitleAndUnitFont().getFamily(), this.getTitleAndUnitFont().getStyle(), this.getTitleAndUnitFont().getSize()));
            } else {
                G2.setFont(new Font("Verdana", 0, (int)(0.04672897196261682 * (double)IMAGE_WIDTH)));
            }
            TextLayout UNIT_LAYOUT = new TextLayout(UNIT_STRING, G2.getFont(), RENDER_CONTEXT);
            Rectangle2D UNIT_BOUNDARY = UNIT_LAYOUT.getBounds();
            G2.drawString(UNIT_STRING, (float)(((double)IMAGE_WIDTH - UNIT_BOUNDARY.getWidth()) / 2.0), 0.37f * (float)IMAGE_HEIGHT + UNIT_LAYOUT.getAscent() - UNIT_LAYOUT.getDescent());
        }
        G2.dispose();
        return image;
    }

    protected BufferedImage create_LCD_Image(int WIDTH, int HEIGHT, LcdColor LCD_COLOR, Paint CUSTOM_LCD_BACKGROUND) {
        return this.createLcdImage(new Rectangle2D.Double(0.0, 0.0, WIDTH, HEIGHT), LCD_COLOR, CUSTOM_LCD_BACKGROUND, null);
    }

    protected BufferedImage createLcdImage(Rectangle2D BOUNDS, LcdColor LCD_COLOR, Paint CUSTOM_LCD_BACKGROUND, BufferedImage IMAGE) {
        return LCD_FACTORY.create_LCD_Image(BOUNDS, LCD_COLOR, CUSTOM_LCD_BACKGROUND, IMAGE);
    }

    protected BufferedImage create_TRACK_Image(int WIDTH, double FREE_AREA_ANGLE, double ROTATION_OFFSET, double MIN_VALUE, double MAX_VALUE, double ANGLE_STEP, double TRACK_START, double TRACK_SECTION, double TRACK_STOP, Color TRACK_START_COLOR, Color TRACK_SECTION_COLOR, Color TRACK_STOP_COLOR, float RADIUS_FACTOR, Point2D CENTER, Direction DIRECTION, Point2D OFFSET) {
        return this.create_TRACK_Image(WIDTH, FREE_AREA_ANGLE, ROTATION_OFFSET, MIN_VALUE, MAX_VALUE, ANGLE_STEP, TRACK_START, TRACK_SECTION, TRACK_STOP, TRACK_START_COLOR, TRACK_SECTION_COLOR, TRACK_STOP_COLOR, RADIUS_FACTOR, CENTER, DIRECTION, OFFSET, null);
    }

    protected BufferedImage create_TRACK_Image(int WIDTH, double FREE_AREA_ANGLE, double ROTATION_OFFSET, double MIN_VALUE, double MAX_VALUE, double ANGLE_STEP, double TRACK_START, double TRACK_SECTION, double TRACK_STOP, Color TRACK_START_COLOR, Color TRACK_SECTION_COLOR, Color TRACK_STOP_COLOR, float RADIUS_FACTOR, Point2D CENTER, Direction DIRECTION, Point2D OFFSET, BufferedImage image) {
        double cosValue;
        double sinValue;
        Color currentColor;
        double ALPHA_STOP;
        double ALPHA_SECTION;
        double ALPHA_START;
        float lineWidth;
        if (WIDTH <= 0) {
            return UTIL.createImage(1, 1, 3);
        }
        if (image == null) {
            image = UTIL.createImage(WIDTH, WIDTH, 3);
        }
        Graphics2D G2 = image.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        int IMAGE_WIDTH = image.getWidth();
        if (OFFSET != null) {
            G2.translate(OFFSET.getX(), OFFSET.getY());
        }
        switch (this.getGaugeType()) {
            case TYPE1: {
                lineWidth = (float)Math.toDegrees(1.5707963267948966 - FREE_AREA_ANGLE) * 0.00167f * (float)WIDTH * 0.0067f;
                break;
            }
            case TYPE2: {
                lineWidth = (float)Math.toDegrees(Math.PI - FREE_AREA_ANGLE) * 0.00167f * (float)WIDTH * 0.0067f;
                break;
            }
            case TYPE3: {
                lineWidth = (float)Math.toDegrees(4.71238898038469 - FREE_AREA_ANGLE) * 0.00167f * (float)WIDTH * 0.0067f;
                break;
            }
            case TYPE4: {
                lineWidth = (float)Math.toDegrees(Math.PI * 2 - FREE_AREA_ANGLE) * 0.00167f * (float)WIDTH * 0.0067f;
                break;
            }
            default: {
                lineWidth = (float)Math.toDegrees(Math.PI * 2 - FREE_AREA_ANGLE) * 0.00167f * (float)WIDTH * 0.0067f;
            }
        }
        if (lineWidth < 0.25f) {
            lineWidth = 0.25f;
        }
        BasicStroke STD_STROKE = new BasicStroke(lineWidth, 1, 2);
        int TRACK_WIDTH = (int)(0.035 * (double)WIDTH);
        float RADIUS = (float)IMAGE_WIDTH * RADIUS_FACTOR;
        Point2D.Double INNER_POINT = new Point2D.Double();
        Point2D.Double OUTER_POINT = new Point2D.Double();
        Line2D.Double TICK = new Line2D.Double();
        switch (DIRECTION) {
            case COUNTER_CLOCKWISE: {
                double TRACK_START_ANGLE = (MAX_VALUE - TRACK_STOP) * ANGLE_STEP;
                double TRACK_SECTION_ANGLE = (MAX_VALUE - TRACK_SECTION) * ANGLE_STEP;
                double TRACK_STOP_ANGLE = (MAX_VALUE - TRACK_START) * ANGLE_STEP;
                ALPHA_START = -ROTATION_OFFSET - FREE_AREA_ANGLE / 2.0 - TRACK_START_ANGLE;
                ALPHA_SECTION = -ROTATION_OFFSET - FREE_AREA_ANGLE / 2.0 - TRACK_SECTION_ANGLE;
                ALPHA_STOP = -ROTATION_OFFSET - FREE_AREA_ANGLE / 2.0 - TRACK_STOP_ANGLE;
                currentColor = TRACK_STOP_COLOR;
                break;
            }
            default: {
                double TRACK_START_ANGLE = TRACK_START * ANGLE_STEP;
                double TRACK_SECTION_ANGLE = TRACK_SECTION * ANGLE_STEP;
                double TRACK_STOP_ANGLE = TRACK_STOP * ANGLE_STEP;
                ALPHA_START = -ROTATION_OFFSET - FREE_AREA_ANGLE / 2.0 - TRACK_START_ANGLE + MIN_VALUE * ANGLE_STEP;
                ALPHA_SECTION = -ROTATION_OFFSET - FREE_AREA_ANGLE / 2.0 - TRACK_SECTION_ANGLE + MIN_VALUE * ANGLE_STEP;
                ALPHA_STOP = -ROTATION_OFFSET - FREE_AREA_ANGLE / 2.0 - TRACK_STOP_ANGLE + MIN_VALUE * ANGLE_STEP;
                currentColor = TRACK_START_COLOR;
            }
        }
        double RANGE_FACTOR = 1000.0 / (MAX_VALUE - MIN_VALUE) < 10.0 ? 10.0 : 1000.0 / (MAX_VALUE - MIN_VALUE);
        double FRACTION_STEP = 1.0 / RANGE_FACTOR;
        G2.setStroke(STD_STROKE);
        float fraction = 0.0f;
        double alpha = ALPHA_START;
        while (Double.compare(alpha, ALPHA_SECTION) >= 0) {
            sinValue = Math.sin(alpha);
            cosValue = Math.cos(alpha);
            switch (DIRECTION) {
                case CLOCKWISE: {
                    currentColor = UTIL.getColorFromFraction(TRACK_START_COLOR, TRACK_SECTION_COLOR, (int)(TRACK_SECTION - TRACK_START), (int)fraction);
                    break;
                }
                case COUNTER_CLOCKWISE: {
                    currentColor = UTIL.getColorFromFraction(TRACK_STOP_COLOR, TRACK_SECTION_COLOR, (int)(TRACK_STOP - TRACK_SECTION), (int)fraction);
                }
            }
            G2.setColor(currentColor);
            ((Point2D)INNER_POINT).setLocation(CENTER.getX() + (double)(RADIUS - (float)TRACK_WIDTH) * sinValue, CENTER.getY() + (double)(RADIUS - (float)TRACK_WIDTH) * cosValue);
            ((Point2D)OUTER_POINT).setLocation(CENTER.getX() + (double)RADIUS * sinValue, CENTER.getY() + (double)RADIUS * cosValue);
            TICK.setLine(INNER_POINT, OUTER_POINT);
            G2.draw(TICK);
            alpha -= ANGLE_STEP / RANGE_FACTOR;
            fraction = (float)((double)fraction + FRACTION_STEP);
        }
        fraction = 0.0f;
        alpha = ALPHA_SECTION;
        while (Double.compare(alpha, ALPHA_STOP) >= 0) {
            sinValue = Math.sin(alpha);
            cosValue = Math.cos(alpha);
            switch (DIRECTION) {
                case CLOCKWISE: {
                    currentColor = UTIL.getColorFromFraction(TRACK_SECTION_COLOR, TRACK_STOP_COLOR, (int)(TRACK_STOP - TRACK_SECTION), (int)fraction);
                    break;
                }
                case COUNTER_CLOCKWISE: {
                    currentColor = UTIL.getColorFromFraction(TRACK_SECTION_COLOR, TRACK_START_COLOR, (int)(TRACK_SECTION - TRACK_START), (int)fraction);
                }
            }
            G2.setColor(currentColor);
            ((Point2D)INNER_POINT).setLocation(CENTER.getX() + (double)(RADIUS - (float)TRACK_WIDTH) * sinValue, CENTER.getY() + (double)(RADIUS - (float)TRACK_WIDTH) * cosValue);
            ((Point2D)OUTER_POINT).setLocation(CENTER.getX() + (double)RADIUS * sinValue, CENTER.getY() + (double)RADIUS * cosValue);
            TICK.setLine(INNER_POINT, OUTER_POINT);
            G2.draw(TICK);
            alpha -= ANGLE_STEP / RANGE_FACTOR;
            fraction = (float)((double)fraction + FRACTION_STEP);
        }
        G2.dispose();
        return image;
    }

    protected BufferedImage create_POSTS_Image(int WIDTH, PostPosition ... POSITIONS) {
        return this.createPostsImage(WIDTH, null, POSITIONS);
    }

    protected BufferedImage createPostsImage(int WIDTH, BufferedImage image, PostPosition ... POSITIONS) {
        if (WIDTH <= 0) {
            return UTIL.createImage(1, 1, 3);
        }
        if (image == null) {
            image = UTIL.createImage(WIDTH, WIDTH, 3);
        }
        Graphics2D G2 = image.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int IMAGE_WIDTH = image.getWidth();
        int IMAGE_HEIGHT = image.getHeight();
        BufferedImage SINGLE_POST = this.create_KNOB_Image((int)Math.ceil((double)WIDTH * 0.03738316893577576), KnobType.SMALL_STD_KNOB, this.getModel().getKnobStyle());
        List<PostPosition> postPositionList = Arrays.asList(POSITIONS);
        if (postPositionList.contains((Object)PostPosition.CENTER)) {
            switch (this.getKnobType()) {
                case SMALL_STD_KNOB: {
                    Color[] CENTER_KNOB_MAIN_COLORS;
                    Ellipse2D.Double CENTER_KNOB_FRAME = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.4579439163208008, (double)IMAGE_HEIGHT * 0.4579439163208008, (double)IMAGE_WIDTH * 0.08411216735839844, (double)IMAGE_HEIGHT * 0.08411216735839844);
                    Point2D.Double CENTER_KNOB_FRAME_START = new Point2D.Double(0.0, CENTER_KNOB_FRAME.getBounds2D().getMinY());
                    Point2D.Double CENTER_KNOB_FRAME_STOP = new Point2D.Double(0.0, CENTER_KNOB_FRAME.getBounds2D().getMaxY());
                    float[] CENTER_KNOB_FRAME_FRACTIONS = new float[]{0.0f, 0.46f, 1.0f};
                    Color[] CENTER_KNOB_FRAME_COLORS = new Color[]{new Color(180, 180, 180, 255), new Color(63, 63, 63, 255), new Color(40, 40, 40, 255)};
                    LinearGradientPaint CENTER_KNOB_FRAME_GRADIENT = new LinearGradientPaint(CENTER_KNOB_FRAME_START, CENTER_KNOB_FRAME_STOP, CENTER_KNOB_FRAME_FRACTIONS, CENTER_KNOB_FRAME_COLORS);
                    G2.setPaint(CENTER_KNOB_FRAME_GRADIENT);
                    G2.fill(CENTER_KNOB_FRAME);
                    Ellipse2D.Double CENTER_KNOB_MAIN = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.4672897160053253, (double)IMAGE_HEIGHT * 0.4672897160053253, (double)IMAGE_WIDTH * 0.06542053818702698, (double)IMAGE_HEIGHT * 0.06542053818702698);
                    Point2D.Double CENTER_KNOB_MAIN_START = new Point2D.Double(0.0, CENTER_KNOB_MAIN.getBounds2D().getMinY());
                    Point2D.Double CENTER_KNOB_MAIN_STOP = new Point2D.Double(0.0, CENTER_KNOB_MAIN.getBounds2D().getMaxY());
                    float[] CENTER_KNOB_MAIN_FRACTIONS = new float[]{0.0f, 0.5f, 1.0f};
                    switch (this.getModel().getKnobStyle()) {
                        case BLACK: {
                            CENTER_KNOB_MAIN_COLORS = new Color[]{new Color(0xBFBFBF), new Color(2828847), new Color(8224384)};
                            break;
                        }
                        case BRASS: {
                            CENTER_KNOB_MAIN_COLORS = new Color[]{new Color(14667950), new Color(8019518), new Color(13614749)};
                            break;
                        }
                        default: {
                            CENTER_KNOB_MAIN_COLORS = new Color[]{new Color(0xD7D7D7), new Color(0x747474), new Color(0xD7D7D7)};
                        }
                    }
                    LinearGradientPaint CENTER_KNOB_MAIN_GRADIENT = new LinearGradientPaint(CENTER_KNOB_MAIN_START, CENTER_KNOB_MAIN_STOP, CENTER_KNOB_MAIN_FRACTIONS, CENTER_KNOB_MAIN_COLORS);
                    G2.setPaint(CENTER_KNOB_MAIN_GRADIENT);
                    G2.fill(CENTER_KNOB_MAIN);
                    Ellipse2D.Double CENTER_KNOB_INNERSHADOW = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.4672897160053253, (double)IMAGE_HEIGHT * 0.4672897160053253, (double)IMAGE_WIDTH * 0.06542053818702698, (double)IMAGE_HEIGHT * 0.06542053818702698);
                    Point2D.Double CENTER_KNOB_INNERSHADOW_CENTER = new Point2D.Double(0.4953271028037383 * (double)IMAGE_WIDTH, 0.49065420560747663 * (double)IMAGE_HEIGHT);
                    float[] CENTER_KNOB_INNERSHADOW_FRACTIONS = new float[]{0.0f, 0.75f, 0.76f, 1.0f};
                    Color[] CENTER_KNOB_INNERSHADOW_COLORS = new Color[]{new Color(0, 0, 0, 0), new Color(0, 0, 0, 0), new Color(0, 0, 0, 1), new Color(0, 0, 0, 51)};
                    RadialGradientPaint CENTER_KNOB_INNERSHADOW_GRADIENT = new RadialGradientPaint(CENTER_KNOB_INNERSHADOW_CENTER, (float)(0.03271028037383177 * (double)IMAGE_WIDTH), CENTER_KNOB_INNERSHADOW_FRACTIONS, CENTER_KNOB_INNERSHADOW_COLORS);
                    G2.setPaint(CENTER_KNOB_INNERSHADOW_GRADIENT);
                    G2.fill(CENTER_KNOB_INNERSHADOW);
                    break;
                }
                case BIG_STD_KNOB: {
                    Color[] BIGCENTER_FOREGROUND_COLORS;
                    Color[] BIGCENTER_FOREGROUNDFRAME_COLORS;
                    Color[] BIGCENTER_BACKGROUND_COLORS;
                    Color[] BIGCENTER_BACKGROUNDFRAME_COLORS;
                    Ellipse2D.Double BIGCENTER_BACKGROUNDFRAME = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.4392523467540741, (double)IMAGE_HEIGHT * 0.4392523467540741, (double)IMAGE_WIDTH * 0.1214953362941742, (double)IMAGE_HEIGHT * 0.1214953362941742);
                    Point2D.Double BIGCENTER_BACKGROUNDFRAME_START = new Point2D.Double(0.0, BIGCENTER_BACKGROUNDFRAME.getBounds2D().getMinY());
                    Point2D.Double BIGCENTER_BACKGROUNDFRAME_STOP = new Point2D.Double(0.0, BIGCENTER_BACKGROUNDFRAME.getBounds2D().getMaxY());
                    float[] BIGCENTER_BACKGROUNDFRAME_FRACTIONS = new float[]{0.0f, 1.0f};
                    switch (this.getModel().getKnobStyle()) {
                        case BLACK: {
                            BIGCENTER_BACKGROUNDFRAME_COLORS = new Color[]{new Color(129, 133, 136, 255), new Color(61, 61, 73, 255)};
                            break;
                        }
                        case BRASS: {
                            BIGCENTER_BACKGROUNDFRAME_COLORS = new Color[]{new Color(143, 117, 80, 255), new Color(100, 76, 49, 255)};
                            break;
                        }
                        default: {
                            BIGCENTER_BACKGROUNDFRAME_COLORS = new Color[]{new Color(152, 152, 152, 255), new Color(118, 121, 126, 255)};
                        }
                    }
                    LinearGradientPaint BIGCENTER_BACKGROUNDFRAME_GRADIENT = new LinearGradientPaint(BIGCENTER_BACKGROUNDFRAME_START, BIGCENTER_BACKGROUNDFRAME_STOP, BIGCENTER_BACKGROUNDFRAME_FRACTIONS, BIGCENTER_BACKGROUNDFRAME_COLORS);
                    G2.setPaint(BIGCENTER_BACKGROUNDFRAME_GRADIENT);
                    G2.fill(BIGCENTER_BACKGROUNDFRAME);
                    Ellipse2D.Double BIGCENTER_BACKGROUND = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.44392523169517517, (double)IMAGE_HEIGHT * 0.44392523169517517, (double)IMAGE_WIDTH * 0.11214950680732727, (double)IMAGE_HEIGHT * 0.11214950680732727);
                    Point2D.Double BIGCENTER_BACKGROUND_START = new Point2D.Double(0.0, BIGCENTER_BACKGROUND.getBounds2D().getMinY());
                    Point2D.Double BIGCENTER_BACKGROUND_STOP = new Point2D.Double(0.0, BIGCENTER_BACKGROUND.getBounds2D().getMaxY());
                    float[] BIGCENTER_BACKGROUND_FRACTIONS = new float[]{0.0f, 1.0f};
                    switch (this.getModel().getKnobStyle()) {
                        case BLACK: {
                            BIGCENTER_BACKGROUND_COLORS = new Color[]{new Color(26, 27, 32, 255), new Color(96, 97, 102, 255)};
                            break;
                        }
                        case BRASS: {
                            BIGCENTER_BACKGROUND_COLORS = new Color[]{new Color(98, 75, 49, 255), new Color(149, 109, 54, 255)};
                            break;
                        }
                        default: {
                            BIGCENTER_BACKGROUND_COLORS = new Color[]{new Color(118, 121, 126, 255), new Color(191, 191, 191, 255)};
                        }
                    }
                    LinearGradientPaint BIGCENTER_BACKGROUND_GRADIENT = new LinearGradientPaint(BIGCENTER_BACKGROUND_START, BIGCENTER_BACKGROUND_STOP, BIGCENTER_BACKGROUND_FRACTIONS, BIGCENTER_BACKGROUND_COLORS);
                    G2.setPaint(BIGCENTER_BACKGROUND_GRADIENT);
                    G2.fill(BIGCENTER_BACKGROUND);
                    Ellipse2D.Double BIGCENTER_FOREGROUNDFRAME = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.4532710313796997, (double)IMAGE_HEIGHT * 0.4532710313796997, (double)IMAGE_WIDTH * 0.09345793724060059, (double)IMAGE_HEIGHT * 0.09345793724060059);
                    Point2D.Double BIGCENTER_FOREGROUNDFRAME_START = new Point2D.Double(0.0, BIGCENTER_FOREGROUNDFRAME.getBounds2D().getMinY());
                    Point2D.Double BIGCENTER_FOREGROUNDFRAME_STOP = new Point2D.Double(0.0, BIGCENTER_FOREGROUNDFRAME.getBounds2D().getMaxY());
                    float[] BIGCENTER_FOREGROUNDFRAME_FRACTIONS = new float[]{0.0f, 0.47f, 1.0f};
                    switch (this.getModel().getKnobStyle()) {
                        case BLACK: {
                            BIGCENTER_FOREGROUNDFRAME_COLORS = new Color[]{new Color(191, 191, 191, 255), new Color(56, 57, 61, 255), new Color(143, 144, 146, 255)};
                            break;
                        }
                        case BRASS: {
                            BIGCENTER_FOREGROUNDFRAME_COLORS = new Color[]{new Color(147, 108, 54, 255), new Color(82, 66, 50, 255), new Color(147, 108, 54, 255)};
                            break;
                        }
                        default: {
                            BIGCENTER_FOREGROUNDFRAME_COLORS = new Color[]{new Color(191, 191, 191, 255), new Color(116, 116, 116, 255), new Color(143, 144, 146, 255)};
                        }
                    }
                    LinearGradientPaint BIGCENTER_FOREGROUNDFRAME_GRADIENT = new LinearGradientPaint(BIGCENTER_FOREGROUNDFRAME_START, BIGCENTER_FOREGROUNDFRAME_STOP, BIGCENTER_FOREGROUNDFRAME_FRACTIONS, BIGCENTER_FOREGROUNDFRAME_COLORS);
                    G2.setPaint(BIGCENTER_FOREGROUNDFRAME_GRADIENT);
                    G2.fill(BIGCENTER_FOREGROUNDFRAME);
                    Ellipse2D.Double BIGCENTER_FOREGROUND = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.4579439163208008, (double)IMAGE_HEIGHT * 0.4579439163208008, (double)IMAGE_WIDTH * 0.08411216735839844, (double)IMAGE_HEIGHT * 0.08411216735839844);
                    Point2D.Double BIGCENTER_FOREGROUND_START = new Point2D.Double(0.0, BIGCENTER_FOREGROUND.getBounds2D().getMinY());
                    Point2D.Double BIGCENTER_FOREGROUND_STOP = new Point2D.Double(0.0, BIGCENTER_FOREGROUND.getBounds2D().getMaxY());
                    float[] BIGCENTER_FOREGROUND_FRACTIONS = new float[]{0.0f, 0.21f, 0.5f, 0.78f, 1.0f};
                    switch (this.getModel().getKnobStyle()) {
                        case BLACK: {
                            BIGCENTER_FOREGROUND_COLORS = new Color[]{new Color(191, 191, 191, 255), new Color(94, 93, 99, 255), new Color(43, 42, 47, 255), new Color(78, 79, 81, 255), new Color(143, 144, 146, 255)};
                            break;
                        }
                        case BRASS: {
                            BIGCENTER_FOREGROUND_COLORS = new Color[]{new Color(223, 208, 174, 255), new Color(159, 136, 104, 255), new Color(122, 94, 62, 255), new Color(159, 136, 104, 255), new Color(223, 208, 174, 255)};
                            break;
                        }
                        default: {
                            BIGCENTER_FOREGROUND_COLORS = new Color[]{new Color(215, 215, 215, 255), new Color(139, 142, 145, 255), new Color(100, 100, 100, 255), new Color(139, 142, 145, 255), new Color(215, 215, 215, 255)};
                        }
                    }
                    LinearGradientPaint BIGCENTER_FOREGROUND_GRADIENT = new LinearGradientPaint(BIGCENTER_FOREGROUND_START, BIGCENTER_FOREGROUND_STOP, BIGCENTER_FOREGROUND_FRACTIONS, BIGCENTER_FOREGROUND_COLORS);
                    G2.setPaint(BIGCENTER_FOREGROUND_GRADIENT);
                    G2.fill(BIGCENTER_FOREGROUND);
                    break;
                }
                case BIG_CHROME_KNOB: {
                    Ellipse2D.Double CHROMEKNOB_BACKFRAME = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.42990654706954956, (double)IMAGE_HEIGHT * 0.42990654706954956, (double)IMAGE_WIDTH * (double)0.1401869f, (double)IMAGE_HEIGHT * (double)0.1401869f);
                    Point2D.Double CHROMEKNOB_BACKFRAME_START = new Point2D.Double(0.46261682242990654 * (double)IMAGE_WIDTH, 0.4392523364485981 * (double)IMAGE_HEIGHT);
                    Point2D.Double CHROMEKNOB_BACKFRAME_STOP = new Point2D.Double(0.534428311508238 * (double)IMAGE_WIDTH, 0.5541747420025063 * (double)IMAGE_HEIGHT);
                    float[] CHROMEKNOB_BACKFRAME_FRACTIONS = new float[]{0.0f, 1.0f};
                    Color[] CHROMEKNOB_BACKFRAME_COLORS = new Color[]{new Color(129, 139, 140, 255), new Color(166, 171, 175, 255)};
                    LinearGradientPaint CHROMEKNOB_BACKFRAME_GRADIENT = new LinearGradientPaint(CHROMEKNOB_BACKFRAME_START, CHROMEKNOB_BACKFRAME_STOP, CHROMEKNOB_BACKFRAME_FRACTIONS, CHROMEKNOB_BACKFRAME_COLORS);
                    G2.setPaint(CHROMEKNOB_BACKFRAME_GRADIENT);
                    G2.fill(CHROMEKNOB_BACKFRAME);
                    Ellipse2D.Double CHROMEKNOB_BACK = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.43457943201065063, (double)IMAGE_HEIGHT * 0.43457943201065063, (double)IMAGE_WIDTH * 0.13084113597869873, (double)IMAGE_HEIGHT * 0.13084113597869873);
                    Point2D.Double CHROMEKNOB_BACK_CENTER = new Point2D.Double(CHROMEKNOB_BACK.getCenterX(), CHROMEKNOB_BACK.getCenterY());
                    float[] CHROMEKNOB_BACK_FRACTIONS = new float[]{0.0f, 0.09f, 0.12f, 0.16f, 0.25f, 0.29f, 0.33f, 0.38f, 0.48f, 0.52f, 0.65f, 0.69f, 0.8f, 0.83f, 0.87f, 0.97f, 1.0f};
                    Color[] CHROMEKNOB_BACK_COLORS = new Color[]{new Color(255, 255, 255, 255), new Color(255, 255, 255, 255), new Color(136, 136, 138, 255), new Color(164, 185, 190, 255), new Color(158, 179, 182, 255), new Color(112, 112, 112, 255), new Color(221, 227, 227, 255), new Color(155, 176, 179, 255), new Color(156, 176, 177, 255), new Color(254, 255, 255, 255), new Color(255, 255, 255, 255), new Color(156, 180, 180, 255), new Color(198, 209, 211, 255), new Color(246, 248, 247, 255), new Color(204, 216, 216, 255), new Color(164, 188, 190, 255), new Color(255, 255, 255, 255)};
                    ConicalGradientPaint CHROMEKNOB_BACK_GRADIENT = new ConicalGradientPaint(false, CHROMEKNOB_BACK_CENTER, 0.0f, CHROMEKNOB_BACK_FRACTIONS, CHROMEKNOB_BACK_COLORS);
                    G2.setPaint(CHROMEKNOB_BACK_GRADIENT);
                    G2.fill(CHROMEKNOB_BACK);
                    Ellipse2D.Double CHROMEKNOB_FOREFRAME = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.4672897160053253, (double)IMAGE_HEIGHT * 0.4672897160053253, (double)IMAGE_WIDTH * 0.06542053818702698, (double)IMAGE_HEIGHT * 0.06542053818702698);
                    Point2D.Double CHROMEKNOB_FOREFRAME_START = new Point2D.Double(0.48130841121495327 * (double)IMAGE_WIDTH, 0.4719626168224299 * (double)IMAGE_HEIGHT);
                    Point2D.Double CHROMEKNOB_FOREFRAME_STOP = new Point2D.Double(0.5152780735753257 * (double)IMAGE_WIDTH, 0.5223247123514745 * (double)IMAGE_HEIGHT);
                    float[] CHROMEKNOB_FOREFRAME_FRACTIONS = new float[]{0.0f, 1.0f};
                    Color[] CHROMEKNOB_FOREFRAME_COLORS = new Color[]{new Color(225, 235, 232, 255), new Color(196, 207, 207, 255)};
                    LinearGradientPaint CHROMEKNOB_FOREFRAME_GRADIENT = new LinearGradientPaint(CHROMEKNOB_FOREFRAME_START, CHROMEKNOB_FOREFRAME_STOP, CHROMEKNOB_FOREFRAME_FRACTIONS, CHROMEKNOB_FOREFRAME_COLORS);
                    G2.setPaint(CHROMEKNOB_FOREFRAME_GRADIENT);
                    G2.fill(CHROMEKNOB_FOREFRAME);
                    Ellipse2D.Double CHROMEKNOB_FORE = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.4719626307487488, (double)IMAGE_HEIGHT * 0.4719626307487488, (double)IMAGE_WIDTH * 0.05607473850250244, (double)IMAGE_HEIGHT * 0.05607473850250244);
                    Point2D.Double CHROMEKNOB_FORE_START = new Point2D.Double(0.48130841121495327 * (double)IMAGE_WIDTH, 0.4766355140186916 * (double)IMAGE_HEIGHT);
                    Point2D.Double CHROMEKNOB_FORE_STOP = new Point2D.Double(0.5126650226245278 * (double)IMAGE_WIDTH, 0.5231236021993482 * (double)IMAGE_HEIGHT);
                    float[] CHROMEKNOB_FORE_FRACTIONS = new float[]{0.0f, 1.0f};
                    Color[] CHROMEKNOB_FORE_COLORS = new Color[]{new Color(237, 239, 237, 255), new Color(148, 161, 161, 255)};
                    LinearGradientPaint CHROMEKNOB_FORE_GRADIENT = new LinearGradientPaint(CHROMEKNOB_FORE_START, CHROMEKNOB_FORE_STOP, CHROMEKNOB_FORE_FRACTIONS, CHROMEKNOB_FORE_COLORS);
                    G2.setPaint(CHROMEKNOB_FORE_GRADIENT);
                    G2.fill(CHROMEKNOB_FORE);
                    break;
                }
                case METAL_KNOB: {
                    Color[] METALKNOB_MAIN_COLORS;
                    Ellipse2D.Double METALKNOB_FRAME = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.4579439163208008, (double)IMAGE_HEIGHT * 0.4579439163208008, (double)IMAGE_WIDTH * 0.08411216735839844, (double)IMAGE_HEIGHT * 0.08411216735839844);
                    Point2D.Double METALKNOB_FRAME_START = new Point2D.Double(0.0, METALKNOB_FRAME.getBounds2D().getMinY());
                    Point2D.Double METALKNOB_FRAME_STOP = new Point2D.Double(0.0, METALKNOB_FRAME.getBounds2D().getMaxY());
                    float[] METALKNOB_FRAME_FRACTIONS = new float[]{0.0f, 0.47f, 1.0f};
                    Color[] METALKNOB_FRAME_COLORS = new Color[]{new Color(92, 95, 101, 255), new Color(46, 49, 53, 255), new Color(22, 23, 26, 255)};
                    LinearGradientPaint METALKNOB_FRAME_GRADIENT = new LinearGradientPaint(METALKNOB_FRAME_START, METALKNOB_FRAME_STOP, METALKNOB_FRAME_FRACTIONS, METALKNOB_FRAME_COLORS);
                    G2.setPaint(METALKNOB_FRAME_GRADIENT);
                    G2.fill(METALKNOB_FRAME);
                    Ellipse2D.Double METALKNOB_MAIN = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.46261683106422424, (double)IMAGE_HEIGHT * 0.46261683106422424, (double)IMAGE_WIDTH * 0.0747663676738739, (double)IMAGE_HEIGHT * 0.0747663676738739);
                    Point2D.Double METALKNOB_MAIN_START = new Point2D.Double(0.0, METALKNOB_MAIN.getBounds2D().getMinY());
                    Point2D.Double METALKNOB_MAIN_STOP = new Point2D.Double(0.0, METALKNOB_MAIN.getBounds2D().getMaxY());
                    float[] METALKNOB_MAIN_FRACTIONS = new float[]{0.0f, 1.0f};
                    switch (this.getModel().getKnobStyle()) {
                        case BLACK: {
                            METALKNOB_MAIN_COLORS = new Color[]{new Color(2828847), new Color(1710880)};
                            break;
                        }
                        case BRASS: {
                            METALKNOB_MAIN_COLORS = new Color[]{new Color(9858614), new Color(8150845)};
                            break;
                        }
                        default: {
                            METALKNOB_MAIN_COLORS = new Color[]{new Color(204, 204, 204, 255), new Color(87, 92, 98, 255)};
                        }
                    }
                    LinearGradientPaint METALKNOB_MAIN_GRADIENT = new LinearGradientPaint(METALKNOB_MAIN_START, METALKNOB_MAIN_STOP, METALKNOB_MAIN_FRACTIONS, METALKNOB_MAIN_COLORS);
                    G2.setPaint(METALKNOB_MAIN_GRADIENT);
                    G2.fill(METALKNOB_MAIN);
                    GeneralPath METALKNOB_LOWERHL = new GeneralPath();
                    METALKNOB_LOWERHL.setWindingRule(0);
                    METALKNOB_LOWERHL.moveTo((double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.5280373831775701);
                    METALKNOB_LOWERHL.curveTo((double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.5186915887850467, (double)IMAGE_WIDTH * 0.5093457943925234, (double)IMAGE_HEIGHT * 0.514018691588785, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.514018691588785);
                    METALKNOB_LOWERHL.curveTo((double)IMAGE_WIDTH * 0.48598130841121495, (double)IMAGE_HEIGHT * 0.514018691588785, (double)IMAGE_WIDTH * 0.4766355140186916, (double)IMAGE_HEIGHT * 0.5186915887850467, (double)IMAGE_WIDTH * 0.4766355140186916, (double)IMAGE_HEIGHT * 0.5280373831775701);
                    METALKNOB_LOWERHL.curveTo((double)IMAGE_WIDTH * 0.48130841121495327, (double)IMAGE_HEIGHT * 0.5327102803738317, (double)IMAGE_WIDTH * 0.49065420560747663, (double)IMAGE_HEIGHT * 0.5373831775700935, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.5373831775700935);
                    METALKNOB_LOWERHL.curveTo((double)IMAGE_WIDTH * 0.5046728971962616, (double)IMAGE_HEIGHT * 0.5373831775700935, (double)IMAGE_WIDTH * 0.514018691588785, (double)IMAGE_HEIGHT * 0.5327102803738317, (double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.5280373831775701);
                    METALKNOB_LOWERHL.closePath();
                    Point2D.Double METALKNOB_LOWERHL_CENTER = new Point2D.Double(0.5 * (double)IMAGE_WIDTH, 0.5373831775700935 * (double)IMAGE_HEIGHT);
                    float[] METALKNOB_LOWERHL_FRACTIONS = new float[]{0.0f, 1.0f};
                    Color[] METALKNOB_LOWERHL_COLORS = new Color[]{new Color(255, 255, 255, 153), new Color(255, 255, 255, 0)};
                    RadialGradientPaint METALKNOB_LOWERHL_GRADIENT = new RadialGradientPaint(METALKNOB_LOWERHL_CENTER, (float)(0.03271028037383177 * (double)IMAGE_WIDTH), METALKNOB_LOWERHL_FRACTIONS, METALKNOB_LOWERHL_COLORS);
                    G2.setPaint(METALKNOB_LOWERHL_GRADIENT);
                    G2.fill(METALKNOB_LOWERHL);
                    GeneralPath METALKNOB_UPPERHL = new GeneralPath();
                    METALKNOB_UPPERHL.setWindingRule(0);
                    METALKNOB_UPPERHL.moveTo((double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.48130841121495327);
                    METALKNOB_UPPERHL.curveTo((double)IMAGE_WIDTH * 0.5280373831775701, (double)IMAGE_HEIGHT * 0.4672897196261682, (double)IMAGE_WIDTH * 0.514018691588785, (double)IMAGE_HEIGHT * 0.45794392523364486, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.45794392523364486);
                    METALKNOB_UPPERHL.curveTo((double)IMAGE_WIDTH * 0.48130841121495327, (double)IMAGE_HEIGHT * 0.45794392523364486, (double)IMAGE_WIDTH * 0.4672897196261682, (double)IMAGE_HEIGHT * 0.4672897196261682, (double)IMAGE_WIDTH * 0.46261682242990654, (double)IMAGE_HEIGHT * 0.48130841121495327);
                    METALKNOB_UPPERHL.curveTo((double)IMAGE_WIDTH * 0.4672897196261682, (double)IMAGE_HEIGHT * 0.48598130841121495, (double)IMAGE_WIDTH * 0.48130841121495327, (double)IMAGE_HEIGHT * 0.49065420560747663, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.49065420560747663);
                    METALKNOB_UPPERHL.curveTo((double)IMAGE_WIDTH * 0.514018691588785, (double)IMAGE_HEIGHT * 0.49065420560747663, (double)IMAGE_WIDTH * 0.5280373831775701, (double)IMAGE_HEIGHT * 0.48598130841121495, (double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.48130841121495327);
                    METALKNOB_UPPERHL.closePath();
                    Point2D.Double METALKNOB_UPPERHL_CENTER = new Point2D.Double(0.4953271028037383 * (double)IMAGE_WIDTH, 0.45794392523364486 * (double)IMAGE_HEIGHT);
                    float[] METALKNOB_UPPERHL_FRACTIONS = new float[]{0.0f, 1.0f};
                    Color[] METALKNOB_UPPERHL_COLORS = new Color[]{new Color(255, 255, 255, 191), new Color(255, 255, 255, 0)};
                    RadialGradientPaint METALKNOB_UPPERHL_GRADIENT = new RadialGradientPaint(METALKNOB_UPPERHL_CENTER, (float)(0.04906542056074766 * (double)IMAGE_WIDTH), METALKNOB_UPPERHL_FRACTIONS, METALKNOB_UPPERHL_COLORS);
                    G2.setPaint(METALKNOB_UPPERHL_GRADIENT);
                    G2.fill(METALKNOB_UPPERHL);
                    Ellipse2D.Double METALKNOB_INNERFRAME = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.47663551568984985, (double)IMAGE_HEIGHT * 0.4813084006309509, (double)IMAGE_WIDTH * 0.04205608367919922, (double)IMAGE_HEIGHT * 0.04205608367919922);
                    Point2D.Double METALKNOB_INNERFRAME_START = new Point2D.Double(0.0, METALKNOB_INNERFRAME.getBounds2D().getMinY());
                    Point2D.Double METALKNOB_INNERFRAME_STOP = new Point2D.Double(0.0, METALKNOB_INNERFRAME.getBounds2D().getMaxY());
                    float[] METALKNOB_INNERFRAME_FRACTIONS = new float[]{0.0f, 1.0f};
                    Color[] METALKNOB_INNERFRAME_COLORS = new Color[]{new Color(0, 0, 0, 255), new Color(204, 204, 204, 255)};
                    LinearGradientPaint METALKNOB_INNERFRAME_GRADIENT = new LinearGradientPaint(METALKNOB_INNERFRAME_START, METALKNOB_INNERFRAME_STOP, METALKNOB_INNERFRAME_FRACTIONS, METALKNOB_INNERFRAME_COLORS);
                    G2.setPaint(METALKNOB_INNERFRAME_GRADIENT);
                    G2.fill(METALKNOB_INNERFRAME);
                    Ellipse2D.Double METALKNOB_INNERBACKGROUND = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.4813084006309509, (double)IMAGE_HEIGHT * 0.4859813153743744, (double)IMAGE_WIDTH * 0.03271031379699707, (double)IMAGE_HEIGHT * 0.03271028399467468);
                    Point2D.Double METALKNOB_INNERBACKGROUND_START = new Point2D.Double(0.0, METALKNOB_INNERBACKGROUND.getBounds2D().getMinY());
                    Point2D.Double METALKNOB_INNERBACKGROUND_STOP = new Point2D.Double(0.0, METALKNOB_INNERBACKGROUND.getBounds2D().getMaxY());
                    float[] METALKNOB_INNERBACKGROUND_FRACTIONS = new float[]{0.0f, 1.0f};
                    Color[] METALKNOB_INNERBACKGROUND_COLORS = new Color[]{new Color(1, 6, 11, 255), new Color(50, 52, 56, 255)};
                    LinearGradientPaint METALKNOB_INNERBACKGROUND_GRADIENT = new LinearGradientPaint(METALKNOB_INNERBACKGROUND_START, METALKNOB_INNERBACKGROUND_STOP, METALKNOB_INNERBACKGROUND_FRACTIONS, METALKNOB_INNERBACKGROUND_COLORS);
                    G2.setPaint(METALKNOB_INNERBACKGROUND_GRADIENT);
                    G2.fill(METALKNOB_INNERBACKGROUND);
                }
            }
        }
        if (postPositionList.contains((Object)PostPosition.MIN_BOTTOM)) {
            G2.drawImage((Image)SINGLE_POST, (int)((double)IMAGE_WIDTH * 0.336448609828949), (int)((double)IMAGE_HEIGHT * 0.8037382960319519), null);
        }
        if (postPositionList.contains((Object)PostPosition.MAX_BOTTOM)) {
            G2.drawImage((Image)SINGLE_POST, (int)((double)IMAGE_WIDTH * 0.6261682510375977), (int)((double)IMAGE_HEIGHT * 0.8037382960319519), null);
        }
        if (postPositionList.contains((Object)PostPosition.MAX_CENTER_BOTTOM)) {
            G2.drawImage((Image)SINGLE_POST, (int)((double)IMAGE_WIDTH * 0.5233644843101501), (int)((double)IMAGE_HEIGHT * 0.8317757248878479), null);
        }
        if (postPositionList.contains((Object)PostPosition.MAX_CENTER_TOP)) {
            G2.drawImage((Image)SINGLE_POST, (int)((double)IMAGE_WIDTH * 0.5233644843101501), (int)((double)IMAGE_HEIGHT * 0.13084112107753754), null);
        }
        if (postPositionList.contains((Object)PostPosition.MAX_RIGHT)) {
            G2.drawImage((Image)SINGLE_POST, (int)((double)IMAGE_WIDTH * 0.8317757248878479), (int)((double)IMAGE_HEIGHT * 0.514018714427948), null);
        }
        if (postPositionList.contains((Object)PostPosition.MIN_LEFT)) {
            G2.drawImage((Image)SINGLE_POST, (int)((double)IMAGE_WIDTH * 0.13084112107753754), (int)((double)IMAGE_HEIGHT * 0.514018714427948), null);
        }
        AffineTransform OLD_TRANSFORM = G2.getTransform();
        Point2D.Double KNOB_CENTER = new Point2D.Double();
        if (postPositionList.contains((Object)PostPosition.LOWER_CENTER)) {
            switch (this.getKnobType()) {
                case SMALL_STD_KNOB: {
                    Color[] LOWERCENTER_KNOB_MAIN_COLORS;
                    Ellipse2D.Double LOWERCENTER_KNOB_FRAME = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.4579439163208008, (double)IMAGE_HEIGHT * 0.6915887594223022, (double)IMAGE_WIDTH * 0.08411216735839844, (double)IMAGE_HEIGHT * 0.08411216735839844);
                    switch (this.getOrientation()) {
                        case WEST: {
                            ((Point2D)KNOB_CENTER).setLocation(LOWERCENTER_KNOB_FRAME.getCenterX(), LOWERCENTER_KNOB_FRAME.getCenterY());
                            G2.rotate(1.5707963267948966, ((Point2D)KNOB_CENTER).getX(), ((Point2D)KNOB_CENTER).getY());
                        }
                    }
                    Point2D.Double LOWERCENTER_KNOB_FRAME_START = new Point2D.Double(0.0, LOWERCENTER_KNOB_FRAME.getBounds2D().getMinY());
                    Point2D.Double LOWERCENTER_KNOB_FRAME_STOP = new Point2D.Double(0.0, LOWERCENTER_KNOB_FRAME.getBounds2D().getMaxY());
                    float[] LOWERCENTER_KNOB_FRAME_FRACTIONS = new float[]{0.0f, 0.46f, 1.0f};
                    Color[] LOWERCENTER_KNOB_FRAME_COLORS = new Color[]{new Color(180, 180, 180, 255), new Color(63, 63, 63, 255), new Color(40, 40, 40, 255)};
                    LinearGradientPaint LOWERCENTER_KNOB_FRAME_GRADIENT = new LinearGradientPaint(LOWERCENTER_KNOB_FRAME_START, LOWERCENTER_KNOB_FRAME_STOP, LOWERCENTER_KNOB_FRAME_FRACTIONS, LOWERCENTER_KNOB_FRAME_COLORS);
                    G2.setPaint(LOWERCENTER_KNOB_FRAME_GRADIENT);
                    G2.fill(LOWERCENTER_KNOB_FRAME);
                    Ellipse2D.Double LOWERCENTER_KNOB_MAIN = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.4672897160053253, (double)IMAGE_HEIGHT * 0.7009345889091492, (double)IMAGE_WIDTH * 0.06542053818702698, (double)IMAGE_HEIGHT * 0.06542056798934937);
                    Point2D.Double LOWERCENTER_KNOB_MAIN_START = new Point2D.Double(0.0, LOWERCENTER_KNOB_MAIN.getBounds2D().getMinY());
                    Point2D.Double LOWERCENTER_KNOB_MAIN_STOP = new Point2D.Double(0.0, LOWERCENTER_KNOB_MAIN.getBounds2D().getMaxY());
                    float[] LOWERCENTER_KNOB_MAIN_FRACTIONS = new float[]{0.0f, 0.5f, 1.0f};
                    switch (this.getModel().getKnobStyle()) {
                        case BLACK: {
                            LOWERCENTER_KNOB_MAIN_COLORS = new Color[]{new Color(0xBFBFBF), new Color(2828847), new Color(8224384)};
                            break;
                        }
                        case BRASS: {
                            LOWERCENTER_KNOB_MAIN_COLORS = new Color[]{new Color(14667950), new Color(8019518), new Color(13614749)};
                            break;
                        }
                        default: {
                            LOWERCENTER_KNOB_MAIN_COLORS = new Color[]{new Color(0xD7D7D7), new Color(0x747474), new Color(0xD7D7D7)};
                        }
                    }
                    LinearGradientPaint LOWERCENTER_KNOB_MAIN_GRADIENT = new LinearGradientPaint(LOWERCENTER_KNOB_MAIN_START, LOWERCENTER_KNOB_MAIN_STOP, LOWERCENTER_KNOB_MAIN_FRACTIONS, LOWERCENTER_KNOB_MAIN_COLORS);
                    G2.setPaint(LOWERCENTER_KNOB_MAIN_GRADIENT);
                    G2.fill(LOWERCENTER_KNOB_MAIN);
                    Ellipse2D.Double LOWERCENTER_KNOB_INNERSHADOW = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.4672897160053253, (double)IMAGE_HEIGHT * 0.7009345889091492, (double)IMAGE_WIDTH * 0.06542053818702698, (double)IMAGE_HEIGHT * 0.06542056798934937);
                    Point2D.Double LOWERCENTER_KNOB_INNERSHADOW_CENTER = new Point2D.Double(0.4953271028037383 * (double)IMAGE_WIDTH, 0.7242990654205608 * (double)IMAGE_HEIGHT);
                    float[] LOWERCENTER_KNOB_INNERSHADOW_FRACTIONS = new float[]{0.0f, 0.75f, 0.76f, 1.0f};
                    Color[] LOWERCENTER_KNOB_INNERSHADOW_COLORS = new Color[]{new Color(0, 0, 0, 0), new Color(0, 0, 0, 0), new Color(0, 0, 0, 1), new Color(0, 0, 0, 51)};
                    RadialGradientPaint LOWERCENTER_KNOB_INNERSHADOW_GRADIENT = new RadialGradientPaint(LOWERCENTER_KNOB_INNERSHADOW_CENTER, (float)(0.03271028037383177 * (double)IMAGE_WIDTH), LOWERCENTER_KNOB_INNERSHADOW_FRACTIONS, LOWERCENTER_KNOB_INNERSHADOW_COLORS);
                    G2.setPaint(LOWERCENTER_KNOB_INNERSHADOW_GRADIENT);
                    G2.fill(LOWERCENTER_KNOB_INNERSHADOW);
                    break;
                }
                case BIG_STD_KNOB: {
                    Color[] BIGLOWERCENTER_FOREGROUND_COLORS;
                    Color[] BIGLOWERCENTER_FOREGROUNDFRAME_COLORS;
                    Color[] BIGLOWERCENTER_BACKGROUND_COLORS;
                    Color[] BIGLOWERCENTER_BACKGROUNDFRAME_COLORS;
                    Ellipse2D.Double BIGLOWERCENTER_BACKGROUNDFRAME = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.4392523467540741, (double)IMAGE_HEIGHT * 0.672897219657898, (double)IMAGE_WIDTH * 0.1214953362941742, (double)IMAGE_HEIGHT * 0.1214953064918518);
                    switch (this.getOrientation()) {
                        case WEST: {
                            ((Point2D)KNOB_CENTER).setLocation(BIGLOWERCENTER_BACKGROUNDFRAME.getCenterX(), BIGLOWERCENTER_BACKGROUNDFRAME.getCenterY());
                            G2.rotate(1.5707963267948966, ((Point2D)KNOB_CENTER).getX(), ((Point2D)KNOB_CENTER).getY());
                        }
                    }
                    Point2D.Double BIGLOWERCENTER_BACKGROUNDFRAME_START = new Point2D.Double(0.0, BIGLOWERCENTER_BACKGROUNDFRAME.getBounds2D().getMinY());
                    Point2D.Double BIGLOWERCENTER_BACKGROUNDFRAME_STOP = new Point2D.Double(0.0, BIGLOWERCENTER_BACKGROUNDFRAME.getBounds2D().getMaxY());
                    float[] BIGLOWERCENTER_BACKGROUNDFRAME_FRACTIONS = new float[]{0.0f, 1.0f};
                    switch (this.getModel().getKnobStyle()) {
                        case BLACK: {
                            BIGLOWERCENTER_BACKGROUNDFRAME_COLORS = new Color[]{new Color(129, 133, 136, 255), new Color(61, 61, 73, 255)};
                            break;
                        }
                        case BRASS: {
                            BIGLOWERCENTER_BACKGROUNDFRAME_COLORS = new Color[]{new Color(143, 117, 80, 255), new Color(100, 76, 49, 255)};
                            break;
                        }
                        default: {
                            BIGLOWERCENTER_BACKGROUNDFRAME_COLORS = new Color[]{new Color(152, 152, 152, 255), new Color(118, 121, 126, 255)};
                        }
                    }
                    LinearGradientPaint BIGLOWERCENTER_BACKGROUNDFRAME_GRADIENT = new LinearGradientPaint(BIGLOWERCENTER_BACKGROUNDFRAME_START, BIGLOWERCENTER_BACKGROUNDFRAME_STOP, BIGLOWERCENTER_BACKGROUNDFRAME_FRACTIONS, BIGLOWERCENTER_BACKGROUNDFRAME_COLORS);
                    G2.setPaint(BIGLOWERCENTER_BACKGROUNDFRAME_GRADIENT);
                    G2.fill(BIGLOWERCENTER_BACKGROUNDFRAME);
                    Ellipse2D.Double BIGLOWERCENTER_BACKGROUND = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.44392523169517517, (double)IMAGE_HEIGHT * 0.677570104598999, (double)IMAGE_WIDTH * 0.11214950680732727, (double)IMAGE_HEIGHT * 0.11214953660964966);
                    Point2D.Double BIGLOWERCENTER_BACKGROUND_START = new Point2D.Double(0.0, BIGLOWERCENTER_BACKGROUND.getBounds2D().getMinY());
                    Point2D.Double BIGLOWERCENTER_BACKGROUND_STOP = new Point2D.Double(0.0, BIGLOWERCENTER_BACKGROUND.getBounds2D().getMaxY());
                    float[] BIGLOWERCENTER_BACKGROUND_FRACTIONS = new float[]{0.0f, 1.0f};
                    switch (this.getModel().getKnobStyle()) {
                        case BLACK: {
                            BIGLOWERCENTER_BACKGROUND_COLORS = new Color[]{new Color(26, 27, 32, 255), new Color(96, 97, 102, 255)};
                            break;
                        }
                        case BRASS: {
                            BIGLOWERCENTER_BACKGROUND_COLORS = new Color[]{new Color(98, 75, 49, 255), new Color(149, 109, 54, 255)};
                            break;
                        }
                        default: {
                            BIGLOWERCENTER_BACKGROUND_COLORS = new Color[]{new Color(118, 121, 126, 255), new Color(191, 191, 191, 255)};
                        }
                    }
                    LinearGradientPaint BIGLOWERCENTER_BACKGROUND_GRADIENT = new LinearGradientPaint(BIGLOWERCENTER_BACKGROUND_START, BIGLOWERCENTER_BACKGROUND_STOP, BIGLOWERCENTER_BACKGROUND_FRACTIONS, BIGLOWERCENTER_BACKGROUND_COLORS);
                    G2.setPaint(BIGLOWERCENTER_BACKGROUND_GRADIENT);
                    G2.fill(BIGLOWERCENTER_BACKGROUND);
                    Ellipse2D.Double BIGLOWERCENTER_FOREGROUNDFRAME = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.4532710313796997, (double)IMAGE_HEIGHT * 0.6869158744812012, (double)IMAGE_WIDTH * 0.09345793724060059, (double)IMAGE_HEIGHT * 0.09345793724060059);
                    Point2D.Double BIGLOWERCENTER_FOREGROUNDFRAME_START = new Point2D.Double(0.0, BIGLOWERCENTER_FOREGROUNDFRAME.getBounds2D().getMinY());
                    Point2D.Double BIGLOWERCENTER_FOREGROUNDFRAME_STOP = new Point2D.Double(0.0, BIGLOWERCENTER_FOREGROUNDFRAME.getBounds2D().getMaxY());
                    float[] BIGLOWERCENTER_FOREGROUNDFRAME_FRACTIONS = new float[]{0.0f, 0.47f, 1.0f};
                    switch (this.getModel().getKnobStyle()) {
                        case BLACK: {
                            BIGLOWERCENTER_FOREGROUNDFRAME_COLORS = new Color[]{new Color(191, 191, 191, 255), new Color(56, 57, 61, 255), new Color(143, 144, 146, 255)};
                            break;
                        }
                        case BRASS: {
                            BIGLOWERCENTER_FOREGROUNDFRAME_COLORS = new Color[]{new Color(147, 108, 54, 255), new Color(82, 66, 50, 255), new Color(147, 108, 54, 255)};
                            break;
                        }
                        default: {
                            BIGLOWERCENTER_FOREGROUNDFRAME_COLORS = new Color[]{new Color(191, 191, 191, 255), new Color(116, 116, 116, 255), new Color(143, 144, 146, 255)};
                        }
                    }
                    LinearGradientPaint BIGLOWERCENTER_FOREGROUNDFRAME_GRADIENT = new LinearGradientPaint(BIGLOWERCENTER_FOREGROUNDFRAME_START, BIGLOWERCENTER_FOREGROUNDFRAME_STOP, BIGLOWERCENTER_FOREGROUNDFRAME_FRACTIONS, BIGLOWERCENTER_FOREGROUNDFRAME_COLORS);
                    G2.setPaint(BIGLOWERCENTER_FOREGROUNDFRAME_GRADIENT);
                    G2.fill(BIGLOWERCENTER_FOREGROUNDFRAME);
                    Ellipse2D.Double BIGLOWERCENTER_FOREGROUND = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.4579439163208008, (double)IMAGE_HEIGHT * 0.6915887594223022, (double)IMAGE_WIDTH * 0.08411216735839844, (double)IMAGE_HEIGHT * 0.08411216735839844);
                    Point2D.Double BIGLOWERCENTER_FOREGROUND_START = new Point2D.Double(0.0, BIGLOWERCENTER_FOREGROUND.getBounds2D().getMinY());
                    Point2D.Double BIGLOWERCENTER_FOREGROUND_STOP = new Point2D.Double(0.0, BIGLOWERCENTER_FOREGROUND.getBounds2D().getMaxY());
                    float[] BIGLOWERCENTER_FOREGROUND_FRACTIONS = new float[]{0.0f, 0.21f, 0.5f, 0.78f, 1.0f};
                    switch (this.getModel().getKnobStyle()) {
                        case BLACK: {
                            BIGLOWERCENTER_FOREGROUND_COLORS = new Color[]{new Color(191, 191, 191, 255), new Color(94, 93, 99, 255), new Color(43, 42, 47, 255), new Color(78, 79, 81, 255), new Color(143, 144, 146, 255)};
                            break;
                        }
                        case BRASS: {
                            BIGLOWERCENTER_FOREGROUND_COLORS = new Color[]{new Color(223, 208, 174, 255), new Color(159, 136, 104, 255), new Color(122, 94, 62, 255), new Color(159, 136, 104, 255), new Color(223, 208, 174, 255)};
                            break;
                        }
                        default: {
                            BIGLOWERCENTER_FOREGROUND_COLORS = new Color[]{new Color(215, 215, 215, 255), new Color(139, 142, 145, 255), new Color(100, 100, 100, 255), new Color(139, 142, 145, 255), new Color(215, 215, 215, 255)};
                        }
                    }
                    LinearGradientPaint BIGLOWERCENTER_FOREGROUND_GRADIENT = new LinearGradientPaint(BIGLOWERCENTER_FOREGROUND_START, BIGLOWERCENTER_FOREGROUND_STOP, BIGLOWERCENTER_FOREGROUND_FRACTIONS, BIGLOWERCENTER_FOREGROUND_COLORS);
                    G2.setPaint(BIGLOWERCENTER_FOREGROUND_GRADIENT);
                    G2.fill(BIGLOWERCENTER_FOREGROUND);
                    break;
                }
                case BIG_CHROME_KNOB: {
                    Ellipse2D.Double CHROMEKNOB_BACKFRAME = new Ellipse2D.Double((double)IMAGE_WIDTH * (double)0.4f, (double)IMAGE_HEIGHT * 0.6333333253860474, (double)IMAGE_WIDTH * 0.20000001788139343, (double)IMAGE_HEIGHT * 0.19999998807907104);
                    switch (this.getOrientation()) {
                        case WEST: {
                            ((Point2D)KNOB_CENTER).setLocation(CHROMEKNOB_BACKFRAME.getCenterX(), CHROMEKNOB_BACKFRAME.getCenterY());
                            G2.rotate(1.5707963267948966, ((Point2D)KNOB_CENTER).getX(), ((Point2D)KNOB_CENTER).getY());
                        }
                    }
                    Point2D.Double CHROMEKNOB_BACKFRAME_START = new Point2D.Double(0.44666666666666666 * (double)IMAGE_WIDTH, 0.6466666666666666 * (double)IMAGE_HEIGHT);
                    Point2D.Double CHROMEKNOB_BACKFRAME_STOP = new Point2D.Double(0.5491177244184196 * (double)IMAGE_WIDTH, 0.8106226319235756 * (double)IMAGE_HEIGHT);
                    float[] CHROMEKNOB_BACKFRAME_FRACTIONS = new float[]{0.0f, 1.0f};
                    Color[] CHROMEKNOB_BACKFRAME_COLORS = new Color[]{new Color(129, 139, 140, 255), new Color(166, 171, 175, 255)};
                    LinearGradientPaint CHROMEKNOB_BACKFRAME_GRADIENT = new LinearGradientPaint(CHROMEKNOB_BACKFRAME_START, CHROMEKNOB_BACKFRAME_STOP, CHROMEKNOB_BACKFRAME_FRACTIONS, CHROMEKNOB_BACKFRAME_COLORS);
                    G2.setPaint(CHROMEKNOB_BACKFRAME_GRADIENT);
                    G2.fill(CHROMEKNOB_BACKFRAME);
                    Ellipse2D.Double CHROMEKNOB_BACK = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.40666666626930237, (double)IMAGE_HEIGHT * (double)0.64f, (double)IMAGE_WIDTH * 0.18666663765907288, (double)IMAGE_HEIGHT * 0.18666666746139526);
                    Point2D.Double CHROMEKNOB_BACK_CENTER = new Point2D.Double(CHROMEKNOB_BACK.getCenterX(), CHROMEKNOB_BACK.getCenterY());
                    float[] CHROMEKNOB_BACK_FRACTIONS = new float[]{0.0f, 0.09f, 0.12f, 0.16f, 0.25f, 0.29f, 0.33f, 0.38f, 0.48f, 0.52f, 0.65f, 0.69f, 0.8f, 0.83f, 0.87f, 0.97f, 1.0f};
                    Color[] CHROMEKNOB_BACK_COLORS = new Color[]{new Color(255, 255, 255, 255), new Color(255, 255, 255, 255), new Color(136, 136, 138, 255), new Color(164, 185, 190, 255), new Color(158, 179, 182, 255), new Color(112, 112, 112, 255), new Color(221, 227, 227, 255), new Color(155, 176, 179, 255), new Color(156, 176, 177, 255), new Color(254, 255, 255, 255), new Color(255, 255, 255, 255), new Color(156, 180, 180, 255), new Color(198, 209, 211, 255), new Color(246, 248, 247, 255), new Color(204, 216, 216, 255), new Color(164, 188, 190, 255), new Color(255, 255, 255, 255)};
                    ConicalGradientPaint CHROMEKNOB_BACK_GRADIENT = new ConicalGradientPaint(false, CHROMEKNOB_BACK_CENTER, 0.0f, CHROMEKNOB_BACK_FRACTIONS, CHROMEKNOB_BACK_COLORS);
                    G2.setPaint(CHROMEKNOB_BACK_GRADIENT);
                    G2.fill(CHROMEKNOB_BACK);
                    Ellipse2D.Double CHROMEKNOB_FOREFRAME = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.4533333480358124, (double)IMAGE_HEIGHT * 0.6866666674613953, (double)IMAGE_WIDTH * 0.09333333373069763, (double)IMAGE_HEIGHT * 0.09333330392837524);
                    Point2D.Double CHROMEKNOB_FOREFRAME_START = new Point2D.Double(0.47333333333333333 * (double)IMAGE_WIDTH, 0.6933333333333334 * (double)IMAGE_HEIGHT);
                    Point2D.Double CHROMEKNOB_FOREFRAME_STOP = new Point2D.Double(0.5217967183007981 * (double)IMAGE_WIDTH, 0.7651832562881037 * (double)IMAGE_HEIGHT);
                    float[] CHROMEKNOB_FOREFRAME_FRACTIONS = new float[]{0.0f, 1.0f};
                    Color[] CHROMEKNOB_FOREFRAME_COLORS = new Color[]{new Color(225, 235, 232, 255), new Color(196, 207, 207, 255)};
                    LinearGradientPaint CHROMEKNOB_FOREFRAME_GRADIENT = new LinearGradientPaint(CHROMEKNOB_FOREFRAME_START, CHROMEKNOB_FOREFRAME_STOP, CHROMEKNOB_FOREFRAME_FRACTIONS, CHROMEKNOB_FOREFRAME_COLORS);
                    G2.setPaint(CHROMEKNOB_FOREFRAME_GRADIENT);
                    G2.fill(CHROMEKNOB_FOREFRAME);
                    Ellipse2D.Double CHROMEKNOB_FORE = new Ellipse2D.Double((double)IMAGE_WIDTH * (double)0.46f, (double)IMAGE_HEIGHT * 0.6933333277702332, (double)IMAGE_WIDTH * 0.08000001311302185, (double)IMAGE_HEIGHT * 0.07999998331069946);
                    Point2D.Double CHROMEKNOB_FORE_START = new Point2D.Double(0.47333333333333333 * (double)IMAGE_WIDTH, 0.7 * (double)IMAGE_HEIGHT);
                    Point2D.Double CHROMEKNOB_FORE_STOP = new Point2D.Double(0.518068765610993 * (double)IMAGE_WIDTH, 0.7663230058044033 * (double)IMAGE_HEIGHT);
                    float[] CHROMEKNOB_FORE_FRACTIONS = new float[]{0.0f, 1.0f};
                    Color[] CHROMEKNOB_FORE_COLORS = new Color[]{new Color(237, 239, 237, 255), new Color(148, 161, 161, 255)};
                    LinearGradientPaint CHROMEKNOB_FORE_GRADIENT = new LinearGradientPaint(CHROMEKNOB_FORE_START, CHROMEKNOB_FORE_STOP, CHROMEKNOB_FORE_FRACTIONS, CHROMEKNOB_FORE_COLORS);
                    G2.setPaint(CHROMEKNOB_FORE_GRADIENT);
                    G2.fill(CHROMEKNOB_FORE);
                    break;
                }
                case METAL_KNOB: {
                    Color[] METALKNOBLC_MAIN_COLORS;
                    Ellipse2D.Double METALKNOBLC_FRAME = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.4579439163208008, (double)IMAGE_HEIGHT * 0.6915887594223022, (double)IMAGE_WIDTH * 0.08411216735839844, (double)IMAGE_HEIGHT * 0.08411216735839844);
                    switch (this.getOrientation()) {
                        case WEST: {
                            ((Point2D)KNOB_CENTER).setLocation(METALKNOBLC_FRAME.getCenterX(), METALKNOBLC_FRAME.getCenterY());
                            G2.rotate(1.5707963267948966, ((Point2D)KNOB_CENTER).getX(), ((Point2D)KNOB_CENTER).getY());
                        }
                    }
                    Point2D.Double METALKNOBLC_FRAME_START = new Point2D.Double(0.0, METALKNOBLC_FRAME.getBounds2D().getMinY());
                    Point2D.Double METALKNOBLC_FRAME_STOP = new Point2D.Double(0.0, METALKNOBLC_FRAME.getBounds2D().getMaxY());
                    float[] METALKNOBLC_FRAME_FRACTIONS = new float[]{0.0f, 0.47f, 1.0f};
                    Color[] METALKNOBLC_FRAME_COLORS = new Color[]{new Color(92, 95, 101, 255), new Color(46, 49, 53, 255), new Color(22, 23, 26, 255)};
                    LinearGradientPaint METALKNOBLC_FRAME_GRADIENT = new LinearGradientPaint(METALKNOBLC_FRAME_START, METALKNOBLC_FRAME_STOP, METALKNOBLC_FRAME_FRACTIONS, METALKNOBLC_FRAME_COLORS);
                    G2.setPaint(METALKNOBLC_FRAME_GRADIENT);
                    G2.fill(METALKNOBLC_FRAME);
                    Ellipse2D.Double METALKNOBLC_MAIN = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.46261683106422424, (double)IMAGE_HEIGHT * 0.6962617039680481, (double)IMAGE_WIDTH * 0.0747663676738739, (double)IMAGE_HEIGHT * 0.07476633787155151);
                    Point2D.Double METALKNOBLC_MAIN_START = new Point2D.Double(0.0, METALKNOBLC_MAIN.getBounds2D().getMinY());
                    Point2D.Double METALKNOBLC_MAIN_STOP = new Point2D.Double(0.0, METALKNOBLC_MAIN.getBounds2D().getMaxY());
                    float[] METALKNOBLC_MAIN_FRACTIONS = new float[]{0.0f, 1.0f};
                    switch (this.getModel().getKnobStyle()) {
                        case BLACK: {
                            METALKNOBLC_MAIN_COLORS = new Color[]{new Color(2828847), new Color(1710880)};
                            break;
                        }
                        case BRASS: {
                            METALKNOBLC_MAIN_COLORS = new Color[]{new Color(9858614), new Color(8150845)};
                            break;
                        }
                        default: {
                            METALKNOBLC_MAIN_COLORS = new Color[]{new Color(204, 204, 204, 255), new Color(87, 92, 98, 255)};
                        }
                    }
                    LinearGradientPaint METALKNOBLC_MAIN_GRADIENT = new LinearGradientPaint(METALKNOBLC_MAIN_START, METALKNOBLC_MAIN_STOP, METALKNOBLC_MAIN_FRACTIONS, METALKNOBLC_MAIN_COLORS);
                    G2.setPaint(METALKNOBLC_MAIN_GRADIENT);
                    G2.fill(METALKNOBLC_MAIN);
                    GeneralPath METALKNOBLC_LOWERHL = new GeneralPath();
                    METALKNOBLC_LOWERHL.setWindingRule(0);
                    METALKNOBLC_LOWERHL.moveTo((double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.7616822429906542);
                    METALKNOBLC_LOWERHL.curveTo((double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.7523364485981309, (double)IMAGE_WIDTH * 0.5093457943925234, (double)IMAGE_HEIGHT * 0.7476635514018691, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.7476635514018691);
                    METALKNOBLC_LOWERHL.curveTo((double)IMAGE_WIDTH * 0.48598130841121495, (double)IMAGE_HEIGHT * 0.7476635514018691, (double)IMAGE_WIDTH * 0.4766355140186916, (double)IMAGE_HEIGHT * 0.7523364485981309, (double)IMAGE_WIDTH * 0.4766355140186916, (double)IMAGE_HEIGHT * 0.7616822429906542);
                    METALKNOBLC_LOWERHL.curveTo((double)IMAGE_WIDTH * 0.48130841121495327, (double)IMAGE_HEIGHT * 0.7663551401869159, (double)IMAGE_WIDTH * 0.49065420560747663, (double)IMAGE_HEIGHT * 0.7710280373831776, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.7710280373831776);
                    METALKNOBLC_LOWERHL.curveTo((double)IMAGE_WIDTH * 0.5046728971962616, (double)IMAGE_HEIGHT * 0.7710280373831776, (double)IMAGE_WIDTH * 0.514018691588785, (double)IMAGE_HEIGHT * 0.7663551401869159, (double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.7616822429906542);
                    METALKNOBLC_LOWERHL.closePath();
                    Point2D.Double METALKNOBLC_LOWERHL_CENTER = new Point2D.Double(0.5 * (double)IMAGE_WIDTH, 0.7710280373831776 * (double)IMAGE_HEIGHT);
                    float[] METALKNOBLC_LOWERHL_FRACTIONS = new float[]{0.0f, 1.0f};
                    Color[] METALKNOBLC_LOWERHL_COLORS = new Color[]{new Color(255, 255, 255, 153), new Color(255, 255, 255, 0)};
                    RadialGradientPaint METALKNOBLC_LOWERHL_GRADIENT = new RadialGradientPaint(METALKNOBLC_LOWERHL_CENTER, (float)(0.03271028037383177 * (double)IMAGE_WIDTH), METALKNOBLC_LOWERHL_FRACTIONS, METALKNOBLC_LOWERHL_COLORS);
                    G2.setPaint(METALKNOBLC_LOWERHL_GRADIENT);
                    G2.fill(METALKNOBLC_LOWERHL);
                    GeneralPath METALKNOBLC_UPPERHL = new GeneralPath();
                    METALKNOBLC_UPPERHL.setWindingRule(0);
                    METALKNOBLC_UPPERHL.moveTo((double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.7149532710280374);
                    METALKNOBLC_UPPERHL.curveTo((double)IMAGE_WIDTH * 0.5280373831775701, (double)IMAGE_HEIGHT * 0.7009345794392523, (double)IMAGE_WIDTH * 0.514018691588785, (double)IMAGE_HEIGHT * 0.6915887850467289, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.6915887850467289);
                    METALKNOBLC_UPPERHL.curveTo((double)IMAGE_WIDTH * 0.48130841121495327, (double)IMAGE_HEIGHT * 0.6915887850467289, (double)IMAGE_WIDTH * 0.4672897196261682, (double)IMAGE_HEIGHT * 0.7009345794392523, (double)IMAGE_WIDTH * 0.46261682242990654, (double)IMAGE_HEIGHT * 0.7149532710280374);
                    METALKNOBLC_UPPERHL.curveTo((double)IMAGE_WIDTH * 0.4672897196261682, (double)IMAGE_HEIGHT * 0.719626168224299, (double)IMAGE_WIDTH * 0.48130841121495327, (double)IMAGE_HEIGHT * 0.7242990654205608, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.7242990654205608);
                    METALKNOBLC_UPPERHL.curveTo((double)IMAGE_WIDTH * 0.514018691588785, (double)IMAGE_HEIGHT * 0.7242990654205608, (double)IMAGE_WIDTH * 0.5280373831775701, (double)IMAGE_HEIGHT * 0.719626168224299, (double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.7149532710280374);
                    METALKNOBLC_UPPERHL.closePath();
                    Point2D.Double METALKNOBLC_UPPERHL_CENTER = new Point2D.Double(0.4953271028037383 * (double)IMAGE_WIDTH, 0.6915887850467289 * (double)IMAGE_HEIGHT);
                    float[] METALKNOBLC_UPPERHL_FRACTIONS = new float[]{0.0f, 1.0f};
                    Color[] METALKNOBLC_UPPERHL_COLORS = new Color[]{new Color(255, 255, 255, 191), new Color(255, 255, 255, 0)};
                    RadialGradientPaint METALKNOBLC_UPPERHL_GRADIENT = new RadialGradientPaint(METALKNOBLC_UPPERHL_CENTER, (float)(0.04906542056074766 * (double)IMAGE_WIDTH), METALKNOBLC_UPPERHL_FRACTIONS, METALKNOBLC_UPPERHL_COLORS);
                    G2.setPaint(METALKNOBLC_UPPERHL_GRADIENT);
                    G2.fill(METALKNOBLC_UPPERHL);
                    Ellipse2D.Double METALKNOBLC_INNERFRAME = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.47663551568984985, (double)IMAGE_HEIGHT * 0.7149532437324524, (double)IMAGE_WIDTH * 0.04205608367919922, (double)IMAGE_HEIGHT * 0.04205608367919922);
                    Point2D.Double METALKNOBLC_INNERFRAME_START = new Point2D.Double(0.0, METALKNOBLC_INNERFRAME.getBounds2D().getMinY());
                    Point2D.Double METALKNOBLC_INNERFRAME_STOP = new Point2D.Double(0.0, METALKNOBLC_INNERFRAME.getBounds2D().getMaxY());
                    float[] METALKNOBLC_INNERFRAME_FRACTIONS = new float[]{0.0f, 1.0f};
                    Color[] METALKNOBLC_INNERFRAME_COLORS = new Color[]{new Color(0, 0, 0, 255), new Color(204, 204, 204, 255)};
                    LinearGradientPaint METALKNOBLC_INNERFRAME_GRADIENT = new LinearGradientPaint(METALKNOBLC_INNERFRAME_START, METALKNOBLC_INNERFRAME_STOP, METALKNOBLC_INNERFRAME_FRACTIONS, METALKNOBLC_INNERFRAME_COLORS);
                    G2.setPaint(METALKNOBLC_INNERFRAME_GRADIENT);
                    G2.fill(METALKNOBLC_INNERFRAME);
                    Ellipse2D.Double METALKNOBLC_INNERBACKGROUND = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.4813084006309509, (double)IMAGE_HEIGHT * 0.7196261882781982, (double)IMAGE_WIDTH * 0.03271031379699707, (double)IMAGE_HEIGHT * 0.032710254192352295);
                    Point2D.Double METALKNOBLC_INNERBACKGROUND_START = new Point2D.Double(0.0, METALKNOBLC_INNERBACKGROUND.getBounds2D().getMinY());
                    Point2D.Double METALKNOBLC_INNERBACKGROUND_STOP = new Point2D.Double(0.0, METALKNOBLC_INNERBACKGROUND.getBounds2D().getMaxY());
                    float[] METALKNOBLC_INNERBACKGROUND_FRACTIONS = new float[]{0.0f, 1.0f};
                    Color[] METALKNOBLC_INNERBACKGROUND_COLORS = new Color[]{new Color(1, 6, 11, 255), new Color(50, 52, 56, 255)};
                    LinearGradientPaint METALKNOBLC_INNERBACKGROUND_GRADIENT = new LinearGradientPaint(METALKNOBLC_INNERBACKGROUND_START, METALKNOBLC_INNERBACKGROUND_STOP, METALKNOBLC_INNERBACKGROUND_FRACTIONS, METALKNOBLC_INNERBACKGROUND_COLORS);
                    G2.setPaint(METALKNOBLC_INNERBACKGROUND_GRADIENT);
                    G2.fill(METALKNOBLC_INNERBACKGROUND);
                }
            }
        }
        G2.setTransform(OLD_TRANSFORM);
        if (postPositionList.contains((Object)PostPosition.SMALL_GAUGE_MAX_RIGHT)) {
            switch (this.getOrientation()) {
                case WEST: {
                    ((Point2D)KNOB_CENTER).setLocation((double)IMAGE_WIDTH * 0.7803738117218018 + (double)SINGLE_POST.getWidth() / 2.0, (double)IMAGE_HEIGHT * 0.44859811663627625 + (double)SINGLE_POST.getHeight() / 2.0);
                    G2.rotate(1.5707963267948966, ((Point2D)KNOB_CENTER).getX(), ((Point2D)KNOB_CENTER).getY());
                }
            }
            G2.drawImage((Image)SINGLE_POST, (int)((double)IMAGE_WIDTH * 0.7803738117218018), (int)((double)IMAGE_HEIGHT * 0.44859811663627625), null);
            G2.setTransform(OLD_TRANSFORM);
        }
        if (postPositionList.contains((Object)PostPosition.SMALL_GAUGE_MIN_LEFT)) {
            switch (this.getOrientation()) {
                case WEST: {
                    ((Point2D)KNOB_CENTER).setLocation((double)IMAGE_WIDTH * 0.1822429895401001 + (double)SINGLE_POST.getWidth() / 2.0, (double)IMAGE_HEIGHT * 0.44859811663627625 + (double)SINGLE_POST.getHeight() / 2.0);
                    G2.rotate(1.5707963267948966, ((Point2D)KNOB_CENTER).getX(), ((Point2D)KNOB_CENTER).getY());
                }
            }
            G2.drawImage((Image)SINGLE_POST, (int)((double)IMAGE_WIDTH * 0.1822429895401001), (int)((double)IMAGE_HEIGHT * 0.44859811663627625), null);
            G2.setTransform(OLD_TRANSFORM);
        }
        G2.dispose();
        return image;
    }

    private BufferedImage create_KNOB_Image(int WIDTH, KnobType KNOB_TYPE, KnobStyle KNOB_STYLE) {
        return KNOB_FACTORY.create_KNOB_Image(WIDTH, KNOB_TYPE, KNOB_STYLE);
    }

    protected BufferedImage create_THRESHOLD_Image(int WIDTH) {
        return this.create_THRESHOLD_Image(WIDTH, 0.0);
    }

    protected BufferedImage create_THRESHOLD_Image(int WIDTH, double ROTATION_OFFSET) {
        if (WIDTH <= 22) {
            return UTIL.createImage(1, 1, 3);
        }
        int IMAGE_WIDTH = (int)((double)WIDTH * 0.0420560748);
        int IMAGE_HEIGHT = (int)((double)WIDTH * 0.0981308411);
        BufferedImage IMAGE = UTIL.createImage(IMAGE_WIDTH, IMAGE_HEIGHT, 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.rotate(ROTATION_OFFSET, (double)IMAGE_WIDTH / 2.0, (double)IMAGE_HEIGHT / 2.0);
        Point2D.Double THRESHOLD_START = new Point2D.Double();
        Point2D.Double THRESHOLD_STOP = new Point2D.Double();
        GeneralPath THRESHOLD = new GeneralPath();
        switch (this.getThresholdType()) {
            case ARROW: {
                THRESHOLD.setWindingRule(0);
                THRESHOLD.moveTo((double)IMAGE_WIDTH * 0.1111111111111111, (double)IMAGE_HEIGHT * 0.047619047619047616);
                THRESHOLD.lineTo((double)IMAGE_WIDTH * 0.8888888888888888, (double)IMAGE_HEIGHT * 0.047619047619047616);
                THRESHOLD.lineTo((double)IMAGE_WIDTH * 0.8888888888888888, (double)IMAGE_HEIGHT * 0.3333333333333333);
                THRESHOLD.lineTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.5714285714285714);
                THRESHOLD.lineTo((double)IMAGE_WIDTH * 0.1111111111111111, (double)IMAGE_HEIGHT * 0.3333333333333333);
                THRESHOLD.closePath();
                ((Point2D)THRESHOLD_START).setLocation(0.0, THRESHOLD.getBounds2D().getMinY());
                ((Point2D)THRESHOLD_STOP).setLocation(0.0, THRESHOLD.getBounds2D().getMaxY());
                break;
            }
            default: {
                THRESHOLD.setWindingRule(0);
                THRESHOLD.moveTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.6190476190476191);
                THRESHOLD.lineTo((double)IMAGE_WIDTH * 0.1111111111111111, (double)IMAGE_HEIGHT * 0.9523809523809523);
                THRESHOLD.lineTo((double)IMAGE_WIDTH * 0.8888888888888888, (double)IMAGE_HEIGHT * 0.9523809523809523);
                THRESHOLD.closePath();
                ((Point2D)THRESHOLD_START).setLocation(0.0, THRESHOLD.getBounds2D().getMaxY());
                ((Point2D)THRESHOLD_STOP).setLocation(0.0, THRESHOLD.getBounds2D().getMinY());
            }
        }
        float[] THRESHOLD_FRACTIONS = new float[]{0.0f, 0.3f, 0.59f, 1.0f};
        Color[] THRESHOLD_COLORS = new Color[]{this.getThresholdColor().DARK, this.getThresholdColor().MEDIUM, this.getThresholdColor().MEDIUM, this.getThresholdColor().DARK};
        LinearGradientPaint THRESHOLD_GRADIENT = new LinearGradientPaint(THRESHOLD_START, THRESHOLD_STOP, THRESHOLD_FRACTIONS, THRESHOLD_COLORS);
        G2.setPaint(THRESHOLD_GRADIENT);
        G2.fill(THRESHOLD);
        G2.setColor(Color.WHITE);
        G2.setStroke(new BasicStroke(1.0f, 0, 0));
        G2.draw(THRESHOLD);
        G2.dispose();
        return IMAGE;
    }

    protected BufferedImage create_MEASURED_VALUE_Image(int WIDTH, Color COLOR) {
        return this.create_MEASURED_VALUE_Image(WIDTH, COLOR, 0.0);
    }

    protected BufferedImage create_MEASURED_VALUE_Image(int WIDTH, Color COLOR, double ROTATION_OFFSET) {
        int IMAGE_HEIGHT;
        if (WIDTH <= 36) {
            return UTIL.createImage(1, 1, 3);
        }
        int IMAGE_WIDTH = IMAGE_HEIGHT = (int)((double)WIDTH * 0.0280373832);
        BufferedImage IMAGE = UTIL.createImage(IMAGE_WIDTH, IMAGE_HEIGHT, 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.rotate(ROTATION_OFFSET, (double)IMAGE_WIDTH / 2.0, (double)IMAGE_HEIGHT / 2.0);
        GeneralPath INDICATOR = new GeneralPath();
        INDICATOR.setWindingRule(0);
        INDICATOR.moveTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT);
        INDICATOR.lineTo(0.0, 0.0);
        INDICATOR.lineTo((double)IMAGE_WIDTH, 0.0);
        INDICATOR.closePath();
        G2.setColor(COLOR);
        G2.fill(INDICATOR);
        G2.dispose();
        return IMAGE;
    }

    protected BufferedImage create_POINTER_Image(int WIDTH) {
        return this.create_POINTER_Image(WIDTH, PointerType.TYPE1);
    }

    protected BufferedImage create_POINTER_Image(int WIDTH, PointerType POINTER_TYPE) {
        if (this.getPointerColor() != ColorDef.CUSTOM) {
            return POINTER_FACTORY.createStandardPointer(WIDTH, POINTER_TYPE, this.getPointerColor(), this.getBackgroundColor());
        }
        return POINTER_FACTORY.createStandardPointer(WIDTH, POINTER_TYPE, this.getPointerColor(), this.getModel().getCustomPointerColorObject(), this.getBackgroundColor());
    }

    protected BufferedImage create_POINTER_Image(int WIDTH, PointerType POINTER_TYPE, ColorDef POINTER_COLOR) {
        return POINTER_FACTORY.createStandardPointer(WIDTH, POINTER_TYPE, POINTER_COLOR, this.getBackgroundColor());
    }

    protected BufferedImage create_POINTER_Image(int WIDTH, PointerType POINTER_TYPE, ColorDef POINTER_COLOR, CustomColorDef CUSTOM_POINTER_COLOR) {
        return POINTER_FACTORY.createStandardPointer(WIDTH, POINTER_TYPE, POINTER_COLOR, CUSTOM_POINTER_COLOR, this.getBackgroundColor());
    }

    protected BufferedImage create_POINTER_SHADOW_Image(int WIDTH) {
        return this.create_POINTER_SHADOW_Image(WIDTH, PointerType.TYPE1);
    }

    protected BufferedImage create_POINTER_SHADOW_Image(int WIDTH, PointerType POINTER_TYPE) {
        return POINTER_FACTORY.createStandardPointerShadow(WIDTH, POINTER_TYPE);
    }

    protected BufferedImage create_FOREGROUND_Image(int WIDTH) {
        switch (this.getFrameType()) {
            case ROUND: {
                return FOREGROUND_FACTORY.createRadialForeground(WIDTH);
            }
            case SQUARE: {
                return FOREGROUND_FACTORY.createLinearForeground(WIDTH, WIDTH);
            }
        }
        return FOREGROUND_FACTORY.createRadialForeground(WIDTH);
    }

    protected BufferedImage create_FOREGROUND_Image(int WIDTH, boolean WITH_CENTER_KNOB) {
        switch (this.getFrameType()) {
            case ROUND: {
                return FOREGROUND_FACTORY.createRadialForeground(WIDTH, WITH_CENTER_KNOB);
            }
            case SQUARE: {
                return FOREGROUND_FACTORY.createLinearForeground(WIDTH, WIDTH, WITH_CENTER_KNOB);
            }
        }
        return FOREGROUND_FACTORY.createRadialForeground(WIDTH, WITH_CENTER_KNOB);
    }

    protected BufferedImage create_FOREGROUND_Image(int WIDTH, boolean WITH_CENTER_KNOB, ForegroundType TYPE) {
        return this.create_FOREGROUND_Image(WIDTH, WITH_CENTER_KNOB, TYPE, null);
    }

    protected BufferedImage create_FOREGROUND_Image(int WIDTH, boolean WITH_CENTER_KNOB, ForegroundType TYPE, BufferedImage IMAGE) {
        switch (this.getFrameType()) {
            case ROUND: {
                return FOREGROUND_FACTORY.createRadialForeground(WIDTH, WITH_CENTER_KNOB, TYPE, IMAGE);
            }
            case SQUARE: {
                return FOREGROUND_FACTORY.createLinearForeground(WIDTH, WIDTH, WITH_CENTER_KNOB, IMAGE);
            }
        }
        return FOREGROUND_FACTORY.createRadialForeground(WIDTH, WITH_CENTER_KNOB, ForegroundType.FG_TYPE1, IMAGE);
    }

    protected BufferedImage create_DISABLED_Image(int WIDTH) {
        return DISABLED_FACTORY.createRadialDisabled(WIDTH);
    }

    @Override
    public void calcInnerBounds() {
        this.calcInnerBounds(this.getWidth(), this.getHeight());
    }

    public void calcInnerBounds(int WIDTH, int HEIGHT) {
        Insets INSETS = this.getInsets();
        int SIZE = WIDTH - INSETS.left - INSETS.right <= HEIGHT - INSETS.top - INSETS.bottom ? WIDTH - INSETS.left - INSETS.right : HEIGHT - INSETS.top - INSETS.bottom;
        this.INNER_BOUNDS.setBounds(INSETS.left, INSETS.top, WIDTH - INSETS.left - INSETS.right, HEIGHT - INSETS.top - INSETS.bottom);
        if (!this.isFrameVisible()) {
            this.GAUGE_BOUNDS.setBounds(INSETS.left, INSETS.top, (int)((double)SIZE * 1.202247191), (int)((double)SIZE * 1.202247191));
        } else {
            this.GAUGE_BOUNDS.setBounds(INSETS.left, INSETS.top, SIZE, SIZE);
        }
        this.FRAMELESS_BOUNDS.setBounds(INSETS.left + (int)((double)SIZE * 0.08411215245723724), INSETS.top + (int)((double)SIZE * 0.08411215245723724), (int)((double)SIZE * 0.8317756652832031), (int)((double)SIZE * 0.8317756652832031));
    }

    @Override
    public Rectangle getInnerBounds() {
        return this.INNER_BOUNDS;
    }

    public Rectangle getGaugeBounds() {
        return this.GAUGE_BOUNDS;
    }

    public Rectangle getFramelessBounds() {
        return this.FRAMELESS_BOUNDS;
    }

    public Point2D getFramelessOffset() {
        return this.FRAMELESS_OFFSET;
    }

    public void setFramelessOffset(double X, double Y) {
        this.FRAMELESS_OFFSET.setLocation(X, Y);
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension dim = super.getMinimumSize();
        if (dim.width < 50 || dim.height < 50) {
            dim = new Dimension(50, 50);
        }
        return dim;
    }

    @Override
    public void setMinimumSize(Dimension DIM) {
        int width = DIM.width < 50 ? 50 : DIM.width;
        int height = DIM.height < 50 ? 50 : DIM.height;
        int SIZE = width <= height ? width : height;
        super.setMinimumSize(new Dimension(SIZE, SIZE));
        this.calcInnerBounds();
        this.init(this.getGaugeBounds().width, this.getGaugeBounds().height);
        this.setInitialized(true);
        this.invalidate();
        this.repaint();
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension dim = super.getMaximumSize();
        if (dim.width > 1080 || dim.height > 1080) {
            dim = new Dimension(1080, 1080);
        }
        return dim;
    }

    @Override
    public void setMaximumSize(Dimension DIM) {
        int width = DIM.width > 1080 ? 1080 : DIM.width;
        int height = DIM.height > 1080 ? 1080 : DIM.height;
        int SIZE = width <= height ? width : height;
        super.setMaximumSize(new Dimension(SIZE, SIZE));
        this.calcInnerBounds();
        this.init(this.getGaugeBounds().width, this.getGaugeBounds().height);
        this.setInitialized(true);
        this.invalidate();
        this.repaint();
    }

    @Override
    public void setPreferredSize(Dimension DIM) {
        int SIZE = DIM.width <= DIM.height ? DIM.width : DIM.height;
        super.setPreferredSize(new Dimension(SIZE, SIZE));
        this.calcInnerBounds();
        this.init(this.getGaugeBounds().width, this.getGaugeBounds().height);
        this.setInitialized(true);
        this.invalidate();
        this.repaint();
    }

    @Override
    public void setSize(int WIDTH, int HEIGHT) {
        int SIZE = WIDTH <= HEIGHT ? WIDTH : HEIGHT;
        super.setSize(SIZE, SIZE);
        this.calcInnerBounds();
        this.init(this.getGaugeBounds().width, this.getGaugeBounds().height);
        this.setInitialized(true);
    }

    @Override
    public void setSize(Dimension DIM) {
        int SIZE = DIM.width <= DIM.height ? DIM.width : DIM.height;
        super.setSize(new Dimension(SIZE, SIZE));
        this.calcInnerBounds();
        this.init(this.getGaugeBounds().width, this.getGaugeBounds().height);
        this.setInitialized(true);
    }

    @Override
    public void setBounds(Rectangle BOUNDS) {
        if (BOUNDS.width <= BOUNDS.height) {
            int yNew;
            switch (this.verticalAlignment) {
                case 1: {
                    yNew = BOUNDS.y;
                    break;
                }
                case 3: {
                    yNew = BOUNDS.y + (BOUNDS.height - BOUNDS.width);
                    break;
                }
                default: {
                    yNew = BOUNDS.y + (BOUNDS.height - BOUNDS.width) / 2;
                }
            }
            super.setBounds(BOUNDS.x, yNew, BOUNDS.width, BOUNDS.width);
        } else {
            int xNew;
            switch (this.horizontalAlignment) {
                case 2: {
                    xNew = BOUNDS.x;
                    break;
                }
                case 4: {
                    xNew = BOUNDS.x + (BOUNDS.width - BOUNDS.height);
                    break;
                }
                default: {
                    xNew = BOUNDS.x + (BOUNDS.width - BOUNDS.height) / 2;
                }
            }
            super.setBounds(xNew, BOUNDS.y, BOUNDS.height, BOUNDS.height);
        }
        this.calcInnerBounds();
        this.init(this.getGaugeBounds().width, this.getGaugeBounds().height);
        this.setInitialized(true);
    }

    @Override
    public void setBounds(int X, int Y, int WIDTH, int HEIGHT) {
        if (WIDTH <= HEIGHT) {
            int yNew;
            switch (this.verticalAlignment) {
                case 1: {
                    yNew = Y;
                    break;
                }
                case 3: {
                    yNew = Y + (HEIGHT - WIDTH);
                    break;
                }
                default: {
                    yNew = Y + (HEIGHT - WIDTH) / 2;
                }
            }
            super.setBounds(X, yNew, WIDTH, WIDTH);
        } else {
            int xNew;
            switch (this.horizontalAlignment) {
                case 2: {
                    xNew = X;
                    break;
                }
                case 4: {
                    xNew = X + (WIDTH - HEIGHT);
                    break;
                }
                default: {
                    xNew = X + (WIDTH - HEIGHT) / 2;
                }
            }
            super.setBounds(xNew, Y, HEIGHT, HEIGHT);
        }
        this.calcInnerBounds();
        this.init(this.getGaugeBounds().width, this.getGaugeBounds().height);
        this.setInitialized(true);
    }

    @Override
    public void setBorder(Border BORDER) {
        super.setBorder(BORDER);
        this.calcInnerBounds();
        this.init(this.getGaugeBounds().width, this.getGaugeBounds().height);
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(int HORIZONTAL_ALIGNMENT) {
        this.horizontalAlignment = HORIZONTAL_ALIGNMENT;
    }

    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(int VERTICAL_ALIGNMENT) {
        this.verticalAlignment = VERTICAL_ALIGNMENT;
    }

    @Override
    public void componentResized(ComponentEvent EVENT) {
        int SIZE = this.getWidth() <= this.getHeight() ? this.getWidth() : this.getHeight();
        Container PARENT = this.getParent();
        if (PARENT != null && PARENT.getLayout() == null) {
            if (SIZE < this.getMinimumSize().width || SIZE < this.getMinimumSize().height) {
                this.setSize(this.getMinimumSize());
            } else {
                this.setSize(SIZE, SIZE);
            }
        } else if (SIZE < this.getMinimumSize().width || SIZE < this.getMinimumSize().height) {
            this.setPreferredSize(this.getMinimumSize());
        } else {
            this.setPreferredSize(new Dimension(SIZE, SIZE));
        }
        this.calcInnerBounds();
        this.recreateLedImages();
        if (this.isLedOn()) {
            this.setCurrentLedImage(this.getLedImageOn());
        } else {
            this.setCurrentLedImage(this.getLedImageOff());
        }
        this.recreateUserLedImages();
        if (this.isUserLedOn()) {
            this.setCurrentUserLedImage(this.getUserLedImageOn());
        } else {
            this.setCurrentUserLedImage(this.getUserLedImageOff());
        }
        this.getModel().setSize(this.getLocation().x, this.getLocation().y, SIZE, SIZE);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
    }

    @Override
    public void actionPerformed(ActionEvent EVENT) {
        super.actionPerformed(EVENT);
        if (EVENT.getSource().equals(this.LCD_BLINKING_TIMER)) {
            this.lcdTextVisible ^= true;
            this.repaint(this.getInnerBounds());
        }
    }

    @Override
    public String toString() {
        return "AbstractRadial";
    }
}

