/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.gauges;

import eu.hansolo.steelseries.gauges.AbstractGauge;
import eu.hansolo.steelseries.gauges.AbstractRadial;
import eu.hansolo.steelseries.tools.BackgroundColor;
import eu.hansolo.steelseries.tools.ColorDef;
import eu.hansolo.steelseries.tools.ConicalGradientPaint;
import eu.hansolo.steelseries.tools.Direction;
import eu.hansolo.steelseries.tools.FrameDesign;
import eu.hansolo.steelseries.tools.GaugeType;
import eu.hansolo.steelseries.tools.GradientWrapper;
import eu.hansolo.steelseries.tools.Model;
import eu.hansolo.steelseries.tools.Orientation;
import eu.hansolo.steelseries.tools.PointerType;
import eu.hansolo.steelseries.tools.Scaler;
import eu.hansolo.steelseries.tools.Section;
import eu.hansolo.steelseries.tools.Shadow;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.util.Random;

public final class Radial1Square
extends AbstractRadial {
    private static final int BASE = 10;
    private static final double TICKMARK_ROTATION_OFFSET = 1.5707963267948966;
    private final double ROTATION_OFFSET;
    private BufferedImage bImage;
    private BufferedImage fImage;
    private BufferedImage glowImageOff;
    private BufferedImage glowImageOn;
    private BufferedImage pointerImage;
    private BufferedImage pointerShadowImage;
    private BufferedImage thresholdImage;
    private BufferedImage minMeasuredImage;
    private BufferedImage maxMeasuredImage;
    private BufferedImage disabledImage;
    private final Point2D ROTATION_CENTER;
    private final Point2D TRACK_OFFSET;
    private final Point2D TICKMARKS_OFFSET;
    private final Point2D THRESHOLD_OFFSET;
    private final Point2D MEASURED_OFFSET;
    private double thresholdRotationOffset;
    private double measuredRotationOffset;
    private float titleOffsetYFactor;
    private float unitOffsetYFactor;
    private double angle;
    private final Color DARK_NOISE;
    private final Color BRIGHT_NOISE;

    public Radial1Square() {
        this.getModel().setGaugeType(GaugeType.TYPE1);
        this.ROTATION_OFFSET = 4.71238898038469 + this.getModel().getFreeAreaAngle() / 2.0;
        this.ROTATION_CENTER = new Point2D.Double(0.0, 0.0);
        this.TRACK_OFFSET = new Point2D.Double(0.0, 0.0);
        this.TICKMARKS_OFFSET = new Point2D.Double(0.0, 0.0);
        this.THRESHOLD_OFFSET = new Point2D.Double(0.0, 0.0);
        this.MEASURED_OFFSET = new Point2D.Double(0.0, 0.0);
        this.measuredRotationOffset = 0.0;
        this.thresholdRotationOffset = 0.0;
        this.titleOffsetYFactor = 0.6f;
        this.unitOffsetYFactor = 0.67f;
        this.angle = 0.0;
        this.DARK_NOISE = new Color(0.2f, 0.2f, 0.2f);
        this.BRIGHT_NOISE = new Color(0.8f, 0.8f, 0.8f);
        this.setLedPosition(0.45, 0.45);
        this.setUserLedPosition(0.6, 0.45);
        this.setOrientation(Orientation.NORTH_WEST);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
    }

    public Radial1Square(Model MODEL) {
        this.setModel(MODEL);
        this.ROTATION_OFFSET = 4.71238898038469 + this.getModel().getFreeAreaAngle() / 2.0;
        this.ROTATION_CENTER = new Point2D.Double(0.0, 0.0);
        this.TRACK_OFFSET = new Point2D.Double(0.0, 0.0);
        this.TICKMARKS_OFFSET = new Point2D.Double(0.0, 0.0);
        this.THRESHOLD_OFFSET = new Point2D.Double(0.0, 0.0);
        this.MEASURED_OFFSET = new Point2D.Double(0.0, 0.0);
        this.measuredRotationOffset = 0.0;
        this.thresholdRotationOffset = 0.0;
        this.titleOffsetYFactor = 0.6f;
        this.unitOffsetYFactor = 0.67f;
        this.angle = 0.0;
        this.DARK_NOISE = new Color(0.2f, 0.2f, 0.2f);
        this.BRIGHT_NOISE = new Color(0.8f, 0.8f, 0.8f);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
    }

    @Override
    public final AbstractGauge init(int WIDTH, int HEIGHT) {
        double MAX_MEASURED_ORIENTATION_OFFSET;
        double MIN_MEASURED_ORIENTATION_OFFSET;
        double THRESHOLD_ORIENTATION_OFFSET;
        double TRACK_ORIENTATION_OFFSET;
        int GAUGE_HEIGHT;
        int GAUGE_WIDTH = this.isFrameVisible() ? WIDTH : this.getGaugeBounds().width;
        int n = GAUGE_HEIGHT = this.isFrameVisible() ? HEIGHT : this.getGaugeBounds().height;
        if (GAUGE_WIDTH <= 1 || GAUGE_HEIGHT <= 1) {
            return this;
        }
        if (!this.isFrameVisible()) {
            this.setFramelessOffset((double)(-this.getGaugeBounds().width) * 0.0841121495, (double)(-this.getGaugeBounds().width) * 0.0841121495);
        } else {
            this.setFramelessOffset(this.getGaugeBounds().x, this.getGaugeBounds().y);
        }
        if (this.bImage != null) {
            this.bImage.flush();
        }
        this.bImage = UTIL.createImage(GAUGE_WIDTH, GAUGE_WIDTH, 3);
        if (this.fImage != null) {
            this.fImage.flush();
        }
        this.fImage = UTIL.createImage(GAUGE_WIDTH, GAUGE_WIDTH, 3);
        if (this.isFrameVisible()) {
            this.create_FRAME_Image(GAUGE_WIDTH, this.bImage);
        }
        if (this.isBackgroundVisible()) {
            this.create_BACKGROUND_Image(GAUGE_WIDTH, this.bImage);
        }
        if (this.isGlowVisible()) {
            if (this.glowImageOff != null) {
                this.glowImageOff.flush();
            }
            this.glowImageOff = this.create_GLOW_Image(GAUGE_WIDTH, this.getGlowColor(), false);
            if (this.glowImageOn != null) {
                this.glowImageOn.flush();
            }
            this.glowImageOn = this.create_GLOW_Image(GAUGE_WIDTH, this.getGlowColor(), true);
        } else {
            this.setGlowPulsating(false);
        }
        switch (this.getOrientation()) {
            case NORTH_EAST: {
                TRACK_ORIENTATION_OFFSET = 1.5707963267948966;
                this.TRACK_OFFSET.setLocation(-((double)GAUGE_WIDTH / 1.55), 0.0);
                break;
            }
            case SOUTH_EAST: {
                TRACK_ORIENTATION_OFFSET = Math.PI;
                this.TRACK_OFFSET.setLocation(-((double)GAUGE_WIDTH / 1.55), -((double)GAUGE_WIDTH / 1.55));
                break;
            }
            case SOUTH_WEST: {
                TRACK_ORIENTATION_OFFSET = 4.71238898038469;
                this.TRACK_OFFSET.setLocation(0.0, -((double)GAUGE_WIDTH / 1.55));
                break;
            }
            default: {
                TRACK_ORIENTATION_OFFSET = 0.0;
                this.TRACK_OFFSET.setLocation(0.0, 0.0);
            }
        }
        if (this.isTrackVisible()) {
            this.create_TRACK_Image(GAUGE_WIDTH, this.getModel().getFreeAreaAngle(), 1.5707963267948966 + TRACK_ORIENTATION_OFFSET, this.getMinValue(), this.getMaxValue(), this.getAngleStep(), this.getTrackStart(), this.getTrackSection(), this.getTrackStop(), this.getTrackStartColor(), this.getTrackSectionColor(), this.getTrackStopColor(), 0.68f, new Point2D.Double((double)GAUGE_WIDTH * 0.8271028037, (double)GAUGE_WIDTH * 0.8271028037), this.getTickmarkDirection(), this.TRACK_OFFSET, this.bImage);
        }
        if (!this.getAreas().isEmpty()) {
            this.createAreas(this.bImage);
        }
        if (!this.getSections().isEmpty()) {
            this.createSections(this.bImage);
        }
        switch (this.getOrientation()) {
            case NORTH_EAST: {
                this.TICKMARKS_OFFSET.setLocation(-((double)GAUGE_WIDTH / 1.55), 0.0);
                break;
            }
            case SOUTH_EAST: {
                this.TICKMARKS_OFFSET.setLocation(-((double)GAUGE_WIDTH / 1.55), -((double)GAUGE_WIDTH / 1.55));
                break;
            }
            case SOUTH_WEST: {
                this.TICKMARKS_OFFSET.setLocation(0.0, -((double)GAUGE_WIDTH / 1.55));
                break;
            }
            default: {
                this.TICKMARKS_OFFSET.setLocation(0.0, 0.0);
            }
        }
        TICKMARK_FACTORY.create_RADIAL_TICKMARKS_Image(GAUGE_WIDTH, this.getModel().getNiceMinValue(), this.getModel().getNiceMaxValue(), this.getModel().getMaxNoOfMinorTicks(), this.getModel().getMaxNoOfMajorTicks(), this.getModel().getMinorTickSpacing(), this.getModel().getMajorTickSpacing(), this.getGaugeType(), this.getMinorTickmarkType(), this.getMajorTickmarkType(), this.isTickmarksVisible(), this.isTicklabelsVisible(), this.getModel().isMinorTickmarksVisible(), this.getModel().isMajorTickmarksVisible(), this.getLabelNumberFormat(), this.isTickmarkSectionsVisible(), this.getBackgroundColor(), this.getTickmarkColor(), this.isTickmarkColorFromThemeEnabled(), this.getTickmarkSections(), this.isSectionTickmarksOnly(), this.getSections(), 0.68f, 0.09f, new Point2D.Double((double)GAUGE_WIDTH * 0.8271028037, (double)GAUGE_WIDTH * 0.8271028037), new Point2D.Double(0.0, 0.0), Orientation.NORTH_WEST, this.getModel().getTicklabelOrientation(), this.getModel().isNiceScale(), this.getModel().isLogScale(), this.bImage);
        if (this.pointerImage != null) {
            this.pointerImage.flush();
        }
        this.pointerImage = this.create_POINTER_Image(GAUGE_WIDTH, this.getPointerType());
        if (this.pointerShadowImage != null) {
            this.pointerShadowImage.flush();
        }
        this.pointerShadowImage = this.getModel().isPointerShadowVisible() ? this.create_POINTER_SHADOW_Image(GAUGE_WIDTH, this.getPointerType()) : null;
        this.create_POSTS_Image(GAUGE_WIDTH, this.fImage);
        if (this.isForegroundVisible()) {
            this.create_FOREGROUND_Image(GAUGE_WIDTH, this.fImage);
        }
        switch (this.getOrientation()) {
            case NORTH_EAST: {
                THRESHOLD_ORIENTATION_OFFSET = 1.5707963267948966;
                this.THRESHOLD_OFFSET.setLocation((double)this.bImage.getWidth() * 0.775, (double)this.bImage.getHeight() * 0.81);
                if (!this.isLogScale()) {
                    this.thresholdRotationOffset = this.ROTATION_OFFSET + (this.getMaxValue() - this.getThreshold() - this.getMinValue()) * this.getAngleStep();
                    break;
                }
                this.thresholdRotationOffset = this.ROTATION_OFFSET + UTIL.logOfBase(10.0, this.getMaxValue() - this.getThreshold() - this.getMinValue()) * this.getLogAngleStep();
                break;
            }
            case SOUTH_EAST: {
                THRESHOLD_ORIENTATION_OFFSET = 1.5707963267948966;
                this.THRESHOLD_OFFSET.setLocation((double)this.bImage.getWidth() * 0.79, (double)this.bImage.getHeight() * 0.16);
                if (!this.isLogScale()) {
                    this.thresholdRotationOffset = 1.5707963267948966 + this.ROTATION_OFFSET + (this.getMaxValue() - this.getThreshold() - this.getMinValue()) * this.getAngleStep();
                    break;
                }
                this.thresholdRotationOffset = 1.5707963267948966 + this.ROTATION_OFFSET + UTIL.logOfBase(10.0, this.getMaxValue() - this.getThreshold() - this.getMinValue()) * this.getLogAngleStep();
                break;
            }
            case SOUTH_WEST: {
                THRESHOLD_ORIENTATION_OFFSET = -1.5707963267948966;
                this.THRESHOLD_OFFSET.setLocation((double)this.bImage.getWidth() * 0.19, (double)this.bImage.getHeight() * 0.16);
                if (!this.isLogScale()) {
                    this.thresholdRotationOffset = this.ROTATION_OFFSET + (this.getThreshold() - this.getMinValue()) * this.getAngleStep();
                    break;
                }
                this.thresholdRotationOffset = this.ROTATION_OFFSET + UTIL.logOfBase(10.0, this.getThreshold() - this.getMinValue()) * this.getLogAngleStep();
                break;
            }
            default: {
                THRESHOLD_ORIENTATION_OFFSET = 0.0;
                this.THRESHOLD_OFFSET.setLocation((double)this.bImage.getWidth() * 0.805, (double)this.bImage.getHeight() * 0.19);
                this.thresholdRotationOffset = !this.isLogScale() ? this.ROTATION_OFFSET + (this.getThreshold() - this.getMinValue()) * this.getAngleStep() : this.ROTATION_OFFSET + UTIL.logOfBase(10.0, this.getThreshold() - this.getMinValue()) * this.getLogAngleStep();
            }
        }
        if (this.thresholdImage != null) {
            this.thresholdImage.flush();
        }
        this.thresholdImage = this.create_THRESHOLD_Image(GAUGE_WIDTH, THRESHOLD_ORIENTATION_OFFSET);
        switch (this.getOrientation()) {
            case NORTH_EAST: {
                MIN_MEASURED_ORIENTATION_OFFSET = 1.5707963267948966;
                this.measuredRotationOffset = this.ROTATION_OFFSET;
                this.MEASURED_OFFSET.setLocation((double)this.bImage.getWidth() * 0.87, (double)this.bImage.getHeight() * 0.815);
                break;
            }
            case SOUTH_EAST: {
                MIN_MEASURED_ORIENTATION_OFFSET = 1.5707963267948966;
                this.MEASURED_OFFSET.setLocation((double)this.bImage.getWidth() * 0.87, (double)this.bImage.getHeight() * 0.15);
                this.measuredRotationOffset = 1.5707963267948966 + this.ROTATION_OFFSET;
                break;
            }
            case SOUTH_WEST: {
                MIN_MEASURED_ORIENTATION_OFFSET = -1.5707963267948966;
                this.MEASURED_OFFSET.setLocation((double)this.bImage.getWidth() * 0.1, (double)this.bImage.getHeight() * 0.16);
                this.measuredRotationOffset = this.ROTATION_OFFSET;
                break;
            }
            default: {
                MIN_MEASURED_ORIENTATION_OFFSET = 0.0;
                this.MEASURED_OFFSET.setLocation((double)this.bImage.getWidth() * 0.811, (double)this.bImage.getHeight() * 0.11);
                this.measuredRotationOffset = this.ROTATION_OFFSET;
            }
        }
        if (this.minMeasuredImage != null) {
            this.minMeasuredImage.flush();
        }
        this.minMeasuredImage = this.create_MEASURED_VALUE_Image(GAUGE_WIDTH, new Color(0, 23, 252, 255), MIN_MEASURED_ORIENTATION_OFFSET);
        switch (this.getOrientation()) {
            case NORTH_EAST: {
                MAX_MEASURED_ORIENTATION_OFFSET = 1.5707963267948966;
                this.measuredRotationOffset = this.ROTATION_OFFSET;
                this.MEASURED_OFFSET.setLocation((double)this.bImage.getWidth() * 0.87, (double)this.bImage.getHeight() * 0.815);
                break;
            }
            case SOUTH_EAST: {
                MAX_MEASURED_ORIENTATION_OFFSET = 1.5707963267948966;
                this.MEASURED_OFFSET.setLocation((double)this.bImage.getWidth() * 0.87, (double)this.bImage.getHeight() * 0.15);
                this.measuredRotationOffset = 1.5707963267948966 + this.ROTATION_OFFSET;
                break;
            }
            case SOUTH_WEST: {
                MAX_MEASURED_ORIENTATION_OFFSET = -1.5707963267948966;
                this.MEASURED_OFFSET.setLocation((double)this.bImage.getWidth() * 0.1, (double)this.bImage.getHeight() * 0.16);
                this.measuredRotationOffset = this.ROTATION_OFFSET;
                break;
            }
            default: {
                MAX_MEASURED_ORIENTATION_OFFSET = 0.0;
                this.MEASURED_OFFSET.setLocation((double)this.bImage.getWidth() * 0.811, (double)this.bImage.getHeight() * 0.11);
                this.measuredRotationOffset = this.ROTATION_OFFSET;
            }
        }
        if (this.maxMeasuredImage != null) {
            this.maxMeasuredImage.flush();
        }
        this.maxMeasuredImage = this.create_MEASURED_VALUE_Image(GAUGE_WIDTH, new Color(252, 29, 0, 255), MAX_MEASURED_ORIENTATION_OFFSET);
        if (this.disabledImage != null) {
            this.disabledImage.flush();
        }
        this.disabledImage = this.create_DISABLED_Image(GAUGE_WIDTH);
        switch (this.getOrientation()) {
            case NORTH_EAST: {
                this.ROTATION_CENTER.setLocation((double)GAUGE_WIDTH - (double)GAUGE_WIDTH * 0.8271028037, (double)GAUGE_WIDTH * 0.8271028037);
                this.titleOffsetYFactor = 0.6f;
                this.unitOffsetYFactor = 0.67f;
                break;
            }
            case SOUTH_EAST: {
                this.ROTATION_CENTER.setLocation((double)GAUGE_WIDTH - (double)GAUGE_WIDTH * 0.8271028037, (double)GAUGE_WIDTH - (double)GAUGE_WIDTH * 0.8271028037);
                this.titleOffsetYFactor = 0.3f;
                this.unitOffsetYFactor = 0.37f;
                break;
            }
            case SOUTH_WEST: {
                this.ROTATION_CENTER.setLocation((double)GAUGE_WIDTH * 0.8271028037, (double)GAUGE_WIDTH - (double)GAUGE_WIDTH * 0.8271028037);
                this.titleOffsetYFactor = 0.3f;
                this.unitOffsetYFactor = 0.37f;
                break;
            }
            default: {
                this.ROTATION_CENTER.setLocation((double)GAUGE_WIDTH * 0.8271028037, (double)GAUGE_WIDTH * 0.8271028037);
                this.titleOffsetYFactor = 0.6f;
                this.unitOffsetYFactor = 0.67f;
            }
        }
        this.setCurrentLedImage(this.getLedImageOff());
        return this;
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (!this.isInitialized()) {
            return;
        }
        Graphics2D G2 = (Graphics2D)g.create();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        G2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        G2.translate(this.getFramelessOffset().getX(), this.getFramelessOffset().getY());
        AffineTransform OLD_TRANSFORM = G2.getTransform();
        G2.drawImage((Image)this.bImage, 0, 0, null);
        if (this.isHighlightArea()) {
            for (Section area : this.getAreas()) {
                if (!area.contains(this.getValue())) continue;
                G2.setColor(area.getHighlightColor());
                G2.fill(area.getFilledArea());
                break;
            }
        }
        if (this.isHighlightSection()) {
            for (Section section : this.getSections()) {
                if (!section.contains(this.getValue())) continue;
                G2.setColor(section.getHighlightColor());
                G2.fill(section.getSectionArea());
                break;
            }
        }
        FontRenderContext RENDER_CONTEXT = new FontRenderContext(null, true, true);
        if (!this.getTitle().isEmpty()) {
            if (this.isLabelColorFromThemeEnabled()) {
                G2.setColor(this.getBackgroundColor().LABEL_COLOR);
            } else {
                G2.setColor(this.getLabelColor());
            }
            if (this.isTitleAndUnitFontEnabled()) {
                G2.setFont(new Font(this.getTitleAndUnitFont().getFamily(), 0, (int)(0.04672897196261682 * (double)this.getGaugeBounds().width)));
            } else {
                G2.setFont(new Font("Verdana", 0, (int)(0.04672897196261682 * (double)this.getGaugeBounds().width)));
            }
            TextLayout TITLE_LAYOUT = new TextLayout(this.getTitle(), G2.getFont(), RENDER_CONTEXT);
            Rectangle2D TITLE_BOUNDARY = TITLE_LAYOUT.getBounds();
            G2.drawString(this.getTitle(), (float)(((double)this.getGaugeBounds().width - TITLE_BOUNDARY.getWidth()) / 2.0), this.titleOffsetYFactor * (float)this.getGaugeBounds().height + TITLE_LAYOUT.getAscent() - TITLE_LAYOUT.getDescent());
        }
        if (!this.getUnitString().isEmpty()) {
            if (this.isLabelColorFromThemeEnabled()) {
                G2.setColor(this.getBackgroundColor().LABEL_COLOR);
            } else {
                G2.setColor(this.getLabelColor());
            }
            if (this.isTitleAndUnitFontEnabled()) {
                G2.setFont(new Font(this.getTitleAndUnitFont().getFamily(), 0, (int)(0.04672897196261682 * (double)this.getGaugeBounds().width)));
            } else {
                G2.setFont(new Font("Verdana", 0, (int)(0.04672897196261682 * (double)this.bImage.getWidth())));
            }
            TextLayout UNIT_LAYOUT = new TextLayout(this.getUnitString(), G2.getFont(), RENDER_CONTEXT);
            Rectangle2D UNIT_BOUNDARY = UNIT_LAYOUT.getBounds();
            G2.drawString(this.getUnitString(), (float)(((double)this.getGaugeBounds().width - UNIT_BOUNDARY.getWidth()) / 2.0), this.unitOffsetYFactor * (float)this.getGaugeBounds().width + UNIT_LAYOUT.getAscent() - UNIT_LAYOUT.getDescent());
        }
        if (this.isThresholdVisible()) {
            G2.rotate(this.thresholdRotationOffset, this.ROTATION_CENTER.getX(), this.ROTATION_CENTER.getY());
            G2.drawImage((Image)this.thresholdImage, (int)this.THRESHOLD_OFFSET.getX(), (int)this.THRESHOLD_OFFSET.getY(), null);
            G2.setTransform(OLD_TRANSFORM);
        }
        if (this.isMinMeasuredValueVisible()) {
            switch (this.getOrientation()) {
                case NORTH_EAST: {
                    if (!this.isLogScale()) {
                        G2.rotate(this.measuredRotationOffset + (this.getMaxValue() - this.getMinMeasuredValue() - this.getMinValue()) * this.getAngleStep(), this.ROTATION_CENTER.getX(), this.ROTATION_CENTER.getY());
                        break;
                    }
                    G2.rotate(this.measuredRotationOffset + UTIL.logOfBase(10.0, this.getMaxValue() - this.getMinMeasuredValue() - this.getMinValue()) * this.getLogAngleStep(), this.ROTATION_CENTER.getX(), this.ROTATION_CENTER.getY());
                    break;
                }
                case SOUTH_EAST: {
                    if (!this.isLogScale()) {
                        G2.rotate(this.measuredRotationOffset + (this.getMaxValue() - this.getMinMeasuredValue() - this.getMinValue()) * this.getAngleStep(), this.ROTATION_CENTER.getX(), this.ROTATION_CENTER.getY());
                        break;
                    }
                    G2.rotate(this.measuredRotationOffset + UTIL.logOfBase(10.0, this.getMaxValue() - this.getMinMeasuredValue() - this.getMinValue()) * this.getLogAngleStep(), this.ROTATION_CENTER.getX(), this.ROTATION_CENTER.getY());
                    break;
                }
                case SOUTH_WEST: {
                    if (!this.isLogScale()) {
                        G2.rotate(this.measuredRotationOffset + (this.getMinMeasuredValue() - this.getMinValue()) * this.getAngleStep(), this.ROTATION_CENTER.getX(), this.ROTATION_CENTER.getY());
                        break;
                    }
                    G2.rotate(this.measuredRotationOffset + UTIL.logOfBase(10.0, this.getMinMeasuredValue() - this.getMinValue()) * this.getLogAngleStep(), this.ROTATION_CENTER.getX(), this.ROTATION_CENTER.getY());
                    break;
                }
                case NORTH_WEST: {
                    if (!this.isLogScale()) {
                        G2.rotate(this.measuredRotationOffset + (this.getMinMeasuredValue() - this.getMinValue()) * this.getAngleStep(), this.ROTATION_CENTER.getX(), this.ROTATION_CENTER.getY());
                        break;
                    }
                    G2.rotate(this.measuredRotationOffset + UTIL.logOfBase(10.0, this.getMinMeasuredValue() - this.getMinValue()) * this.getLogAngleStep(), this.ROTATION_CENTER.getX(), this.ROTATION_CENTER.getY());
                }
            }
            G2.drawImage((Image)this.minMeasuredImage, (int)this.MEASURED_OFFSET.getX(), (int)this.MEASURED_OFFSET.getY(), null);
            G2.setTransform(OLD_TRANSFORM);
        }
        if (this.isMaxMeasuredValueVisible()) {
            switch (this.getOrientation()) {
                case NORTH_EAST: {
                    if (!this.isLogScale()) {
                        G2.rotate(this.measuredRotationOffset + (this.getMaxValue() - this.getMaxMeasuredValue() - this.getMinValue()) * this.getAngleStep(), this.ROTATION_CENTER.getX(), this.ROTATION_CENTER.getY());
                        break;
                    }
                    G2.rotate(this.measuredRotationOffset + UTIL.logOfBase(10.0, this.getMaxValue() - this.getMaxMeasuredValue() - this.getMinValue()) * this.getLogAngleStep(), this.ROTATION_CENTER.getX(), this.ROTATION_CENTER.getY());
                    break;
                }
                case SOUTH_EAST: {
                    if (!this.isLogScale()) {
                        G2.rotate(this.measuredRotationOffset + (this.getMaxValue() - this.getMaxMeasuredValue() - this.getMinValue()) * this.getAngleStep(), this.ROTATION_CENTER.getX(), this.ROTATION_CENTER.getY());
                        break;
                    }
                    G2.rotate(this.measuredRotationOffset + UTIL.logOfBase(10.0, this.getMaxValue() - this.getMaxMeasuredValue() - this.getMinValue()) * this.getLogAngleStep(), this.ROTATION_CENTER.getX(), this.ROTATION_CENTER.getY());
                    break;
                }
                case SOUTH_WEST: {
                    if (!this.isLogScale()) {
                        G2.rotate(this.measuredRotationOffset + (this.getMaxMeasuredValue() - this.getMinValue()) * this.getAngleStep(), this.ROTATION_CENTER.getX(), this.ROTATION_CENTER.getY());
                        break;
                    }
                    G2.rotate(this.measuredRotationOffset + UTIL.logOfBase(10.0, this.getMaxMeasuredValue() - this.getMinValue()) * this.getLogAngleStep(), this.ROTATION_CENTER.getX(), this.ROTATION_CENTER.getY());
                    break;
                }
                case NORTH_WEST: {
                    if (!this.isLogScale()) {
                        G2.rotate(this.measuredRotationOffset + (this.getMaxMeasuredValue() - this.getMinValue()) * this.getAngleStep(), this.ROTATION_CENTER.getX(), this.ROTATION_CENTER.getY());
                        break;
                    }
                    G2.rotate(this.measuredRotationOffset + UTIL.logOfBase(10.0, this.getMaxMeasuredValue() - this.getMinValue()) * this.getLogAngleStep(), this.ROTATION_CENTER.getX(), this.ROTATION_CENTER.getY());
                }
            }
            G2.drawImage((Image)this.maxMeasuredImage, (int)this.MEASURED_OFFSET.getX(), (int)this.MEASURED_OFFSET.getY(), null);
            G2.setTransform(OLD_TRANSFORM);
        }
        if (this.isLedVisible()) {
            G2.drawImage((Image)this.getCurrentLedImage(), (int)((double)this.getGaugeBounds().width * this.getLedPosition().getX()), (int)((double)this.getGaugeBounds().width * this.getLedPosition().getY()), null);
        }
        if (this.isUserLedVisible()) {
            G2.drawImage((Image)this.getCurrentUserLedImage(), (int)((double)this.getGaugeBounds().width * this.getUserLedPosition().getX()), (int)((double)this.getGaugeBounds().width * this.getUserLedPosition().getY()), null);
        }
        switch (this.getOrientation()) {
            case SOUTH_EAST: {
                if (!this.isLogScale()) {
                    this.angle = (this.getValue() - this.getMinValue() - this.getMaxValue()) * -this.getAngleStep();
                    break;
                }
                this.angle = UTIL.logOfBase(10.0, this.getValue() - this.getMinValue() - this.getMaxValue()) * -this.getLogAngleStep();
                break;
            }
            case SOUTH_WEST: {
                if (!this.isLogScale()) {
                    this.angle = (this.getValue() - this.getMinValue() - this.getMaxValue()) * this.getAngleStep();
                    break;
                }
                this.angle = UTIL.logOfBase(10.0, this.getValue() - this.getMinValue() - this.getMaxValue()) * this.getLogAngleStep();
                break;
            }
            case NORTH_EAST: {
                if (!this.isLogScale()) {
                    this.angle = (this.getValue() - this.getMinValue()) * -this.getAngleStep();
                    break;
                }
                this.angle = UTIL.logOfBase(10.0, this.getValue() - this.getMinValue()) * -this.getLogAngleStep();
                break;
            }
            default: {
                this.angle = !this.isLogScale() ? (this.getValue() - this.getMinValue()) * this.getAngleStep() : UTIL.logOfBase(10.0, this.getValue() - this.getMinValue()) * this.getLogAngleStep();
            }
        }
        G2.rotate(this.angle, this.ROTATION_CENTER.getX(), this.ROTATION_CENTER.getY() + 2.0);
        G2.drawImage((Image)this.pointerShadowImage, 0, 0, null);
        G2.setTransform(OLD_TRANSFORM);
        G2.rotate(this.angle, this.ROTATION_CENTER.getX(), this.ROTATION_CENTER.getY());
        G2.drawImage((Image)this.pointerImage, 0, 0, null);
        G2.setTransform(OLD_TRANSFORM);
        G2.drawImage((Image)this.fImage, 0, 0, null);
        if (this.isGlowVisible()) {
            if (this.isGlowing()) {
                G2.setComposite(AlphaComposite.getInstance(3, this.getGlowAlpha()));
                G2.drawImage((Image)this.glowImageOn, 0, 0, null);
                G2.setComposite(AlphaComposite.getInstance(3, 1.0f));
            } else {
                G2.drawImage((Image)this.glowImageOff, 0, 0, null);
            }
        }
        if (!this.isEnabled()) {
            G2.drawImage((Image)this.disabledImage, 0, 0, null);
        }
        G2.translate(-this.getInnerBounds().x, -this.getInnerBounds().y);
        G2.dispose();
    }

    @Override
    public GaugeType getGaugeType() {
        return GaugeType.TYPE1;
    }

    @Override
    public Orientation getOrientation() {
        return Orientation.NORTH_WEST;
    }

    @Override
    public void setOrientation(Orientation ORIENTATION) {
        super.setOrientation(ORIENTATION);
        switch (this.getOrientation()) {
            case NORTH_WEST: {
                this.setTickmarkDirection(Direction.CLOCKWISE);
                break;
            }
            case NORTH_EAST: {
                this.setTickmarkDirection(Direction.COUNTER_CLOCKWISE);
                break;
            }
            case SOUTH_EAST: {
                this.setTickmarkDirection(Direction.COUNTER_CLOCKWISE);
                break;
            }
            case SOUTH_WEST: {
                this.setTickmarkDirection(Direction.CLOCKWISE);
            }
        }
        this.init(this.getGaugeBounds().width, this.getGaugeBounds().height);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public Point2D getCenter() {
        return new Point2D.Double((double)this.bImage.getWidth() / 2.0, (double)this.bImage.getHeight() / 2.0);
    }

    @Override
    public Rectangle2D getBounds2D() {
        return new Rectangle2D.Double(this.bImage.getMinX(), this.bImage.getMinY(), this.bImage.getWidth(), this.bImage.getHeight());
    }

    @Override
    public Rectangle getLcdBounds() {
        return new Rectangle();
    }

    private void createAreas(BufferedImage IMAGE) {
        Point2D.Double AREA_OFFSET = new Point2D.Double(0.0, 0.0);
        if (this.bImage != null && !this.getAreas().isEmpty()) {
            double stopAngle = 0.0;
            double startAngle = 0.0;
            double OUTER_RADIUS = (float)this.bImage.getWidth() * 0.3411215f;
            double RADIUS = this.isSectionsVisible() ? (this.isExpandedSectionsEnabled() ? OUTER_RADIUS - (double)((float)this.bImage.getWidth() * 0.12f) : OUTER_RADIUS - (double)((float)this.bImage.getWidth() * 0.023364486f)) : OUTER_RADIUS;
            double FREE_AREA = (double)this.bImage.getWidth() / 2.0 - RADIUS;
            Rectangle2D.Double AREA_FRAME = new Rectangle2D.Double((double)this.bImage.getMinX() + FREE_AREA * 0.9 + ((Point2D)AREA_OFFSET).getX(), (double)this.bImage.getMinY() + FREE_AREA * 0.9 + ((Point2D)AREA_OFFSET).getY(), 4.0 * RADIUS, 4.0 * RADIUS);
            for (Section tmpArea : this.getAreas()) {
                switch (this.getOrientation()) {
                    case NORTH_EAST: {
                        if (!this.isLogScale()) {
                            stopAngle = 90.0 - Math.toDegrees((this.getMaxValue() - tmpArea.getStop() - this.getMinValue()) * this.getAngleStep());
                            startAngle = 90.0 - Math.toDegrees((this.getMaxValue() - tmpArea.getStart() - this.getMinValue()) * this.getAngleStep());
                        } else {
                            stopAngle = 90.0 - Math.toDegrees(UTIL.logOfBase(10.0, this.getMaxValue() - tmpArea.getStop() - this.getMinValue()) * this.getLogAngleStep());
                            startAngle = 90.0 - Math.toDegrees(UTIL.logOfBase(10.0, this.getMaxValue() - tmpArea.getStart() - this.getMinValue()) * this.getLogAngleStep());
                        }
                        ((Point2D)AREA_OFFSET).setLocation((double)(-this.bImage.getWidth()) * 0.45, (double)this.bImage.getWidth() * 0.195);
                        break;
                    }
                    case SOUTH_EAST: {
                        if (!this.isLogScale()) {
                            stopAngle = 0.0 - Math.toDegrees((this.getMaxValue() - tmpArea.getStop() - this.getMinValue()) * this.getAngleStep());
                            startAngle = 0.0 - Math.toDegrees((this.getMaxValue() - tmpArea.getStart() - this.getMinValue()) * this.getAngleStep());
                        } else {
                            stopAngle = 0.0 - Math.toDegrees(UTIL.logOfBase(10.0, this.getMaxValue() - tmpArea.getStop() - this.getMinValue()) * this.getLogAngleStep());
                            startAngle = 0.0 - Math.toDegrees(UTIL.logOfBase(10.0, this.getMaxValue() - tmpArea.getStart() - this.getMinValue()) * this.getLogAngleStep());
                        }
                        ((Point2D)AREA_OFFSET).setLocation((double)(-this.bImage.getWidth()) * 0.45, (double)(-this.bImage.getWidth()) * 0.45);
                        break;
                    }
                    case SOUTH_WEST: {
                        if (!this.isLogScale()) {
                            stopAngle = 270.0 - Math.toDegrees((tmpArea.getStop() - this.getMinValue()) * this.getAngleStep());
                            startAngle = 270.0 - Math.toDegrees((tmpArea.getStart() - this.getMinValue()) * this.getAngleStep());
                        } else {
                            stopAngle = 270.0 - Math.toDegrees(UTIL.logOfBase(10.0, tmpArea.getStop() - this.getMinValue()) * this.getLogAngleStep());
                            startAngle = 270.0 - Math.toDegrees(UTIL.logOfBase(10.0, tmpArea.getStart() - this.getMinValue()) * this.getLogAngleStep());
                        }
                        ((Point2D)AREA_OFFSET).setLocation((double)this.bImage.getWidth() * 0.195, (double)(-this.bImage.getWidth()) * 0.45);
                        break;
                    }
                    default: {
                        if (!this.isLogScale()) {
                            stopAngle = 180.0 - Math.toDegrees((tmpArea.getStop() - this.getMinValue()) * this.getAngleStep());
                            startAngle = 180.0 - Math.toDegrees((tmpArea.getStart() - this.getMinValue()) * this.getAngleStep());
                        } else if (!this.isLogScale()) {
                            stopAngle = 180.0 - Math.toDegrees(UTIL.logOfBase(10.0, tmpArea.getStop() - this.getMinValue()) * this.getLogAngleStep());
                            startAngle = 180.0 - Math.toDegrees(UTIL.logOfBase(10.0, tmpArea.getStart() - this.getMinValue()) * this.getLogAngleStep());
                        }
                        if (this.isSectionsVisible()) {
                            ((Point2D)AREA_OFFSET).setLocation((double)this.bImage.getWidth() * 0.195, (double)this.bImage.getWidth() * 0.195);
                            break;
                        }
                        ((Point2D)AREA_OFFSET).setLocation((double)this.bImage.getWidth() * 0.148271028, (double)this.bImage.getWidth() * 0.148271028);
                    }
                }
                Arc2D.Double ARC = new Arc2D.Double(AREA_FRAME, 0.0 - tmpArea.getStart() * this.getAngleStep(), -(tmpArea.getStop() - tmpArea.getStart()) * this.getAngleStep(), 2);
                ARC.setFrame(((Point2D)AREA_OFFSET).getX(), ((Point2D)AREA_OFFSET).getY(), 4.0 * RADIUS, 4.0 * RADIUS);
                ((Arc2D)ARC).setAngleStart(startAngle);
                ((Arc2D)ARC).setAngleExtent(stopAngle - startAngle);
                tmpArea.setFilledArea(ARC);
            }
            if (this.isAreasVisible() && IMAGE != null) {
                Graphics2D G2 = IMAGE.createGraphics();
                G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                for (Section area : this.getAreas()) {
                    G2.setColor(this.isTransparentAreasEnabled() ? area.getTransparentColor() : area.getColor());
                    G2.fill(area.getFilledArea());
                }
                G2.dispose();
            }
        }
    }

    private void createSections(BufferedImage IMAGE) {
        if (!this.getSections().isEmpty() && this.bImage != null) {
            double OUTER_RADIUS = (float)this.bImage.getWidth() * 0.3411215f;
            double INNER_RADIUS = this.isExpandedSectionsEnabled() ? OUTER_RADIUS - (double)((float)this.bImage.getWidth() * 0.12f) : OUTER_RADIUS - (double)((float)this.bImage.getWidth() * 0.023364486f);
            Ellipse2D.Double INNER = new Ellipse2D.Double(0.0, 0.0, 1.0, 1.0);
            switch (this.getOrientation()) {
                case NORTH_EAST: {
                    ((RectangularShape)INNER).setFrame((double)(-this.bImage.getWidth()) * 0.45, (double)this.bImage.getWidth() * 0.195, 4.0 * INNER_RADIUS, 4.0 * INNER_RADIUS);
                    break;
                }
                case SOUTH_EAST: {
                    ((RectangularShape)INNER).setFrame((double)(-this.bImage.getWidth()) * 0.45, (double)(-this.bImage.getWidth()) * 0.45, 4.0 * INNER_RADIUS, 4.0 * INNER_RADIUS);
                    break;
                }
                case SOUTH_WEST: {
                    ((RectangularShape)INNER).setFrame((double)this.bImage.getWidth() * 0.195, (double)(-this.bImage.getWidth()) * 0.45, 4.0 * INNER_RADIUS, 4.0 * INNER_RADIUS);
                    break;
                }
                default: {
                    double INNER_OFFSET = this.isExpandedSectionsEnabled() ? (double)this.bImage.getWidth() * 0.38 : (double)this.bImage.getWidth() * 0.195;
                    ((RectangularShape)INNER).setFrame(INNER_OFFSET, INNER_OFFSET, 4.0 * INNER_RADIUS, 4.0 * INNER_RADIUS);
                }
            }
            Point2D.Double SECTION_OFFSET = new Point2D.Double(0.0, 0.0);
            for (Section section : this.getSections()) {
                double startAngle;
                double stopAngle;
                switch (this.getOrientation()) {
                    case NORTH_EAST: {
                        if (!this.isLogScale()) {
                            stopAngle = 90.0 - Math.toDegrees((this.getMaxValue() - section.getStop() - this.getMinValue()) * this.getAngleStep());
                            startAngle = 90.0 - Math.toDegrees((this.getMaxValue() - section.getStart() - this.getMinValue()) * this.getAngleStep());
                        } else {
                            stopAngle = 90.0 - Math.toDegrees(UTIL.logOfBase(10.0, this.getMaxValue() - section.getStop() - this.getMinValue()) * this.getLogAngleStep());
                            startAngle = 90.0 - Math.toDegrees(UTIL.logOfBase(10.0, this.getMaxValue() - section.getStart() - this.getMinValue()) * this.getLogAngleStep());
                        }
                        ((Point2D)SECTION_OFFSET).setLocation((double)(-this.bImage.getWidth()) * 0.403271028, (double)this.bImage.getWidth() * 0.148271028);
                        break;
                    }
                    case SOUTH_EAST: {
                        if (!this.isLogScale()) {
                            stopAngle = 0.0 - Math.toDegrees((this.getMaxValue() - section.getStop() - this.getMinValue()) * this.getAngleStep());
                            startAngle = 0.0 - Math.toDegrees((this.getMaxValue() - section.getStart() - this.getMinValue()) * this.getAngleStep());
                        } else {
                            stopAngle = 0.0 - Math.toDegrees(UTIL.logOfBase(10.0, this.getMaxValue() - section.getStop() - this.getMinValue()) * this.getLogAngleStep());
                            startAngle = 0.0 - Math.toDegrees(UTIL.logOfBase(10.0, this.getMaxValue() - section.getStart() - this.getMinValue()) * this.getLogAngleStep());
                        }
                        ((Point2D)SECTION_OFFSET).setLocation((double)(-this.bImage.getWidth()) * 0.403271028, (double)(-this.bImage.getWidth()) * 0.403271028);
                        break;
                    }
                    case SOUTH_WEST: {
                        if (!this.isLogScale()) {
                            stopAngle = 270.0 - Math.toDegrees((section.getStop() - this.getMinValue()) * this.getAngleStep());
                            startAngle = 270.0 - Math.toDegrees((section.getStart() - this.getMinValue()) * this.getAngleStep());
                        } else {
                            stopAngle = 270.0 - Math.toDegrees(UTIL.logOfBase(10.0, section.getStop() - this.getMinValue()) * this.getLogAngleStep());
                            startAngle = 270.0 - Math.toDegrees(UTIL.logOfBase(10.0, section.getStart() - this.getMinValue()) * this.getLogAngleStep());
                        }
                        ((Point2D)SECTION_OFFSET).setLocation((double)this.bImage.getWidth() * 0.148271028, (double)(-this.bImage.getWidth()) * 0.403271028);
                        break;
                    }
                    default: {
                        if (!this.isLogScale()) {
                            stopAngle = 180.0 - Math.toDegrees((section.getStop() - this.getMinValue()) * this.getAngleStep());
                            startAngle = 180.0 - Math.toDegrees((section.getStart() - this.getMinValue()) * this.getAngleStep());
                        } else {
                            stopAngle = 180.0 - Math.toDegrees(UTIL.logOfBase(10.0, section.getStop() - this.getMinValue()) * this.getLogAngleStep());
                            startAngle = 180.0 - Math.toDegrees(UTIL.logOfBase(10.0, section.getStart() - this.getMinValue()) * this.getLogAngleStep());
                        }
                        ((Point2D)SECTION_OFFSET).setLocation((double)this.bImage.getWidth() * 0.148271028, (double)this.bImage.getWidth() * 0.148271028);
                    }
                }
                Arc2D.Double OUTER_ARC = new Arc2D.Double(2);
                OUTER_ARC.setFrame(((Point2D)SECTION_OFFSET).getX(), ((Point2D)SECTION_OFFSET).getY(), 4.0 * OUTER_RADIUS, 4.0 * OUTER_RADIUS);
                ((Arc2D)OUTER_ARC).setAngleStart(startAngle);
                ((Arc2D)OUTER_ARC).setAngleExtent(stopAngle - startAngle);
                Area SECTION = new Area(OUTER_ARC);
                SECTION.subtract(new Area(INNER));
                section.setSectionArea(SECTION);
            }
            if (this.isSectionsVisible() && IMAGE != null) {
                Graphics2D G2 = IMAGE.createGraphics();
                G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                for (Section section : this.getSections()) {
                    G2.setColor(this.isTransparentAreasEnabled() ? section.getTransparentColor() : section.getColor());
                    G2.fill(section.getSectionArea());
                }
                G2.dispose();
            }
        }
    }

    private void transformGraphics(int IMAGE_WIDTH, int IMAGE_HEIGHT, Graphics2D G2) {
        switch (this.getOrientation()) {
            case NORTH_EAST: {
                G2.scale(-1.0, 1.0);
                G2.translate(-IMAGE_WIDTH, 0);
                break;
            }
            case SOUTH_EAST: {
                G2.scale(-1.0, -1.0);
                G2.translate(-IMAGE_WIDTH, -IMAGE_HEIGHT);
                break;
            }
            case SOUTH_WEST: {
                G2.scale(1.0, -1.0);
                G2.translate(0, -IMAGE_HEIGHT);
                break;
            }
            default: {
                G2.scale(1.0, 1.0);
            }
        }
    }

    private BufferedImage create_FRAME_Image(int WIDTH, BufferedImage image) {
        Point2D.Double FRAME_MAIN_STOP;
        Point2D.Double FRAME_MAIN_START;
        if (WIDTH <= 0) {
            return null;
        }
        if (image == null) {
            image = UTIL.createImage(WIDTH, WIDTH, 3);
        }
        Graphics2D G2 = image.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        G2.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        G2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int IMAGE_WIDTH = image.getWidth();
        int IMAGE_HEIGHT = image.getHeight();
        this.transformGraphics(IMAGE_WIDTH, IMAGE_HEIGHT, G2);
        GeneralPath BACKGROUND = new GeneralPath();
        BACKGROUND.setWindingRule(0);
        BACKGROUND.moveTo((double)IMAGE_WIDTH * 0.9158878504672897, (double)IMAGE_HEIGHT * 0.9158878504672897);
        BACKGROUND.curveTo((double)IMAGE_WIDTH * 0.9158878504672897, (double)IMAGE_HEIGHT * 0.9158878504672897, (double)IMAGE_WIDTH * 0.9158878504672897, (double)IMAGE_HEIGHT * 0.08411214953271028, (double)IMAGE_WIDTH * 0.9158878504672897, (double)IMAGE_HEIGHT * 0.08411214953271028);
        BACKGROUND.curveTo((double)IMAGE_WIDTH * 0.6401869158878505, (double)IMAGE_HEIGHT * 0.08411214953271028, (double)IMAGE_WIDTH * 0.46261682242990654, (double)IMAGE_HEIGHT * 0.1588785046728972, (double)IMAGE_WIDTH * 0.29439252336448596, (double)IMAGE_HEIGHT * 0.32242990654205606);
        BACKGROUND.curveTo((double)IMAGE_WIDTH * 0.17289719626168223, (double)IMAGE_HEIGHT * 0.4439252336448598, (double)IMAGE_WIDTH * 0.08411214953271028, (double)IMAGE_HEIGHT * 0.6635514018691588, (double)IMAGE_WIDTH * 0.08411214953271028, (double)IMAGE_HEIGHT * 0.9158878504672897);
        BACKGROUND.curveTo((double)IMAGE_WIDTH * 0.08411214953271028, (double)IMAGE_HEIGHT * 0.9158878504672897, (double)IMAGE_WIDTH * 0.9158878504672897, (double)IMAGE_HEIGHT * 0.9158878504672897, (double)IMAGE_WIDTH * 0.9158878504672897, (double)IMAGE_HEIGHT * 0.9158878504672897);
        BACKGROUND.closePath();
        Area SUBTRACT = new Area(BACKGROUND);
        GeneralPath FRAME_OUTERFRAME = new GeneralPath();
        FRAME_OUTERFRAME.setWindingRule(0);
        FRAME_OUTERFRAME.moveTo((double)IMAGE_WIDTH * 1.0, (double)IMAGE_HEIGHT * 1.0);
        FRAME_OUTERFRAME.curveTo((double)IMAGE_WIDTH * 1.0, (double)IMAGE_HEIGHT * 1.0, (double)IMAGE_WIDTH * 1.0, (double)IMAGE_HEIGHT * 0.0, (double)IMAGE_WIDTH * 1.0, (double)IMAGE_HEIGHT * 0.0);
        FRAME_OUTERFRAME.curveTo((double)IMAGE_WIDTH * 0.3644859813084112, (double)IMAGE_HEIGHT * 0.0, (double)IMAGE_WIDTH * 0.0, (double)IMAGE_HEIGHT * 0.308411214953271, (double)IMAGE_WIDTH * 0.0, (double)IMAGE_HEIGHT * 1.0);
        FRAME_OUTERFRAME.curveTo((double)IMAGE_WIDTH * 0.0, (double)IMAGE_HEIGHT * 1.0, (double)IMAGE_WIDTH * 1.0, (double)IMAGE_HEIGHT * 1.0, (double)IMAGE_WIDTH * 1.0, (double)IMAGE_HEIGHT * 1.0);
        FRAME_OUTERFRAME.closePath();
        G2.setPaint(this.getOuterFrameColor());
        Area FRAME_OUTERFRAME_AREA = new Area(FRAME_OUTERFRAME);
        FRAME_OUTERFRAME_AREA.subtract(SUBTRACT);
        G2.fill(FRAME_OUTERFRAME_AREA);
        GeneralPath FRAME_MAIN = new GeneralPath();
        FRAME_MAIN.setWindingRule(0);
        FRAME_MAIN.moveTo((double)IMAGE_WIDTH * 0.9953271028037384, (double)IMAGE_HEIGHT * 0.9953271028037384);
        FRAME_MAIN.curveTo((double)IMAGE_WIDTH * 0.9953271028037384, (double)IMAGE_HEIGHT * 0.9953271028037384, (double)IMAGE_WIDTH * 0.9953271028037384, (double)IMAGE_HEIGHT * 0.004672897196261682, (double)IMAGE_WIDTH * 0.9953271028037384, (double)IMAGE_HEIGHT * 0.004672897196261682);
        FRAME_MAIN.curveTo((double)IMAGE_WIDTH * 0.3364485981308411, (double)IMAGE_HEIGHT * 0.004672897196261682, (double)IMAGE_WIDTH * 0.004672897196261682, (double)IMAGE_HEIGHT * 0.35514018691588783, (double)IMAGE_WIDTH * 0.004672897196261682, (double)IMAGE_HEIGHT * 0.9953271028037384);
        FRAME_MAIN.curveTo((double)IMAGE_WIDTH * 0.004672897196261682, (double)IMAGE_HEIGHT * 0.9953271028037384, (double)IMAGE_WIDTH * 0.9953271028037384, (double)IMAGE_HEIGHT * 0.9953271028037384, (double)IMAGE_WIDTH * 0.9953271028037384, (double)IMAGE_HEIGHT * 0.9953271028037384);
        FRAME_MAIN.closePath();
        Point2D.Double FRAME_MAIN_CENTER = new Point2D.Double(FRAME_MAIN.getBounds2D().getCenterX(), FRAME_MAIN.getBounds2D().getCenterY());
        switch (this.getOrientation()) {
            case NORTH_WEST: {
                FRAME_MAIN_START = new Point2D.Double(0.0, FRAME_MAIN.getBounds2D().getMinY());
                FRAME_MAIN_STOP = new Point2D.Double(0.0, FRAME_MAIN.getBounds2D().getMaxY());
                break;
            }
            case NORTH_EAST: {
                FRAME_MAIN_START = new Point2D.Double(0.0, FRAME_MAIN.getBounds2D().getMinY());
                FRAME_MAIN_STOP = new Point2D.Double(0.0, FRAME_MAIN.getBounds2D().getMaxY());
                break;
            }
            case SOUTH_EAST: {
                FRAME_MAIN_START = new Point2D.Double(0.0, FRAME_MAIN.getBounds2D().getMaxY());
                FRAME_MAIN_STOP = new Point2D.Double(0.0, FRAME_MAIN.getBounds2D().getMinY());
                break;
            }
            case SOUTH_WEST: {
                FRAME_MAIN_START = new Point2D.Double(0.0, FRAME_MAIN.getBounds2D().getMaxY());
                FRAME_MAIN_STOP = new Point2D.Double(0.0, FRAME_MAIN.getBounds2D().getMinY());
                break;
            }
            default: {
                FRAME_MAIN_START = new Point2D.Double(0.0, FRAME_MAIN.getBounds2D().getMinY());
                FRAME_MAIN_STOP = new Point2D.Double(0.0, FRAME_MAIN.getBounds2D().getMaxY());
            }
        }
        float ANGLE_OFFSET = (float)Math.toDegrees(Math.atan((float)IMAGE_HEIGHT / 8.0f / ((float)IMAGE_WIDTH / 2.0f)));
        Area FRAME_MAIN_AREA = new Area(FRAME_MAIN);
        if (this.getFrameDesign() == FrameDesign.CUSTOM) {
            G2.setPaint(this.getCustomFrameDesign());
            FRAME_MAIN_AREA.subtract(SUBTRACT);
            G2.fill(FRAME_MAIN_AREA);
        } else {
            switch (this.getFrameDesign()) {
                case BLACK_METAL: {
                    float[] frameMainFractions1 = new float[]{0.0f, 90.0f - 2.0f * ANGLE_OFFSET, 90.0f, 90.0f + 3.0f * ANGLE_OFFSET, 180.0f, 270.0f - 3.0f * ANGLE_OFFSET, 270.0f, 270.0f + 2.0f * ANGLE_OFFSET, 1.0f};
                    Color[] frameMainColors1 = new Color[]{new Color(254, 254, 254, 255), new Color(0, 0, 0, 255), new Color(153, 153, 153, 255), new Color(0, 0, 0, 255), new Color(0, 0, 0, 255), new Color(0, 0, 0, 255), new Color(153, 153, 153, 255), new Color(0, 0, 0, 255), new Color(254, 254, 254, 255)};
                    ConicalGradientPaint frameMainGradient1 = new ConicalGradientPaint(true, FRAME_MAIN_CENTER, 0.0f, frameMainFractions1, frameMainColors1);
                    G2.setPaint(frameMainGradient1);
                    FRAME_MAIN_AREA.subtract(SUBTRACT);
                    G2.fill(FRAME_MAIN_AREA);
                    break;
                }
                case METAL: {
                    float[] frameMainFractions2 = new float[]{0.0f, 0.07f, 0.12f, 1.0f};
                    Color[] frameMainColors2 = new Color[]{new Color(254, 254, 254, 255), new Color(210, 210, 210, 255), new Color(179, 179, 179, 255), new Color(213, 213, 213, 255)};
                    LinearGradientPaint frameMainGradient2 = new LinearGradientPaint(FRAME_MAIN_START, FRAME_MAIN_STOP, frameMainFractions2, frameMainColors2);
                    G2.setPaint(frameMainGradient2);
                    FRAME_MAIN_AREA.subtract(SUBTRACT);
                    G2.fill(FRAME_MAIN_AREA);
                    break;
                }
                case SHINY_METAL: {
                    float[] frameMainFractions3 = new float[]{0.0f, 90.0f - 2.0f * ANGLE_OFFSET, 90.0f, 90.0f + 4.0f * ANGLE_OFFSET, 180.0f, 270.0f - 4.0f * ANGLE_OFFSET, 270.0f, 270.0f + 2.0f * ANGLE_OFFSET, 1.0f};
                    Color[] frameMainColors3 = this.isFrameBaseColorEnabled() ? new Color[]{new Color(254, 254, 254, 255), new Color(this.getFrameBaseColor().getRed(), this.getFrameBaseColor().getGreen(), this.getFrameBaseColor().getBlue(), 255), new Color(this.getFrameBaseColor().brighter().brighter().getRed(), this.getFrameBaseColor().brighter().brighter().getGreen(), this.getFrameBaseColor().brighter().brighter().getBlue(), 255), new Color(this.getFrameBaseColor().getRed(), this.getFrameBaseColor().getGreen(), this.getFrameBaseColor().getBlue(), 255), new Color(this.getFrameBaseColor().getRed(), this.getFrameBaseColor().getGreen(), this.getFrameBaseColor().getBlue(), 255), new Color(this.getFrameBaseColor().getRed(), this.getFrameBaseColor().getGreen(), this.getFrameBaseColor().getBlue(), 255), new Color(this.getFrameBaseColor().brighter().brighter().getRed(), this.getFrameBaseColor().brighter().brighter().getGreen(), this.getFrameBaseColor().brighter().brighter().getBlue(), 255), new Color(this.getFrameBaseColor().getRed(), this.getFrameBaseColor().getGreen(), this.getFrameBaseColor().getBlue(), 255), new Color(254, 254, 254, 255)} : new Color[]{new Color(254, 254, 254, 255), new Color(179, 179, 179, 255), new Color(238, 238, 238, 255), new Color(179, 179, 179, 255), new Color(179, 179, 179, 255), new Color(179, 179, 179, 255), new Color(238, 238, 238, 255), new Color(179, 179, 179, 255), new Color(254, 254, 254, 255)};
                    ConicalGradientPaint frameMainGradient3 = new ConicalGradientPaint(true, FRAME_MAIN_CENTER, 0.0f, frameMainFractions3, frameMainColors3);
                    G2.setPaint(frameMainGradient3);
                    FRAME_MAIN_AREA.subtract(SUBTRACT);
                    G2.fill(FRAME_MAIN_AREA);
                    break;
                }
                case GLOSSY_METAL: {
                    GeneralPath FRAME_GLOSSY1 = new GeneralPath();
                    FRAME_GLOSSY1.setWindingRule(0);
                    FRAME_GLOSSY1.moveTo(0.9953271028037384 * (double)IMAGE_WIDTH, 0.9953271028037384 * (double)IMAGE_HEIGHT);
                    FRAME_GLOSSY1.curveTo(0.9953271028037384 * (double)IMAGE_WIDTH, 0.9953271028037384 * (double)IMAGE_HEIGHT, 0.9953271028037384 * (double)IMAGE_WIDTH, 0.004672897196261682 * (double)IMAGE_HEIGHT, 0.9953271028037384 * (double)IMAGE_WIDTH, 0.004672897196261682 * (double)IMAGE_HEIGHT);
                    FRAME_GLOSSY1.curveTo(0.3364485981308411 * (double)IMAGE_WIDTH, 0.004672897196261682 * (double)IMAGE_HEIGHT, 0.004672897196261682 * (double)IMAGE_WIDTH, 0.35514018691588783 * (double)IMAGE_HEIGHT, 0.004672897196261682 * (double)IMAGE_WIDTH, 0.9953271028037384 * (double)IMAGE_HEIGHT);
                    FRAME_GLOSSY1.curveTo(0.004672897196261682 * (double)IMAGE_WIDTH, 0.9953271028037384 * (double)IMAGE_HEIGHT, 0.9953271028037384 * (double)IMAGE_WIDTH, 0.9953271028037384 * (double)IMAGE_HEIGHT, 0.9953271028037384 * (double)IMAGE_WIDTH, 0.9953271028037384 * (double)IMAGE_HEIGHT);
                    FRAME_GLOSSY1.closePath();
                    Area FRAME_GLOSSY_1 = new Area(FRAME_GLOSSY1);
                    FRAME_GLOSSY_1.subtract(SUBTRACT);
                    G2.setPaint(new RadialGradientPaint(new Point2D.Double(0.9906542056074766 * (double)IMAGE_WIDTH, 0.9813084112149533 * (double)IMAGE_HEIGHT), (float)(0.9789719626168224 * (double)IMAGE_WIDTH), new float[]{0.0f, 0.94f, 1.0f}, new Color[]{new Color(0.8235294f, 0.8235294f, 0.8235294f, 1.0f), new Color(0.8235294f, 0.8235294f, 0.8235294f, 1.0f), new Color(1.0f, 1.0f, 1.0f, 1.0f)}));
                    G2.fill(FRAME_GLOSSY_1);
                    GeneralPath FRAME_GLOSSY2 = new GeneralPath();
                    FRAME_GLOSSY2.setWindingRule(0);
                    FRAME_GLOSSY2.moveTo(0.9906542056074766 * (double)IMAGE_WIDTH, 0.9906542056074766 * (double)IMAGE_HEIGHT);
                    FRAME_GLOSSY2.curveTo(0.9906542056074766 * (double)IMAGE_WIDTH, 0.9906542056074766 * (double)IMAGE_HEIGHT, 0.9906542056074766 * (double)IMAGE_WIDTH, 0.009345794392523364 * (double)IMAGE_HEIGHT, 0.9906542056074766 * (double)IMAGE_WIDTH, 0.009345794392523364 * (double)IMAGE_HEIGHT);
                    FRAME_GLOSSY2.curveTo(0.3364485981308411 * (double)IMAGE_WIDTH, 0.009345794392523364 * (double)IMAGE_HEIGHT, 0.009345794392523364 * (double)IMAGE_WIDTH, 0.3598130841121495 * (double)IMAGE_HEIGHT, 0.009345794392523364 * (double)IMAGE_WIDTH, 0.9906542056074766 * (double)IMAGE_HEIGHT);
                    FRAME_GLOSSY2.curveTo(0.009345794392523364 * (double)IMAGE_WIDTH, 0.9906542056074766 * (double)IMAGE_HEIGHT, 0.9906542056074766 * (double)IMAGE_WIDTH, 0.9906542056074766 * (double)IMAGE_HEIGHT, 0.9906542056074766 * (double)IMAGE_WIDTH, 0.9906542056074766 * (double)IMAGE_HEIGHT);
                    FRAME_GLOSSY2.closePath();
                    Area FRAME_GLOSSY_2 = new Area(FRAME_GLOSSY2);
                    FRAME_GLOSSY_1.subtract(SUBTRACT);
                    G2.setPaint(new LinearGradientPaint(new Point2D.Double(0.9953271028037384 * (double)IMAGE_WIDTH, 0.004672897196261682 * (double)IMAGE_HEIGHT), new Point2D.Double(0.9953271028037384 * (double)IMAGE_WIDTH, 0.9906542056074766 * (double)IMAGE_HEIGHT), new float[]{0.0f, 0.18f, 0.32f, 0.66f, 0.89f, 1.0f}, new Color[]{new Color(0.9764706f, 0.9764706f, 0.9764706f, 1.0f), new Color(0.78431374f, 0.7647059f, 0.7490196f, 1.0f), new Color(0.99607843f, 0.99607843f, 0.99215686f, 1.0f), new Color(0.11372549f, 0.11372549f, 0.11372549f, 1.0f), new Color(0.78431374f, 0.7647059f, 0.7490196f, 1.0f), new Color(0.81960785f, 0.81960785f, 0.81960785f, 1.0f)}));
                    G2.fill(FRAME_GLOSSY_2);
                    GeneralPath FRAME_GLOSSY3 = new GeneralPath();
                    FRAME_GLOSSY3.setWindingRule(0);
                    FRAME_GLOSSY3.moveTo(0.9299065420560748 * (double)IMAGE_WIDTH, 0.9299065420560748 * (double)IMAGE_HEIGHT);
                    FRAME_GLOSSY3.curveTo(0.9299065420560748 * (double)IMAGE_WIDTH, 0.9299065420560748 * (double)IMAGE_HEIGHT, 0.9299065420560748 * (double)IMAGE_WIDTH, 0.06542056074766354 * (double)IMAGE_HEIGHT, 0.9299065420560748 * (double)IMAGE_WIDTH, 0.06542056074766354 * (double)IMAGE_HEIGHT);
                    FRAME_GLOSSY3.curveTo(0.40654205607476634 * (double)IMAGE_WIDTH, 0.06542056074766354 * (double)IMAGE_HEIGHT, 0.07009345794392523 * (double)IMAGE_WIDTH, 0.37383177570093457 * (double)IMAGE_HEIGHT, 0.07009345794392523 * (double)IMAGE_WIDTH, 0.9299065420560748 * (double)IMAGE_HEIGHT);
                    FRAME_GLOSSY3.curveTo(0.07009345794392523 * (double)IMAGE_WIDTH, 0.9299065420560748 * (double)IMAGE_HEIGHT, 0.9299065420560748 * (double)IMAGE_WIDTH, 0.9299065420560748 * (double)IMAGE_HEIGHT, 0.9299065420560748 * (double)IMAGE_WIDTH, 0.9299065420560748 * (double)IMAGE_HEIGHT);
                    FRAME_GLOSSY3.closePath();
                    Area FRAME_GLOSSY_3 = new Area(FRAME_GLOSSY3);
                    FRAME_GLOSSY_3.subtract(SUBTRACT);
                    G2.setPaint(new Color(0.9647059f, 0.9647059f, 0.9647059f, 1.0f));
                    G2.fill(FRAME_GLOSSY_3);
                    GeneralPath FRAME_GLOSSY4 = new GeneralPath();
                    FRAME_GLOSSY4.setWindingRule(0);
                    FRAME_GLOSSY4.moveTo(0.9252336448598131 * (double)IMAGE_WIDTH, 0.9252336448598131 * (double)IMAGE_HEIGHT);
                    FRAME_GLOSSY4.curveTo(0.9252336448598131 * (double)IMAGE_WIDTH, 0.9252336448598131 * (double)IMAGE_HEIGHT, 0.9252336448598131 * (double)IMAGE_WIDTH, 0.07009345794392523 * (double)IMAGE_HEIGHT, 0.9252336448598131 * (double)IMAGE_WIDTH, 0.07009345794392523 * (double)IMAGE_HEIGHT);
                    FRAME_GLOSSY4.curveTo(0.3878504672897196 * (double)IMAGE_WIDTH, 0.07009345794392523 * (double)IMAGE_HEIGHT, 0.07476635514018691 * (double)IMAGE_WIDTH, 0.4158878504672897 * (double)IMAGE_HEIGHT, 0.07476635514018691 * (double)IMAGE_WIDTH, 0.9252336448598131 * (double)IMAGE_HEIGHT);
                    FRAME_GLOSSY4.curveTo(0.07476635514018691 * (double)IMAGE_WIDTH, 0.9252336448598131 * (double)IMAGE_HEIGHT, 0.9252336448598131 * (double)IMAGE_WIDTH, 0.9252336448598131 * (double)IMAGE_HEIGHT, 0.9252336448598131 * (double)IMAGE_WIDTH, 0.9252336448598131 * (double)IMAGE_HEIGHT);
                    FRAME_GLOSSY4.closePath();
                    Area FRAME_GLOSSY_4 = new Area(FRAME_GLOSSY4);
                    FRAME_GLOSSY_4.subtract(SUBTRACT);
                    G2.setPaint(new Color(0.2f, 0.2f, 0.2f, 1.0f));
                    G2.fill(FRAME_GLOSSY_4);
                    break;
                }
                case BRASS: {
                    float[] frameMainFractions5 = new float[]{0.0f, 0.05f, 0.1f, 0.5f, 0.9f, 0.95f, 1.0f};
                    Color[] frameMainColors5 = new Color[]{new Color(249, 243, 155, 255), new Color(246, 226, 101, 255), new Color(240, 225, 132, 255), new Color(90, 57, 22, 255), new Color(249, 237, 139, 255), new Color(243, 226, 108, 255), new Color(202, 182, 113, 255)};
                    LinearGradientPaint frameMainGradient5 = new LinearGradientPaint(FRAME_MAIN_START, FRAME_MAIN_STOP, frameMainFractions5, frameMainColors5);
                    G2.setPaint(frameMainGradient5);
                    FRAME_MAIN_AREA.subtract(SUBTRACT);
                    G2.fill(FRAME_MAIN_AREA);
                    break;
                }
                case STEEL: {
                    float[] frameMainFractions6 = new float[]{0.0f, 0.05f, 0.1f, 0.5f, 0.9f, 0.95f, 1.0f};
                    Color[] frameMainColors6 = new Color[]{new Color(231, 237, 237, 255), new Color(189, 199, 198, 255), new Color(192, 201, 200, 255), new Color(23, 31, 33, 255), new Color(196, 205, 204, 255), new Color(194, 204, 203, 255), new Color(189, 201, 199, 255)};
                    LinearGradientPaint frameMainGradient6 = new LinearGradientPaint(FRAME_MAIN_START, FRAME_MAIN_STOP, frameMainFractions6, frameMainColors6);
                    G2.setPaint(frameMainGradient6);
                    FRAME_MAIN_AREA.subtract(SUBTRACT);
                    G2.fill(FRAME_MAIN_AREA);
                    break;
                }
                case CHROME: {
                    float[] frameMainFractions7 = new float[]{0.0f, 0.09f, 0.12f, 0.16f, 0.25f, 0.29f, 0.33f, 0.38f, 0.48f, 0.52f, 0.63f, 0.68f, 0.8f, 0.83f, 0.87f, 0.97f, 1.0f};
                    Color[] frameMainColors7 = new Color[]{new Color(255, 255, 255, 255), new Color(255, 255, 255, 255), new Color(136, 136, 138, 255), new Color(164, 185, 190, 255), new Color(158, 179, 182, 255), new Color(112, 112, 112, 255), new Color(221, 227, 227, 255), new Color(155, 176, 179, 255), new Color(156, 176, 177, 255), new Color(254, 255, 255, 255), new Color(255, 255, 255, 255), new Color(156, 180, 180, 255), new Color(198, 209, 211, 255), new Color(246, 248, 247, 255), new Color(204, 216, 216, 255), new Color(164, 188, 190, 255), new Color(255, 255, 255, 255)};
                    ConicalGradientPaint frameMainGradient7 = new ConicalGradientPaint(false, FRAME_MAIN_CENTER, 0.0f, frameMainFractions7, frameMainColors7);
                    G2.setPaint(frameMainGradient7);
                    FRAME_MAIN_AREA.subtract(SUBTRACT);
                    G2.fill(FRAME_MAIN_AREA);
                    break;
                }
                case GOLD: {
                    float[] frameMainFractions8 = new float[]{0.0f, 0.15f, 0.22f, 0.3f, 0.38f, 0.44f, 0.51f, 0.6f, 0.68f, 0.75f, 1.0f};
                    Color[] frameMainColors8 = new Color[]{new Color(255, 255, 207, 255), new Color(255, 237, 96, 255), new Color(254, 199, 57, 255), new Color(255, 249, 203, 255), new Color(255, 199, 64, 255), new Color(252, 194, 60, 255), new Color(255, 204, 59, 255), new Color(213, 134, 29, 255), new Color(255, 201, 56, 255), new Color(212, 135, 29, 255), new Color(247, 238, 101, 255)};
                    LinearGradientPaint frameMainGradient8 = new LinearGradientPaint(FRAME_MAIN_START, FRAME_MAIN_STOP, frameMainFractions8, frameMainColors8);
                    G2.setPaint(frameMainGradient8);
                    FRAME_MAIN_AREA.subtract(SUBTRACT);
                    G2.fill(FRAME_MAIN_AREA);
                    break;
                }
                case ANTHRACITE: {
                    float[] frameMainFractions9 = new float[]{0.0f, 0.06f, 0.12f, 1.0f};
                    Color[] frameMainColors9 = new Color[]{new Color(118, 117, 135, 255), new Color(74, 74, 82, 255), new Color(50, 50, 54, 255), new Color(97, 97, 108, 255)};
                    LinearGradientPaint frameMainGradient9 = new LinearGradientPaint(FRAME_MAIN_START, FRAME_MAIN_STOP, frameMainFractions9, frameMainColors9);
                    G2.setPaint(frameMainGradient9);
                    FRAME_MAIN_AREA.subtract(SUBTRACT);
                    G2.fill(FRAME_MAIN_AREA);
                    break;
                }
                case TILTED_GRAY: {
                    ((Point2D)FRAME_MAIN_START).setLocation(0.2336448598130841 * (double)IMAGE_WIDTH, 0.08411214953271028 * (double)IMAGE_HEIGHT);
                    ((Point2D)FRAME_MAIN_STOP).setLocation(0.8125818236066633 * (double)IMAGE_WIDTH, 0.9109198204038422 * (double)IMAGE_HEIGHT);
                    float[] frameMainFractions10 = new float[]{0.0f, 0.07f, 0.16f, 0.33f, 0.55f, 0.79f, 1.0f};
                    Color[] frameMainColors10 = new Color[]{new Color(255, 255, 255, 255), new Color(210, 210, 210, 255), new Color(179, 179, 179, 255), new Color(255, 255, 255, 255), new Color(197, 197, 197, 255), new Color(255, 255, 255, 255), new Color(102, 102, 102, 255)};
                    LinearGradientPaint frameMainGradient10 = new LinearGradientPaint(FRAME_MAIN_START, FRAME_MAIN_STOP, frameMainFractions10, frameMainColors10);
                    G2.setPaint(frameMainGradient10);
                    FRAME_MAIN_AREA.subtract(SUBTRACT);
                    G2.fill(FRAME_MAIN_AREA);
                    break;
                }
                case TILTED_BLACK: {
                    ((Point2D)FRAME_MAIN_START).setLocation(0.22897196261682243 * (double)IMAGE_WIDTH, 0.0794392523364486 * (double)IMAGE_HEIGHT);
                    ((Point2D)FRAME_MAIN_STOP).setLocation(0.8025483989678684 * (double)IMAGE_WIDTH, 0.8985912966254403 * (double)IMAGE_HEIGHT);
                    float[] frameMainFractions11 = new float[]{0.0f, 0.21f, 0.47f, 0.99f, 1.0f};
                    Color[] frameMainColors11 = new Color[]{new Color(102, 102, 102, 255), new Color(0, 0, 0, 255), new Color(102, 102, 102, 255), new Color(0, 0, 0, 255), new Color(0, 0, 0, 255)};
                    LinearGradientPaint frameMainGradient11 = new LinearGradientPaint(FRAME_MAIN_START, FRAME_MAIN_STOP, frameMainFractions11, frameMainColors11);
                    G2.setPaint(frameMainGradient11);
                    FRAME_MAIN_AREA.subtract(SUBTRACT);
                    G2.fill(FRAME_MAIN_AREA);
                    break;
                }
                default: {
                    float[] frameMainFractions = new float[]{0.0f, 0.07f, 0.12f, 1.0f};
                    Color[] frameMainColors = new Color[]{new Color(254, 254, 254, 255), new Color(210, 210, 210, 255), new Color(179, 179, 179, 255), new Color(213, 213, 213, 255)};
                    LinearGradientPaint frameMainGradient = new LinearGradientPaint(FRAME_MAIN_START, FRAME_MAIN_STOP, frameMainFractions, frameMainColors);
                    G2.setPaint(frameMainGradient);
                    FRAME_MAIN_AREA.subtract(SUBTRACT);
                    G2.fill(FRAME_MAIN_AREA);
                }
            }
        }
        float scale = 1.0f;
        Shape[] EFFECT = new Shape[100];
        switch (this.getFrameEffect()) {
            case EFFECT_BULGE: {
                int i;
                float[] EFFECT_FRACTIONS = new float[]{0.0f, 0.13f, 0.14f, 0.17f, 0.18f, 1.0f};
                Color[] EFFECT_COLORS = new Color[]{new Color(0, 0, 0, 102), new Color(255, 255, 255, 151), new Color(219, 219, 219, 153), new Color(0, 0, 0, 95), new Color(0, 0, 0, 76), new Color(0, 0, 0, 0)};
                GradientWrapper EFFECT_GRADIENT = new GradientWrapper(new Point2D.Double(100.0, 0.0), new Point2D.Double(0.0, 0.0), EFFECT_FRACTIONS, EFFECT_COLORS);
                for (i = 0; i < 100; ++i) {
                    EFFECT[i] = Scaler.INSTANCE.scale(FRAME_MAIN_AREA, scale);
                    scale -= 0.01f;
                }
                G2.setStroke(new BasicStroke(1.5f));
                for (i = 0; i < EFFECT.length; ++i) {
                    G2.setPaint(EFFECT_GRADIENT.getColorAt((float)i / 100.0f));
                    G2.draw(EFFECT[i]);
                }
                break;
            }
            case EFFECT_CONE: {
                int i;
                float[] EFFECT_FRACTIONS = new float[]{0.0f, 0.0399f, 0.04f, 0.1799f, 0.18f, 1.0f};
                Color[] EFFECT_COLORS = new Color[]{new Color(0, 0, 0, 76), new Color(223, 223, 223, 127), new Color(255, 255, 255, 124), new Color(9, 9, 9, 51), new Color(0, 0, 0, 50), new Color(0, 0, 0, 0)};
                GradientWrapper EFFECT_GRADIENT = new GradientWrapper(new Point2D.Double(100.0, 0.0), new Point2D.Double(0.0, 0.0), EFFECT_FRACTIONS, EFFECT_COLORS);
                for (i = 0; i < 100; ++i) {
                    EFFECT[i] = Scaler.INSTANCE.scale(FRAME_MAIN_AREA, scale);
                    scale -= 0.01f;
                }
                G2.setStroke(new BasicStroke(1.5f));
                for (i = 0; i < EFFECT.length; ++i) {
                    G2.setPaint(EFFECT_GRADIENT.getColorAt((float)i / 100.0f));
                    G2.draw(EFFECT[i]);
                }
                break;
            }
            case EFFECT_TORUS: {
                int i;
                float[] EFFECT_FRACTIONS = new float[]{0.0f, 0.08f, 0.1799f, 0.18f, 1.0f};
                Color[] EFFECT_COLORS = new Color[]{new Color(0, 0, 0, 76), new Color(255, 255, 255, 64), new Color(13, 13, 13, 51), new Color(0, 0, 0, 50), new Color(0, 0, 0, 0)};
                GradientWrapper EFFECT_GRADIENT = new GradientWrapper(new Point2D.Double(100.0, 0.0), new Point2D.Double(0.0, 0.0), EFFECT_FRACTIONS, EFFECT_COLORS);
                for (i = 0; i < 100; ++i) {
                    EFFECT[i] = Scaler.INSTANCE.scale(FRAME_MAIN_AREA, scale);
                    scale -= 0.01f;
                }
                G2.setStroke(new BasicStroke(1.5f));
                for (i = 0; i < EFFECT.length; ++i) {
                    G2.setPaint(EFFECT_GRADIENT.getColorAt((float)i / 100.0f));
                    G2.draw(EFFECT[i]);
                }
                break;
            }
            case EFFECT_INNER_FRAME: {
                Shape EFFECT_BIGINNERFRAME = Scaler.INSTANCE.scale(FRAME_MAIN_AREA, 0.8785046339035034);
                Point2D.Double EFFECT_BIGINNERFRAME_START = new Point2D.Double(0.0, EFFECT_BIGINNERFRAME.getBounds2D().getMinY());
                Point2D.Double EFFECT_BIGINNERFRAME_STOP = new Point2D.Double(0.0, EFFECT_BIGINNERFRAME.getBounds2D().getMaxY());
                float[] EFFECT_FRACTIONS = new float[]{0.0f, 0.3f, 0.5f, 0.71f, 1.0f};
                Color[] EFFECT_COLORS = new Color[]{new Color(0, 0, 0, 183), new Color(148, 148, 148, 25), new Color(0, 0, 0, 159), new Color(0, 0, 0, 81), new Color(255, 255, 255, 158)};
                LinearGradientPaint EFFECT_BIGINNERFRAME_GRADIENT = new LinearGradientPaint(EFFECT_BIGINNERFRAME_START, EFFECT_BIGINNERFRAME_STOP, EFFECT_FRACTIONS, EFFECT_COLORS);
                G2.setPaint(EFFECT_BIGINNERFRAME_GRADIENT);
                G2.fill(EFFECT_BIGINNERFRAME);
            }
        }
        GeneralPath GAUGE_BACKGROUND_MAIN = new GeneralPath();
        GAUGE_BACKGROUND_MAIN.setWindingRule(0);
        GAUGE_BACKGROUND_MAIN.moveTo((double)IMAGE_WIDTH * 0.9205607476635514, (double)IMAGE_HEIGHT * 0.9205607476635514);
        GAUGE_BACKGROUND_MAIN.curveTo((double)IMAGE_WIDTH * 0.9205607476635514, (double)IMAGE_HEIGHT * 0.9205607476635514, (double)IMAGE_WIDTH * 0.9205607476635514, (double)IMAGE_HEIGHT * 0.0794392523364486, (double)IMAGE_WIDTH * 0.9205607476635514, (double)IMAGE_HEIGHT * 0.0794392523364486);
        GAUGE_BACKGROUND_MAIN.curveTo((double)IMAGE_WIDTH * 0.6822429906542056, (double)IMAGE_HEIGHT * 0.0794392523364486, (double)IMAGE_WIDTH * 0.48130841121495327, (double)IMAGE_HEIGHT * 0.13551401869158877, (double)IMAGE_WIDTH * 0.3037383177570093, (double)IMAGE_HEIGHT * 0.308411214953271);
        GAUGE_BACKGROUND_MAIN.curveTo((double)IMAGE_WIDTH * 0.16355140186915887, (double)IMAGE_HEIGHT * 0.4439252336448598, (double)IMAGE_WIDTH * 0.0794392523364486, (double)IMAGE_HEIGHT * 0.6822429906542056, (double)IMAGE_WIDTH * 0.0794392523364486, (double)IMAGE_HEIGHT * 0.9205607476635514);
        GAUGE_BACKGROUND_MAIN.curveTo((double)IMAGE_WIDTH * 0.0794392523364486, (double)IMAGE_HEIGHT * 0.9205607476635514, (double)IMAGE_WIDTH * 0.9205607476635514, (double)IMAGE_HEIGHT * 0.9205607476635514, (double)IMAGE_WIDTH * 0.9205607476635514, (double)IMAGE_HEIGHT * 0.9205607476635514);
        GAUGE_BACKGROUND_MAIN.closePath();
        G2.setColor(Color.WHITE);
        Area GAUGE_BACKGROUND_MAIN_AREA = new Area(GAUGE_BACKGROUND_MAIN);
        GAUGE_BACKGROUND_MAIN_AREA.subtract(SUBTRACT);
        G2.fill(GAUGE_BACKGROUND_MAIN_AREA);
        G2.dispose();
        return image;
    }

    private BufferedImage create_BACKGROUND_Image(int WIDTH, BufferedImage image) {
        Point2D.Double GAUGE_BACKGROUND_STOP;
        Point2D.Double GAUGE_BACKGROUND_START;
        if (WIDTH <= 0) {
            return null;
        }
        if (image == null) {
            image = UTIL.createImage(WIDTH, WIDTH, 3);
        }
        Graphics2D G2 = image.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        G2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int IMAGE_WIDTH = image.getWidth();
        int IMAGE_HEIGHT = image.getHeight();
        boolean fadeInOut = false;
        AffineTransform OLD_TRANSFORM = G2.getTransform();
        this.transformGraphics(IMAGE_WIDTH, IMAGE_HEIGHT, G2);
        AffineTransform NEW_TRANSFORM = G2.getTransform();
        GeneralPath GAUGE_BACKGROUND = new GeneralPath();
        GAUGE_BACKGROUND.setWindingRule(0);
        GAUGE_BACKGROUND.moveTo((double)IMAGE_WIDTH * 0.9158878504672897, (double)IMAGE_HEIGHT * 0.9158878504672897);
        GAUGE_BACKGROUND.curveTo((double)IMAGE_WIDTH * 0.9158878504672897, (double)IMAGE_HEIGHT * 0.9158878504672897, (double)IMAGE_WIDTH * 0.9158878504672897, (double)IMAGE_HEIGHT * 0.08411214953271028, (double)IMAGE_WIDTH * 0.9158878504672897, (double)IMAGE_HEIGHT * 0.08411214953271028);
        GAUGE_BACKGROUND.curveTo((double)IMAGE_WIDTH * 0.6401869158878505, (double)IMAGE_HEIGHT * 0.08411214953271028, (double)IMAGE_WIDTH * 0.46261682242990654, (double)IMAGE_HEIGHT * 0.1588785046728972, (double)IMAGE_WIDTH * 0.29439252336448596, (double)IMAGE_HEIGHT * 0.32242990654205606);
        GAUGE_BACKGROUND.curveTo((double)IMAGE_WIDTH * 0.17289719626168223, (double)IMAGE_HEIGHT * 0.4439252336448598, (double)IMAGE_WIDTH * 0.08411214953271028, (double)IMAGE_HEIGHT * 0.6635514018691588, (double)IMAGE_WIDTH * 0.08411214953271028, (double)IMAGE_HEIGHT * 0.9158878504672897);
        GAUGE_BACKGROUND.curveTo((double)IMAGE_WIDTH * 0.08411214953271028, (double)IMAGE_HEIGHT * 0.9158878504672897, (double)IMAGE_WIDTH * 0.9158878504672897, (double)IMAGE_HEIGHT * 0.9158878504672897, (double)IMAGE_WIDTH * 0.9158878504672897, (double)IMAGE_HEIGHT * 0.9158878504672897);
        GAUGE_BACKGROUND.closePath();
        switch (this.getOrientation()) {
            case NORTH_WEST: {
                GAUGE_BACKGROUND_START = new Point2D.Double(0.0, GAUGE_BACKGROUND.getBounds2D().getMinY());
                GAUGE_BACKGROUND_STOP = new Point2D.Double(0.0, GAUGE_BACKGROUND.getBounds2D().getMaxY());
                break;
            }
            case NORTH_EAST: {
                GAUGE_BACKGROUND_START = new Point2D.Double(0.0, GAUGE_BACKGROUND.getBounds2D().getMinY());
                GAUGE_BACKGROUND_STOP = new Point2D.Double(0.0, GAUGE_BACKGROUND.getBounds2D().getMaxY());
                break;
            }
            case SOUTH_EAST: {
                GAUGE_BACKGROUND_START = new Point2D.Double(0.0, GAUGE_BACKGROUND.getBounds2D().getMaxY());
                GAUGE_BACKGROUND_STOP = new Point2D.Double(0.0, GAUGE_BACKGROUND.getBounds2D().getMinY());
                break;
            }
            case SOUTH_WEST: {
                GAUGE_BACKGROUND_START = new Point2D.Double(0.0, GAUGE_BACKGROUND.getBounds2D().getMaxY());
                GAUGE_BACKGROUND_STOP = new Point2D.Double(0.0, GAUGE_BACKGROUND.getBounds2D().getMinY());
                break;
            }
            default: {
                GAUGE_BACKGROUND_START = new Point2D.Double(0.0, GAUGE_BACKGROUND.getBounds2D().getMinY());
                GAUGE_BACKGROUND_STOP = new Point2D.Double(0.0, GAUGE_BACKGROUND.getBounds2D().getMaxY());
            }
        }
        float[] GAUGE_BACKGROUND_FRACTIONS = new float[]{0.0f, 0.39f, 1.0f};
        Paint backgroundPaint = null;
        if (this.getCustomBackground() != null && this.getBackgroundColor() == BackgroundColor.CUSTOM) {
            G2.setPaint(this.getCustomBackground());
        } else {
            Color[] GAUGE_BACKGROUND_COLORS = new Color[]{this.getBackgroundColor().GRADIENT_START_COLOR, this.getBackgroundColor().GRADIENT_FRACTION_COLOR, this.getBackgroundColor().GRADIENT_STOP_COLOR};
            if (this.getBackgroundColor() == BackgroundColor.BRUSHED_METAL) {
                backgroundPaint = new TexturePaint(UTIL.createBrushMetalTexture(this.getModel().getTextureColor(), GAUGE_BACKGROUND.getBounds().width, GAUGE_BACKGROUND.getBounds().height), GAUGE_BACKGROUND.getBounds());
            } else if (this.getBackgroundColor() == BackgroundColor.STAINLESS) {
                float[] STAINLESS_FRACTIONS = new float[]{0.0f, 0.03f, 0.1f, 0.14f, 0.24f, 0.33f, 0.38f, 0.5f, 0.62f, 0.67f, 0.76f, 0.81f, 0.85f, 0.97f, 1.0f};
                Color[] STAINLESS_COLORS = new Color[]{new Color(0xFDFDFD), new Color(0xFDFDFD), new Color(0xB2B2B4), new Color(0xACACAE), new Color(0xFDFDFD), new Color(7237232), new Color(7237232), new Color(0xFDFDFD), new Color(7237232), new Color(7237232), new Color(0xFDFDFD), new Color(0xACACAE), new Color(0xB2B2B4), new Color(0xFDFDFD), new Color(0xFDFDFD)};
                backgroundPaint = new ConicalGradientPaint(false, this.ROTATION_CENTER, -0.45f, STAINLESS_FRACTIONS, STAINLESS_COLORS);
            } else if (this.getBackgroundColor() == BackgroundColor.STAINLESS_GRINDED) {
                backgroundPaint = new TexturePaint(Radial1Square.BACKGROUND_FACTORY.STAINLESS_GRINDED_TEXTURE, new Rectangle(0, 0, 100, 100));
            } else if (this.getBackgroundColor() == BackgroundColor.CARBON) {
                backgroundPaint = new TexturePaint(Radial1Square.BACKGROUND_FACTORY.CARBON_FIBRE_TEXTURE, new Rectangle(0, 0, 12, 12));
                fadeInOut = true;
            } else if (this.getBackgroundColor() == BackgroundColor.PUNCHED_SHEET) {
                backgroundPaint = new TexturePaint(BACKGROUND_FACTORY.getPunchedSheetTexture(), new Rectangle(0, 0, 12, 12));
                fadeInOut = true;
            } else if (this.getBackgroundColor() == BackgroundColor.LINEN) {
                backgroundPaint = new TexturePaint(UTIL.createLinenTexture(this.getModel().getTextureColor(), GAUGE_BACKGROUND.getBounds().width, GAUGE_BACKGROUND.getBounds().height), GAUGE_BACKGROUND.getBounds());
            } else if (this.getBackgroundColor() == BackgroundColor.NOISY_PLASTIC) {
                ((Point2D)GAUGE_BACKGROUND_START).setLocation(0.0, GAUGE_BACKGROUND.getBounds2D().getMinY());
                ((Point2D)GAUGE_BACKGROUND_STOP).setLocation(0.0, GAUGE_BACKGROUND.getBounds2D().getMaxY());
                if (GAUGE_BACKGROUND_START.equals(GAUGE_BACKGROUND_STOP)) {
                    ((Point2D)GAUGE_BACKGROUND_STOP).setLocation(0.0, ((Point2D)GAUGE_BACKGROUND_START).getY() + 1.0);
                }
                float[] FRACTIONS = new float[]{0.0f, 1.0f};
                Color[] COLORS = new Color[]{UTIL.lighter(this.getTextureColor(), 0.15f), UTIL.darker(this.getTextureColor(), 0.15f)};
                backgroundPaint = new LinearGradientPaint(GAUGE_BACKGROUND_START, GAUGE_BACKGROUND_STOP, FRACTIONS, COLORS);
            } else {
                backgroundPaint = new LinearGradientPaint(GAUGE_BACKGROUND_START, GAUGE_BACKGROUND_STOP, GAUGE_BACKGROUND_FRACTIONS, GAUGE_BACKGROUND_COLORS);
            }
            G2.setPaint(backgroundPaint);
        }
        G2.fill(GAUGE_BACKGROUND);
        BufferedImage CLP = this.getCustomBackground() != null && this.getBackgroundColor() == BackgroundColor.CUSTOM ? Shadow.INSTANCE.createInnerShadow(GAUGE_BACKGROUND, this.getCustomBackground(), 0, 0.65f, Color.BLACK, 20, 315) : Shadow.INSTANCE.createInnerShadow(GAUGE_BACKGROUND, backgroundPaint, 0, 0.65f, Color.BLACK, 20, 315);
        G2.drawImage((Image)CLP, GAUGE_BACKGROUND.getBounds().x, GAUGE_BACKGROUND.getBounds().y, null);
        if (this.getBackgroundColor() == BackgroundColor.NOISY_PLASTIC) {
            Random BW_RND = new Random();
            Random ALPHA_RND = new Random();
            Shape OLD_CLIP = G2.getClip();
            G2.setClip(GAUGE_BACKGROUND);
            int y = 0;
            while ((double)y < GAUGE_BACKGROUND.getBounds().getHeight()) {
                int x = 0;
                while ((double)x < GAUGE_BACKGROUND.getBounds().getWidth()) {
                    Color noiseColor = BW_RND.nextBoolean() ? this.BRIGHT_NOISE : this.DARK_NOISE;
                    int noiseAlpha = 10 + ALPHA_RND.nextInt(10) - 5;
                    G2.setColor(new Color(noiseColor.getRed(), noiseColor.getGreen(), noiseColor.getBlue(), noiseAlpha));
                    G2.drawLine((int)((double)x + GAUGE_BACKGROUND.getBounds2D().getMinX()), (int)((double)y + GAUGE_BACKGROUND.getBounds2D().getMinY()), (int)((double)x + GAUGE_BACKGROUND.getBounds2D().getMinX()), (int)((double)y + GAUGE_BACKGROUND.getBounds2D().getMinY()));
                    ++x;
                }
                ++y;
            }
            G2.setClip(OLD_CLIP);
        }
        if (fadeInOut) {
            float[] SHADOW_OVERLAY_FRACTIONS = new float[]{0.0f, 0.4f, 0.6f, 1.0f};
            Color[] SHADOW_OVERLAY_COLORS = new Color[]{new Color(0.0f, 0.0f, 0.0f, 0.6f), new Color(0.0f, 0.0f, 0.0f, 0.0f), new Color(0.0f, 0.0f, 0.0f, 0.0f), new Color(0.0f, 0.0f, 0.0f, 0.6f)};
            LinearGradientPaint SHADOW_OVERLAY_GRADIENT = new LinearGradientPaint(new Point2D.Double(GAUGE_BACKGROUND.getBounds().getMinX(), 0.0), new Point2D.Double(GAUGE_BACKGROUND.getBounds().getMaxX(), 0.0), SHADOW_OVERLAY_FRACTIONS, SHADOW_OVERLAY_COLORS);
            G2.setPaint(SHADOW_OVERLAY_GRADIENT);
            G2.fill(GAUGE_BACKGROUND);
        }
        if (this.isCustomLayerVisible()) {
            G2.setTransform(OLD_TRANSFORM);
            G2.drawImage((Image)UTIL.getScaledInstance(this.getCustomLayer(), IMAGE_WIDTH, IMAGE_HEIGHT, RenderingHints.VALUE_INTERPOLATION_BICUBIC), 0, 0, null);
            G2.setTransform(NEW_TRANSFORM);
        }
        G2.dispose();
        return image;
    }

    @Override
    protected BufferedImage create_POINTER_Image(int WIDTH, PointerType POINTER_TYPE) {
        if (WIDTH <= 0) {
            return null;
        }
        BufferedImage IMAGE = UTIL.createImage(WIDTH, WIDTH, 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        int IMAGE_WIDTH = IMAGE.getWidth();
        int IMAGE_HEIGHT = IMAGE.getHeight();
        this.transformGraphics(IMAGE_WIDTH, IMAGE_HEIGHT, G2);
        switch (POINTER_TYPE) {
            case TYPE2: {
                GeneralPath POINTER = new GeneralPath();
                POINTER.setWindingRule(0);
                POINTER.moveTo((double)IMAGE_WIDTH * 0.7990654205607477, (double)IMAGE_HEIGHT * 0.8130841121495327);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.7897196261682243, (double)IMAGE_HEIGHT * 0.822429906542056);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.6635514018691588, (double)IMAGE_HEIGHT * 0.822429906542056);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.16355140186915887, (double)IMAGE_HEIGHT * 0.8271028037383178);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.16355140186915887, (double)IMAGE_HEIGHT * 0.8317757009345794);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.6682242990654206, (double)IMAGE_HEIGHT * 0.8364485981308412);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.7897196261682243, (double)IMAGE_HEIGHT * 0.8364485981308412);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.7990654205607477, (double)IMAGE_HEIGHT * 0.8457943925233645);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.7990654205607477, (double)IMAGE_HEIGHT * 0.8457943925233645, (double)IMAGE_WIDTH * 0.8177570093457944, (double)IMAGE_HEIGHT * 0.8598130841121495, (double)IMAGE_WIDTH * 0.8271028037383178, (double)IMAGE_HEIGHT * 0.8598130841121495);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.8457943925233645, (double)IMAGE_HEIGHT * 0.8598130841121495, (double)IMAGE_WIDTH * 0.8598130841121495, (double)IMAGE_HEIGHT * 0.8457943925233645, (double)IMAGE_WIDTH * 0.8598130841121495, (double)IMAGE_HEIGHT * 0.8271028037383178);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.8598130841121495, (double)IMAGE_HEIGHT * 0.8084112149532711, (double)IMAGE_WIDTH * 0.8457943925233645, (double)IMAGE_HEIGHT * 0.794392523364486, (double)IMAGE_WIDTH * 0.8271028037383178, (double)IMAGE_HEIGHT * 0.794392523364486);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.8177570093457944, (double)IMAGE_HEIGHT * 0.794392523364486, (double)IMAGE_WIDTH * 0.7990654205607477, (double)IMAGE_HEIGHT * 0.8130841121495327, (double)IMAGE_WIDTH * 0.7990654205607477, (double)IMAGE_HEIGHT * 0.8130841121495327);
                POINTER.closePath();
                Point2D.Double POINTER_START = new Point2D.Double(POINTER.getBounds2D().getMaxX(), 0.0);
                Point2D.Double POINTER_STOP = new Point2D.Double(POINTER.getBounds2D().getMinX(), 0.0);
                float[] POINTER_FRACTIONS = new float[]{0.0f, 0.36f, 0.3601f, 1.0f};
                Color[] POINTER_COLORS = this.getPointerColor() != ColorDef.CUSTOM ? new Color[]{this.getBackgroundColor().LABEL_COLOR, this.getBackgroundColor().LABEL_COLOR, this.getPointerColor().LIGHT, this.getPointerColor().LIGHT} : new Color[]{this.getBackgroundColor().LABEL_COLOR, this.getBackgroundColor().LABEL_COLOR, this.getCustomPointerColorObject().LIGHT, this.getCustomPointerColorObject().LIGHT};
                LinearGradientPaint POINTER_GRADIENT = new LinearGradientPaint(POINTER_START, POINTER_STOP, POINTER_FRACTIONS, POINTER_COLORS);
                G2.setPaint(POINTER_GRADIENT);
                G2.fill(POINTER);
                break;
            }
            case TYPE3: {
                GeneralPath POINTER = new GeneralPath(new Rectangle2D.Double((double)IMAGE_WIDTH * 0.16355140186915887, (double)IMAGE_HEIGHT * 0.822429906542056, (double)IMAGE_WIDTH * 0.6775700935, (double)IMAGE_HEIGHT * 0.009345794392523364));
                if (this.getPointerColor() != ColorDef.CUSTOM) {
                    G2.setColor(this.getPointerColor().LIGHT);
                } else {
                    G2.setColor(this.getCustomPointerColorObject().LIGHT);
                }
                G2.fill(POINTER);
                break;
            }
            case TYPE4: {
                GeneralPath POINTER = new GeneralPath();
                POINTER.setWindingRule(0);
                POINTER.moveTo((double)IMAGE_WIDTH * 0.16355140186915887, (double)IMAGE_HEIGHT * 0.8271028037383178);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.17757009345794392, (double)IMAGE_HEIGHT * 0.8084112149532711);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.8271028037383178, (double)IMAGE_HEIGHT * 0.794392523364486);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.897196261682243, (double)IMAGE_HEIGHT * 0.8037383177570093);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.897196261682243, (double)IMAGE_HEIGHT * 0.8504672897196262);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.8271028037383178, (double)IMAGE_HEIGHT * 0.8598130841121495);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.17757009345794392, (double)IMAGE_HEIGHT * 0.8411214953271028);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.16355140186915887, (double)IMAGE_HEIGHT * 0.8271028037383178);
                POINTER.closePath();
                Point2D.Double POINTER_START = new Point2D.Double(0.0, POINTER.getBounds2D().getMaxY());
                Point2D.Double POINTER_STOP = new Point2D.Double(0.0, POINTER.getBounds2D().getMinY());
                float[] POINTER_FRACTIONS = new float[]{0.0f, 0.51f, 0.52f, 1.0f};
                Color[] POINTER_COLORS = this.getPointerColor() != ColorDef.CUSTOM ? new Color[]{this.getPointerColor().DARK, this.getPointerColor().DARK, this.getPointerColor().LIGHT, this.getPointerColor().LIGHT} : new Color[]{this.getCustomPointerColorObject().DARK, this.getCustomPointerColorObject().DARK, this.getCustomPointerColorObject().LIGHT, this.getCustomPointerColorObject().LIGHT};
                LinearGradientPaint POINTER_GRADIENT = new LinearGradientPaint(POINTER_START, POINTER_STOP, POINTER_FRACTIONS, POINTER_COLORS);
                G2.setPaint(POINTER_GRADIENT);
                G2.fill(POINTER);
                break;
            }
            case TYPE5: {
                GeneralPath POINTER = new GeneralPath();
                POINTER.setWindingRule(0);
                POINTER.moveTo((double)IMAGE_WIDTH * 0.8271028037383178, (double)IMAGE_HEIGHT * 0.8271028037383178);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.8271028037383178, (double)IMAGE_HEIGHT * 0.7990654205607477);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.16822429906542055, (double)IMAGE_HEIGHT * 0.8271028037383178);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.8271028037383178, (double)IMAGE_HEIGHT * 0.8551401869158879);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.8271028037383178, (double)IMAGE_HEIGHT * 0.8271028037383178);
                POINTER.closePath();
                Point2D.Double POINTER_START = new Point2D.Double(0.0, POINTER.getBounds2D().getMaxY());
                Point2D.Double POINTER_STOP = new Point2D.Double(0.0, POINTER.getBounds2D().getMinY());
                float[] POINTER_FRACTIONS = new float[]{0.0f, 0.45f, 0.46f, 1.0f};
                Color[] POINTER_COLORS = this.getPointerColor() != ColorDef.CUSTOM ? new Color[]{this.getPointerColor().LIGHT, this.getPointerColor().LIGHT, this.getPointerColor().MEDIUM, this.getPointerColor().MEDIUM} : new Color[]{this.getCustomPointerColorObject().LIGHT, this.getCustomPointerColorObject().LIGHT, this.getCustomPointerColorObject().MEDIUM, this.getCustomPointerColorObject().MEDIUM};
                LinearGradientPaint POINTER_GRADIENT = new LinearGradientPaint(POINTER_START, POINTER_STOP, POINTER_FRACTIONS, POINTER_COLORS);
                G2.setPaint(POINTER_GRADIENT);
                G2.fill(POINTER);
                if (this.getPointerColor() != ColorDef.CUSTOM) {
                    G2.setColor(this.getPointerColor().DARK);
                } else {
                    G2.setColor(this.getCustomPointerColorObject().DARK);
                }
                G2.setStroke(new BasicStroke(1.0f, 0, 0));
                G2.draw(POINTER);
                break;
            }
            case TYPE6: {
                GeneralPath POINTER = new GeneralPath();
                POINTER.setWindingRule(0);
                POINTER.moveTo((double)IMAGE_WIDTH * 0.8271028037383178, (double)IMAGE_HEIGHT * 0.8457943925233645);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.6495327102803738, (double)IMAGE_HEIGHT * 0.8457943925233645);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.514018691588785, (double)IMAGE_HEIGHT * 0.8411214953271028);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.16355140186915887, (double)IMAGE_HEIGHT * 0.8317757009345794);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.16355140186915887, (double)IMAGE_HEIGHT * 0.822429906542056);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.514018691588785, (double)IMAGE_HEIGHT * 0.8130841121495327);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.6448598130841121, (double)IMAGE_HEIGHT * 0.8084112149532711);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.8271028037383178, (double)IMAGE_HEIGHT * 0.8084112149532711);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.8271028037383178, (double)IMAGE_HEIGHT * 0.822429906542056);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.6495327102803738, (double)IMAGE_HEIGHT * 0.822429906542056);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.514018691588785, (double)IMAGE_HEIGHT * 0.8271028037383178);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.6495327102803738, (double)IMAGE_HEIGHT * 0.8317757009345794);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.8271028037383178, (double)IMAGE_HEIGHT * 0.8317757009345794);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.8271028037383178, (double)IMAGE_HEIGHT * 0.8457943925233645);
                POINTER.closePath();
                Point2D.Double POINTER_START = new Point2D.Double(0.0, POINTER.getBounds2D().getMaxX());
                Point2D.Double POINTER_STOP = new Point2D.Double(0.0, POINTER.getBounds2D().getMinX());
                float[] POINTER_FRACTIONS = new float[]{0.0f, 0.25f, 0.75f, 1.0f};
                Color[] POINTER_COLORS = this.getPointerColor() != ColorDef.CUSTOM ? new Color[]{this.getPointerColor().LIGHT, this.getPointerColor().MEDIUM, this.getPointerColor().MEDIUM, this.getPointerColor().LIGHT} : new Color[]{this.getCustomPointerColorObject().LIGHT, this.getCustomPointerColorObject().MEDIUM, this.getCustomPointerColorObject().MEDIUM, this.getCustomPointerColorObject().LIGHT};
                LinearGradientPaint POINTER_GRADIENT = new LinearGradientPaint(POINTER_START, POINTER_STOP, POINTER_FRACTIONS, POINTER_COLORS);
                G2.setPaint(POINTER_GRADIENT);
                G2.fill(POINTER);
                if (this.getPointerColor() != ColorDef.CUSTOM) {
                    G2.setColor(this.getPointerColor().DARK);
                } else {
                    G2.setColor(this.getCustomPointerColorObject().DARK);
                }
                G2.setStroke(new BasicStroke(1.0f, 0, 0));
                G2.draw(POINTER);
                break;
            }
            case TYPE7: {
                GeneralPath POINTER = new GeneralPath();
                POINTER.setWindingRule(0);
                POINTER.moveTo((double)IMAGE_WIDTH * 0.16355140186915887, (double)IMAGE_HEIGHT * 0.8364485981308412);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.8271028037383178, (double)IMAGE_HEIGHT * 0.8504672897196262);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.8271028037383178, (double)IMAGE_HEIGHT * 0.8084112149532711);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.16355140186915887, (double)IMAGE_HEIGHT * 0.822429906542056);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.16355140186915887, (double)IMAGE_HEIGHT * 0.8364485981308412);
                POINTER.closePath();
                Point2D.Double POINTER_START = new Point2D.Double(0.0, POINTER.getBounds2D().getMaxY());
                Point2D.Double POINTER_STOP = new Point2D.Double(0.0, POINTER.getBounds2D().getMinY());
                float[] POINTER_FRACTIONS = new float[]{0.0f, 1.0f};
                Color[] POINTER_COLORS = this.getPointerColor() != ColorDef.CUSTOM ? new Color[]{this.getPointerColor().DARK, this.getPointerColor().MEDIUM} : new Color[]{this.getCustomPointerColorObject().DARK, this.getCustomPointerColorObject().MEDIUM};
                LinearGradientPaint POINTER_GRADIENT = new LinearGradientPaint(POINTER_START, POINTER_STOP, POINTER_FRACTIONS, POINTER_COLORS);
                G2.setPaint(POINTER_GRADIENT);
                G2.fill(POINTER);
                break;
            }
            case TYPE8: {
                GeneralPath POINTER = new GeneralPath();
                POINTER.setWindingRule(0);
                POINTER.moveTo((double)IMAGE_WIDTH * 0.8598130841121495, (double)IMAGE_HEIGHT * 0.8271028037383178);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.8271028037383178, (double)IMAGE_HEIGHT * 0.794392523364486);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.8271028037383178, (double)IMAGE_HEIGHT * 0.794392523364486, (double)IMAGE_WIDTH * 0.7850467289719626, (double)IMAGE_HEIGHT * 0.8177570093457944, (double)IMAGE_WIDTH * 0.16822429906542055, (double)IMAGE_HEIGHT * 0.8271028037383178);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.7850467289719626, (double)IMAGE_HEIGHT * 0.8411214953271028, (double)IMAGE_WIDTH * 0.8271028037383178, (double)IMAGE_HEIGHT * 0.8598130841121495, (double)IMAGE_WIDTH * 0.8271028037383178, (double)IMAGE_HEIGHT * 0.8598130841121495);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.8598130841121495, (double)IMAGE_HEIGHT * 0.8271028037383178);
                POINTER.closePath();
                Point2D.Double POINTER_START = new Point2D.Double(0.0, POINTER.getBounds2D().getMaxY());
                Point2D.Double POINTER_STOP = new Point2D.Double(0.0, POINTER.getBounds2D().getMinY());
                float[] POINTER_FRACTIONS = new float[]{0.0f, 0.46f, 0.47f, 1.0f};
                Color[] POINTER_COLORS = this.getPointerColor() != ColorDef.CUSTOM ? new Color[]{this.getPointerColor().LIGHT, this.getPointerColor().LIGHT, this.getPointerColor().MEDIUM, this.getPointerColor().MEDIUM} : new Color[]{this.getCustomPointerColorObject().LIGHT, this.getCustomPointerColorObject().LIGHT, this.getCustomPointerColorObject().MEDIUM, this.getCustomPointerColorObject().MEDIUM};
                LinearGradientPaint POINTER_GRADIENT = new LinearGradientPaint(POINTER_START, POINTER_STOP, POINTER_FRACTIONS, POINTER_COLORS);
                G2.setPaint(POINTER_GRADIENT);
                G2.fill(POINTER);
                if (this.getPointerColor() != ColorDef.CUSTOM) {
                    G2.setColor(this.getPointerColor().DARK);
                } else {
                    G2.setColor(this.getCustomPointerColorObject().DARK);
                }
                G2.setStroke(new BasicStroke(1.0f, 0, 0));
                G2.draw(POINTER);
                break;
            }
            case TYPE9: {
                GeneralPath POINTER = new GeneralPath();
                POINTER.setWindingRule(0);
                POINTER.moveTo((double)IMAGE_WIDTH * 0.29439252336448596, (double)IMAGE_HEIGHT * 0.8317757009345794);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.29439252336448596, (double)IMAGE_HEIGHT * 0.822429906542056);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.7663551401869159, (double)IMAGE_HEIGHT * 0.8130841121495327);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.7663551401869159, (double)IMAGE_HEIGHT * 0.8411214953271028);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.29439252336448596, (double)IMAGE_HEIGHT * 0.8317757009345794);
                POINTER.closePath();
                POINTER.moveTo((double)IMAGE_WIDTH * 0.16355140186915887, (double)IMAGE_HEIGHT * 0.8364485981308412);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.7990654205607477, (double)IMAGE_HEIGHT * 0.8551401869158879);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.8551401869158879, (double)IMAGE_HEIGHT * 0.8551401869158879);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.8551401869158879, (double)IMAGE_HEIGHT * 0.8551401869158879, (double)IMAGE_WIDTH * 0.8878504672897196, (double)IMAGE_HEIGHT * 0.8504672897196262, (double)IMAGE_WIDTH * 0.8878504672897196, (double)IMAGE_HEIGHT * 0.8504672897196262);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.8925233644859814, (double)IMAGE_HEIGHT * 0.8504672897196262, (double)IMAGE_WIDTH * 0.8925233644859814, (double)IMAGE_HEIGHT * 0.8457943925233645, (double)IMAGE_WIDTH * 0.8925233644859814, (double)IMAGE_HEIGHT * 0.8271028037383178);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.8925233644859814, (double)IMAGE_HEIGHT * 0.8084112149532711, (double)IMAGE_WIDTH * 0.8925233644859814, (double)IMAGE_HEIGHT * 0.8037383177570093, (double)IMAGE_WIDTH * 0.8878504672897196, (double)IMAGE_HEIGHT * 0.8037383177570093);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.8878504672897196, (double)IMAGE_HEIGHT * 0.8037383177570093, (double)IMAGE_WIDTH * 0.8551401869158879, (double)IMAGE_HEIGHT * 0.7990654205607477, (double)IMAGE_WIDTH * 0.8551401869158879, (double)IMAGE_HEIGHT * 0.7990654205607477);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.7990654205607477, (double)IMAGE_HEIGHT * 0.7990654205607477);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.16355140186915887, (double)IMAGE_HEIGHT * 0.8177570093457944);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.16355140186915887, (double)IMAGE_HEIGHT * 0.8364485981308412);
                POINTER.closePath();
                Point2D.Double POINTER_START = new Point2D.Double(0.0, POINTER.getBounds2D().getMaxY());
                Point2D.Double POINTER_STOP = new Point2D.Double(0.0, POINTER.getBounds2D().getMinY());
                float[] POINTER_FRACTIONS = new float[]{0.0f, 0.48f, 1.0f};
                Color[] POINTER_COLORS = new Color[]{new Color(50, 50, 50, 255), new Color(102, 102, 102, 255), new Color(50, 50, 50, 255)};
                LinearGradientPaint POINTER_GRADIENT = new LinearGradientPaint(POINTER_START, POINTER_STOP, POINTER_FRACTIONS, POINTER_COLORS);
                G2.setPaint(POINTER_GRADIENT);
                G2.fill(POINTER);
                G2.setColor(new Color(0x2E2E2E));
                G2.setStroke(new BasicStroke(1.0f, 0, 0));
                G2.draw(POINTER);
                GeneralPath COLOR_BOX = new GeneralPath();
                COLOR_BOX.setWindingRule(0);
                COLOR_BOX.moveTo((double)IMAGE_WIDTH * 0.2523364485981308, (double)IMAGE_HEIGHT * 0.8317757009345794);
                COLOR_BOX.lineTo((double)IMAGE_WIDTH * 0.2523364485981308, (double)IMAGE_HEIGHT * 0.822429906542056);
                COLOR_BOX.lineTo((double)IMAGE_WIDTH * 0.16822429906542055, (double)IMAGE_HEIGHT * 0.822429906542056);
                COLOR_BOX.lineTo((double)IMAGE_WIDTH * 0.16822429906542055, (double)IMAGE_HEIGHT * 0.8317757009345794);
                COLOR_BOX.lineTo((double)IMAGE_WIDTH * 0.2523364485981308, (double)IMAGE_HEIGHT * 0.8317757009345794);
                COLOR_BOX.closePath();
                G2.setColor(this.getPointerColor().MEDIUM);
                G2.fill(COLOR_BOX);
                break;
            }
            case TYPE10: {
                GeneralPath POINTER = new GeneralPath();
                POINTER.setWindingRule(0);
                POINTER.moveTo((double)IMAGE_WIDTH * 0.16355140186915887, (double)IMAGE_HEIGHT * 0.8271028037383178);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.16355140186915887, (double)IMAGE_HEIGHT * 0.8271028037383178, (double)IMAGE_WIDTH * 0.822429906542056, (double)IMAGE_HEIGHT * 0.883177570093458, (double)IMAGE_WIDTH * 0.8317757009345794, (double)IMAGE_HEIGHT * 0.883177570093458);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.8598130841121495, (double)IMAGE_HEIGHT * 0.883177570093458, (double)IMAGE_WIDTH * 0.8878504672897196, (double)IMAGE_HEIGHT * 0.8598130841121495, (double)IMAGE_WIDTH * 0.8878504672897196, (double)IMAGE_HEIGHT * 0.8271028037383178);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.8878504672897196, (double)IMAGE_HEIGHT * 0.7990654205607477, (double)IMAGE_WIDTH * 0.8598130841121495, (double)IMAGE_HEIGHT * 0.7710280373831776, (double)IMAGE_WIDTH * 0.8317757009345794, (double)IMAGE_HEIGHT * 0.7710280373831776);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.822429906542056, (double)IMAGE_HEIGHT * 0.7710280373831776, (double)IMAGE_WIDTH * 0.16355140186915887, (double)IMAGE_HEIGHT * 0.8271028037383178, (double)IMAGE_WIDTH * 0.16355140186915887, (double)IMAGE_HEIGHT * 0.8271028037383178);
                POINTER.closePath();
                Point2D.Double POINTER_START = new Point2D.Double(0.0, POINTER.getBounds2D().getMaxY());
                Point2D.Double POINTER_STOP = new Point2D.Double(0.0, POINTER.getBounds2D().getMinY());
                float[] POINTER_FRACTIONS = new float[]{0.0f, 0.4999f, 0.5f, 1.0f};
                Color[] POINTER_COLORS = new Color[]{this.getPointerColor().LIGHT, this.getPointerColor().LIGHT, this.getPointerColor().MEDIUM, this.getPointerColor().MEDIUM};
                LinearGradientPaint POINTER_GRADIENT = new LinearGradientPaint(POINTER_START, POINTER_STOP, POINTER_FRACTIONS, POINTER_COLORS);
                G2.setPaint(POINTER_GRADIENT);
                G2.fill(POINTER);
                G2.setColor(this.getPointerColor().MEDIUM);
                G2.setStroke(new BasicStroke(1.0f, 0, 0));
                G2.draw(POINTER);
                break;
            }
            case TYPE11: {
                GeneralPath POINTER = new GeneralPath();
                POINTER.setWindingRule(0);
                POINTER.moveTo(0.16822429906542055 * (double)IMAGE_WIDTH, 0.8271028037383178 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.8317757009345794 * (double)IMAGE_WIDTH, 0.8411214953271028 * (double)IMAGE_HEIGHT);
                POINTER.curveTo(0.8317757009345794 * (double)IMAGE_WIDTH, 0.8411214953271028 * (double)IMAGE_HEIGHT, 0.9018691588785047 * (double)IMAGE_WIDTH, 0.8411214953271028 * (double)IMAGE_HEIGHT, 0.9018691588785047 * (double)IMAGE_WIDTH, 0.8271028037383178 * (double)IMAGE_HEIGHT);
                POINTER.curveTo(0.9018691588785047 * (double)IMAGE_WIDTH, 0.8130841121495327 * (double)IMAGE_HEIGHT, 0.8317757009345794 * (double)IMAGE_WIDTH, 0.8130841121495327 * (double)IMAGE_HEIGHT, 0.8317757009345794 * (double)IMAGE_WIDTH, 0.8130841121495327 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.16822429906542055 * (double)IMAGE_WIDTH, 0.8271028037383178 * (double)IMAGE_HEIGHT);
                POINTER.closePath();
                G2.setPaint(new LinearGradientPaint(new Point2D.Double(0.16822429906542055 * (double)IMAGE_WIDTH, 0.822429906542056 * (double)IMAGE_HEIGHT), new Point2D.Double(0.897196261682243 * (double)IMAGE_WIDTH, 0.822429906542056 * (double)IMAGE_HEIGHT), new float[]{0.0f, 1.0f}, new Color[]{this.getPointerColor().LIGHT, this.getPointerColor().MEDIUM}));
                G2.fill(POINTER);
                G2.setPaint(this.getPointerColor().DARK);
                G2.setStroke(new BasicStroke(0.004672897f * (float)IMAGE_WIDTH, 0, 1));
                G2.draw(POINTER);
                break;
            }
            case TYPE12: {
                GeneralPath POINTER = new GeneralPath();
                POINTER.setWindingRule(0);
                POINTER.moveTo(0.16822429906542055 * (double)IMAGE_WIDTH, 0.8271028037383178 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.8317757009345794 * (double)IMAGE_WIDTH, 0.8411214953271028 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.8411214953271028 * (double)IMAGE_WIDTH, 0.8271028037383178 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.8317757009345794 * (double)IMAGE_WIDTH, 0.8130841121495327 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.16822429906542055 * (double)IMAGE_WIDTH, 0.8271028037383178 * (double)IMAGE_HEIGHT);
                POINTER.closePath();
                G2.setPaint(new LinearGradientPaint(new Point2D.Double(0.16822429906542055 * (double)IMAGE_WIDTH, 0.822429906542056 * (double)IMAGE_HEIGHT), new Point2D.Double(0.8364485981308412 * (double)IMAGE_WIDTH, 0.822429906542056 * (double)IMAGE_HEIGHT), new float[]{0.0f, 1.0f}, new Color[]{this.getPointerColor().LIGHT, this.getPointerColor().MEDIUM}));
                G2.fill(POINTER);
                G2.setPaint(this.getPointerColor().DARK);
                G2.setStroke(new BasicStroke(0.004672897f * (float)IMAGE_WIDTH, 0, 1));
                G2.draw(POINTER);
                break;
            }
            case TYPE13: {
                GeneralPath POINTER = new GeneralPath();
                POINTER.setWindingRule(0);
                POINTER.moveTo(0.20093457943925233 * (double)IMAGE_WIDTH, 0.8411214953271028 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.16355140186915887 * (double)IMAGE_WIDTH, 0.8271028037383178 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.20093457943925233 * (double)IMAGE_WIDTH, 0.8130841121495327 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.8317757009345794 * (double)IMAGE_WIDTH, 0.8130841121495327 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.8317757009345794 * (double)IMAGE_WIDTH, 0.8411214953271028 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.20093457943925233 * (double)IMAGE_WIDTH, 0.8411214953271028 * (double)IMAGE_HEIGHT);
                POINTER.closePath();
                G2.setPaint(new LinearGradientPaint(new Point2D.Double(0.822429906542056 * (double)IMAGE_WIDTH, 0.8271028037383178 * (double)IMAGE_HEIGHT), new Point2D.Double(0.16822429906542055 * (double)IMAGE_WIDTH, 0.8271028037383179 * (double)IMAGE_HEIGHT), new float[]{0.0f, 0.899999f, 0.9f, 1.0f}, new Color[]{this.getPointerColor().MEDIUM, this.getPointerColor().MEDIUM, this.getBackgroundColor().LABEL_COLOR, this.getBackgroundColor().LABEL_COLOR}));
                G2.fill(POINTER);
                break;
            }
            case TYPE14: {
                GeneralPath POINTER = new GeneralPath();
                POINTER.setWindingRule(0);
                POINTER.moveTo(0.20093457943925233 * (double)IMAGE_WIDTH, 0.8411214953271028 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.16355140186915887 * (double)IMAGE_WIDTH, 0.8271028037383178 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.20093457943925233 * (double)IMAGE_WIDTH, 0.8130841121495327 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.8317757009345794 * (double)IMAGE_WIDTH, 0.8130841121495327 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.8317757009345794 * (double)IMAGE_WIDTH, 0.8411214953271028 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.20093457943925233 * (double)IMAGE_WIDTH, 0.8411214953271028 * (double)IMAGE_HEIGHT);
                POINTER.closePath();
                G2.setPaint(new LinearGradientPaint(new Point2D.Double(0.7476635514018691 * (double)IMAGE_WIDTH, 0.8411214953271028 * (double)IMAGE_HEIGHT), new Point2D.Double(0.7476635514018691 * (double)IMAGE_WIDTH, 0.8084112149532711 * (double)IMAGE_HEIGHT), new float[]{0.0f, 0.5f, 1.0f}, new Color[]{this.getPointerColor().VERY_DARK, this.getPointerColor().LIGHT, this.getPointerColor().VERY_DARK}));
                G2.fill(POINTER);
                break;
            }
            default: {
                GeneralPath POINTER = new GeneralPath();
                POINTER.setWindingRule(0);
                POINTER.moveTo((double)IMAGE_WIDTH * 0.7990654205607477, (double)IMAGE_HEIGHT * 0.8130841121495327);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.7850467289719626, (double)IMAGE_HEIGHT * 0.8130841121495327, (double)IMAGE_WIDTH * 0.7429906542056075, (double)IMAGE_HEIGHT * 0.8130841121495327, (double)IMAGE_WIDTH * 0.7289719626168224, (double)IMAGE_HEIGHT * 0.8130841121495327);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.7102803738317757, (double)IMAGE_HEIGHT * 0.822429906542056, (double)IMAGE_WIDTH * 0.16355140186915887, (double)IMAGE_HEIGHT * 0.8271028037383178, (double)IMAGE_WIDTH * 0.16355140186915887, (double)IMAGE_HEIGHT * 0.8271028037383178);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.16355140186915887, (double)IMAGE_HEIGHT * 0.8271028037383178, (double)IMAGE_WIDTH * 0.7149532710280374, (double)IMAGE_HEIGHT * 0.8364485981308412, (double)IMAGE_WIDTH * 0.7242990654205608, (double)IMAGE_HEIGHT * 0.8411214953271028);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.7429906542056075, (double)IMAGE_HEIGHT * 0.8411214953271028, (double)IMAGE_WIDTH * 0.7850467289719626, (double)IMAGE_HEIGHT * 0.8411214953271028, (double)IMAGE_WIDTH * 0.7990654205607477, (double)IMAGE_HEIGHT * 0.8457943925233645);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.8084112149532711, (double)IMAGE_HEIGHT * 0.8551401869158879, (double)IMAGE_WIDTH * 0.8177570093457944, (double)IMAGE_HEIGHT * 0.8598130841121495, (double)IMAGE_WIDTH * 0.8271028037383178, (double)IMAGE_HEIGHT * 0.8598130841121495);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.8457943925233645, (double)IMAGE_HEIGHT * 0.8598130841121495, (double)IMAGE_WIDTH * 0.8598130841121495, (double)IMAGE_HEIGHT * 0.8457943925233645, (double)IMAGE_WIDTH * 0.8598130841121495, (double)IMAGE_HEIGHT * 0.8271028037383178);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.8598130841121495, (double)IMAGE_HEIGHT * 0.8084112149532711, (double)IMAGE_WIDTH * 0.8457943925233645, (double)IMAGE_HEIGHT * 0.794392523364486, (double)IMAGE_WIDTH * 0.8271028037383178, (double)IMAGE_HEIGHT * 0.794392523364486);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.8177570093457944, (double)IMAGE_HEIGHT * 0.794392523364486, (double)IMAGE_WIDTH * 0.8084112149532711, (double)IMAGE_HEIGHT * 0.7990654205607477, (double)IMAGE_WIDTH * 0.7990654205607477, (double)IMAGE_HEIGHT * 0.8130841121495327);
                POINTER.closePath();
                Point2D.Double POINTER_START = new Point2D.Double(POINTER.getBounds2D().getMinX(), 0.0);
                Point2D.Double POINTER_STOP = new Point2D.Double(POINTER.getBounds2D().getMaxX(), 0.0);
                float[] POINTER_FRACTIONS = new float[]{0.0f, 0.3f, 0.59f, 1.0f};
                Color[] POINTER_COLORS = this.getPointerColor() != ColorDef.CUSTOM ? new Color[]{this.getPointerColor().DARK, this.getPointerColor().LIGHT, this.getPointerColor().LIGHT, this.getPointerColor().DARK} : new Color[]{this.getCustomPointerColorObject().DARK, this.getCustomPointerColorObject().LIGHT, this.getCustomPointerColorObject().LIGHT, this.getCustomPointerColorObject().DARK};
                LinearGradientPaint POINTER_GRADIENT = new LinearGradientPaint(POINTER_START, POINTER_STOP, POINTER_FRACTIONS, POINTER_COLORS);
                G2.setPaint(POINTER_GRADIENT);
                G2.fill(POINTER);
                Color STROKE_COLOR_POINTER = this.getPointerColor().LIGHT;
                G2.setColor(STROKE_COLOR_POINTER);
                G2.setStroke(new BasicStroke(1.0f, 0, 0));
                G2.draw(POINTER);
            }
        }
        G2.dispose();
        return IMAGE;
    }

    @Override
    protected BufferedImage create_POINTER_SHADOW_Image(int WIDTH, PointerType POINTER_TYPE) {
        if (WIDTH <= 0) {
            return null;
        }
        Color SHADOW_COLOR = new Color(0.0f, 0.0f, 0.0f, 0.65f);
        BufferedImage IMAGE = UTIL.createImage(WIDTH, WIDTH, 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        int IMAGE_WIDTH = IMAGE.getWidth();
        int IMAGE_HEIGHT = IMAGE.getHeight();
        this.transformGraphics(IMAGE_WIDTH, IMAGE_HEIGHT, G2);
        switch (POINTER_TYPE) {
            case TYPE1: {
                GeneralPath POINTER = new GeneralPath();
                POINTER.setWindingRule(0);
                POINTER.moveTo((double)IMAGE_WIDTH * 0.7990654205607477, (double)IMAGE_HEIGHT * 0.8130841121495327);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.7850467289719626, (double)IMAGE_HEIGHT * 0.8130841121495327, (double)IMAGE_WIDTH * 0.7429906542056075, (double)IMAGE_HEIGHT * 0.8130841121495327, (double)IMAGE_WIDTH * 0.7289719626168224, (double)IMAGE_HEIGHT * 0.8130841121495327);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.7102803738317757, (double)IMAGE_HEIGHT * 0.822429906542056, (double)IMAGE_WIDTH * 0.2102803738317757, (double)IMAGE_HEIGHT * 0.8271028037383178, (double)IMAGE_WIDTH * 0.2102803738317757, (double)IMAGE_HEIGHT * 0.8271028037383178);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.2102803738317757, (double)IMAGE_HEIGHT * 0.8271028037383178, (double)IMAGE_WIDTH * 0.7149532710280374, (double)IMAGE_HEIGHT * 0.8364485981308412, (double)IMAGE_WIDTH * 0.7242990654205608, (double)IMAGE_HEIGHT * 0.8411214953271028);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.7429906542056075, (double)IMAGE_HEIGHT * 0.8411214953271028, (double)IMAGE_WIDTH * 0.7850467289719626, (double)IMAGE_HEIGHT * 0.8411214953271028, (double)IMAGE_WIDTH * 0.7990654205607477, (double)IMAGE_HEIGHT * 0.8457943925233645);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.8084112149532711, (double)IMAGE_HEIGHT * 0.8551401869158879, (double)IMAGE_WIDTH * 0.8177570093457944, (double)IMAGE_HEIGHT * 0.8598130841121495, (double)IMAGE_WIDTH * 0.8271028037383178, (double)IMAGE_HEIGHT * 0.8598130841121495);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.8457943925233645, (double)IMAGE_HEIGHT * 0.8598130841121495, (double)IMAGE_WIDTH * 0.8598130841121495, (double)IMAGE_HEIGHT * 0.8457943925233645, (double)IMAGE_WIDTH * 0.8598130841121495, (double)IMAGE_HEIGHT * 0.8271028037383178);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.8598130841121495, (double)IMAGE_HEIGHT * 0.8084112149532711, (double)IMAGE_WIDTH * 0.8457943925233645, (double)IMAGE_HEIGHT * 0.794392523364486, (double)IMAGE_WIDTH * 0.8271028037383178, (double)IMAGE_HEIGHT * 0.794392523364486);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.8177570093457944, (double)IMAGE_HEIGHT * 0.794392523364486, (double)IMAGE_WIDTH * 0.8084112149532711, (double)IMAGE_HEIGHT * 0.7990654205607477, (double)IMAGE_WIDTH * 0.7990654205607477, (double)IMAGE_HEIGHT * 0.8130841121495327);
                POINTER.closePath();
                G2.setColor(SHADOW_COLOR);
                G2.fill(POINTER);
                break;
            }
            case TYPE2: {
                GeneralPath POINTER = new GeneralPath();
                POINTER.setWindingRule(0);
                POINTER.moveTo((double)IMAGE_WIDTH * 0.7990654205607477, (double)IMAGE_HEIGHT * 0.8130841121495327);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.7897196261682243, (double)IMAGE_HEIGHT * 0.822429906542056);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.6635514018691588, (double)IMAGE_HEIGHT * 0.822429906542056);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.2102803738317757, (double)IMAGE_HEIGHT * 0.8271028037383178);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.2102803738317757, (double)IMAGE_HEIGHT * 0.8317757009345794);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.6682242990654206, (double)IMAGE_HEIGHT * 0.8364485981308412);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.7897196261682243, (double)IMAGE_HEIGHT * 0.8364485981308412);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.7990654205607477, (double)IMAGE_HEIGHT * 0.8457943925233645);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.7990654205607477, (double)IMAGE_HEIGHT * 0.8457943925233645, (double)IMAGE_WIDTH * 0.8177570093457944, (double)IMAGE_HEIGHT * 0.8598130841121495, (double)IMAGE_WIDTH * 0.8271028037383178, (double)IMAGE_HEIGHT * 0.8598130841121495);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.8457943925233645, (double)IMAGE_HEIGHT * 0.8598130841121495, (double)IMAGE_WIDTH * 0.8598130841121495, (double)IMAGE_HEIGHT * 0.8457943925233645, (double)IMAGE_WIDTH * 0.8598130841121495, (double)IMAGE_HEIGHT * 0.8271028037383178);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.8598130841121495, (double)IMAGE_HEIGHT * 0.8084112149532711, (double)IMAGE_WIDTH * 0.8457943925233645, (double)IMAGE_HEIGHT * 0.794392523364486, (double)IMAGE_WIDTH * 0.8271028037383178, (double)IMAGE_HEIGHT * 0.794392523364486);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.8177570093457944, (double)IMAGE_HEIGHT * 0.794392523364486, (double)IMAGE_WIDTH * 0.7990654205607477, (double)IMAGE_HEIGHT * 0.8130841121495327, (double)IMAGE_WIDTH * 0.7990654205607477, (double)IMAGE_HEIGHT * 0.8130841121495327);
                POINTER.closePath();
                G2.setColor(SHADOW_COLOR);
                G2.fill(POINTER);
                break;
            }
            case TYPE3: {
                break;
            }
            case TYPE4: {
                GeneralPath POINTER = new GeneralPath();
                POINTER.setWindingRule(0);
                POINTER.moveTo((double)IMAGE_WIDTH * 0.16355140186915887, (double)IMAGE_HEIGHT * 0.8271028037383178);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.17757009345794392, (double)IMAGE_HEIGHT * 0.8084112149532711);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.8271028037383178, (double)IMAGE_HEIGHT * 0.794392523364486);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.897196261682243, (double)IMAGE_HEIGHT * 0.8037383177570093);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.897196261682243, (double)IMAGE_HEIGHT * 0.8504672897196262);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.8271028037383178, (double)IMAGE_HEIGHT * 0.8598130841121495);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.17757009345794392, (double)IMAGE_HEIGHT * 0.8411214953271028);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.16355140186915887, (double)IMAGE_HEIGHT * 0.8271028037383178);
                POINTER.closePath();
                G2.setColor(SHADOW_COLOR);
                G2.fill(POINTER);
                break;
            }
            case TYPE5: {
                GeneralPath POINTER = new GeneralPath();
                POINTER.setWindingRule(0);
                POINTER.moveTo((double)IMAGE_WIDTH * 0.8271028037383178, (double)IMAGE_HEIGHT * 0.8271028037383178);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.8271028037383178, (double)IMAGE_HEIGHT * 0.7990654205607477);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.16822429906542055, (double)IMAGE_HEIGHT * 0.8271028037383178);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.8271028037383178, (double)IMAGE_HEIGHT * 0.8551401869158879);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.8271028037383178, (double)IMAGE_HEIGHT * 0.8271028037383178);
                POINTER.closePath();
                G2.setColor(SHADOW_COLOR);
                G2.fill(POINTER);
                break;
            }
            case TYPE6: {
                GeneralPath POINTER = new GeneralPath();
                POINTER.setWindingRule(0);
                POINTER.moveTo((double)IMAGE_WIDTH * 0.8271028037383178, (double)IMAGE_HEIGHT * 0.8457943925233645);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.6495327102803738, (double)IMAGE_HEIGHT * 0.8457943925233645);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.514018691588785, (double)IMAGE_HEIGHT * 0.8411214953271028);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.16355140186915887, (double)IMAGE_HEIGHT * 0.8317757009345794);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.16355140186915887, (double)IMAGE_HEIGHT * 0.822429906542056);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.514018691588785, (double)IMAGE_HEIGHT * 0.8130841121495327);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.6448598130841121, (double)IMAGE_HEIGHT * 0.8084112149532711);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.8271028037383178, (double)IMAGE_HEIGHT * 0.8084112149532711);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.8271028037383178, (double)IMAGE_HEIGHT * 0.822429906542056);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.6495327102803738, (double)IMAGE_HEIGHT * 0.822429906542056);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.514018691588785, (double)IMAGE_HEIGHT * 0.8271028037383178);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.6495327102803738, (double)IMAGE_HEIGHT * 0.8317757009345794);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.8271028037383178, (double)IMAGE_HEIGHT * 0.8317757009345794);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.8271028037383178, (double)IMAGE_HEIGHT * 0.8457943925233645);
                POINTER.closePath();
                G2.setColor(SHADOW_COLOR);
                G2.fill(POINTER);
                break;
            }
            case TYPE7: {
                GeneralPath POINTER = new GeneralPath();
                POINTER.setWindingRule(0);
                POINTER.moveTo((double)IMAGE_WIDTH * 0.16355140186915887, (double)IMAGE_HEIGHT * 0.8364485981308412);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.8271028037383178, (double)IMAGE_HEIGHT * 0.8504672897196262);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.8271028037383178, (double)IMAGE_HEIGHT * 0.8084112149532711);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.16355140186915887, (double)IMAGE_HEIGHT * 0.822429906542056);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.16355140186915887, (double)IMAGE_HEIGHT * 0.8364485981308412);
                POINTER.closePath();
                G2.setColor(SHADOW_COLOR);
                G2.fill(POINTER);
                break;
            }
            case TYPE8: {
                GeneralPath POINTER = new GeneralPath();
                POINTER.setWindingRule(0);
                POINTER.moveTo((double)IMAGE_WIDTH * 0.8598130841121495, (double)IMAGE_HEIGHT * 0.8271028037383178);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.8271028037383178, (double)IMAGE_HEIGHT * 0.794392523364486);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.8271028037383178, (double)IMAGE_HEIGHT * 0.794392523364486, (double)IMAGE_WIDTH * 0.7850467289719626, (double)IMAGE_HEIGHT * 0.8177570093457944, (double)IMAGE_WIDTH * 0.16822429906542055, (double)IMAGE_HEIGHT * 0.8271028037383178);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.7850467289719626, (double)IMAGE_HEIGHT * 0.8411214953271028, (double)IMAGE_WIDTH * 0.8271028037383178, (double)IMAGE_HEIGHT * 0.8598130841121495, (double)IMAGE_WIDTH * 0.8271028037383178, (double)IMAGE_HEIGHT * 0.8598130841121495);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.8598130841121495, (double)IMAGE_HEIGHT * 0.8271028037383178);
                POINTER.closePath();
                G2.setColor(SHADOW_COLOR);
                G2.fill(POINTER);
                break;
            }
            case TYPE9: {
                GeneralPath POINTER = new GeneralPath();
                POINTER.setWindingRule(0);
                POINTER.moveTo((double)IMAGE_WIDTH * 0.29439252336448596, (double)IMAGE_HEIGHT * 0.8317757009345794);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.29439252336448596, (double)IMAGE_HEIGHT * 0.822429906542056);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.7663551401869159, (double)IMAGE_HEIGHT * 0.8130841121495327);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.7663551401869159, (double)IMAGE_HEIGHT * 0.8411214953271028);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.29439252336448596, (double)IMAGE_HEIGHT * 0.8317757009345794);
                POINTER.closePath();
                POINTER.moveTo((double)IMAGE_WIDTH * 0.16355140186915887, (double)IMAGE_HEIGHT * 0.8364485981308412);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.7990654205607477, (double)IMAGE_HEIGHT * 0.8551401869158879);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.8551401869158879, (double)IMAGE_HEIGHT * 0.8551401869158879);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.8551401869158879, (double)IMAGE_HEIGHT * 0.8551401869158879, (double)IMAGE_WIDTH * 0.8878504672897196, (double)IMAGE_HEIGHT * 0.8504672897196262, (double)IMAGE_WIDTH * 0.8878504672897196, (double)IMAGE_HEIGHT * 0.8504672897196262);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.8925233644859814, (double)IMAGE_HEIGHT * 0.8504672897196262, (double)IMAGE_WIDTH * 0.8925233644859814, (double)IMAGE_HEIGHT * 0.8457943925233645, (double)IMAGE_WIDTH * 0.8925233644859814, (double)IMAGE_HEIGHT * 0.8271028037383178);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.8925233644859814, (double)IMAGE_HEIGHT * 0.8084112149532711, (double)IMAGE_WIDTH * 0.8925233644859814, (double)IMAGE_HEIGHT * 0.8037383177570093, (double)IMAGE_WIDTH * 0.8878504672897196, (double)IMAGE_HEIGHT * 0.8037383177570093);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.8878504672897196, (double)IMAGE_HEIGHT * 0.8037383177570093, (double)IMAGE_WIDTH * 0.8551401869158879, (double)IMAGE_HEIGHT * 0.7990654205607477, (double)IMAGE_WIDTH * 0.8551401869158879, (double)IMAGE_HEIGHT * 0.7990654205607477);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.7990654205607477, (double)IMAGE_HEIGHT * 0.7990654205607477);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.16355140186915887, (double)IMAGE_HEIGHT * 0.8177570093457944);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.16355140186915887, (double)IMAGE_HEIGHT * 0.8364485981308412);
                POINTER.closePath();
                G2.setColor(SHADOW_COLOR);
                G2.fill(POINTER);
                break;
            }
            case TYPE10: {
                GeneralPath POINTER = new GeneralPath();
                POINTER.setWindingRule(0);
                POINTER.moveTo((double)IMAGE_WIDTH * 0.16355140186915887, (double)IMAGE_HEIGHT * 0.8271028037383178);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.16355140186915887, (double)IMAGE_HEIGHT * 0.8271028037383178, (double)IMAGE_WIDTH * 0.822429906542056, (double)IMAGE_HEIGHT * 0.883177570093458, (double)IMAGE_WIDTH * 0.8317757009345794, (double)IMAGE_HEIGHT * 0.883177570093458);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.8598130841121495, (double)IMAGE_HEIGHT * 0.883177570093458, (double)IMAGE_WIDTH * 0.8878504672897196, (double)IMAGE_HEIGHT * 0.8598130841121495, (double)IMAGE_WIDTH * 0.8878504672897196, (double)IMAGE_HEIGHT * 0.8271028037383178);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.8878504672897196, (double)IMAGE_HEIGHT * 0.7990654205607477, (double)IMAGE_WIDTH * 0.8598130841121495, (double)IMAGE_HEIGHT * 0.7710280373831776, (double)IMAGE_WIDTH * 0.8317757009345794, (double)IMAGE_HEIGHT * 0.7710280373831776);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.822429906542056, (double)IMAGE_HEIGHT * 0.7710280373831776, (double)IMAGE_WIDTH * 0.16355140186915887, (double)IMAGE_HEIGHT * 0.8271028037383178, (double)IMAGE_WIDTH * 0.16355140186915887, (double)IMAGE_HEIGHT * 0.8271028037383178);
                POINTER.closePath();
                G2.setColor(SHADOW_COLOR);
                G2.fill(POINTER);
                break;
            }
            case TYPE11: {
                GeneralPath POINTER = new GeneralPath();
                POINTER.setWindingRule(0);
                POINTER.moveTo(0.16822429906542055 * (double)IMAGE_WIDTH, 0.8271028037383178 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.8317757009345794 * (double)IMAGE_WIDTH, 0.8411214953271028 * (double)IMAGE_HEIGHT);
                POINTER.curveTo(0.8317757009345794 * (double)IMAGE_WIDTH, 0.8411214953271028 * (double)IMAGE_HEIGHT, 0.9018691588785047 * (double)IMAGE_WIDTH, 0.8411214953271028 * (double)IMAGE_HEIGHT, 0.9018691588785047 * (double)IMAGE_WIDTH, 0.8271028037383178 * (double)IMAGE_HEIGHT);
                POINTER.curveTo(0.9018691588785047 * (double)IMAGE_WIDTH, 0.8130841121495327 * (double)IMAGE_HEIGHT, 0.8317757009345794 * (double)IMAGE_WIDTH, 0.8130841121495327 * (double)IMAGE_HEIGHT, 0.8317757009345794 * (double)IMAGE_WIDTH, 0.8130841121495327 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.16822429906542055 * (double)IMAGE_WIDTH, 0.8271028037383178 * (double)IMAGE_HEIGHT);
                POINTER.closePath();
                G2.setColor(SHADOW_COLOR);
                G2.fill(POINTER);
                break;
            }
            case TYPE12: {
                GeneralPath POINTER = new GeneralPath();
                POINTER.setWindingRule(0);
                POINTER.moveTo(0.16822429906542055 * (double)IMAGE_WIDTH, 0.8271028037383178 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.8317757009345794 * (double)IMAGE_WIDTH, 0.8411214953271028 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.8411214953271028 * (double)IMAGE_WIDTH, 0.8271028037383178 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.8317757009345794 * (double)IMAGE_WIDTH, 0.8130841121495327 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.16822429906542055 * (double)IMAGE_WIDTH, 0.8271028037383178 * (double)IMAGE_HEIGHT);
                POINTER.closePath();
                G2.setColor(SHADOW_COLOR);
                G2.fill(POINTER);
                break;
            }
            case TYPE13: {
                GeneralPath POINTER = new GeneralPath();
                POINTER.setWindingRule(0);
                POINTER.moveTo(0.20093457943925233 * (double)IMAGE_WIDTH, 0.8411214953271028 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.16355140186915887 * (double)IMAGE_WIDTH, 0.8271028037383178 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.20093457943925233 * (double)IMAGE_WIDTH, 0.8130841121495327 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.8317757009345794 * (double)IMAGE_WIDTH, 0.8130841121495327 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.8317757009345794 * (double)IMAGE_WIDTH, 0.8411214953271028 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.20093457943925233 * (double)IMAGE_WIDTH, 0.8411214953271028 * (double)IMAGE_HEIGHT);
                POINTER.closePath();
                G2.setColor(SHADOW_COLOR);
                G2.fill(POINTER);
                break;
            }
            case TYPE14: {
                GeneralPath POINTER = new GeneralPath();
                POINTER.setWindingRule(0);
                POINTER.moveTo(0.20093457943925233 * (double)IMAGE_WIDTH, 0.8411214953271028 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.16355140186915887 * (double)IMAGE_WIDTH, 0.8271028037383178 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.20093457943925233 * (double)IMAGE_WIDTH, 0.8130841121495327 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.8317757009345794 * (double)IMAGE_WIDTH, 0.8130841121495327 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.8317757009345794 * (double)IMAGE_WIDTH, 0.8411214953271028 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.20093457943925233 * (double)IMAGE_WIDTH, 0.8411214953271028 * (double)IMAGE_HEIGHT);
                POINTER.closePath();
                G2.setColor(SHADOW_COLOR);
                G2.fill(POINTER);
            }
        }
        G2.dispose();
        return IMAGE;
    }

    private BufferedImage create_POSTS_Image(int WIDTH, BufferedImage image) {
        if (WIDTH <= 0) {
            return null;
        }
        if (image == null) {
            image = UTIL.createImage(WIDTH, WIDTH, 3);
        }
        Graphics2D G2 = image.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int IMAGE_WIDTH = image.getWidth();
        int IMAGE_HEIGHT = image.getHeight();
        this.transformGraphics(IMAGE_WIDTH, IMAGE_HEIGHT, G2);
        if (this.getPostsVisible()) {
            if (this.getOrientation() == Orientation.NORTH_EAST || this.getOrientation() == Orientation.NORTH_WEST) {
                Color[] MIN_POST_MAIN_COLORS;
                Ellipse2D.Double MIN_POST_FRAME = new Ellipse2D.Double((double)IMAGE_WIDTH * (double)0.1588785f, (double)IMAGE_HEIGHT * 0.836448609828949, (double)IMAGE_WIDTH * 0.03738318383693695, (double)IMAGE_HEIGHT * 0.03738313913345337);
                Point2D.Double MIN_POST_FRAME_START = new Point2D.Double(0.0, MIN_POST_FRAME.getBounds2D().getMinY());
                Point2D.Double MIN_POST_FRAME_STOP = new Point2D.Double(0.0, MIN_POST_FRAME.getBounds2D().getMaxY());
                float[] MIN_POST_FRAME_FRACTIONS = new float[]{0.0f, 0.46f, 1.0f};
                Color[] MIN_POST_FRAME_COLORS = new Color[]{new Color(180, 180, 180, 255), new Color(63, 63, 63, 255), new Color(40, 40, 40, 255)};
                LinearGradientPaint MIN_POST_FRAME_GRADIENT = new LinearGradientPaint(MIN_POST_FRAME_START, MIN_POST_FRAME_STOP, MIN_POST_FRAME_FRACTIONS, MIN_POST_FRAME_COLORS);
                G2.setPaint(MIN_POST_FRAME_GRADIENT);
                G2.fill(MIN_POST_FRAME);
                Ellipse2D.Double MIN_POST_MAIN = new Ellipse2D.Double((double)IMAGE_WIDTH * (double)0.1635514f, (double)IMAGE_HEIGHT * 0.84112149477005, (double)IMAGE_WIDTH * 0.028037384152412415, (double)IMAGE_HEIGHT * 0.02803736925125122);
                Point2D.Double MIN_POST_MAIN_START = new Point2D.Double(0.0, MIN_POST_MAIN.getBounds2D().getMinY());
                Point2D.Double MIN_POST_MAIN_STOP = new Point2D.Double(0.0, MIN_POST_MAIN.getBounds2D().getMaxY());
                float[] MIN_POST_MAIN_FRACTIONS = new float[]{0.0f, 0.5f, 1.0f};
                switch (this.getModel().getKnobStyle()) {
                    case BLACK: {
                        MIN_POST_MAIN_COLORS = new Color[]{new Color(0xBFBFBF), new Color(2828847), new Color(8224384)};
                        break;
                    }
                    case BRASS: {
                        MIN_POST_MAIN_COLORS = new Color[]{new Color(14667950), new Color(8019518), new Color(13614749)};
                        break;
                    }
                    default: {
                        MIN_POST_MAIN_COLORS = new Color[]{new Color(0xD7D7D7), new Color(0x747474), new Color(0xD7D7D7)};
                    }
                }
                LinearGradientPaint MIN_POST_MAIN_GRADIENT = new LinearGradientPaint(MIN_POST_MAIN_START, MIN_POST_MAIN_STOP, MIN_POST_MAIN_FRACTIONS, MIN_POST_MAIN_COLORS);
                G2.setPaint(MIN_POST_MAIN_GRADIENT);
                G2.fill(MIN_POST_MAIN);
            }
            if (this.getOrientation() == Orientation.SOUTH_EAST || this.getOrientation() == Orientation.SOUTH_WEST) {
                Color[] MIN_POST1_MAIN_COLORS;
                Ellipse2D.Double MIN_POST1_FRAME = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.8317757248878479, (double)IMAGE_HEIGHT * 0.1682243049144745, (double)IMAGE_WIDTH * 0.03738313913345337, (double)IMAGE_HEIGHT * 0.03738316893577576);
                Point2D.Double MIN_POST1_FRAME_START = new Point2D.Double(MIN_POST1_FRAME.getBounds2D().getMaxX(), 0.0);
                Point2D.Double MIN_POST1_FRAME_STOP = new Point2D.Double(MIN_POST1_FRAME.getBounds2D().getMinX(), 0.0);
                float[] MIN_POST1_FRAME_FRACTIONS = new float[]{0.0f, 0.46f, 1.0f};
                Color[] MIN_POST1_FRAME_COLORS = new Color[]{new Color(180, 180, 180, 255), new Color(63, 63, 63, 255), new Color(40, 40, 40, 255)};
                LinearGradientPaint MIN_POST1_FRAME_GRADIENT = new LinearGradientPaint(MIN_POST1_FRAME_START, MIN_POST1_FRAME_STOP, MIN_POST1_FRAME_FRACTIONS, MIN_POST1_FRAME_COLORS);
                G2.setPaint(MIN_POST1_FRAME_GRADIENT);
                G2.fill(MIN_POST1_FRAME);
                Ellipse2D.Double MIN_POST1_MAIN = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.836448609828949, (double)IMAGE_HEIGHT * 0.17289718985557556, (double)IMAGE_WIDTH * 0.02803736925125122, (double)IMAGE_HEIGHT * 0.028037384152412415);
                Point2D.Double MIN_POST1_MAIN_START = new Point2D.Double(MIN_POST1_MAIN.getBounds2D().getMaxX(), 0.0);
                Point2D.Double MIN_POST1_MAIN_STOP = new Point2D.Double(MIN_POST1_MAIN.getBounds2D().getMinX(), 0.0);
                float[] MIN_POST1_MAIN_FRACTIONS = new float[]{0.0f, 0.5f, 1.0f};
                switch (this.getModel().getKnobStyle()) {
                    case BLACK: {
                        MIN_POST1_MAIN_COLORS = new Color[]{new Color(0xBFBFBF), new Color(2828847), new Color(8224384)};
                        break;
                    }
                    case BRASS: {
                        MIN_POST1_MAIN_COLORS = new Color[]{new Color(14667950), new Color(8019518), new Color(13614749)};
                        break;
                    }
                    default: {
                        MIN_POST1_MAIN_COLORS = new Color[]{new Color(0xD7D7D7), new Color(0x747474), new Color(0xD7D7D7)};
                    }
                }
                LinearGradientPaint MIN_POST1_MAIN_GRADIENT = new LinearGradientPaint(MIN_POST1_MAIN_START, MIN_POST1_MAIN_STOP, MIN_POST1_MAIN_FRACTIONS, MIN_POST1_MAIN_COLORS);
                G2.setPaint(MIN_POST1_MAIN_GRADIENT);
                G2.fill(MIN_POST1_MAIN);
            }
        }
        switch (this.getKnobType()) {
            case SMALL_STD_KNOB: {
                Color[] CENTER_KNOB_MAIN_COLORS;
                Ellipse2D.Double CENTER_KNOB_FRAME = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.7850467562675476, (double)IMAGE_HEIGHT * 0.7850467562675476, (double)IMAGE_WIDTH * 0.08411210775375366, (double)IMAGE_HEIGHT * 0.08411210775375366);
                Point2D.Double CENTER_KNOB_FRAME_START = new Point2D.Double(0.0, CENTER_KNOB_FRAME.getBounds2D().getMinY());
                Point2D.Double CENTER_KNOB_FRAME_STOP = new Point2D.Double(0.0, CENTER_KNOB_FRAME.getBounds2D().getMaxY());
                float[] CENTER_KNOB_FRAME_FRACTIONS = new float[]{0.0f, 0.46f, 1.0f};
                Color[] CENTER_KNOB_FRAME_COLORS = new Color[]{new Color(180, 180, 180, 255), new Color(63, 63, 63, 255), new Color(40, 40, 40, 255)};
                LinearGradientPaint CENTER_KNOB_FRAME_GRADIENT = new LinearGradientPaint(CENTER_KNOB_FRAME_START, CENTER_KNOB_FRAME_STOP, CENTER_KNOB_FRAME_FRACTIONS, CENTER_KNOB_FRAME_COLORS);
                G2.setPaint(CENTER_KNOB_FRAME_GRADIENT);
                G2.fill(CENTER_KNOB_FRAME);
                Ellipse2D.Double CENTER_KNOB_MAIN = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.7943925261497498, (double)IMAGE_HEIGHT * 0.7943925261497498, (double)IMAGE_WIDTH * 0.06542056798934937, (double)IMAGE_HEIGHT * 0.06542056798934937);
                Point2D.Double CENTER_KNOB_MAIN_START = new Point2D.Double(0.0, CENTER_KNOB_MAIN.getBounds2D().getMinY());
                Point2D.Double CENTER_KNOB_MAIN_STOP = new Point2D.Double(0.0, CENTER_KNOB_MAIN.getBounds2D().getMaxY());
                float[] CENTER_KNOB_MAIN_FRACTIONS = new float[]{0.0f, 0.5f, 1.0f};
                switch (this.getModel().getKnobStyle()) {
                    case BLACK: {
                        CENTER_KNOB_MAIN_COLORS = new Color[]{new Color(0xBFBFBF), new Color(2828847), new Color(8224384)};
                        break;
                    }
                    case BRASS: {
                        CENTER_KNOB_MAIN_COLORS = new Color[]{new Color(14667950), new Color(8019518), new Color(13614749)};
                        break;
                    }
                    default: {
                        CENTER_KNOB_MAIN_COLORS = new Color[]{new Color(0xD7D7D7), new Color(0x747474), new Color(0xD7D7D7)};
                    }
                }
                LinearGradientPaint CENTER_KNOB_MAIN_GRADIENT = new LinearGradientPaint(CENTER_KNOB_MAIN_START, CENTER_KNOB_MAIN_STOP, CENTER_KNOB_MAIN_FRACTIONS, CENTER_KNOB_MAIN_COLORS);
                G2.setPaint(CENTER_KNOB_MAIN_GRADIENT);
                G2.fill(CENTER_KNOB_MAIN);
                Ellipse2D.Double CENTER_KNOB_INNERSHADOW = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.7943925261497498, (double)IMAGE_HEIGHT * 0.7943925261497498, (double)IMAGE_WIDTH * 0.06542056798934937, (double)IMAGE_HEIGHT * 0.06542056798934937);
                Point2D.Double CENTER_KNOB_INNERSHADOW_CENTER = new Point2D.Double(0.822429906542056 * (double)IMAGE_WIDTH, 0.8177570093457944 * (double)IMAGE_HEIGHT);
                float[] CENTER_KNOB_INNERSHADOW_FRACTIONS = new float[]{0.0f, 0.75f, 0.76f, 1.0f};
                Color[] CENTER_KNOB_INNERSHADOW_COLORS = new Color[]{new Color(0, 0, 0, 0), new Color(0, 0, 0, 0), new Color(0, 0, 0, 1), new Color(0, 0, 0, 51)};
                RadialGradientPaint CENTER_KNOB_INNERSHADOW_GRADIENT = new RadialGradientPaint(CENTER_KNOB_INNERSHADOW_CENTER, (float)(0.03271028037383177 * (double)IMAGE_WIDTH), CENTER_KNOB_INNERSHADOW_FRACTIONS, CENTER_KNOB_INNERSHADOW_COLORS);
                G2.setPaint(CENTER_KNOB_INNERSHADOW_GRADIENT);
                G2.fill(CENTER_KNOB_INNERSHADOW);
                break;
            }
            case BIG_STD_KNOB: {
                Color[] BIGCENTER_FOREGROUND_COLORS;
                Color[] BIGCENTER_FOREGROUNDFRAME_COLORS;
                Color[] BIGCENTER_BACKGROUND_COLORS;
                Color[] BIGCENTER_BACKGROUNDFRAME_COLORS;
                Ellipse2D.Double BIGCENTER_BACKGROUNDFRAME = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.7663551568984985, (double)IMAGE_HEIGHT * 0.7663551568984985, (double)IMAGE_WIDTH * 0.1214953064918518, (double)IMAGE_HEIGHT * 0.1214953064918518);
                Point2D.Double BIGCENTER_BACKGROUNDFRAME_START = new Point2D.Double(0.0, BIGCENTER_BACKGROUNDFRAME.getBounds2D().getMinY());
                Point2D.Double BIGCENTER_BACKGROUNDFRAME_STOP = new Point2D.Double(0.0, BIGCENTER_BACKGROUNDFRAME.getBounds2D().getMaxY());
                float[] BIGCENTER_BACKGROUNDFRAME_FRACTIONS = new float[]{0.0f, 1.0f};
                switch (this.getModel().getKnobStyle()) {
                    case BLACK: {
                        BIGCENTER_BACKGROUNDFRAME_COLORS = new Color[]{new Color(129, 133, 136, 255), new Color(61, 61, 73, 255)};
                        break;
                    }
                    case BRASS: {
                        BIGCENTER_BACKGROUNDFRAME_COLORS = new Color[]{new Color(143, 117, 80, 255), new Color(100, 76, 49, 255)};
                        break;
                    }
                    default: {
                        BIGCENTER_BACKGROUNDFRAME_COLORS = new Color[]{new Color(152, 152, 152, 255), new Color(118, 121, 126, 255)};
                    }
                }
                LinearGradientPaint BIGCENTER_BACKGROUNDFRAME_GRADIENT = new LinearGradientPaint(BIGCENTER_BACKGROUNDFRAME_START, BIGCENTER_BACKGROUNDFRAME_STOP, BIGCENTER_BACKGROUNDFRAME_FRACTIONS, BIGCENTER_BACKGROUNDFRAME_COLORS);
                G2.setPaint(BIGCENTER_BACKGROUNDFRAME_GRADIENT);
                G2.fill(BIGCENTER_BACKGROUNDFRAME);
                Ellipse2D.Double BIGCENTER_BACKGROUND = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.7710280418395996, (double)IMAGE_HEIGHT * 0.7710280418395996, (double)IMAGE_WIDTH * 0.11214953660964966, (double)IMAGE_HEIGHT * 0.11214953660964966);
                Point2D.Double BIGCENTER_BACKGROUND_START = new Point2D.Double(0.0, BIGCENTER_BACKGROUND.getBounds2D().getMinY());
                Point2D.Double BIGCENTER_BACKGROUND_STOP = new Point2D.Double(0.0, BIGCENTER_BACKGROUND.getBounds2D().getMaxY());
                float[] BIGCENTER_BACKGROUND_FRACTIONS = new float[]{0.0f, 1.0f};
                switch (this.getModel().getKnobStyle()) {
                    case BLACK: {
                        BIGCENTER_BACKGROUND_COLORS = new Color[]{new Color(26, 27, 32, 255), new Color(96, 97, 102, 255)};
                        break;
                    }
                    case BRASS: {
                        BIGCENTER_BACKGROUND_COLORS = new Color[]{new Color(98, 75, 49, 255), new Color(149, 109, 54, 255)};
                        break;
                    }
                    default: {
                        BIGCENTER_BACKGROUND_COLORS = new Color[]{new Color(118, 121, 126, 255), new Color(191, 191, 191, 255)};
                    }
                }
                LinearGradientPaint BIGCENTER_BACKGROUND_GRADIENT = new LinearGradientPaint(BIGCENTER_BACKGROUND_START, BIGCENTER_BACKGROUND_STOP, BIGCENTER_BACKGROUND_FRACTIONS, BIGCENTER_BACKGROUND_COLORS);
                G2.setPaint(BIGCENTER_BACKGROUND_GRADIENT);
                G2.fill(BIGCENTER_BACKGROUND);
                Ellipse2D.Double BIGCENTER_FOREGROUNDFRAME = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.7803738117218018, (double)IMAGE_HEIGHT * 0.7803738117218018, (double)IMAGE_WIDTH * 0.09345793724060059, (double)IMAGE_HEIGHT * 0.09345793724060059);
                Point2D.Double BIGCENTER_FOREGROUNDFRAME_START = new Point2D.Double(0.0, BIGCENTER_FOREGROUNDFRAME.getBounds2D().getMinY());
                Point2D.Double BIGCENTER_FOREGROUNDFRAME_STOP = new Point2D.Double(0.0, BIGCENTER_FOREGROUNDFRAME.getBounds2D().getMaxY());
                float[] BIGCENTER_FOREGROUNDFRAME_FRACTIONS = new float[]{0.0f, 0.47f, 1.0f};
                switch (this.getModel().getKnobStyle()) {
                    case BLACK: {
                        BIGCENTER_FOREGROUNDFRAME_COLORS = new Color[]{new Color(191, 191, 191, 255), new Color(56, 57, 61, 255), new Color(143, 144, 146, 255)};
                        break;
                    }
                    case BRASS: {
                        BIGCENTER_FOREGROUNDFRAME_COLORS = new Color[]{new Color(147, 108, 54, 255), new Color(82, 66, 50, 255), new Color(147, 108, 54, 255)};
                        break;
                    }
                    default: {
                        BIGCENTER_FOREGROUNDFRAME_COLORS = new Color[]{new Color(191, 191, 191, 255), new Color(116, 116, 116, 255), new Color(143, 144, 146, 255)};
                    }
                }
                LinearGradientPaint BIGCENTER_FOREGROUNDFRAME_GRADIENT = new LinearGradientPaint(BIGCENTER_FOREGROUNDFRAME_START, BIGCENTER_FOREGROUNDFRAME_STOP, BIGCENTER_FOREGROUNDFRAME_FRACTIONS, BIGCENTER_FOREGROUNDFRAME_COLORS);
                G2.setPaint(BIGCENTER_FOREGROUNDFRAME_GRADIENT);
                G2.fill(BIGCENTER_FOREGROUNDFRAME);
                Ellipse2D.Double BIGCENTER_FOREGROUND = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.7850467562675476, (double)IMAGE_HEIGHT * 0.7850467562675476, (double)IMAGE_WIDTH * 0.08411210775375366, (double)IMAGE_HEIGHT * 0.08411210775375366);
                Point2D.Double BIGCENTER_FOREGROUND_START = new Point2D.Double(0.0, BIGCENTER_FOREGROUND.getBounds2D().getMinY());
                Point2D.Double BIGCENTER_FOREGROUND_STOP = new Point2D.Double(0.0, BIGCENTER_FOREGROUND.getBounds2D().getMaxY());
                float[] BIGCENTER_FOREGROUND_FRACTIONS = new float[]{0.0f, 0.21f, 0.5f, 0.78f, 1.0f};
                switch (this.getModel().getKnobStyle()) {
                    case BLACK: {
                        BIGCENTER_FOREGROUND_COLORS = new Color[]{new Color(191, 191, 191, 255), new Color(94, 93, 99, 255), new Color(43, 42, 47, 255), new Color(78, 79, 81, 255), new Color(143, 144, 146, 255)};
                        break;
                    }
                    case BRASS: {
                        BIGCENTER_FOREGROUND_COLORS = new Color[]{new Color(223, 208, 174, 255), new Color(159, 136, 104, 255), new Color(122, 94, 62, 255), new Color(159, 136, 104, 255), new Color(223, 208, 174, 255)};
                        break;
                    }
                    default: {
                        BIGCENTER_FOREGROUND_COLORS = new Color[]{new Color(215, 215, 215, 255), new Color(139, 142, 145, 255), new Color(100, 100, 100, 255), new Color(139, 142, 145, 255), new Color(215, 215, 215, 255)};
                    }
                }
                LinearGradientPaint BIGCENTER_FOREGROUND_GRADIENT = new LinearGradientPaint(BIGCENTER_FOREGROUND_START, BIGCENTER_FOREGROUND_STOP, BIGCENTER_FOREGROUND_FRACTIONS, BIGCENTER_FOREGROUND_COLORS);
                G2.setPaint(BIGCENTER_FOREGROUND_GRADIENT);
                G2.fill(BIGCENTER_FOREGROUND);
                break;
            }
            case BIG_CHROME_KNOB: {
                Ellipse2D.Double CHROMEKNOB_BACKFRAME = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.7570093274116516, (double)IMAGE_HEIGHT * 0.7570093274116516, (double)IMAGE_WIDTH * (double)0.1401869f, (double)IMAGE_HEIGHT * (double)0.1401869f);
                Point2D.Double CHROMEKNOB_BACKFRAME_START = new Point2D.Double(0.7897196261682243 * (double)IMAGE_WIDTH, 0.7663551401869159 * (double)IMAGE_HEIGHT);
                Point2D.Double CHROMEKNOB_BACKFRAME_STOP = new Point2D.Double(0.8615311152465558 * (double)IMAGE_WIDTH, 0.8812775457408241 * (double)IMAGE_HEIGHT);
                float[] CHROMEKNOB_BACKFRAME_FRACTIONS = new float[]{0.0f, 1.0f};
                Color[] CHROMEKNOB_BACKFRAME_COLORS = new Color[]{new Color(129, 139, 140, 255), new Color(166, 171, 175, 255)};
                LinearGradientPaint CHROMEKNOB_BACKFRAME_GRADIENT = new LinearGradientPaint(CHROMEKNOB_BACKFRAME_START, CHROMEKNOB_BACKFRAME_STOP, CHROMEKNOB_BACKFRAME_FRACTIONS, CHROMEKNOB_BACKFRAME_COLORS);
                G2.setPaint(CHROMEKNOB_BACKFRAME_GRADIENT);
                G2.fill(CHROMEKNOB_BACKFRAME);
                Ellipse2D.Double CHROMEKNOB_BACK = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.7616822719573975, (double)IMAGE_HEIGHT * 0.7616822719573975, (double)IMAGE_WIDTH * 0.13084107637405396, (double)IMAGE_HEIGHT * 0.13084107637405396);
                Point2D.Double CHROMEKNOB_BACK_CENTER = new Point2D.Double(CHROMEKNOB_BACK.getCenterX(), CHROMEKNOB_BACK.getCenterY());
                float[] CHROMEKNOB_BACK_FRACTIONS = new float[]{0.0f, 0.09f, 0.12f, 0.16f, 0.25f, 0.29f, 0.33f, 0.38f, 0.48f, 0.52f, 0.65f, 0.69f, 0.8f, 0.83f, 0.87f, 0.97f, 1.0f};
                Color[] CHROMEKNOB_BACK_COLORS = new Color[]{new Color(255, 255, 255, 255), new Color(255, 255, 255, 255), new Color(136, 136, 138, 255), new Color(164, 185, 190, 255), new Color(158, 179, 182, 255), new Color(112, 112, 112, 255), new Color(221, 227, 227, 255), new Color(155, 176, 179, 255), new Color(156, 176, 177, 255), new Color(254, 255, 255, 255), new Color(255, 255, 255, 255), new Color(156, 180, 180, 255), new Color(198, 209, 211, 255), new Color(246, 248, 247, 255), new Color(204, 216, 216, 255), new Color(164, 188, 190, 255), new Color(255, 255, 255, 255)};
                ConicalGradientPaint CHROMEKNOB_BACK_GRADIENT = new ConicalGradientPaint(false, CHROMEKNOB_BACK_CENTER, 0.0f, CHROMEKNOB_BACK_FRACTIONS, CHROMEKNOB_BACK_COLORS);
                G2.setPaint(CHROMEKNOB_BACK_GRADIENT);
                G2.fill(CHROMEKNOB_BACK);
                Ellipse2D.Double CHROMEKNOB_FOREFRAME = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.7943925261497498, (double)IMAGE_HEIGHT * 0.7943925261497498, (double)IMAGE_WIDTH * 0.06542056798934937, (double)IMAGE_HEIGHT * 0.06542056798934937);
                Point2D.Double CHROMEKNOB_FOREFRAME_START = new Point2D.Double(0.8084112149532711 * (double)IMAGE_WIDTH, 0.7990654205607477 * (double)IMAGE_HEIGHT);
                Point2D.Double CHROMEKNOB_FOREFRAME_STOP = new Point2D.Double(0.8423808773136435 * (double)IMAGE_WIDTH, 0.8494275160897923 * (double)IMAGE_HEIGHT);
                float[] CHROMEKNOB_FOREFRAME_FRACTIONS = new float[]{0.0f, 1.0f};
                Color[] CHROMEKNOB_FOREFRAME_COLORS = new Color[]{new Color(225, 235, 232, 255), new Color(196, 207, 207, 255)};
                LinearGradientPaint CHROMEKNOB_FOREFRAME_GRADIENT = new LinearGradientPaint(CHROMEKNOB_FOREFRAME_START, CHROMEKNOB_FOREFRAME_STOP, CHROMEKNOB_FOREFRAME_FRACTIONS, CHROMEKNOB_FOREFRAME_COLORS);
                G2.setPaint(CHROMEKNOB_FOREFRAME_GRADIENT);
                G2.fill(CHROMEKNOB_FOREFRAME);
                Ellipse2D.Double CHROMEKNOB_FORE = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.7990654110908508, (double)IMAGE_HEIGHT * 0.7990654110908508, (double)IMAGE_WIDTH * 0.05607479810714722, (double)IMAGE_HEIGHT * 0.05607479810714722);
                Point2D.Double CHROMEKNOB_FORE_START = new Point2D.Double(0.8084112149532711 * (double)IMAGE_WIDTH, 0.8037383177570093 * (double)IMAGE_HEIGHT);
                Point2D.Double CHROMEKNOB_FORE_STOP = new Point2D.Double(0.8397678263628456 * (double)IMAGE_WIDTH, 0.8502264059376659 * (double)IMAGE_HEIGHT);
                float[] CHROMEKNOB_FORE_FRACTIONS = new float[]{0.0f, 1.0f};
                Color[] CHROMEKNOB_FORE_COLORS = new Color[]{new Color(237, 239, 237, 255), new Color(148, 161, 161, 255)};
                LinearGradientPaint CHROMEKNOB_FORE_GRADIENT = new LinearGradientPaint(CHROMEKNOB_FORE_START, CHROMEKNOB_FORE_STOP, CHROMEKNOB_FORE_FRACTIONS, CHROMEKNOB_FORE_COLORS);
                G2.setPaint(CHROMEKNOB_FORE_GRADIENT);
                G2.fill(CHROMEKNOB_FORE);
                break;
            }
            case METAL_KNOB: {
                Color[] METALKNOB_MAIN_COLORS;
                Ellipse2D.Double METALKNOB_FRAME = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.7897196412086487, (double)IMAGE_HEIGHT * 0.7850467562675476, (double)IMAGE_WIDTH * 0.08411210775375366, (double)IMAGE_HEIGHT * 0.08411210775375366);
                Point2D.Double METALKNOB_FRAME_START = new Point2D.Double(0.0, METALKNOB_FRAME.getBounds2D().getMinY());
                Point2D.Double METALKNOB_FRAME_STOP = new Point2D.Double(0.0, METALKNOB_FRAME.getBounds2D().getMaxY());
                float[] METALKNOB_FRAME_FRACTIONS = new float[]{0.0f, 0.47f, 1.0f};
                Color[] METALKNOB_FRAME_COLORS = new Color[]{new Color(92, 95, 101, 255), new Color(46, 49, 53, 255), new Color(22, 23, 26, 255)};
                LinearGradientPaint METALKNOB_FRAME_GRADIENT = new LinearGradientPaint(METALKNOB_FRAME_START, METALKNOB_FRAME_STOP, METALKNOB_FRAME_FRACTIONS, METALKNOB_FRAME_COLORS);
                G2.setPaint(METALKNOB_FRAME_GRADIENT);
                G2.fill(METALKNOB_FRAME);
                Ellipse2D.Double METALKNOB_MAIN = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.7943925261497498, (double)IMAGE_HEIGHT * 0.7897196412086487, (double)IMAGE_WIDTH * 0.07476633787155151, (double)IMAGE_HEIGHT * 0.07476633787155151);
                Point2D.Double METALKNOB_MAIN_START = new Point2D.Double(0.0, METALKNOB_MAIN.getBounds2D().getMinY());
                Point2D.Double METALKNOB_MAIN_STOP = new Point2D.Double(0.0, METALKNOB_MAIN.getBounds2D().getMaxY());
                float[] METALKNOB_MAIN_FRACTIONS = new float[]{0.0f, 1.0f};
                switch (this.getModel().getKnobStyle()) {
                    case BLACK: {
                        METALKNOB_MAIN_COLORS = new Color[]{new Color(2828847), new Color(1710880)};
                        break;
                    }
                    case BRASS: {
                        METALKNOB_MAIN_COLORS = new Color[]{new Color(9858614), new Color(8150845)};
                        break;
                    }
                    default: {
                        METALKNOB_MAIN_COLORS = new Color[]{new Color(204, 204, 204, 255), new Color(87, 92, 98, 255)};
                    }
                }
                LinearGradientPaint METALKNOB_MAIN_GRADIENT = new LinearGradientPaint(METALKNOB_MAIN_START, METALKNOB_MAIN_STOP, METALKNOB_MAIN_FRACTIONS, METALKNOB_MAIN_COLORS);
                G2.setPaint(METALKNOB_MAIN_GRADIENT);
                G2.fill(METALKNOB_MAIN);
                GeneralPath METALKNOB_LOWERHL = new GeneralPath();
                METALKNOB_LOWERHL.setWindingRule(0);
                METALKNOB_LOWERHL.moveTo((double)IMAGE_WIDTH * 0.8504672897196262, (double)IMAGE_HEIGHT * 0.8551401869158879);
                METALKNOB_LOWERHL.curveTo((double)IMAGE_WIDTH * 0.8504672897196262, (double)IMAGE_HEIGHT * 0.8457943925233645, (double)IMAGE_WIDTH * 0.8411214953271028, (double)IMAGE_HEIGHT * 0.8411214953271028, (double)IMAGE_WIDTH * 0.8317757009345794, (double)IMAGE_HEIGHT * 0.8411214953271028);
                METALKNOB_LOWERHL.curveTo((double)IMAGE_WIDTH * 0.8177570093457944, (double)IMAGE_HEIGHT * 0.8411214953271028, (double)IMAGE_WIDTH * 0.8084112149532711, (double)IMAGE_HEIGHT * 0.8457943925233645, (double)IMAGE_WIDTH * 0.8084112149532711, (double)IMAGE_HEIGHT * 0.8551401869158879);
                METALKNOB_LOWERHL.curveTo((double)IMAGE_WIDTH * 0.8130841121495327, (double)IMAGE_HEIGHT * 0.8598130841121495, (double)IMAGE_WIDTH * 0.822429906542056, (double)IMAGE_HEIGHT * 0.8644859813084113, (double)IMAGE_WIDTH * 0.8317757009345794, (double)IMAGE_HEIGHT * 0.8644859813084113);
                METALKNOB_LOWERHL.curveTo((double)IMAGE_WIDTH * 0.8364485981308412, (double)IMAGE_HEIGHT * 0.8644859813084113, (double)IMAGE_WIDTH * 0.8457943925233645, (double)IMAGE_HEIGHT * 0.8598130841121495, (double)IMAGE_WIDTH * 0.8504672897196262, (double)IMAGE_HEIGHT * 0.8551401869158879);
                METALKNOB_LOWERHL.closePath();
                Point2D.Double METALKNOB_LOWERHL_CENTER = new Point2D.Double(0.8317757009345794 * (double)IMAGE_WIDTH, 0.8644859813084113 * (double)IMAGE_HEIGHT);
                float[] METALKNOB_LOWERHL_FRACTIONS = new float[]{0.0f, 1.0f};
                Color[] METALKNOB_LOWERHL_COLORS = new Color[]{new Color(255, 255, 255, 153), new Color(255, 255, 255, 0)};
                RadialGradientPaint METALKNOB_LOWERHL_GRADIENT = new RadialGradientPaint(METALKNOB_LOWERHL_CENTER, (float)(0.03271028037383177 * (double)IMAGE_WIDTH), METALKNOB_LOWERHL_FRACTIONS, METALKNOB_LOWERHL_COLORS);
                G2.setPaint(METALKNOB_LOWERHL_GRADIENT);
                G2.fill(METALKNOB_LOWERHL);
                GeneralPath METALKNOB_UPPERHL = new GeneralPath();
                METALKNOB_UPPERHL.setWindingRule(0);
                METALKNOB_UPPERHL.moveTo((double)IMAGE_WIDTH * 0.8644859813084113, (double)IMAGE_HEIGHT * 0.8084112149532711);
                METALKNOB_UPPERHL.curveTo((double)IMAGE_WIDTH * 0.8598130841121495, (double)IMAGE_HEIGHT * 0.794392523364486, (double)IMAGE_WIDTH * 0.8457943925233645, (double)IMAGE_HEIGHT * 0.7850467289719626, (double)IMAGE_WIDTH * 0.8317757009345794, (double)IMAGE_HEIGHT * 0.7850467289719626);
                METALKNOB_UPPERHL.curveTo((double)IMAGE_WIDTH * 0.8130841121495327, (double)IMAGE_HEIGHT * 0.7850467289719626, (double)IMAGE_WIDTH * 0.7990654205607477, (double)IMAGE_HEIGHT * 0.794392523364486, (double)IMAGE_WIDTH * 0.794392523364486, (double)IMAGE_HEIGHT * 0.8084112149532711);
                METALKNOB_UPPERHL.curveTo((double)IMAGE_WIDTH * 0.7990654205607477, (double)IMAGE_HEIGHT * 0.8130841121495327, (double)IMAGE_WIDTH * 0.8130841121495327, (double)IMAGE_HEIGHT * 0.8177570093457944, (double)IMAGE_WIDTH * 0.8317757009345794, (double)IMAGE_HEIGHT * 0.8177570093457944);
                METALKNOB_UPPERHL.curveTo((double)IMAGE_WIDTH * 0.8457943925233645, (double)IMAGE_HEIGHT * 0.8177570093457944, (double)IMAGE_WIDTH * 0.8598130841121495, (double)IMAGE_HEIGHT * 0.8130841121495327, (double)IMAGE_WIDTH * 0.8644859813084113, (double)IMAGE_HEIGHT * 0.8084112149532711);
                METALKNOB_UPPERHL.closePath();
                Point2D.Double METALKNOB_UPPERHL_CENTER = new Point2D.Double(0.8271028037383178 * (double)IMAGE_WIDTH, 0.7850467289719626 * (double)IMAGE_HEIGHT);
                float[] METALKNOB_UPPERHL_FRACTIONS = new float[]{0.0f, 1.0f};
                Color[] METALKNOB_UPPERHL_COLORS = new Color[]{new Color(255, 255, 255, 191), new Color(255, 255, 255, 0)};
                RadialGradientPaint METALKNOB_UPPERHL_GRADIENT = new RadialGradientPaint(METALKNOB_UPPERHL_CENTER, (float)(0.04906542056074766 * (double)IMAGE_WIDTH), METALKNOB_UPPERHL_FRACTIONS, METALKNOB_UPPERHL_COLORS);
                G2.setPaint(METALKNOB_UPPERHL_GRADIENT);
                G2.fill(METALKNOB_UPPERHL);
                Ellipse2D.Double METALKNOB_INNERFRAME = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.8084112405776978, (double)IMAGE_HEIGHT * 0.8084112405776978, (double)IMAGE_WIDTH * 0.04205602407455444, (double)IMAGE_HEIGHT * 0.04205602407455444);
                Point2D.Double METALKNOB_INNERFRAME_START = new Point2D.Double(0.0, METALKNOB_INNERFRAME.getBounds2D().getMinY());
                Point2D.Double METALKNOB_INNERFRAME_STOP = new Point2D.Double(0.0, METALKNOB_INNERFRAME.getBounds2D().getMaxY());
                float[] METALKNOB_INNERFRAME_FRACTIONS = new float[]{0.0f, 1.0f};
                Color[] METALKNOB_INNERFRAME_COLORS = new Color[]{new Color(0, 0, 0, 255), new Color(204, 204, 204, 255)};
                LinearGradientPaint METALKNOB_INNERFRAME_GRADIENT = new LinearGradientPaint(METALKNOB_INNERFRAME_START, METALKNOB_INNERFRAME_STOP, METALKNOB_INNERFRAME_FRACTIONS, METALKNOB_INNERFRAME_COLORS);
                G2.setPaint(METALKNOB_INNERFRAME_GRADIENT);
                G2.fill(METALKNOB_INNERFRAME);
                Ellipse2D.Double METALKNOB_INNERBACKGROUND = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.8130841255187988, (double)IMAGE_HEIGHT * 0.8130841255187988, (double)IMAGE_WIDTH * 0.032710254192352295, (double)IMAGE_HEIGHT * 0.032710254192352295);
                Point2D.Double METALKNOB_INNERBACKGROUND_START = new Point2D.Double(0.0, METALKNOB_INNERBACKGROUND.getBounds2D().getMinY());
                Point2D.Double METALKNOB_INNERBACKGROUND_STOP = new Point2D.Double(0.0, METALKNOB_INNERBACKGROUND.getBounds2D().getMaxY());
                float[] METALKNOB_INNERBACKGROUND_FRACTIONS = new float[]{0.0f, 1.0f};
                Color[] METALKNOB_INNERBACKGROUND_COLORS = new Color[]{new Color(1, 6, 11, 255), new Color(50, 52, 56, 255)};
                LinearGradientPaint METALKNOB_INNERBACKGROUND_GRADIENT = new LinearGradientPaint(METALKNOB_INNERBACKGROUND_START, METALKNOB_INNERBACKGROUND_STOP, METALKNOB_INNERBACKGROUND_FRACTIONS, METALKNOB_INNERBACKGROUND_COLORS);
                G2.setPaint(METALKNOB_INNERBACKGROUND_GRADIENT);
                G2.fill(METALKNOB_INNERBACKGROUND);
            }
        }
        G2.dispose();
        return image;
    }

    private BufferedImage create_FOREGROUND_Image(int WIDTH, BufferedImage image) {
        if (WIDTH <= 0) {
            return null;
        }
        if (image == null) {
            image = UTIL.createImage(WIDTH, WIDTH, 3);
        }
        Graphics2D G2 = image.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int IMAGE_WIDTH = image.getWidth();
        int IMAGE_HEIGHT = image.getHeight();
        this.transformGraphics(IMAGE_WIDTH, IMAGE_HEIGHT, G2);
        if (this.getOrientation() == Orientation.NORTH_EAST || this.getOrientation() == Orientation.NORTH_WEST) {
            GeneralPath HIGHLIGHT = new GeneralPath();
            HIGHLIGHT.setWindingRule(0);
            HIGHLIGHT.moveTo((double)IMAGE_WIDTH * 0.9158878504672897, (double)IMAGE_HEIGHT * 0.3925233644859813);
            HIGHLIGHT.curveTo((double)IMAGE_WIDTH * 0.9158878504672897, (double)IMAGE_HEIGHT * 0.35514018691588783, (double)IMAGE_WIDTH * 0.9158878504672897, (double)IMAGE_HEIGHT * 0.08411214953271028, (double)IMAGE_WIDTH * 0.9158878504672897, (double)IMAGE_HEIGHT * 0.08411214953271028);
            HIGHLIGHT.curveTo((double)IMAGE_WIDTH * 0.7710280373831776, (double)IMAGE_HEIGHT * 0.08411214953271028, (double)IMAGE_WIDTH * 0.5887850467289719, (double)IMAGE_HEIGHT * 0.102803738317757, (double)IMAGE_WIDTH * 0.4392523364485981, (double)IMAGE_HEIGHT * 0.205607476635514);
            HIGHLIGHT.curveTo((double)IMAGE_WIDTH * 0.3037383177570093, (double)IMAGE_HEIGHT * 0.29439252336448596, (double)IMAGE_WIDTH * 0.22429906542056074, (double)IMAGE_HEIGHT * 0.37850467289719625, (double)IMAGE_WIDTH * 0.1542056074766355, (double)IMAGE_HEIGHT * 0.5420560747663551);
            HIGHLIGHT.curveTo((double)IMAGE_WIDTH * 0.49065420560747663, (double)IMAGE_HEIGHT * 0.3691588785046729, (double)IMAGE_WIDTH * 0.794392523364486, (double)IMAGE_HEIGHT * 0.38317757009345793, (double)IMAGE_WIDTH * 0.9158878504672897, (double)IMAGE_HEIGHT * 0.3925233644859813);
            HIGHLIGHT.closePath();
            Point2D.Double HIGHLIGHT_START = new Point2D.Double(0.0, HIGHLIGHT.getBounds2D().getMinY());
            Point2D.Double HIGHLIGHT_STOP = new Point2D.Double(0.0, HIGHLIGHT.getBounds2D().getMaxY());
            float[] HIGHLIGHT_FRACTIONS = new float[]{0.0f, 1.0f};
            Color[] HIGHLIGHT_COLORS = new Color[]{new Color(255, 255, 255, 63), new Color(255, 255, 255, 12)};
            LinearGradientPaint HIGHLIGHT_GRADIENT = new LinearGradientPaint(HIGHLIGHT_START, HIGHLIGHT_STOP, HIGHLIGHT_FRACTIONS, HIGHLIGHT_COLORS);
            G2.setPaint(HIGHLIGHT_GRADIENT);
            G2.fill(HIGHLIGHT);
        } else {
            GeneralPath HIGHLIGHT_FLIPPED = new GeneralPath();
            HIGHLIGHT_FLIPPED.setWindingRule(0);
            HIGHLIGHT_FLIPPED.moveTo((double)IMAGE_WIDTH * 0.9158878504672897, (double)IMAGE_HEIGHT * 0.9158878504672897);
            HIGHLIGHT_FLIPPED.curveTo((double)IMAGE_WIDTH * 0.9158878504672897, (double)IMAGE_HEIGHT * 0.9158878504672897, (double)IMAGE_WIDTH * 0.9158878504672897, (double)IMAGE_HEIGHT * 0.5560747663551402, (double)IMAGE_WIDTH * 0.9158878504672897, (double)IMAGE_HEIGHT * 0.5560747663551402);
            HIGHLIGHT_FLIPPED.curveTo((double)IMAGE_WIDTH * 0.5841121495327103, (double)IMAGE_HEIGHT * 0.5327102803738317, (double)IMAGE_WIDTH * 0.22897196261682243, (double)IMAGE_HEIGHT * 0.6308411214953271, (double)IMAGE_WIDTH * 0.08411214953271028, (double)IMAGE_HEIGHT * 0.9158878504672897);
            HIGHLIGHT_FLIPPED.curveTo((double)IMAGE_WIDTH * 0.08411214953271028, (double)IMAGE_HEIGHT * 0.9158878504672897, (double)IMAGE_WIDTH * 0.9158878504672897, (double)IMAGE_HEIGHT * 0.9158878504672897, (double)IMAGE_WIDTH * 0.9158878504672897, (double)IMAGE_HEIGHT * 0.9158878504672897);
            HIGHLIGHT_FLIPPED.closePath();
            Point2D.Double HIGHLIGHT_FLIPPED_START = new Point2D.Double(0.0, HIGHLIGHT_FLIPPED.getBounds2D().getMaxY());
            Point2D.Double HIGHLIGHT_FLIPPED_STOP = new Point2D.Double(0.0, HIGHLIGHT_FLIPPED.getBounds2D().getMinY());
            float[] HIGHLIGHT_FLIPPED_FRACTIONS = new float[]{0.0f, 1.0f};
            Color[] HIGHLIGHT_FLIPPED_COLORS = new Color[]{new Color(255, 255, 255, 63), new Color(255, 255, 255, 12)};
            LinearGradientPaint HIGHLIGHT_FLIPPED_GRADIENT = new LinearGradientPaint(HIGHLIGHT_FLIPPED_START, HIGHLIGHT_FLIPPED_STOP, HIGHLIGHT_FLIPPED_FRACTIONS, HIGHLIGHT_FLIPPED_COLORS);
            G2.setPaint(HIGHLIGHT_FLIPPED_GRADIENT);
            G2.fill(HIGHLIGHT_FLIPPED);
        }
        G2.dispose();
        return image;
    }

    private BufferedImage create_GLOW_Image(int WIDTH, Color GLOW_COLOR, boolean ON) {
        if (WIDTH <= 0) {
            return null;
        }
        BufferedImage IMAGE = UTIL.createImage(WIDTH, WIDTH, 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        int IMAGE_WIDTH = IMAGE.getWidth();
        int IMAGE_HEIGHT = IMAGE.getHeight();
        GeneralPath GLOWRING = new GeneralPath();
        GLOWRING.setWindingRule(0);
        GLOWRING.moveTo((double)IMAGE_WIDTH * 0.8925233644859814, (double)IMAGE_HEIGHT * 0.8925233644859814);
        GLOWRING.curveTo((double)IMAGE_WIDTH * 0.8925233644859814, (double)IMAGE_HEIGHT * 0.8925233644859814, (double)IMAGE_WIDTH * 0.10747663551401869, (double)IMAGE_HEIGHT * 0.8925233644859814, (double)IMAGE_WIDTH * 0.10747663551401869, (double)IMAGE_HEIGHT * 0.8925233644859814);
        GLOWRING.curveTo((double)IMAGE_WIDTH * 0.10747663551401869, (double)IMAGE_HEIGHT * 0.6588785046728972, (double)IMAGE_WIDTH * 0.19626168224299065, (double)IMAGE_HEIGHT * 0.4532710280373832, (double)IMAGE_WIDTH * 0.308411214953271, (double)IMAGE_HEIGHT * 0.3411214953271028);
        GLOWRING.curveTo((double)IMAGE_WIDTH * 0.4672897196261682, (double)IMAGE_HEIGHT * 0.17757009345794392, (double)IMAGE_WIDTH * 0.6308411214953271, (double)IMAGE_HEIGHT * 0.10747663551401869, (double)IMAGE_WIDTH * 0.8925233644859814, (double)IMAGE_HEIGHT * 0.10747663551401869);
        GLOWRING.curveTo((double)IMAGE_WIDTH * 0.8925233644859814, (double)IMAGE_HEIGHT * 0.10747663551401869, (double)IMAGE_WIDTH * 0.8925233644859814, (double)IMAGE_HEIGHT * 0.8925233644859814, (double)IMAGE_WIDTH * 0.8925233644859814, (double)IMAGE_HEIGHT * 0.8925233644859814);
        GLOWRING.closePath();
        GLOWRING.moveTo((double)IMAGE_WIDTH * 0.9158878504672897, (double)IMAGE_HEIGHT * 0.9158878504672897);
        GLOWRING.curveTo((double)IMAGE_WIDTH * 0.9158878504672897, (double)IMAGE_HEIGHT * 0.9158878504672897, (double)IMAGE_WIDTH * 0.9158878504672897, (double)IMAGE_HEIGHT * 0.08411214953271028, (double)IMAGE_WIDTH * 0.9158878504672897, (double)IMAGE_HEIGHT * 0.08411214953271028);
        GLOWRING.curveTo((double)IMAGE_WIDTH * 0.6401869158878505, (double)IMAGE_HEIGHT * 0.08411214953271028, (double)IMAGE_WIDTH * 0.46261682242990654, (double)IMAGE_HEIGHT * 0.1588785046728972, (double)IMAGE_WIDTH * 0.29439252336448596, (double)IMAGE_HEIGHT * 0.32242990654205606);
        GLOWRING.curveTo((double)IMAGE_WIDTH * 0.17289719626168223, (double)IMAGE_HEIGHT * 0.4439252336448598, (double)IMAGE_WIDTH * 0.08411214953271028, (double)IMAGE_HEIGHT * 0.6635514018691588, (double)IMAGE_WIDTH * 0.08411214953271028, (double)IMAGE_HEIGHT * 0.9158878504672897);
        GLOWRING.curveTo((double)IMAGE_WIDTH * 0.08411214953271028, (double)IMAGE_HEIGHT * 0.9158878504672897, (double)IMAGE_WIDTH * 0.9158878504672897, (double)IMAGE_HEIGHT * 0.9158878504672897, (double)IMAGE_WIDTH * 0.9158878504672897, (double)IMAGE_HEIGHT * 0.9158878504672897);
        GLOWRING.closePath();
        if (!ON) {
            Point2D.Double GLOWRING_OFF_START = new Point2D.Double(0.3037383177570093 * (double)IMAGE_WIDTH, 0.3037383177570093 * (double)IMAGE_HEIGHT);
            Point2D.Double GLOWRING_OFF_STOP = new Point2D.Double(0.901805268199837 * (double)IMAGE_WIDTH, 0.9018052681998369 * (double)IMAGE_HEIGHT);
            float[] GLOWRING_OFF_FRACTIONS = new float[]{0.0f, 0.19f, 0.2f, 0.39f, 0.4f, 0.64f, 0.65f, 0.82f, 1.0f};
            Color[] GLOWRING_OFF_COLORS = new Color[]{new Color(204, 204, 204, 102), new Color(255, 255, 255, 102), new Color(250, 250, 250, 102), new Color(158, 158, 158, 102), new Color(153, 153, 153, 102), new Color(202, 202, 202, 102), new Color(204, 204, 204, 102), new Color(255, 255, 255, 102), new Color(153, 153, 153, 102)};
            LinearGradientPaint GLOWRING_OFF_GRADIENT = new LinearGradientPaint(GLOWRING_OFF_START, GLOWRING_OFF_STOP, GLOWRING_OFF_FRACTIONS, GLOWRING_OFF_COLORS);
            G2.setPaint(GLOWRING_OFF_GRADIENT);
            G2.fill(GLOWRING);
        } else {
            G2.translate(-10, -10);
            G2.drawImage((Image)Shadow.INSTANCE.createDropShadow(GLOWRING, GLOW_COLOR, GLOW_COLOR, true, null, null, 0, 1.0f, 10, 315, GLOW_COLOR), GLOWRING.getBounds().x, GLOWRING.getBounds().y, null);
            G2.translate(10, 10);
            Point2D.Double GLOWRING_HL_START = new Point2D.Double(0.3037383177570093 * (double)IMAGE_WIDTH, 0.3037383177570093 * (double)IMAGE_HEIGHT);
            Point2D.Double GLOWRING_HL_STOP = new Point2D.Double(0.901805268199837 * (double)IMAGE_WIDTH, 0.9018052681998369 * (double)IMAGE_HEIGHT);
            float[] GLOWRING_HL_FRACTIONS = new float[]{0.0f, 0.26f, 0.42f, 0.42009997f, 0.56f, 0.5601f, 0.96f, 0.9601f, 1.0f};
            Color[] GLOWRING_HL_COLORS = new Color[]{new Color(255, 255, 255, 0), new Color(255, 255, 255, 63), new Color(255, 255, 255, 102), new Color(255, 255, 255, 98), new Color(255, 255, 255, 3), new Color(255, 255, 255, 0), new Color(255, 255, 255, 0), new Color(255, 255, 255, 0), new Color(255, 255, 255, 102)};
            LinearGradientPaint GLOWRING_HL_GRADIENT = new LinearGradientPaint(GLOWRING_HL_START, GLOWRING_HL_STOP, GLOWRING_HL_FRACTIONS, GLOWRING_HL_COLORS);
            G2.setPaint(GLOWRING_HL_GRADIENT);
            G2.fill(GLOWRING);
        }
        G2.dispose();
        return IMAGE;
    }

    @Override
    protected BufferedImage create_DISABLED_Image(int WIDTH) {
        if (WIDTH <= 0) {
            return null;
        }
        BufferedImage IMAGE = UTIL.createImage(WIDTH, WIDTH, 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int IMAGE_WIDTH = IMAGE.getWidth();
        int IMAGE_HEIGHT = IMAGE.getHeight();
        this.transformGraphics(IMAGE_WIDTH, IMAGE_HEIGHT, G2);
        GeneralPath BACKGROUND = new GeneralPath();
        BACKGROUND.setWindingRule(0);
        BACKGROUND.moveTo((double)IMAGE_WIDTH * 0.9158878504672897, (double)IMAGE_HEIGHT * 0.9158878504672897);
        BACKGROUND.curveTo((double)IMAGE_WIDTH * 0.9158878504672897, (double)IMAGE_HEIGHT * 0.9158878504672897, (double)IMAGE_WIDTH * 0.9158878504672897, (double)IMAGE_HEIGHT * 0.08411214953271028, (double)IMAGE_WIDTH * 0.9158878504672897, (double)IMAGE_HEIGHT * 0.08411214953271028);
        BACKGROUND.curveTo((double)IMAGE_WIDTH * 0.6401869158878505, (double)IMAGE_HEIGHT * 0.08411214953271028, (double)IMAGE_WIDTH * 0.46261682242990654, (double)IMAGE_HEIGHT * 0.1588785046728972, (double)IMAGE_WIDTH * 0.29439252336448596, (double)IMAGE_HEIGHT * 0.32242990654205606);
        BACKGROUND.curveTo((double)IMAGE_WIDTH * 0.17289719626168223, (double)IMAGE_HEIGHT * 0.4439252336448598, (double)IMAGE_WIDTH * 0.08411214953271028, (double)IMAGE_HEIGHT * 0.6635514018691588, (double)IMAGE_WIDTH * 0.08411214953271028, (double)IMAGE_HEIGHT * 0.9158878504672897);
        BACKGROUND.curveTo((double)IMAGE_WIDTH * 0.08411214953271028, (double)IMAGE_HEIGHT * 0.9158878504672897, (double)IMAGE_WIDTH * 0.9158878504672897, (double)IMAGE_HEIGHT * 0.9158878504672897, (double)IMAGE_WIDTH * 0.9158878504672897, (double)IMAGE_HEIGHT * 0.9158878504672897);
        BACKGROUND.closePath();
        G2.setColor(new Color(102, 102, 102, 178));
        G2.fill(BACKGROUND);
        G2.dispose();
        return IMAGE;
    }

    @Override
    public String toString() {
        return "Radial1Square";
    }
}

