/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.gauges;

import eu.hansolo.steelseries.gauges.AbstractGauge;
import eu.hansolo.steelseries.gauges.AbstractRadial;
import eu.hansolo.steelseries.tools.ColorDef;
import eu.hansolo.steelseries.tools.CustomColorDef;
import eu.hansolo.steelseries.tools.GaugeType;
import eu.hansolo.steelseries.tools.Model;
import eu.hansolo.steelseries.tools.Orientation;
import eu.hansolo.steelseries.tools.PointerType;
import eu.hansolo.steelseries.tools.PostPosition;
import eu.hansolo.steelseries.tools.Section;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public final class Radial1Vertical
extends AbstractRadial {
    private static final int BASE = 10;
    private final Point2D CENTER = new Point2D.Double();
    private final Point2D TRACK_OFFSET = new Point2D.Double();
    private BufferedImage bImage;
    private BufferedImage fImage;
    private BufferedImage glowImageOff;
    private BufferedImage glowImageOn;
    private BufferedImage postsImage;
    private BufferedImage trackImage;
    private BufferedImage tickmarksImage;
    private BufferedImage pointerImage;
    private BufferedImage pointerShadowImage;
    private BufferedImage thresholdImage;
    private BufferedImage minMeasuredImage;
    private BufferedImage maxMeasuredImage;
    private BufferedImage disabledImage;
    private double angle = 0.0;

    public Radial1Vertical() {
        this.setLedPosition(0.455, 0.51);
        this.setUserLedPosition(0.455, 0.58);
        this.setOrientation(Orientation.NORTH);
        this.setGaugeType(GaugeType.TYPE5);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
    }

    public Radial1Vertical(Model MODEL) {
        this.setModel(MODEL);
        this.setGaugeType(GaugeType.TYPE5);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
    }

    @Override
    public final AbstractGauge init(int WIDTH, int HEIGHT) {
        int GAUGE_HEIGHT;
        int GAUGE_WIDTH = this.isFrameVisible() ? WIDTH : this.getGaugeBounds().width;
        int n = GAUGE_HEIGHT = this.isFrameVisible() ? HEIGHT : this.getGaugeBounds().height;
        if (GAUGE_WIDTH <= 1 || GAUGE_HEIGHT <= 1) {
            return this;
        }
        this.CENTER.setLocation(this.getGaugeBounds().getCenterX() - (double)this.getInsets().left, (double)this.getGaugeBounds().height * 0.73 - (double)this.getInsets().top);
        if (!this.isFrameVisible()) {
            this.setFramelessOffset((double)(-this.getGaugeBounds().width) * 0.0841121495, (double)(-this.getGaugeBounds().width) * 0.0841121495);
        } else {
            this.setFramelessOffset(this.getGaugeBounds().x, this.getGaugeBounds().y);
        }
        if (this.bImage != null) {
            this.bImage.flush();
        }
        this.bImage = UTIL.createImage(GAUGE_WIDTH, GAUGE_WIDTH, 3);
        if (this.fImage != null) {
            this.fImage.flush();
        }
        this.fImage = UTIL.createImage(GAUGE_WIDTH, GAUGE_WIDTH, 3);
        if (this.isFrameVisible()) {
            switch (this.getFrameType()) {
                case ROUND: {
                    FRAME_FACTORY.createRadialFrame(GAUGE_WIDTH, this.getFrameDesign(), this.getCustomFrameDesign(), this.getFrameBaseColor(), this.isFrameBaseColorEnabled(), this.getFrameEffect(), this.bImage);
                    break;
                }
                case SQUARE: {
                    FRAME_FACTORY.createLinearFrame(GAUGE_WIDTH, GAUGE_WIDTH, this.getFrameDesign(), this.getCustomFrameDesign(), this.getFrameBaseColor(), this.isFrameBaseColorEnabled(), this.getFrameEffect(), this.bImage);
                    break;
                }
                default: {
                    FRAME_FACTORY.createRadialFrame(GAUGE_WIDTH, this.getFrameDesign(), this.getCustomFrameDesign(), this.getFrameBaseColor(), this.isFrameBaseColorEnabled(), this.getFrameEffect(), this.bImage);
                }
            }
        }
        if (this.isBackgroundVisible()) {
            this.create_BACKGROUND_Image(GAUGE_WIDTH, "", "", this.bImage);
        }
        if (this.isGlowVisible()) {
            if (this.glowImageOff != null) {
                this.glowImageOff.flush();
            }
            this.glowImageOff = this.create_GLOW_Image(GAUGE_WIDTH, this.getGlowColor(), false, this.getGaugeType(), true, this.getOrientation());
            if (this.glowImageOn != null) {
                this.glowImageOn.flush();
            }
            this.glowImageOn = this.create_GLOW_Image(GAUGE_WIDTH, this.getGlowColor(), true, this.getGaugeType(), true, this.getOrientation());
        } else {
            this.setGlowPulsating(false);
        }
        if (this.postsImage != null) {
            this.postsImage.flush();
        }
        this.postsImage = this.getPostsVisible() ? this.create_POSTS_Image(GAUGE_WIDTH, PostPosition.LOWER_CENTER, PostPosition.SMALL_GAUGE_MIN_LEFT, PostPosition.SMALL_GAUGE_MAX_RIGHT) : this.create_POSTS_Image(GAUGE_WIDTH, PostPosition.LOWER_CENTER);
        if (this.trackImage != null) {
            this.trackImage.flush();
        }
        this.TRACK_OFFSET.setLocation(0.0, 0.0);
        this.trackImage = this.create_TRACK_Image(GAUGE_WIDTH, 1.5707963267948966, this.getTickmarkOffset() - 0.7853981633974483, this.getMinValue(), this.getMaxValue(), this.getAngleStep(), this.getTrackStart(), this.getTrackSection(), this.getTrackStop(), this.getTrackStartColor(), this.getTrackSectionColor(), this.getTrackStopColor(), 0.44f, this.CENTER, this.getTickmarkDirection(), this.TRACK_OFFSET);
        if (this.tickmarksImage != null) {
            this.tickmarksImage.flush();
        }
        this.tickmarksImage = TICKMARK_FACTORY.create_RADIAL_TICKMARKS_Image(GAUGE_WIDTH, this.getModel().getNiceMinValue(), this.getModel().getNiceMaxValue(), this.getModel().getMaxNoOfMinorTicks(), this.getModel().getMaxNoOfMajorTicks(), this.getModel().getMinorTickSpacing(), this.getModel().getMajorTickSpacing(), this.getGaugeType(), this.getMinorTickmarkType(), this.getMajorTickmarkType(), this.isTickmarksVisible(), this.isTicklabelsVisible(), this.getModel().isMinorTickmarksVisible(), this.getModel().isMajorTickmarksVisible(), this.getLabelNumberFormat(), this.isTickmarkSectionsVisible(), this.getBackgroundColor(), this.getTickmarkColor(), this.isTickmarkColorFromThemeEnabled(), this.getTickmarkSections(), this.isSectionTickmarksOnly(), this.getSections(), 0.44f, -0.04f, this.CENTER, new Point2D.Double(0.0, 0.0), this.getOrientation(), this.getModel().getTicklabelOrientation(), this.getModel().isNiceScale(), this.getModel().isLogScale(), null);
        if (this.pointerImage != null) {
            this.pointerImage.flush();
        }
        this.pointerImage = this.create_POINTER_Image(GAUGE_WIDTH, this.getPointerType());
        if (this.pointerShadowImage != null) {
            this.pointerShadowImage.flush();
        }
        this.pointerShadowImage = this.getModel().isPointerShadowVisible() ? this.create_POINTER_SHADOW_Image(GAUGE_WIDTH, this.getPointerType()) : null;
        if (this.thresholdImage != null) {
            this.thresholdImage.flush();
        }
        this.thresholdImage = this.create_THRESHOLD_Image(GAUGE_WIDTH);
        if (this.minMeasuredImage != null) {
            this.minMeasuredImage.flush();
        }
        this.minMeasuredImage = this.create_MEASURED_VALUE_Image(GAUGE_WIDTH, new Color(0, 23, 252, 255));
        if (this.maxMeasuredImage != null) {
            this.maxMeasuredImage.flush();
        }
        this.maxMeasuredImage = this.create_MEASURED_VALUE_Image(GAUGE_WIDTH, new Color(252, 29, 0, 255));
        if (this.isForegroundVisible()) {
            switch (this.getFrameType()) {
                case SQUARE: {
                    FOREGROUND_FACTORY.createLinearForeground(GAUGE_WIDTH, GAUGE_WIDTH, false, this.fImage);
                    break;
                }
                default: {
                    FOREGROUND_FACTORY.createRadialForeground(GAUGE_WIDTH, false, this.getForegroundType(), this.fImage);
                }
            }
        }
        if (this.disabledImage != null) {
            this.disabledImage.flush();
        }
        this.disabledImage = this.create_DISABLED_Image(GAUGE_WIDTH);
        this.CENTER.setLocation(this.getGaugeBounds().getCenterX(), this.getGaugeBounds().getCenterY());
        if (!this.getAreas().isEmpty()) {
            this.createAreas(this.bImage);
        }
        if (!this.getSections().isEmpty()) {
            this.createSections(this.bImage);
        }
        this.setCurrentLedImage(this.getLedImageOff());
        return this;
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (!this.isInitialized()) {
            return;
        }
        Graphics2D G2 = (Graphics2D)g.create();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        G2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        G2.translate(this.getFramelessOffset().getX(), this.getFramelessOffset().getY());
        AffineTransform OLD_TRANSFORM = G2.getTransform();
        G2.drawImage((Image)this.bImage, 0, 0, null);
        if (this.isHighlightArea()) {
            switch (this.getOrientation()) {
                case EAST: {
                    break;
                }
                case SOUTH: {
                    break;
                }
                case WEST: {
                    G2.translate(this.CENTER.getX() / 2.2, 0.0);
                    break;
                }
                default: {
                    G2.translate(0.0, this.CENTER.getY() / 2.2);
                }
            }
            for (Section area : this.getAreas()) {
                if (!area.contains(this.getValue())) continue;
                G2.setColor(area.getHighlightColor());
                G2.fill(area.getFilledArea());
                break;
            }
            G2.setTransform(OLD_TRANSFORM);
        }
        if (this.isHighlightSection()) {
            switch (this.getOrientation()) {
                case EAST: {
                    break;
                }
                case SOUTH: {
                    break;
                }
                case WEST: {
                    G2.translate(this.CENTER.getX() / 2.2, 0.0);
                    break;
                }
                default: {
                    G2.translate(0.0, this.CENTER.getY() / 2.2);
                }
            }
            for (Section section : this.getSections()) {
                if (!section.contains(this.getValue())) continue;
                G2.setColor(section.getHighlightColor());
                G2.fill(section.getSectionArea());
                break;
            }
            G2.setTransform(OLD_TRANSFORM);
        }
        FontRenderContext RENDER_CONTEXT = new FontRenderContext(null, true, true);
        if (!this.getTitle().isEmpty()) {
            if (this.isLabelColorFromThemeEnabled()) {
                G2.setColor(this.getBackgroundColor().LABEL_COLOR);
            } else {
                G2.setColor(this.getLabelColor());
            }
            G2.setFont(new Font("Verdana", 0, (int)(0.04672897196261682 * (double)this.getGaugeBounds().width)));
            TextLayout TITLE_LAYOUT = new TextLayout(this.getTitle(), G2.getFont(), RENDER_CONTEXT);
            Rectangle2D TITLE_BOUNDARY = TITLE_LAYOUT.getBounds();
            G2.drawString(this.getTitle(), (float)(((double)this.getGaugeBounds().width - TITLE_BOUNDARY.getWidth()) / 2.0), 0.4f * (float)this.getGaugeBounds().width + TITLE_LAYOUT.getAscent() - TITLE_LAYOUT.getDescent());
        }
        if (!this.getUnitString().isEmpty()) {
            if (this.isLabelColorFromThemeEnabled()) {
                G2.setColor(this.getBackgroundColor().LABEL_COLOR);
            } else {
                G2.setColor(this.getLabelColor());
            }
            G2.setFont(new Font("Verdana", 0, (int)(0.04672897196261682 * (double)this.getGaugeBounds().width)));
            TextLayout UNIT_LAYOUT = new TextLayout(this.getUnitString(), G2.getFont(), RENDER_CONTEXT);
            Rectangle2D UNIT_BOUNDARY = UNIT_LAYOUT.getBounds();
            G2.drawString(this.getUnitString(), (float)(((double)this.getGaugeBounds().width - UNIT_BOUNDARY.getWidth()) / 2.0), 0.47f * (float)this.getGaugeBounds().width + UNIT_LAYOUT.getAscent() - UNIT_LAYOUT.getDescent());
        }
        switch (this.getOrientation()) {
            case NORTH: {
                break;
            }
            case EAST: {
                break;
            }
            case SOUTH: {
                break;
            }
            case WEST: {
                G2.rotate(-1.5707963267948966, this.CENTER.getX(), this.CENTER.getY());
                break;
            }
        }
        AffineTransform FORMER_TRANSFORM = G2.getTransform();
        if (this.isTrackVisible()) {
            G2.drawImage((Image)this.trackImage, 0, 0, null);
        }
        G2.drawImage((Image)this.tickmarksImage, 0, 0, null);
        if (this.isThresholdVisible()) {
            if (!this.isLogScale()) {
                G2.rotate(this.getGaugeType().ROTATION_OFFSET + (this.getThreshold() - this.getMinValue()) * this.getAngleStep(), this.CENTER.getX(), (double)this.getGaugeBounds().width * 0.7336448598);
            } else {
                G2.rotate(this.getGaugeType().ROTATION_OFFSET + UTIL.logOfBase(10.0, this.getThreshold() - this.getMinValue()) * this.getLogAngleStep(), this.CENTER.getX(), (double)this.getGaugeBounds().width * 0.7336448598);
            }
            G2.drawImage((Image)this.thresholdImage, 0, 0, null);
            G2.setTransform(FORMER_TRANSFORM);
        }
        if (this.isMinMeasuredValueVisible()) {
            if (!this.isLogScale()) {
                G2.rotate(this.getGaugeType().ROTATION_OFFSET + (this.getMinMeasuredValue() - this.getMinValue()) * this.getAngleStep(), this.CENTER.getX(), (double)this.getGaugeBounds().width * 0.7336448598);
            } else {
                G2.rotate(this.getGaugeType().ROTATION_OFFSET + UTIL.logOfBase(10.0, this.getMinMeasuredValue() - this.getMinValue()) * this.getLogAngleStep(), this.CENTER.getX(), (double)this.getGaugeBounds().width * 0.7336448598);
            }
            G2.drawImage((Image)this.minMeasuredImage, 0, 0, null);
            G2.setTransform(FORMER_TRANSFORM);
        }
        if (this.isMaxMeasuredValueVisible()) {
            if (!this.isLogScale()) {
                G2.rotate(this.getGaugeType().ROTATION_OFFSET + (this.getMaxMeasuredValue() - this.getMinValue()) * this.getAngleStep(), this.CENTER.getX(), (double)this.getGaugeBounds().width * 0.7336448598);
            } else {
                G2.rotate(this.getGaugeType().ROTATION_OFFSET + UTIL.logOfBase(10.0, this.getMaxMeasuredValue() - this.getMinValue()) * this.getLogAngleStep(), this.CENTER.getX(), (double)this.getGaugeBounds().width * 0.7336448598);
            }
            G2.drawImage((Image)this.maxMeasuredImage, 0, 0, null);
            G2.setTransform(FORMER_TRANSFORM);
        }
        if (this.isLedVisible()) {
            G2.setTransform(OLD_TRANSFORM);
            G2.drawImage((Image)this.getCurrentLedImage(), (int)((double)this.getGaugeBounds().width * this.getLedPosition().getX()), (int)((double)this.getGaugeBounds().width * this.getLedPosition().getY()), null);
            G2.setTransform(FORMER_TRANSFORM);
        }
        if (this.isUserLedVisible()) {
            G2.setTransform(OLD_TRANSFORM);
            G2.drawImage((Image)this.getCurrentUserLedImage(), (int)((double)this.getGaugeBounds().width * this.getUserLedPosition().getX()), (int)((double)this.getGaugeBounds().width * this.getUserLedPosition().getY()), null);
            G2.setTransform(FORMER_TRANSFORM);
        }
        this.angle = !this.isLogScale() ? this.getGaugeType().ROTATION_OFFSET + (this.getValue() - this.getMinValue()) * this.getAngleStep() : this.getGaugeType().ROTATION_OFFSET + UTIL.logOfBase(10.0, this.getValue() - this.getMinValue()) * this.getLogAngleStep();
        G2.rotate(this.angle, this.CENTER.getX(), (double)this.getGaugeBounds().height * 0.7336448598 + 2.0);
        G2.drawImage((Image)this.pointerShadowImage, 0, 0, null);
        G2.setTransform(FORMER_TRANSFORM);
        G2.rotate(this.angle, this.CENTER.getX(), (double)this.getGaugeBounds().height * 0.7336448598);
        G2.drawImage((Image)this.pointerImage, 0, 0, null);
        G2.setTransform(FORMER_TRANSFORM);
        G2.drawImage((Image)this.postsImage, 0, 0, null);
        switch (this.getOrientation()) {
            case NORTH: {
                break;
            }
            case EAST: {
                break;
            }
            case SOUTH: {
                break;
            }
            case WEST: {
                G2.setTransform(OLD_TRANSFORM);
                break;
            }
        }
        G2.drawImage((Image)this.fImage, 0, 0, null);
        if (this.isGlowVisible()) {
            if (this.isGlowing()) {
                G2.setComposite(AlphaComposite.getInstance(3, this.getGlowAlpha()));
                G2.drawImage((Image)this.glowImageOn, 0, 0, null);
                G2.setComposite(AlphaComposite.getInstance(3, 1.0f));
            } else {
                G2.drawImage((Image)this.glowImageOff, 0, 0, null);
            }
        }
        if (!this.isEnabled()) {
            G2.drawImage((Image)this.disabledImage, 0, 0, null);
        }
        G2.dispose();
    }

    @Override
    public void setOrientation(Orientation ORIENTATION) {
        super.setOrientation(ORIENTATION);
        switch (ORIENTATION) {
            case NORTH: {
                this.setLedPosition(0.455, 0.51);
                this.setUserLedPosition(0.455, 0.58);
                break;
            }
            case EAST: {
                break;
            }
            case SOUTH: {
                break;
            }
            case WEST: {
                this.setLedPosition(0.455, 0.51);
                this.setUserLedPosition(0.455, 0.58);
                break;
            }
            default: {
                this.setLedPosition(0.455, 0.51);
                this.setUserLedPosition(0.455, 0.58);
            }
        }
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public Point2D getCenter() {
        return new Point2D.Double((double)this.bImage.getWidth() / 2.0, (double)this.bImage.getHeight() / 2.0);
    }

    @Override
    public Rectangle2D getBounds2D() {
        return new Rectangle2D.Double(this.bImage.getMinX(), this.bImage.getMinY(), this.bImage.getWidth(), this.bImage.getHeight());
    }

    @Override
    public Rectangle getLcdBounds() {
        return new Rectangle();
    }

    private void createAreas(BufferedImage IMAGE) {
        double ORIGIN_CORRECTION;
        switch (this.getOrientation()) {
            case NORTH: {
                ORIGIN_CORRECTION = 135.0;
                break;
            }
            case EAST: {
                ORIGIN_CORRECTION = 135.0;
                break;
            }
            case SOUTH: {
                ORIGIN_CORRECTION = 135.0;
                break;
            }
            case WEST: {
                ORIGIN_CORRECTION = 225.0;
                break;
            }
            default: {
                ORIGIN_CORRECTION = 135.0;
            }
        }
        if (this.bImage != null) {
            double ANGLE_STEP = !this.isLogScale() ? Math.toDegrees(this.getGaugeType().ANGLE_RANGE) / (this.getMaxValue() - this.getMinValue()) : Math.toDegrees(this.getGaugeType().ANGLE_RANGE) / UTIL.logOfBase(10.0, this.getMaxValue() - this.getMinValue());
            if (this.bImage != null && !this.getAreas().isEmpty()) {
                double OUTER_RADIUS = (float)this.bImage.getWidth() * 0.44f;
                double RADIUS = this.isSectionsVisible() ? (this.isExpandedSectionsEnabled() ? OUTER_RADIUS - (double)((float)this.bImage.getWidth() * 0.12f) : OUTER_RADIUS - (double)((float)this.bImage.getWidth() * 0.04f)) : OUTER_RADIUS;
                double FREE_AREA = (double)this.bImage.getWidth() / 2.0 - RADIUS;
                Rectangle2D.Double AREA_FRAME = new Rectangle2D.Double((double)this.bImage.getMinX() + FREE_AREA, (double)this.bImage.getMinY() + FREE_AREA, 2.0 * RADIUS, 2.0 * RADIUS);
                for (Section area : this.getAreas()) {
                    if (!this.isLogScale()) {
                        area.setFilledArea(new Arc2D.Double(AREA_FRAME, ORIGIN_CORRECTION - area.getStart() * ANGLE_STEP + this.getMinValue() * ANGLE_STEP, -(area.getStop() - area.getStart()) * ANGLE_STEP, 2));
                        continue;
                    }
                    area.setFilledArea(new Arc2D.Double(AREA_FRAME, ORIGIN_CORRECTION - UTIL.logOfBase(10.0, area.getStart()) * ANGLE_STEP + UTIL.logOfBase(10.0, this.getMinValue()) * ANGLE_STEP, -UTIL.logOfBase(10.0, area.getStop() - area.getStart()) * ANGLE_STEP, 2));
                }
            }
            if (this.isAreasVisible() && IMAGE != null) {
                Graphics2D G2 = IMAGE.createGraphics();
                G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                switch (this.getOrientation()) {
                    case EAST: {
                        break;
                    }
                    case SOUTH: {
                        break;
                    }
                    case WEST: {
                        G2.translate(this.CENTER.getX() / 2.2, 0.0);
                        break;
                    }
                    default: {
                        G2.translate(0.0, this.CENTER.getY() / 2.2);
                    }
                }
                for (Section area : this.getAreas()) {
                    G2.setColor(this.isTransparentAreasEnabled() ? area.getTransparentColor() : area.getColor());
                    G2.fill(area.getFilledArea());
                }
                G2.dispose();
            }
        }
    }

    private void createSections(BufferedImage IMAGE) {
        if (this.bImage != null) {
            double ORIGIN_CORRECTION;
            switch (this.getOrientation()) {
                case NORTH: {
                    ORIGIN_CORRECTION = 135.0;
                    break;
                }
                case EAST: {
                    ORIGIN_CORRECTION = 135.0;
                    break;
                }
                case SOUTH: {
                    ORIGIN_CORRECTION = 135.0;
                    break;
                }
                case WEST: {
                    ORIGIN_CORRECTION = 225.0;
                    break;
                }
                default: {
                    ORIGIN_CORRECTION = 135.0;
                }
            }
            double ANGLE_STEP = !this.isLogScale() ? this.getGaugeType().APEX_ANGLE / (this.getMaxValue() - this.getMinValue()) : this.getGaugeType().APEX_ANGLE / UTIL.logOfBase(10.0, this.getMaxValue() - this.getMinValue());
            double OUTER_RADIUS = (float)this.bImage.getWidth() * 0.44f;
            double INNER_RADIUS = this.isExpandedSectionsEnabled() ? OUTER_RADIUS - (double)((float)this.bImage.getWidth() * 0.12f) : OUTER_RADIUS - (double)((float)this.bImage.getWidth() * 0.04f);
            double FREE_AREA_OUTER_RADIUS = (double)this.bImage.getWidth() / 2.0 - OUTER_RADIUS;
            double FREE_AREA_INNER_RADIUS = (double)this.bImage.getWidth() / 2.0 - INNER_RADIUS;
            Ellipse2D.Double INNER = new Ellipse2D.Double((double)this.bImage.getMinX() + FREE_AREA_INNER_RADIUS, (double)this.bImage.getMinY() + FREE_AREA_INNER_RADIUS, 2.0 * INNER_RADIUS, 2.0 * INNER_RADIUS);
            for (Section section : this.getSections()) {
                double ANGLE_EXTEND;
                double ANGLE_START;
                if (!this.isLogScale()) {
                    ANGLE_START = ORIGIN_CORRECTION - section.getStart() * ANGLE_STEP + this.getMinValue() * ANGLE_STEP;
                    ANGLE_EXTEND = -(section.getStop() - section.getStart()) * ANGLE_STEP;
                } else {
                    ANGLE_START = ORIGIN_CORRECTION - UTIL.logOfBase(10.0, section.getStart()) * ANGLE_STEP + UTIL.logOfBase(10.0, this.getMinValue()) * ANGLE_STEP;
                    ANGLE_EXTEND = -(section.getStop() - section.getStart()) * ANGLE_STEP;
                }
                Arc2D.Double OUTER_ARC = new Arc2D.Double(2);
                OUTER_ARC.setFrame((double)this.bImage.getMinX() + FREE_AREA_OUTER_RADIUS, (double)this.bImage.getMinY() + FREE_AREA_OUTER_RADIUS, 2.0 * OUTER_RADIUS, 2.0 * OUTER_RADIUS);
                ((Arc2D)OUTER_ARC).setAngleStart(ANGLE_START);
                ((Arc2D)OUTER_ARC).setAngleExtent(ANGLE_EXTEND);
                Area SECTION = new Area(OUTER_ARC);
                SECTION.subtract(new Area(INNER));
                section.setSectionArea(SECTION);
            }
            if (this.isSectionsVisible() && IMAGE != null) {
                Graphics2D G2 = IMAGE.createGraphics();
                G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                switch (this.getOrientation()) {
                    case EAST: {
                        break;
                    }
                    case SOUTH: {
                        break;
                    }
                    case WEST: {
                        G2.translate(this.CENTER.getX() / 2.2, 0.0);
                        break;
                    }
                    default: {
                        G2.translate(0.0, this.CENTER.getY() / 2.2);
                    }
                }
                for (Section section : this.getSections()) {
                    G2.setColor(this.isTransparentAreasEnabled() ? section.getTransparentColor() : section.getColor());
                    G2.fill(section.getSectionArea());
                }
                G2.dispose();
            }
        }
    }

    @Override
    protected BufferedImage create_THRESHOLD_Image(int WIDTH) {
        if (WIDTH <= 0) {
            return null;
        }
        BufferedImage IMAGE = UTIL.createImage(WIDTH, WIDTH, 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        G2.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        int IMAGE_WIDTH = IMAGE.getWidth();
        int IMAGE_HEIGHT = IMAGE.getHeight();
        GeneralPath THRESHOLD = new GeneralPath();
        THRESHOLD.setWindingRule(0);
        THRESHOLD.moveTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.3333333333333333);
        THRESHOLD.lineTo((double)IMAGE_WIDTH * 0.4866666666666667, (double)IMAGE_HEIGHT * 0.37333333333333335);
        THRESHOLD.lineTo((double)IMAGE_WIDTH * 0.52, (double)IMAGE_HEIGHT * 0.37333333333333335);
        THRESHOLD.lineTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.3333333333333333);
        THRESHOLD.closePath();
        Point2D.Double THRESHOLD_START = new Point2D.Double(0.0, THRESHOLD.getBounds2D().getMinY());
        Point2D.Double THRESHOLD_STOP = new Point2D.Double(0.0, THRESHOLD.getBounds2D().getMaxY());
        float[] THRESHOLD_FRACTIONS = new float[]{0.0f, 0.3f, 0.59f, 1.0f};
        Color[] THRESHOLD_COLORS = new Color[]{new Color(82, 0, 0, 255), new Color(252, 29, 0, 255), new Color(252, 29, 0, 255), new Color(82, 0, 0, 255)};
        LinearGradientPaint THRESHOLD_GRADIENT = new LinearGradientPaint(THRESHOLD_START, THRESHOLD_STOP, THRESHOLD_FRACTIONS, THRESHOLD_COLORS);
        G2.setPaint(THRESHOLD_GRADIENT);
        G2.fill(THRESHOLD);
        G2.setColor(Color.WHITE);
        G2.setStroke(new BasicStroke(1.0f, 0, 0));
        G2.draw(THRESHOLD);
        G2.dispose();
        return IMAGE;
    }

    @Override
    protected BufferedImage create_MEASURED_VALUE_Image(int WIDTH, Color COLOR) {
        if (WIDTH <= 0) {
            return null;
        }
        BufferedImage IMAGE = UTIL.createImage(WIDTH, WIDTH, 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int IMAGE_WIDTH = IMAGE.getWidth();
        int IMAGE_HEIGHT = IMAGE.getHeight();
        GeneralPath MAXMEASURED = new GeneralPath();
        MAXMEASURED.setWindingRule(0);
        MAXMEASURED.moveTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.3037383177570093);
        MAXMEASURED.lineTo((double)IMAGE_WIDTH * 0.514018691588785, (double)IMAGE_HEIGHT * 0.2803738317757009);
        MAXMEASURED.lineTo((double)IMAGE_WIDTH * 0.48598130841121495, (double)IMAGE_HEIGHT * 0.2803738317757009);
        MAXMEASURED.lineTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.3037383177570093);
        MAXMEASURED.closePath();
        G2.setColor(COLOR);
        G2.fill(MAXMEASURED);
        G2.dispose();
        return IMAGE;
    }

    @Override
    protected BufferedImage create_POINTER_Image(int WIDTH, PointerType POINTER_TYPE) {
        if (WIDTH <= 0) {
            return null;
        }
        BufferedImage IMAGE = UTIL.createImage(WIDTH, WIDTH, 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        int IMAGE_WIDTH = IMAGE.getWidth();
        int IMAGE_HEIGHT = IMAGE.getHeight();
        CustomColorDef CUSTOM_POINTER_COLOR = this.getPointerColor() == ColorDef.CUSTOM ? new CustomColorDef(this.getCustomPointerColor()) : null;
        switch (POINTER_TYPE) {
            case TYPE2: {
                GeneralPath POINTER = new GeneralPath();
                POINTER.setWindingRule(0);
                POINTER.moveTo((double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.705607476635514);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.5093457943925234, (double)IMAGE_HEIGHT * 0.6962616822429907);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.5093457943925234, (double)IMAGE_HEIGHT * 0.5747663551401869);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.5046728971962616, (double)IMAGE_HEIGHT * 0.2897196261682243);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.4953271028037383, (double)IMAGE_HEIGHT * 0.2897196261682243);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.49065420560747663, (double)IMAGE_HEIGHT * 0.5747663551401869);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.49065420560747663, (double)IMAGE_HEIGHT * 0.6962616822429907);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.48130841121495327, (double)IMAGE_HEIGHT * 0.705607476635514);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.48130841121495327, (double)IMAGE_HEIGHT * 0.705607476635514, (double)IMAGE_WIDTH * 0.4672897196261682, (double)IMAGE_HEIGHT * 0.7242990654205608, (double)IMAGE_WIDTH * 0.4672897196261682, (double)IMAGE_HEIGHT * 0.7336448598130841);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.4672897196261682, (double)IMAGE_HEIGHT * 0.7523364485981309, (double)IMAGE_WIDTH * 0.48130841121495327, (double)IMAGE_HEIGHT * 0.7663551401869159, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.7663551401869159);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.7663551401869159, (double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.7523364485981309, (double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.7336448598130841);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.7242990654205608, (double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.705607476635514, (double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.705607476635514);
                POINTER.closePath();
                Point2D.Double POINTER_START = new Point2D.Double(0.0, POINTER.getBounds2D().getMaxY());
                Point2D.Double POINTER_STOP = new Point2D.Double(0.0, POINTER.getBounds2D().getMinY());
                float[] POINTER_FRACTIONS = new float[]{0.0f, 0.36f, 0.3601f, 1.0f};
                Color[] POINTER_COLORS = this.getPointerColor() != ColorDef.CUSTOM ? new Color[]{this.getBackgroundColor().LABEL_COLOR, this.getBackgroundColor().LABEL_COLOR, this.getPointerColor().LIGHT, this.getPointerColor().LIGHT} : new Color[]{this.getBackgroundColor().LABEL_COLOR, this.getBackgroundColor().LABEL_COLOR, CUSTOM_POINTER_COLOR.LIGHT, CUSTOM_POINTER_COLOR.LIGHT};
                LinearGradientPaint POINTER_GRADIENT = new LinearGradientPaint(POINTER_START, POINTER_STOP, POINTER_FRACTIONS, POINTER_COLORS);
                G2.setPaint(POINTER_GRADIENT);
                G2.fill(POINTER);
                break;
            }
            case TYPE3: {
                GeneralPath POINTER = new GeneralPath(new Rectangle2D.Double((double)IMAGE_WIDTH * 0.4953271028037383, (double)IMAGE_HEIGHT * 0.2897196261682243, (double)IMAGE_WIDTH * 0.009345794392523364, (double)IMAGE_HEIGHT * 0.4485981308));
                if (this.getPointerColor() != ColorDef.CUSTOM) {
                    G2.setColor(this.getPointerColor().LIGHT);
                } else {
                    G2.setColor(CUSTOM_POINTER_COLOR.LIGHT);
                }
                G2.fill(POINTER);
                break;
            }
            case TYPE4: {
                GeneralPath POINTER = new GeneralPath();
                POINTER.setWindingRule(0);
                POINTER.moveTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.29439252336448596);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.514018691588785, (double)IMAGE_HEIGHT * 0.3037383177570093);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.7336448598130841);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.5233644859813084, (double)IMAGE_HEIGHT * 0.8364485981308412);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.4766355140186916, (double)IMAGE_HEIGHT * 0.8364485981308412);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.4672897196261682, (double)IMAGE_HEIGHT * 0.7336448598130841);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.49065420560747663, (double)IMAGE_HEIGHT * 0.3037383177570093);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.29439252336448596);
                POINTER.closePath();
                Point2D.Double POINTER_START = new Point2D.Double(POINTER.getBounds2D().getMinX(), 0.0);
                Point2D.Double POINTER_STOP = new Point2D.Double(POINTER.getBounds2D().getMaxX(), 0.0);
                float[] POINTER_FRACTIONS = new float[]{0.0f, 0.51f, 0.52f, 1.0f};
                Color[] POINTER_COLORS = this.getPointerColor() != ColorDef.CUSTOM ? new Color[]{this.getPointerColor().DARK, this.getPointerColor().DARK, this.getPointerColor().LIGHT, this.getPointerColor().LIGHT} : new Color[]{CUSTOM_POINTER_COLOR.DARK, CUSTOM_POINTER_COLOR.DARK, CUSTOM_POINTER_COLOR.LIGHT, CUSTOM_POINTER_COLOR.LIGHT};
                LinearGradientPaint POINTER_GRADIENT = new LinearGradientPaint(POINTER_START, POINTER_STOP, POINTER_FRACTIONS, POINTER_COLORS);
                G2.setPaint(POINTER_GRADIENT);
                G2.fill(POINTER);
                break;
            }
            case TYPE5: {
                GeneralPath POINTER = new GeneralPath();
                POINTER.setWindingRule(0);
                POINTER.moveTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.74);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.5266666666666666, (double)IMAGE_HEIGHT * 0.74);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.3);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.47333333333333333, (double)IMAGE_HEIGHT * 0.74);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.74);
                POINTER.closePath();
                Point2D.Double POINTER_START = new Point2D.Double(POINTER.getBounds2D().getMinX(), 0.0);
                Point2D.Double POINTER_STOP = new Point2D.Double(POINTER.getBounds2D().getMaxX(), 0.0);
                float[] POINTER_FRACTIONS = new float[]{0.0f, 0.4999f, 0.5f, 1.0f};
                Color[] POINTER_COLORS = this.getPointerColor() != ColorDef.CUSTOM ? new Color[]{this.getPointerColor().LIGHT, this.getPointerColor().LIGHT, this.getPointerColor().MEDIUM, this.getPointerColor().MEDIUM} : new Color[]{this.getCustomPointerColorObject().LIGHT, this.getCustomPointerColorObject().LIGHT, this.getCustomPointerColorObject().MEDIUM, this.getCustomPointerColorObject().MEDIUM};
                LinearGradientPaint POINTER_GRADIENT = new LinearGradientPaint(POINTER_START, POINTER_STOP, POINTER_FRACTIONS, POINTER_COLORS);
                G2.setPaint(POINTER_GRADIENT);
                G2.fill(POINTER);
                if (this.getPointerColor() != ColorDef.CUSTOM) {
                    G2.setColor(this.getPointerColor().DARK);
                } else {
                    G2.setColor(this.getCustomPointerColorObject().DARK);
                }
                G2.setStroke(new BasicStroke(1.0f, 0, 0));
                G2.draw(POINTER);
                break;
            }
            case TYPE6: {
                GeneralPath POINTER = new GeneralPath();
                POINTER.setWindingRule(0);
                POINTER.moveTo((double)IMAGE_WIDTH * 0.47333333333333333, (double)IMAGE_HEIGHT * 0.7333333333333333);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.47333333333333333, (double)IMAGE_HEIGHT * 0.6);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.48, (double)IMAGE_HEIGHT * 0.49333333333333335);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.49333333333333335, (double)IMAGE_HEIGHT * 0.30666666666666664);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.30666666666666664);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.5066666666666667, (double)IMAGE_HEIGHT * 0.30666666666666664);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.52, (double)IMAGE_HEIGHT * 0.49333333333333335);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.5266666666666666, (double)IMAGE_HEIGHT * 0.5933333333333334);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.5266666666666666, (double)IMAGE_HEIGHT * 0.7333333333333333);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.5066666666666667, (double)IMAGE_HEIGHT * 0.7333333333333333);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.5066666666666667, (double)IMAGE_HEIGHT * 0.5933333333333334);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.49333333333333335);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.49333333333333335, (double)IMAGE_HEIGHT * 0.6);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.49333333333333335, (double)IMAGE_HEIGHT * 0.7333333333333333);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.47333333333333333, (double)IMAGE_HEIGHT * 0.7333333333333333);
                POINTER.closePath();
                Point2D.Double POINTER_START = new Point2D.Double(POINTER.getBounds2D().getMaxY(), 0.0);
                Point2D.Double POINTER_STOP = new Point2D.Double(POINTER.getBounds2D().getMinY(), 0.0);
                float[] POINTER_FRACTIONS = new float[]{0.0f, 0.25f, 0.75f, 1.0f};
                Color[] POINTER_COLORS = this.getPointerColor() != ColorDef.CUSTOM ? new Color[]{this.getPointerColor().LIGHT, this.getPointerColor().MEDIUM, this.getPointerColor().MEDIUM, this.getPointerColor().LIGHT} : new Color[]{this.getCustomPointerColorObject().LIGHT, this.getCustomPointerColorObject().MEDIUM, this.getCustomPointerColorObject().MEDIUM, this.getCustomPointerColorObject().LIGHT};
                LinearGradientPaint POINTER_GRADIENT = new LinearGradientPaint(POINTER_START, POINTER_STOP, POINTER_FRACTIONS, POINTER_COLORS);
                G2.setPaint(POINTER_GRADIENT);
                G2.fill(POINTER);
                if (this.getPointerColor() != ColorDef.CUSTOM) {
                    G2.setColor(this.getPointerColor().DARK);
                } else {
                    G2.setColor(this.getCustomPointerColorObject().DARK);
                }
                G2.setStroke(new BasicStroke(1.0f, 0, 0));
                G2.draw(POINTER);
                break;
            }
            case TYPE7: {
                GeneralPath POINTER = new GeneralPath();
                POINTER.setWindingRule(0);
                POINTER.moveTo((double)IMAGE_WIDTH * 0.4866666666666667, (double)IMAGE_HEIGHT * 0.30666666666666664);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.47333333333333333, (double)IMAGE_HEIGHT * 0.7333333333333333);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.5266666666666666, (double)IMAGE_HEIGHT * 0.7333333333333333);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.5066666666666667, (double)IMAGE_HEIGHT * 0.30666666666666664);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.4866666666666667, (double)IMAGE_HEIGHT * 0.30666666666666664);
                POINTER.closePath();
                Point2D.Double POINTER_START = new Point2D.Double(POINTER.getBounds2D().getMinX(), 0.0);
                Point2D.Double POINTER_STOP = new Point2D.Double(POINTER.getBounds2D().getMaxX(), 0.0);
                float[] POINTER_FRACTIONS = new float[]{0.0f, 1.0f};
                Color[] POINTER_COLORS = this.getPointerColor() != ColorDef.CUSTOM ? new Color[]{this.getPointerColor().DARK, this.getPointerColor().MEDIUM} : new Color[]{this.getCustomPointerColorObject().DARK, this.getCustomPointerColorObject().MEDIUM};
                LinearGradientPaint POINTER_GRADIENT = new LinearGradientPaint(POINTER_START, POINTER_STOP, POINTER_FRACTIONS, POINTER_COLORS);
                G2.setPaint(POINTER_GRADIENT);
                G2.fill(POINTER);
                break;
            }
            case TYPE8: {
                GeneralPath POINTER = new GeneralPath();
                POINTER.setWindingRule(0);
                POINTER.moveTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.7666666666666667);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.5333333333333333, (double)IMAGE_HEIGHT * 0.7333333333333333);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.5333333333333333, (double)IMAGE_HEIGHT * 0.7333333333333333, (double)IMAGE_WIDTH * 0.5066666666666667, (double)IMAGE_HEIGHT * 0.7066666666666667, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.31333333333333335);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.49333333333333335, (double)IMAGE_HEIGHT * 0.7066666666666667, (double)IMAGE_WIDTH * 0.4666666666666667, (double)IMAGE_HEIGHT * 0.7333333333333333, (double)IMAGE_WIDTH * 0.4666666666666667, (double)IMAGE_HEIGHT * 0.7333333333333333);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.7666666666666667);
                POINTER.closePath();
                Point2D.Double POINTER_START = new Point2D.Double(POINTER.getBounds2D().getMinX(), 0.0);
                Point2D.Double POINTER_STOP = new Point2D.Double(POINTER.getBounds2D().getMaxX(), 0.0);
                float[] POINTER_FRACTIONS = new float[]{0.0f, 0.46f, 0.47f, 1.0f};
                Color[] POINTER_COLORS = this.getPointerColor() != ColorDef.CUSTOM ? new Color[]{this.getPointerColor().LIGHT, this.getPointerColor().LIGHT, this.getPointerColor().MEDIUM, this.getPointerColor().MEDIUM} : new Color[]{this.getCustomPointerColorObject().LIGHT, this.getCustomPointerColorObject().LIGHT, this.getCustomPointerColorObject().MEDIUM, this.getCustomPointerColorObject().MEDIUM};
                LinearGradientPaint POINTER_GRADIENT = new LinearGradientPaint(POINTER_START, POINTER_STOP, POINTER_FRACTIONS, POINTER_COLORS);
                G2.setPaint(POINTER_GRADIENT);
                G2.fill(POINTER);
                if (this.getPointerColor() != ColorDef.CUSTOM) {
                    G2.setColor(this.getPointerColor().DARK);
                } else {
                    G2.setColor(this.getCustomPointerColorObject().DARK);
                }
                G2.setStroke(new BasicStroke(1.0f, 0, 0));
                G2.draw(POINTER);
                break;
            }
            case TYPE9: {
                GeneralPath POINTER = new GeneralPath();
                POINTER.setWindingRule(0);
                POINTER.moveTo((double)IMAGE_WIDTH * 0.49333333333333335, (double)IMAGE_HEIGHT * 0.42);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.5066666666666667, (double)IMAGE_HEIGHT * 0.42);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.5133333333333333, (double)IMAGE_HEIGHT * 0.66);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.4866666666666667, (double)IMAGE_HEIGHT * 0.66);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.49333333333333335, (double)IMAGE_HEIGHT * 0.42);
                POINTER.closePath();
                POINTER.moveTo((double)IMAGE_WIDTH * 0.49333333333333335, (double)IMAGE_HEIGHT * 0.3);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.47333333333333333, (double)IMAGE_HEIGHT * 0.7);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.47333333333333333, (double)IMAGE_HEIGHT * 0.7666666666666667);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.47333333333333333, (double)IMAGE_HEIGHT * 0.7666666666666667, (double)IMAGE_WIDTH * 0.47333333333333333, (double)IMAGE_HEIGHT * 0.8533333333333334, (double)IMAGE_WIDTH * 0.47333333333333333, (double)IMAGE_HEIGHT * 0.8533333333333334);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.47333333333333333, (double)IMAGE_HEIGHT * 0.86, (double)IMAGE_WIDTH * 0.48, (double)IMAGE_HEIGHT * 0.86, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.86);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.52, (double)IMAGE_HEIGHT * 0.86, (double)IMAGE_WIDTH * 0.5266666666666666, (double)IMAGE_HEIGHT * 0.86, (double)IMAGE_WIDTH * 0.5266666666666666, (double)IMAGE_HEIGHT * 0.8533333333333334);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.5266666666666666, (double)IMAGE_HEIGHT * 0.8533333333333334, (double)IMAGE_WIDTH * 0.5266666666666666, (double)IMAGE_HEIGHT * 0.7666666666666667, (double)IMAGE_WIDTH * 0.5266666666666666, (double)IMAGE_HEIGHT * 0.7666666666666667);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.5266666666666666, (double)IMAGE_HEIGHT * 0.7);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.5066666666666667, (double)IMAGE_HEIGHT * 0.3);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.49333333333333335, (double)IMAGE_HEIGHT * 0.3);
                POINTER.closePath();
                Point2D.Double POINTER_START = new Point2D.Double(POINTER.getBounds2D().getMinX(), 0.0);
                Point2D.Double POINTER_STOP = new Point2D.Double(POINTER.getBounds2D().getMaxX(), 0.0);
                float[] POINTER_FRACTIONS = new float[]{0.0f, 0.48f, 1.0f};
                Color[] POINTER_COLORS = new Color[]{new Color(50, 50, 50, 255), new Color(102, 102, 102, 255), new Color(50, 50, 50, 255)};
                LinearGradientPaint POINTER_GRADIENT = new LinearGradientPaint(POINTER_START, POINTER_STOP, POINTER_FRACTIONS, POINTER_COLORS);
                G2.setPaint(POINTER_GRADIENT);
                G2.fill(POINTER);
                G2.setColor(new Color(0x2E2E2E));
                G2.setStroke(new BasicStroke(1.0f, 0, 0));
                G2.draw(POINTER);
                GeneralPath COLOR_BOX = new GeneralPath();
                COLOR_BOX.setWindingRule(0);
                COLOR_BOX.moveTo((double)IMAGE_WIDTH * 0.49333333333333335, (double)IMAGE_HEIGHT * 0.4066666666666667);
                COLOR_BOX.lineTo((double)IMAGE_WIDTH * 0.5066666666666667, (double)IMAGE_HEIGHT * 0.4066666666666667);
                COLOR_BOX.lineTo((double)IMAGE_WIDTH * 0.5066666666666667, (double)IMAGE_HEIGHT * 0.30666666666666664);
                COLOR_BOX.lineTo((double)IMAGE_WIDTH * 0.49333333333333335, (double)IMAGE_HEIGHT * 0.30666666666666664);
                COLOR_BOX.lineTo((double)IMAGE_WIDTH * 0.49333333333333335, (double)IMAGE_HEIGHT * 0.4066666666666667);
                COLOR_BOX.closePath();
                G2.setColor(this.getPointerColor().MEDIUM);
                G2.fill(COLOR_BOX);
                break;
            }
            case TYPE10: {
                GeneralPath POINTER = new GeneralPath();
                POINTER.setWindingRule(0);
                POINTER.moveTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.3);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.3, (double)IMAGE_WIDTH * 0.43333333333333335, (double)IMAGE_HEIGHT * 0.7133333333333334, (double)IMAGE_WIDTH * 0.43333333333333335, (double)IMAGE_HEIGHT * 0.7266666666666667);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.43333333333333335, (double)IMAGE_HEIGHT * 0.76, (double)IMAGE_WIDTH * 0.46, (double)IMAGE_HEIGHT * 0.7933333333333333, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.7933333333333333);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.54, (double)IMAGE_HEIGHT * 0.7933333333333333, (double)IMAGE_WIDTH * 0.5666666666666667, (double)IMAGE_HEIGHT * 0.76, (double)IMAGE_WIDTH * 0.5666666666666667, (double)IMAGE_HEIGHT * 0.7266666666666667);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.5666666666666667, (double)IMAGE_HEIGHT * 0.7133333333333334, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.3, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.3);
                POINTER.closePath();
                Point2D.Double POINTER_START = new Point2D.Double(POINTER.getBounds2D().getMinX(), 0.0);
                Point2D.Double POINTER_STOP = new Point2D.Double(POINTER.getBounds2D().getMaxX(), 0.0);
                float[] POINTER_FRACTIONS = new float[]{0.0f, 0.4999f, 0.5f, 1.0f};
                Color[] POINTER_COLORS = new Color[]{this.getPointerColor().LIGHT, this.getPointerColor().LIGHT, this.getPointerColor().MEDIUM, this.getPointerColor().MEDIUM};
                LinearGradientPaint POINTER_GRADIENT = new LinearGradientPaint(POINTER_START, POINTER_STOP, POINTER_FRACTIONS, POINTER_COLORS);
                G2.setPaint(POINTER_GRADIENT);
                G2.fill(POINTER);
                G2.setColor(this.getPointerColor().MEDIUM);
                G2.setStroke(new BasicStroke(1.0f, 0, 0));
                G2.draw(POINTER);
                break;
            }
            case TYPE11: {
                GeneralPath POINTER = new GeneralPath();
                POINTER.setWindingRule(0);
                POINTER.moveTo(0.5 * (double)IMAGE_WIDTH, 0.3 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.4866666666666667 * (double)IMAGE_WIDTH, 0.7333333333333333 * (double)IMAGE_HEIGHT);
                POINTER.curveTo(0.4866666666666667 * (double)IMAGE_WIDTH, 0.7333333333333333 * (double)IMAGE_HEIGHT, 0.4866666666666667 * (double)IMAGE_WIDTH, 0.8066666666666666 * (double)IMAGE_HEIGHT, 0.5 * (double)IMAGE_WIDTH, 0.8066666666666666 * (double)IMAGE_HEIGHT);
                POINTER.curveTo(0.5133333333333333 * (double)IMAGE_WIDTH, 0.8066666666666666 * (double)IMAGE_HEIGHT, 0.5133333333333333 * (double)IMAGE_WIDTH, 0.7333333333333333 * (double)IMAGE_HEIGHT, 0.5133333333333333 * (double)IMAGE_WIDTH, 0.7333333333333333 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.5 * (double)IMAGE_WIDTH, 0.3 * (double)IMAGE_HEIGHT);
                POINTER.closePath();
                G2.setPaint(new LinearGradientPaint(new Point2D.Double(0.5066666666666667 * (double)IMAGE_WIDTH, 0.22666666666666666 * (double)IMAGE_HEIGHT), new Point2D.Double(0.5066666666666667 * (double)IMAGE_WIDTH, 0.8666666666666667 * (double)IMAGE_HEIGHT), new float[]{0.0f, 1.0f}, new Color[]{this.getPointerColor().LIGHT, this.getPointerColor().MEDIUM}));
                G2.fill(POINTER);
                G2.setColor(this.getPointerColor().DARK);
                G2.setStroke(new BasicStroke(0.006666667f * (float)IMAGE_WIDTH, 0, 1));
                G2.draw(POINTER);
                break;
            }
            case TYPE12: {
                GeneralPath POINTER = new GeneralPath();
                POINTER.setWindingRule(0);
                POINTER.moveTo(0.5 * (double)IMAGE_WIDTH, 0.3 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.4866666666666667 * (double)IMAGE_WIDTH, 0.7333333333333333 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.5 * (double)IMAGE_WIDTH, 0.7466666666666667 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.5133333333333333 * (double)IMAGE_WIDTH, 0.7333333333333333 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.5 * (double)IMAGE_WIDTH, 0.3 * (double)IMAGE_HEIGHT);
                POINTER.closePath();
                G2.setPaint(new LinearGradientPaint(new Point2D.Double(0.5066666666666667 * (double)IMAGE_WIDTH, 0.22666666666666666 * (double)IMAGE_HEIGHT), new Point2D.Double(0.5066666666666667 * (double)IMAGE_WIDTH, 0.7466666666666667 * (double)IMAGE_HEIGHT), new float[]{0.0f, 1.0f}, new Color[]{this.getPointerColor().LIGHT, this.getPointerColor().MEDIUM}));
                G2.fill(POINTER);
                G2.setPaint(this.getPointerColor().DARK);
                G2.setStroke(new BasicStroke(0.006666667f * (float)IMAGE_WIDTH, 0, 1));
                G2.draw(POINTER);
                break;
            }
            case TYPE13: {
                GeneralPath POINTER = new GeneralPath();
                POINTER.setWindingRule(0);
                POINTER.moveTo(0.4866666666666667 * (double)IMAGE_WIDTH, 0.32666666666666666 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.5 * (double)IMAGE_WIDTH, 0.29333333333333333 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.5133333333333333 * (double)IMAGE_WIDTH, 0.32666666666666666 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.5133333333333333 * (double)IMAGE_WIDTH, 0.7466666666666667 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.4866666666666667 * (double)IMAGE_WIDTH, 0.7466666666666667 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.4866666666666667 * (double)IMAGE_WIDTH, 0.32666666666666666 * (double)IMAGE_HEIGHT);
                POINTER.closePath();
                G2.setPaint(new LinearGradientPaint(new Point2D.Double(0.5 * (double)IMAGE_WIDTH, 0.7333333333333333 * (double)IMAGE_HEIGHT), new Point2D.Double(0.5 * (double)IMAGE_WIDTH, 0.29333333333333333 * (double)IMAGE_HEIGHT), new float[]{0.0f, 0.849999f, 0.85f, 1.0f}, new Color[]{this.getPointerColor().MEDIUM, this.getPointerColor().MEDIUM, this.getBackgroundColor().LABEL_COLOR, this.getBackgroundColor().LABEL_COLOR}));
                G2.fill(POINTER);
                break;
            }
            case TYPE14: {
                GeneralPath POINTER = new GeneralPath();
                POINTER.setWindingRule(0);
                POINTER.moveTo(0.4866666666666667 * (double)IMAGE_WIDTH, 0.32666666666666666 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.5 * (double)IMAGE_WIDTH, 0.29333333333333333 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.5133333333333333 * (double)IMAGE_WIDTH, 0.32666666666666666 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.5133333333333333 * (double)IMAGE_WIDTH, 0.7466666666666667 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.4866666666666667 * (double)IMAGE_WIDTH, 0.7466666666666667 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.4866666666666667 * (double)IMAGE_WIDTH, 0.32666666666666666 * (double)IMAGE_HEIGHT);
                POINTER.closePath();
                G2.setPaint(new LinearGradientPaint(new Point2D.Double(0.4866666666666667 * (double)IMAGE_WIDTH, 0.64 * (double)IMAGE_HEIGHT), new Point2D.Double(0.5066666666666667 * (double)IMAGE_WIDTH, 0.64 * (double)IMAGE_HEIGHT), new float[]{0.0f, 0.5f, 1.0f}, new Color[]{this.getPointerColor().VERY_DARK, this.getPointerColor().LIGHT, this.getPointerColor().VERY_DARK}));
                G2.fill(POINTER);
                break;
            }
            default: {
                GeneralPath POINTER = new GeneralPath();
                POINTER.setWindingRule(0);
                POINTER.moveTo((double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.705607476635514);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.514018691588785, (double)IMAGE_HEIGHT * 0.6915887850467289, (double)IMAGE_WIDTH * 0.5093457943925234, (double)IMAGE_HEIGHT * 0.6261682242990654, (double)IMAGE_WIDTH * 0.5093457943925234, (double)IMAGE_HEIGHT * 0.6121495327102804);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.5046728971962616, (double)IMAGE_HEIGHT * 0.5981308411214953, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.29906542056074764, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.29906542056074764);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.29906542056074764, (double)IMAGE_WIDTH * 0.49065420560747663, (double)IMAGE_HEIGHT * 0.5981308411214953, (double)IMAGE_WIDTH * 0.49065420560747663, (double)IMAGE_HEIGHT * 0.6121495327102804);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.49065420560747663, (double)IMAGE_HEIGHT * 0.6308411214953271, (double)IMAGE_WIDTH * 0.48598130841121495, (double)IMAGE_HEIGHT * 0.6915887850467289, (double)IMAGE_WIDTH * 0.48130841121495327, (double)IMAGE_HEIGHT * 0.705607476635514);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.4719626168224299, (double)IMAGE_HEIGHT * 0.7149532710280374, (double)IMAGE_WIDTH * 0.4672897196261682, (double)IMAGE_HEIGHT * 0.7242990654205608, (double)IMAGE_WIDTH * 0.4672897196261682, (double)IMAGE_HEIGHT * 0.7336448598130841);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.4672897196261682, (double)IMAGE_HEIGHT * 0.7523364485981309, (double)IMAGE_WIDTH * 0.48130841121495327, (double)IMAGE_HEIGHT * 0.7663551401869159, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.7663551401869159);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.7663551401869159, (double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.7523364485981309, (double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.7336448598130841);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.7242990654205608, (double)IMAGE_WIDTH * 0.5280373831775701, (double)IMAGE_HEIGHT * 0.7149532710280374, (double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.705607476635514);
                POINTER.closePath();
                Point2D.Double POINTER_START = new Point2D.Double(0.0, POINTER.getBounds2D().getMinY());
                Point2D.Double POINTER_STOP = new Point2D.Double(0.0, POINTER.getBounds2D().getMaxY());
                float[] POINTER_FRACTIONS = new float[]{0.0f, 0.3f, 0.59f, 1.0f};
                Color[] POINTER_COLORS = this.getPointerColor() != ColorDef.CUSTOM ? new Color[]{this.getPointerColor().DARK, this.getPointerColor().LIGHT, this.getPointerColor().LIGHT, this.getPointerColor().DARK} : new Color[]{CUSTOM_POINTER_COLOR.DARK, CUSTOM_POINTER_COLOR.LIGHT, CUSTOM_POINTER_COLOR.LIGHT, CUSTOM_POINTER_COLOR.DARK};
                LinearGradientPaint POINTER_GRADIENT = new LinearGradientPaint(POINTER_START, POINTER_STOP, POINTER_FRACTIONS, POINTER_COLORS);
                G2.setPaint(POINTER_GRADIENT);
                G2.fill(POINTER);
                Color STROKE_COLOR_POINTER = this.getPointerColor().LIGHT;
                G2.setColor(STROKE_COLOR_POINTER);
                G2.setStroke(new BasicStroke(1.0f, 0, 0));
                G2.draw(POINTER);
            }
        }
        G2.dispose();
        return IMAGE;
    }

    @Override
    protected BufferedImage create_POINTER_SHADOW_Image(int WIDTH, PointerType POINTER_TYPE) {
        if (WIDTH <= 0) {
            return null;
        }
        Color SHADOW_COLOR = new Color(0.0f, 0.0f, 0.0f, 0.65f);
        BufferedImage IMAGE = UTIL.createImage(WIDTH, WIDTH, 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        int IMAGE_WIDTH = IMAGE.getWidth();
        int IMAGE_HEIGHT = IMAGE.getHeight();
        switch (POINTER_TYPE) {
            case TYPE1: {
                GeneralPath POINTER = new GeneralPath();
                POINTER.setWindingRule(0);
                POINTER.moveTo((double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.705607476635514);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.514018691588785, (double)IMAGE_HEIGHT * 0.6915887850467289, (double)IMAGE_WIDTH * 0.5093457943925234, (double)IMAGE_HEIGHT * 0.6261682242990654, (double)IMAGE_WIDTH * 0.5093457943925234, (double)IMAGE_HEIGHT * 0.6121495327102804);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.5046728971962616, (double)IMAGE_HEIGHT * 0.5981308411214953, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.29906542056074764, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.29906542056074764);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.29906542056074764, (double)IMAGE_WIDTH * 0.49065420560747663, (double)IMAGE_HEIGHT * 0.5981308411214953, (double)IMAGE_WIDTH * 0.49065420560747663, (double)IMAGE_HEIGHT * 0.6121495327102804);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.49065420560747663, (double)IMAGE_HEIGHT * 0.6308411214953271, (double)IMAGE_WIDTH * 0.48598130841121495, (double)IMAGE_HEIGHT * 0.6915887850467289, (double)IMAGE_WIDTH * 0.48130841121495327, (double)IMAGE_HEIGHT * 0.705607476635514);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.4719626168224299, (double)IMAGE_HEIGHT * 0.7149532710280374, (double)IMAGE_WIDTH * 0.4672897196261682, (double)IMAGE_HEIGHT * 0.7242990654205608, (double)IMAGE_WIDTH * 0.4672897196261682, (double)IMAGE_HEIGHT * 0.7336448598130841);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.4672897196261682, (double)IMAGE_HEIGHT * 0.7523364485981309, (double)IMAGE_WIDTH * 0.48130841121495327, (double)IMAGE_HEIGHT * 0.7663551401869159, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.7663551401869159);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.7663551401869159, (double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.7523364485981309, (double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.7336448598130841);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.7242990654205608, (double)IMAGE_WIDTH * 0.5280373831775701, (double)IMAGE_HEIGHT * 0.7149532710280374, (double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.705607476635514);
                POINTER.closePath();
                G2.setColor(SHADOW_COLOR);
                G2.fill(POINTER);
                break;
            }
            case TYPE2: {
                GeneralPath POINTER = new GeneralPath();
                POINTER.setWindingRule(0);
                POINTER.moveTo((double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.705607476635514);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.5093457943925234, (double)IMAGE_HEIGHT * 0.6962616822429907);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.5093457943925234, (double)IMAGE_HEIGHT * 0.5747663551401869);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.5046728971962616, (double)IMAGE_HEIGHT * 0.2897196261682243);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.4953271028037383, (double)IMAGE_HEIGHT * 0.2897196261682243);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.49065420560747663, (double)IMAGE_HEIGHT * 0.5747663551401869);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.49065420560747663, (double)IMAGE_HEIGHT * 0.6962616822429907);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.48130841121495327, (double)IMAGE_HEIGHT * 0.705607476635514);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.48130841121495327, (double)IMAGE_HEIGHT * 0.705607476635514, (double)IMAGE_WIDTH * 0.4672897196261682, (double)IMAGE_HEIGHT * 0.7242990654205608, (double)IMAGE_WIDTH * 0.4672897196261682, (double)IMAGE_HEIGHT * 0.7336448598130841);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.4672897196261682, (double)IMAGE_HEIGHT * 0.7523364485981309, (double)IMAGE_WIDTH * 0.48130841121495327, (double)IMAGE_HEIGHT * 0.7663551401869159, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.7663551401869159);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.7663551401869159, (double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.7523364485981309, (double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.7336448598130841);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.7242990654205608, (double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.705607476635514, (double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.705607476635514);
                POINTER.closePath();
                G2.setColor(SHADOW_COLOR);
                G2.fill(POINTER);
                break;
            }
            case TYPE3: {
                break;
            }
            case TYPE4: {
                GeneralPath POINTER = new GeneralPath();
                POINTER.setWindingRule(0);
                POINTER.moveTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.29439252336448596);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.514018691588785, (double)IMAGE_HEIGHT * 0.3037383177570093);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.7336448598130841);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.5233644859813084, (double)IMAGE_HEIGHT * 0.8364485981308412);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.4766355140186916, (double)IMAGE_HEIGHT * 0.8364485981308412);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.4672897196261682, (double)IMAGE_HEIGHT * 0.7336448598130841);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.49065420560747663, (double)IMAGE_HEIGHT * 0.3037383177570093);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.29439252336448596);
                POINTER.closePath();
                G2.setColor(SHADOW_COLOR);
                G2.fill(POINTER);
                break;
            }
            case TYPE5: {
                GeneralPath POINTER = new GeneralPath();
                POINTER.setWindingRule(0);
                POINTER.moveTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.74);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.5266666666666666, (double)IMAGE_HEIGHT * 0.74);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.3);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.47333333333333333, (double)IMAGE_HEIGHT * 0.74);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.74);
                POINTER.closePath();
                G2.setColor(SHADOW_COLOR);
                G2.fill(POINTER);
                break;
            }
            case TYPE6: {
                GeneralPath POINTER = new GeneralPath();
                POINTER.setWindingRule(0);
                POINTER.moveTo((double)IMAGE_WIDTH * 0.47333333333333333, (double)IMAGE_HEIGHT * 0.7333333333333333);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.47333333333333333, (double)IMAGE_HEIGHT * 0.6);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.48, (double)IMAGE_HEIGHT * 0.49333333333333335);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.49333333333333335, (double)IMAGE_HEIGHT * 0.30666666666666664);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.30666666666666664);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.5066666666666667, (double)IMAGE_HEIGHT * 0.30666666666666664);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.52, (double)IMAGE_HEIGHT * 0.49333333333333335);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.5266666666666666, (double)IMAGE_HEIGHT * 0.5933333333333334);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.5266666666666666, (double)IMAGE_HEIGHT * 0.7333333333333333);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.5066666666666667, (double)IMAGE_HEIGHT * 0.7333333333333333);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.5066666666666667, (double)IMAGE_HEIGHT * 0.5933333333333334);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.49333333333333335);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.49333333333333335, (double)IMAGE_HEIGHT * 0.6);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.49333333333333335, (double)IMAGE_HEIGHT * 0.7333333333333333);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.47333333333333333, (double)IMAGE_HEIGHT * 0.7333333333333333);
                POINTER.closePath();
                G2.setColor(SHADOW_COLOR);
                G2.fill(POINTER);
                break;
            }
            case TYPE7: {
                GeneralPath POINTER = new GeneralPath();
                POINTER.setWindingRule(0);
                POINTER.moveTo((double)IMAGE_WIDTH * 0.4866666666666667, (double)IMAGE_HEIGHT * 0.30666666666666664);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.47333333333333333, (double)IMAGE_HEIGHT * 0.7333333333333333);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.5266666666666666, (double)IMAGE_HEIGHT * 0.7333333333333333);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.5066666666666667, (double)IMAGE_HEIGHT * 0.30666666666666664);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.4866666666666667, (double)IMAGE_HEIGHT * 0.30666666666666664);
                POINTER.closePath();
                G2.setColor(SHADOW_COLOR);
                G2.fill(POINTER);
                break;
            }
            case TYPE8: {
                GeneralPath POINTER = new GeneralPath();
                POINTER.setWindingRule(0);
                POINTER.moveTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.7666666666666667);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.5333333333333333, (double)IMAGE_HEIGHT * 0.7333333333333333);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.5333333333333333, (double)IMAGE_HEIGHT * 0.7333333333333333, (double)IMAGE_WIDTH * 0.5066666666666667, (double)IMAGE_HEIGHT * 0.7066666666666667, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.31333333333333335);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.49333333333333335, (double)IMAGE_HEIGHT * 0.7066666666666667, (double)IMAGE_WIDTH * 0.4666666666666667, (double)IMAGE_HEIGHT * 0.7333333333333333, (double)IMAGE_WIDTH * 0.4666666666666667, (double)IMAGE_HEIGHT * 0.7333333333333333);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.7666666666666667);
                POINTER.closePath();
                G2.setColor(SHADOW_COLOR);
                G2.fill(POINTER);
                break;
            }
            case TYPE9: {
                GeneralPath POINTER = new GeneralPath();
                POINTER.setWindingRule(0);
                POINTER.moveTo((double)IMAGE_WIDTH * 0.49333333333333335, (double)IMAGE_HEIGHT * 0.42);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.5066666666666667, (double)IMAGE_HEIGHT * 0.42);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.5133333333333333, (double)IMAGE_HEIGHT * 0.66);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.4866666666666667, (double)IMAGE_HEIGHT * 0.66);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.49333333333333335, (double)IMAGE_HEIGHT * 0.42);
                POINTER.closePath();
                POINTER.moveTo((double)IMAGE_WIDTH * 0.49333333333333335, (double)IMAGE_HEIGHT * 0.3);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.47333333333333333, (double)IMAGE_HEIGHT * 0.7);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.47333333333333333, (double)IMAGE_HEIGHT * 0.7666666666666667);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.47333333333333333, (double)IMAGE_HEIGHT * 0.7666666666666667, (double)IMAGE_WIDTH * 0.47333333333333333, (double)IMAGE_HEIGHT * 0.8533333333333334, (double)IMAGE_WIDTH * 0.47333333333333333, (double)IMAGE_HEIGHT * 0.8533333333333334);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.47333333333333333, (double)IMAGE_HEIGHT * 0.86, (double)IMAGE_WIDTH * 0.48, (double)IMAGE_HEIGHT * 0.86, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.86);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.52, (double)IMAGE_HEIGHT * 0.86, (double)IMAGE_WIDTH * 0.5266666666666666, (double)IMAGE_HEIGHT * 0.86, (double)IMAGE_WIDTH * 0.5266666666666666, (double)IMAGE_HEIGHT * 0.8533333333333334);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.5266666666666666, (double)IMAGE_HEIGHT * 0.8533333333333334, (double)IMAGE_WIDTH * 0.5266666666666666, (double)IMAGE_HEIGHT * 0.7666666666666667, (double)IMAGE_WIDTH * 0.5266666666666666, (double)IMAGE_HEIGHT * 0.7666666666666667);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.5266666666666666, (double)IMAGE_HEIGHT * 0.7);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.5066666666666667, (double)IMAGE_HEIGHT * 0.3);
                POINTER.lineTo((double)IMAGE_WIDTH * 0.49333333333333335, (double)IMAGE_HEIGHT * 0.3);
                POINTER.closePath();
                G2.setColor(SHADOW_COLOR);
                G2.fill(POINTER);
                break;
            }
            case TYPE10: {
                GeneralPath POINTER = new GeneralPath();
                POINTER.setWindingRule(0);
                POINTER.moveTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.3);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.3, (double)IMAGE_WIDTH * 0.43333333333333335, (double)IMAGE_HEIGHT * 0.7133333333333334, (double)IMAGE_WIDTH * 0.43333333333333335, (double)IMAGE_HEIGHT * 0.7266666666666667);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.43333333333333335, (double)IMAGE_HEIGHT * 0.76, (double)IMAGE_WIDTH * 0.46, (double)IMAGE_HEIGHT * 0.7933333333333333, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.7933333333333333);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.54, (double)IMAGE_HEIGHT * 0.7933333333333333, (double)IMAGE_WIDTH * 0.5666666666666667, (double)IMAGE_HEIGHT * 0.76, (double)IMAGE_WIDTH * 0.5666666666666667, (double)IMAGE_HEIGHT * 0.7266666666666667);
                POINTER.curveTo((double)IMAGE_WIDTH * 0.5666666666666667, (double)IMAGE_HEIGHT * 0.7133333333333334, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.3, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.3);
                POINTER.closePath();
                G2.setColor(SHADOW_COLOR);
                G2.fill(POINTER);
                break;
            }
            case TYPE11: {
                GeneralPath POINTER = new GeneralPath();
                POINTER.setWindingRule(0);
                POINTER.moveTo(0.5 * (double)IMAGE_WIDTH, 0.3 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.4866666666666667 * (double)IMAGE_WIDTH, 0.7333333333333333 * (double)IMAGE_HEIGHT);
                POINTER.curveTo(0.4866666666666667 * (double)IMAGE_WIDTH, 0.7333333333333333 * (double)IMAGE_HEIGHT, 0.4866666666666667 * (double)IMAGE_WIDTH, 0.8066666666666666 * (double)IMAGE_HEIGHT, 0.5 * (double)IMAGE_WIDTH, 0.8066666666666666 * (double)IMAGE_HEIGHT);
                POINTER.curveTo(0.5133333333333333 * (double)IMAGE_WIDTH, 0.8066666666666666 * (double)IMAGE_HEIGHT, 0.5133333333333333 * (double)IMAGE_WIDTH, 0.7333333333333333 * (double)IMAGE_HEIGHT, 0.5133333333333333 * (double)IMAGE_WIDTH, 0.7333333333333333 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.5 * (double)IMAGE_WIDTH, 0.3 * (double)IMAGE_HEIGHT);
                POINTER.closePath();
                G2.setColor(SHADOW_COLOR);
                G2.fill(POINTER);
                break;
            }
            case TYPE12: {
                GeneralPath POINTER = new GeneralPath();
                POINTER.setWindingRule(0);
                POINTER.moveTo(0.5 * (double)IMAGE_WIDTH, 0.3 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.4866666666666667 * (double)IMAGE_WIDTH, 0.7333333333333333 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.5 * (double)IMAGE_WIDTH, 0.7466666666666667 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.5133333333333333 * (double)IMAGE_WIDTH, 0.7333333333333333 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.5 * (double)IMAGE_WIDTH, 0.3 * (double)IMAGE_HEIGHT);
                POINTER.closePath();
                G2.setColor(SHADOW_COLOR);
                G2.fill(POINTER);
                break;
            }
            case TYPE13: {
                GeneralPath POINTER = new GeneralPath();
                POINTER.setWindingRule(0);
                POINTER.moveTo(0.4866666666666667 * (double)IMAGE_WIDTH, 0.32666666666666666 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.5 * (double)IMAGE_WIDTH, 0.29333333333333333 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.5133333333333333 * (double)IMAGE_WIDTH, 0.32666666666666666 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.5133333333333333 * (double)IMAGE_WIDTH, 0.7466666666666667 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.4866666666666667 * (double)IMAGE_WIDTH, 0.7466666666666667 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.4866666666666667 * (double)IMAGE_WIDTH, 0.32666666666666666 * (double)IMAGE_HEIGHT);
                POINTER.closePath();
                G2.setColor(SHADOW_COLOR);
                G2.fill(POINTER);
                break;
            }
            case TYPE14: {
                GeneralPath POINTER = new GeneralPath();
                POINTER.setWindingRule(0);
                POINTER.moveTo(0.4866666666666667 * (double)IMAGE_WIDTH, 0.32666666666666666 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.5 * (double)IMAGE_WIDTH, 0.29333333333333333 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.5133333333333333 * (double)IMAGE_WIDTH, 0.32666666666666666 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.5133333333333333 * (double)IMAGE_WIDTH, 0.7466666666666667 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.4866666666666667 * (double)IMAGE_WIDTH, 0.7466666666666667 * (double)IMAGE_HEIGHT);
                POINTER.lineTo(0.4866666666666667 * (double)IMAGE_WIDTH, 0.32666666666666666 * (double)IMAGE_HEIGHT);
                POINTER.closePath();
                G2.setColor(SHADOW_COLOR);
                G2.fill(POINTER);
            }
        }
        G2.dispose();
        return IMAGE;
    }

    @Override
    public String toString() {
        return "Radial1Vertical";
    }
}

