/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.tools;

import eu.hansolo.steelseries.tools.Util;
import java.awt.Color;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class ContourGradientPaint
implements Paint {
    private static final Util UTIL = Util.INSTANCE;
    private final Rectangle2D BOUNDS;
    private final Float[] FRACTIONS;
    private final Color[] COLORS;
    private List<Color> colorLookup = new ArrayList<Color>(256);

    public ContourGradientPaint(Rectangle2D GIVEN_BOUNDS, float[] GIVEN_FRACTIONS, Color[] GIVEN_COLORS) throws IllegalArgumentException {
        this.BOUNDS = GIVEN_BOUNDS;
        if (GIVEN_FRACTIONS.length != GIVEN_COLORS.length) {
            throw new IllegalArgumentException("Fractions and colors must be equal in size");
        }
        ArrayList<Float> fractionList = new ArrayList<Float>(GIVEN_FRACTIONS.length);
        for (float fraction : GIVEN_FRACTIONS) {
            fractionList.add(Float.valueOf(fraction));
        }
        ArrayList<Color> colorList = new ArrayList<Color>(GIVEN_COLORS.length);
        colorList.addAll(Arrays.asList(GIVEN_COLORS));
        if (((Float)fractionList.get(0)).floatValue() != 0.0f) {
            fractionList.add(0, Float.valueOf(0.0f));
            Color TMP_COLOR = (Color)colorList.get(0);
            colorList.add(0, TMP_COLOR);
        }
        if (((Float)fractionList.get(fractionList.size() - 1)).floatValue() != 1.0f) {
            fractionList.add(Float.valueOf(1.0f));
            colorList.add(GIVEN_COLORS[0]);
        }
        this.COLORS = new Color[colorList.size()];
        this.FRACTIONS = new Float[fractionList.size()];
        colorList.toArray(this.COLORS);
        fractionList.toArray(this.FRACTIONS);
        this.colorLookup.clear();
        this.colorLookup.addAll(this.prepareColorLookup());
    }

    private List<Color> prepareColorLookup() {
        int SIZE = this.BOUNDS.getWidth() <= this.BOUNDS.getHeight() ? (int)(this.BOUNDS.getWidth() / 2.0) : (int)(this.BOUNDS.getHeight() / 2.0);
        ArrayList<Color> tmpColorLookup = new ArrayList<Color>(SIZE);
        for (int colorIndex = 0; colorIndex < this.COLORS.length - 1; ++colorIndex) {
            int relativeValue = 0;
            for (int value = (int)(this.FRACTIONS[colorIndex].floatValue() * (float)SIZE); value < (int)(this.FRACTIONS[colorIndex + 1].floatValue() * (float)SIZE); ++value) {
                tmpColorLookup.add(UTIL.getColorFromFraction(this.COLORS[colorIndex], this.COLORS[colorIndex + 1], (int)((this.FRACTIONS[colorIndex + 1].floatValue() - this.FRACTIONS[colorIndex].floatValue()) * (float)SIZE), relativeValue));
                ++relativeValue;
            }
        }
        return tmpColorLookup;
    }

    @Override
    public PaintContext createContext(ColorModel COLOR_MODEL, Rectangle DEVICE_BOUNDS, Rectangle2D USER_BOUNDS, AffineTransform TRANSFORM, RenderingHints HINTS) {
        return new ContourGradientPaintContext();
    }

    @Override
    public int getTransparency() {
        return 3;
    }

    public String toString() {
        return "ContourGradientPaint";
    }

    private final class ContourGradientPaintContext
    implements PaintContext {
        private final Point2D P1;
        private final Point2D P2;
        final GeneralPath SECTOR_A = new GeneralPath();
        final GeneralPath SECTOR_B = new GeneralPath();
        final GeneralPath SECTOR_C = new GeneralPath();
        final GeneralPath SECTOR_D = new GeneralPath();

        public ContourGradientPaintContext() {
            if (ContourGradientPaint.this.BOUNDS.getWidth() > ContourGradientPaint.this.BOUNDS.getHeight()) {
                this.P1 = new Point2D.Double(ContourGradientPaint.this.BOUNDS.getX() + ContourGradientPaint.this.BOUNDS.getHeight() / 2.0, ContourGradientPaint.this.BOUNDS.getY() + ContourGradientPaint.this.BOUNDS.getHeight() / 2.0);
                this.P2 = new Point2D.Double(ContourGradientPaint.this.BOUNDS.getMaxX() - ContourGradientPaint.this.BOUNDS.getHeight() / 2.0, ContourGradientPaint.this.BOUNDS.getMinY() + ContourGradientPaint.this.BOUNDS.getHeight() / 2.0);
            } else if (ContourGradientPaint.this.BOUNDS.getWidth() < ContourGradientPaint.this.BOUNDS.getHeight()) {
                this.P1 = new Point2D.Double(ContourGradientPaint.this.BOUNDS.getX() + ContourGradientPaint.this.BOUNDS.getWidth() / 2.0, ContourGradientPaint.this.BOUNDS.getY() + ContourGradientPaint.this.BOUNDS.getWidth() / 2.0);
                this.P2 = new Point2D.Double(ContourGradientPaint.this.BOUNDS.getX() + ContourGradientPaint.this.BOUNDS.getWidth() / 2.0, ContourGradientPaint.this.BOUNDS.getMaxY() - ContourGradientPaint.this.BOUNDS.getWidth() / 2.0);
            } else {
                this.P2 = this.P1 = new Point2D.Double(ContourGradientPaint.this.BOUNDS.getX() + ContourGradientPaint.this.BOUNDS.getWidth() / 2.0, ContourGradientPaint.this.BOUNDS.getY() + ContourGradientPaint.this.BOUNDS.getHeight() / 2.0);
            }
            this.SECTOR_A.moveTo(ContourGradientPaint.this.BOUNDS.getMinX(), ContourGradientPaint.this.BOUNDS.getMaxY());
            this.SECTOR_A.lineTo(this.P1.getX(), this.P2.getY());
            this.SECTOR_A.lineTo(this.P1.getX(), this.P1.getY());
            this.SECTOR_A.lineTo(ContourGradientPaint.this.BOUNDS.getMinX(), ContourGradientPaint.this.BOUNDS.getMinY());
            this.SECTOR_A.closePath();
            this.SECTOR_B.moveTo(ContourGradientPaint.this.BOUNDS.getMinX(), ContourGradientPaint.this.BOUNDS.getMinY());
            this.SECTOR_B.lineTo(this.P1.getX(), this.P1.getY());
            this.SECTOR_B.lineTo(this.P2.getX(), this.P1.getY());
            this.SECTOR_B.lineTo(ContourGradientPaint.this.BOUNDS.getMaxX(), ContourGradientPaint.this.BOUNDS.getMinY());
            this.SECTOR_B.closePath();
            this.SECTOR_C.moveTo(ContourGradientPaint.this.BOUNDS.getMaxX(), ContourGradientPaint.this.BOUNDS.getMinY());
            this.SECTOR_C.lineTo(this.P2.getX(), this.P1.getY());
            this.SECTOR_C.lineTo(this.P2.getX(), this.P2.getY());
            this.SECTOR_C.lineTo(ContourGradientPaint.this.BOUNDS.getMaxX(), ContourGradientPaint.this.BOUNDS.getMaxY());
            this.SECTOR_C.closePath();
            this.SECTOR_D.moveTo(ContourGradientPaint.this.BOUNDS.getMaxX(), ContourGradientPaint.this.BOUNDS.getMaxY());
            this.SECTOR_D.lineTo(this.P2.getX(), this.P2.getY());
            this.SECTOR_D.lineTo(this.P1.getX(), this.P2.getY());
            this.SECTOR_D.lineTo(ContourGradientPaint.this.BOUNDS.getMinX(), ContourGradientPaint.this.BOUNDS.getMaxY());
            this.SECTOR_D.closePath();
        }

        @Override
        public void dispose() {
        }

        @Override
        public ColorModel getColorModel() {
            return ColorModel.getRGBdefault();
        }

        @Override
        public Raster getRaster(int X, int Y, int TILE_WIDTH, int TILE_HEIGHT) {
            Point P = new Point(0, 0);
            WritableRaster RASTER = this.getColorModel().createCompatibleWritableRaster(TILE_WIDTH, TILE_HEIGHT);
            int[] data = new int[TILE_WIDTH * TILE_HEIGHT * 4];
            Color currentColor = new Color(0.0f, 0.0f, 0.0f, 0.0f);
            int currentRed = 0;
            int currentGreen = 0;
            int currentBlue = 0;
            int currentAlpha = 0;
            for (int tileY = 0; tileY < TILE_HEIGHT; ++tileY) {
                for (int tileX = 0; tileX < TILE_WIDTH; ++tileX) {
                    P.setLocation(X + tileX, Y + tileY);
                    if (this.SECTOR_A.contains(P) && X + tileX - ((ContourGradientPaint)ContourGradientPaint.this).BOUNDS.getBounds().x < ContourGradientPaint.this.colorLookup.size()) {
                        currentColor = (Color)ContourGradientPaint.this.colorLookup.get(X + tileX - ((ContourGradientPaint)ContourGradientPaint.this).BOUNDS.getBounds().x);
                    }
                    if (this.SECTOR_B.contains(P) && Y + tileY - ((ContourGradientPaint)ContourGradientPaint.this).BOUNDS.getBounds().y < ContourGradientPaint.this.colorLookup.size()) {
                        currentColor = (Color)ContourGradientPaint.this.colorLookup.get(Y + tileY - ((ContourGradientPaint)ContourGradientPaint.this).BOUNDS.getBounds().y);
                    }
                    if (this.SECTOR_C.contains(P) && ContourGradientPaint.this.colorLookup.size() - (X + tileX - this.SECTOR_A.getBounds().width - ((ContourGradientPaint)ContourGradientPaint.this).BOUNDS.getBounds().x - ((int)this.P2.getX() - (int)this.P1.getX())) < ContourGradientPaint.this.colorLookup.size()) {
                        currentColor = (Color)ContourGradientPaint.this.colorLookup.get(ContourGradientPaint.this.colorLookup.size() - (X + tileX - this.SECTOR_A.getBounds().width - ((ContourGradientPaint)ContourGradientPaint.this).BOUNDS.getBounds().x - ((int)this.P2.getX() - (int)this.P1.getX())));
                    }
                    if (this.SECTOR_D.contains(P) && ContourGradientPaint.this.colorLookup.size() - (Y + tileY - this.SECTOR_B.getBounds().height - ((ContourGradientPaint)ContourGradientPaint.this).BOUNDS.getBounds().y - ((int)this.P2.getY() - (int)this.P1.getY())) < ContourGradientPaint.this.colorLookup.size()) {
                        currentColor = (Color)ContourGradientPaint.this.colorLookup.get(ContourGradientPaint.this.colorLookup.size() - (Y + tileY - this.SECTOR_B.getBounds().height - ((ContourGradientPaint)ContourGradientPaint.this).BOUNDS.getBounds().y - ((int)this.P2.getY() - (int)this.P1.getY())));
                    }
                    currentRed = currentColor.getRed();
                    currentGreen = currentColor.getGreen();
                    currentBlue = currentColor.getBlue();
                    currentAlpha = currentColor.getAlpha();
                    int BASE = (tileY * TILE_WIDTH + tileX) * 4;
                    data[BASE + 0] = currentRed;
                    data[BASE + 1] = currentGreen;
                    data[BASE + 2] = currentBlue;
                    data[BASE + 3] = currentAlpha;
                }
            }
            RASTER.setPixels(0, 0, TILE_WIDTH, TILE_HEIGHT, data);
            return RASTER;
        }
    }
}

