/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.tools;

import eu.hansolo.steelseries.tools.ConicalGradientPaint;
import eu.hansolo.steelseries.tools.KnobStyle;
import eu.hansolo.steelseries.tools.KnobType;
import eu.hansolo.steelseries.tools.Util;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.RadialGradientPaint;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;

public enum KnobImageFactory {
    INSTANCE;

    private final Util UTIL = Util.INSTANCE;
    private int sizeBuffer = 0;
    private KnobType knobTypeBuffer = KnobType.SMALL_STD_KNOB;
    private KnobStyle knobStyleBuffer = KnobStyle.SILVER;
    private BufferedImage knobImageBuffer = this.UTIL.createImage(1, 1, 3);

    public BufferedImage create_KNOB_Image(int SIZE, KnobType KNOB_TYPE, KnobStyle KNOB_STYLE) {
        if (SIZE <= 0) {
            return this.UTIL.createImage(1, 1, 3);
        }
        if (this.sizeBuffer == SIZE && this.knobTypeBuffer == KNOB_TYPE && this.knobStyleBuffer == KNOB_STYLE) {
            return this.knobImageBuffer;
        }
        this.knobImageBuffer.flush();
        this.knobImageBuffer = this.UTIL.createImage(SIZE, SIZE, 3);
        Graphics2D G2 = this.knobImageBuffer.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int IMAGE_WIDTH = this.knobImageBuffer.getWidth();
        int IMAGE_HEIGHT = this.knobImageBuffer.getHeight();
        switch (KNOB_TYPE) {
            case SMALL_STD_KNOB: {
                Color[] POST_MAIN_COLORS;
                Ellipse2D.Double POST_FRAME = new Ellipse2D.Double(0.0, 0.0, IMAGE_WIDTH, IMAGE_HEIGHT);
                Point2D.Double POST_FRAME_START = new Point2D.Double(0.0, POST_FRAME.getBounds2D().getMinY());
                Point2D.Double POST_FRAME_STOP = new Point2D.Double(0.0, POST_FRAME.getBounds2D().getMaxY());
                float[] POST_FRAME_FRACTIONS = new float[]{0.0f, 0.46f, 1.0f};
                Color[] POST_FRAME_COLORS = new Color[]{new Color(180, 180, 180, 255), new Color(63, 63, 63, 255), new Color(40, 40, 40, 255)};
                LinearGradientPaint POST_FRAME_GRADIENT = new LinearGradientPaint(POST_FRAME_START, POST_FRAME_STOP, POST_FRAME_FRACTIONS, POST_FRAME_COLORS);
                G2.setPaint(POST_FRAME_GRADIENT);
                G2.fill(POST_FRAME);
                Ellipse2D.Double POST_MAIN = new Ellipse2D.Double(((double)IMAGE_WIDTH - (double)IMAGE_WIDTH * 0.77) / 2.0, ((double)IMAGE_WIDTH - (double)IMAGE_WIDTH * 0.77) / 2.0, (double)IMAGE_WIDTH * 0.77, (double)IMAGE_WIDTH * 0.77);
                Point2D.Double POST_MAIN_START = new Point2D.Double(0.0, POST_MAIN.getBounds2D().getMinY());
                Point2D.Double POST_MAIN_STOP = new Point2D.Double(0.0, POST_MAIN.getBounds2D().getMaxY());
                float[] POST_MAIN_FRACTIONS = new float[]{0.0f, 0.5f, 1.0f};
                switch (KNOB_STYLE) {
                    case BLACK: {
                        POST_MAIN_COLORS = new Color[]{new Color(0xBFBFBF), new Color(2828847), new Color(8224384)};
                        break;
                    }
                    case BRASS: {
                        POST_MAIN_COLORS = new Color[]{new Color(14667950), new Color(8019518), new Color(13614749)};
                        break;
                    }
                    default: {
                        POST_MAIN_COLORS = new Color[]{new Color(0xD7D7D7), new Color(0x747474), new Color(0xD7D7D7)};
                    }
                }
                LinearGradientPaint POST_MAIN_GRADIENT = new LinearGradientPaint(POST_MAIN_START, POST_MAIN_STOP, POST_MAIN_FRACTIONS, POST_MAIN_COLORS);
                G2.setPaint(POST_MAIN_GRADIENT);
                G2.fill(POST_MAIN);
                Ellipse2D.Double POST_INNERSHADOW = new Ellipse2D.Double(((double)IMAGE_WIDTH - (double)IMAGE_WIDTH * 0.77) / 2.0, ((double)IMAGE_WIDTH - (double)IMAGE_WIDTH * 0.77) / 2.0, (double)IMAGE_WIDTH * 0.77, (double)IMAGE_WIDTH * 0.77);
                Point2D.Double POST_INNERSHADOW_CENTER = new Point2D.Double(POST_INNERSHADOW.getCenterX(), POST_INNERSHADOW.getCenterY());
                float[] POST_INNERSHADOW_FRACTIONS = new float[]{0.0f, 0.75f, 0.76f, 1.0f};
                Color[] POST_INNERSHADOW_COLORS = new Color[]{new Color(0, 0, 0, 0), new Color(0, 0, 0, 0), new Color(0, 0, 0, 1), new Color(0, 0, 0, 51)};
                RadialGradientPaint POST_INNERSHADOW_GRADIENT = new RadialGradientPaint(POST_INNERSHADOW_CENTER, (float)(((RectangularShape)POST_INNERSHADOW).getWidth() / 2.0), POST_INNERSHADOW_FRACTIONS, POST_INNERSHADOW_COLORS);
                G2.setPaint(POST_INNERSHADOW_GRADIENT);
                G2.fill(POST_INNERSHADOW);
                break;
            }
            case BIG_STD_KNOB: {
                Color[] BIGCENTER_FOREGROUND_COLORS;
                Color[] BIGCENTER_FOREGROUNDFRAME_COLORS;
                Color[] BIGCENTER_BACKGROUND_COLORS;
                Color[] BIGCENTER_BACKGROUNDFRAME_COLORS;
                Ellipse2D.Double BIGCENTER_BACKGROUNDFRAME = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.4392523467540741, (double)IMAGE_HEIGHT * 0.4392523467540741, (double)IMAGE_WIDTH * 0.1214953362941742, (double)IMAGE_HEIGHT * 0.1214953362941742);
                Point2D.Double BIGCENTER_BACKGROUNDFRAME_START = new Point2D.Double(0.0, BIGCENTER_BACKGROUNDFRAME.getBounds2D().getMinY());
                Point2D.Double BIGCENTER_BACKGROUNDFRAME_STOP = new Point2D.Double(0.0, BIGCENTER_BACKGROUNDFRAME.getBounds2D().getMaxY());
                float[] BIGCENTER_BACKGROUNDFRAME_FRACTIONS = new float[]{0.0f, 1.0f};
                switch (KNOB_STYLE) {
                    case BLACK: {
                        BIGCENTER_BACKGROUNDFRAME_COLORS = new Color[]{new Color(129, 133, 136, 255), new Color(61, 61, 73, 255)};
                        break;
                    }
                    case BRASS: {
                        BIGCENTER_BACKGROUNDFRAME_COLORS = new Color[]{new Color(143, 117, 80, 255), new Color(100, 76, 49, 255)};
                        break;
                    }
                    default: {
                        BIGCENTER_BACKGROUNDFRAME_COLORS = new Color[]{new Color(152, 152, 152, 255), new Color(118, 121, 126, 255)};
                    }
                }
                LinearGradientPaint BIGCENTER_BACKGROUNDFRAME_GRADIENT = new LinearGradientPaint(BIGCENTER_BACKGROUNDFRAME_START, BIGCENTER_BACKGROUNDFRAME_STOP, BIGCENTER_BACKGROUNDFRAME_FRACTIONS, BIGCENTER_BACKGROUNDFRAME_COLORS);
                G2.setPaint(BIGCENTER_BACKGROUNDFRAME_GRADIENT);
                G2.fill(BIGCENTER_BACKGROUNDFRAME);
                Ellipse2D.Double BIGCENTER_BACKGROUND = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.44392523169517517, (double)IMAGE_HEIGHT * 0.44392523169517517, (double)IMAGE_WIDTH * 0.11214950680732727, (double)IMAGE_HEIGHT * 0.11214950680732727);
                Point2D.Double BIGCENTER_BACKGROUND_START = new Point2D.Double(0.0, BIGCENTER_BACKGROUND.getBounds2D().getMinY());
                Point2D.Double BIGCENTER_BACKGROUND_STOP = new Point2D.Double(0.0, BIGCENTER_BACKGROUND.getBounds2D().getMaxY());
                float[] BIGCENTER_BACKGROUND_FRACTIONS = new float[]{0.0f, 1.0f};
                switch (KNOB_STYLE) {
                    case BLACK: {
                        BIGCENTER_BACKGROUND_COLORS = new Color[]{new Color(26, 27, 32, 255), new Color(96, 97, 102, 255)};
                        break;
                    }
                    case BRASS: {
                        BIGCENTER_BACKGROUND_COLORS = new Color[]{new Color(98, 75, 49, 255), new Color(149, 109, 54, 255)};
                        break;
                    }
                    default: {
                        BIGCENTER_BACKGROUND_COLORS = new Color[]{new Color(118, 121, 126, 255), new Color(191, 191, 191, 255)};
                    }
                }
                LinearGradientPaint BIGCENTER_BACKGROUND_GRADIENT = new LinearGradientPaint(BIGCENTER_BACKGROUND_START, BIGCENTER_BACKGROUND_STOP, BIGCENTER_BACKGROUND_FRACTIONS, BIGCENTER_BACKGROUND_COLORS);
                G2.setPaint(BIGCENTER_BACKGROUND_GRADIENT);
                G2.fill(BIGCENTER_BACKGROUND);
                Ellipse2D.Double BIGCENTER_FOREGROUNDFRAME = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.4532710313796997, (double)IMAGE_HEIGHT * 0.4532710313796997, (double)IMAGE_WIDTH * 0.09345793724060059, (double)IMAGE_HEIGHT * 0.09345793724060059);
                Point2D.Double BIGCENTER_FOREGROUNDFRAME_START = new Point2D.Double(0.0, BIGCENTER_FOREGROUNDFRAME.getBounds2D().getMinY());
                Point2D.Double BIGCENTER_FOREGROUNDFRAME_STOP = new Point2D.Double(0.0, BIGCENTER_FOREGROUNDFRAME.getBounds2D().getMaxY());
                float[] BIGCENTER_FOREGROUNDFRAME_FRACTIONS = new float[]{0.0f, 0.47f, 1.0f};
                switch (KNOB_STYLE) {
                    case BLACK: {
                        BIGCENTER_FOREGROUNDFRAME_COLORS = new Color[]{new Color(191, 191, 191, 255), new Color(56, 57, 61, 255), new Color(143, 144, 146, 255)};
                        break;
                    }
                    case BRASS: {
                        BIGCENTER_FOREGROUNDFRAME_COLORS = new Color[]{new Color(147, 108, 54, 255), new Color(82, 66, 50, 255), new Color(147, 108, 54, 255)};
                        break;
                    }
                    default: {
                        BIGCENTER_FOREGROUNDFRAME_COLORS = new Color[]{new Color(191, 191, 191, 255), new Color(116, 116, 116, 255), new Color(143, 144, 146, 255)};
                    }
                }
                LinearGradientPaint BIGCENTER_FOREGROUNDFRAME_GRADIENT = new LinearGradientPaint(BIGCENTER_FOREGROUNDFRAME_START, BIGCENTER_FOREGROUNDFRAME_STOP, BIGCENTER_FOREGROUNDFRAME_FRACTIONS, BIGCENTER_FOREGROUNDFRAME_COLORS);
                G2.setPaint(BIGCENTER_FOREGROUNDFRAME_GRADIENT);
                G2.fill(BIGCENTER_FOREGROUNDFRAME);
                Ellipse2D.Double BIGCENTER_FOREGROUND = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.4579439163208008, (double)IMAGE_HEIGHT * 0.4579439163208008, (double)IMAGE_WIDTH * 0.08411216735839844, (double)IMAGE_HEIGHT * 0.08411216735839844);
                Point2D.Double BIGCENTER_FOREGROUND_START = new Point2D.Double(0.0, BIGCENTER_FOREGROUND.getBounds2D().getMinY());
                Point2D.Double BIGCENTER_FOREGROUND_STOP = new Point2D.Double(0.0, BIGCENTER_FOREGROUND.getBounds2D().getMaxY());
                float[] BIGCENTER_FOREGROUND_FRACTIONS = new float[]{0.0f, 0.21f, 0.5f, 0.78f, 1.0f};
                switch (KNOB_STYLE) {
                    case BLACK: {
                        BIGCENTER_FOREGROUND_COLORS = new Color[]{new Color(191, 191, 191, 255), new Color(94, 93, 99, 255), new Color(43, 42, 47, 255), new Color(78, 79, 81, 255), new Color(143, 144, 146, 255)};
                        break;
                    }
                    case BRASS: {
                        BIGCENTER_FOREGROUND_COLORS = new Color[]{new Color(223, 208, 174, 255), new Color(159, 136, 104, 255), new Color(122, 94, 62, 255), new Color(159, 136, 104, 255), new Color(223, 208, 174, 255)};
                        break;
                    }
                    default: {
                        BIGCENTER_FOREGROUND_COLORS = new Color[]{new Color(215, 215, 215, 255), new Color(139, 142, 145, 255), new Color(100, 100, 100, 255), new Color(139, 142, 145, 255), new Color(215, 215, 215, 255)};
                    }
                }
                LinearGradientPaint BIGCENTER_FOREGROUND_GRADIENT = new LinearGradientPaint(BIGCENTER_FOREGROUND_START, BIGCENTER_FOREGROUND_STOP, BIGCENTER_FOREGROUND_FRACTIONS, BIGCENTER_FOREGROUND_COLORS);
                G2.setPaint(BIGCENTER_FOREGROUND_GRADIENT);
                G2.fill(BIGCENTER_FOREGROUND);
                break;
            }
            case BIG_CHROME_KNOB: {
                Ellipse2D.Double CHROMEKNOB_BACKFRAME = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.42990654706954956, (double)IMAGE_HEIGHT * 0.42990654706954956, (double)IMAGE_WIDTH * (double)0.1401869f, (double)IMAGE_HEIGHT * (double)0.1401869f);
                Point2D.Double CHROMEKNOB_BACKFRAME_START = new Point2D.Double(0.46261682242990654 * (double)IMAGE_WIDTH, 0.4392523364485981 * (double)IMAGE_HEIGHT);
                Point2D.Double CHROMEKNOB_BACKFRAME_STOP = new Point2D.Double(0.534428311508238 * (double)IMAGE_WIDTH, 0.5541747420025063 * (double)IMAGE_HEIGHT);
                float[] CHROMEKNOB_BACKFRAME_FRACTIONS = new float[]{0.0f, 1.0f};
                Color[] CHROMEKNOB_BACKFRAME_COLORS = new Color[]{new Color(129, 139, 140, 255), new Color(166, 171, 175, 255)};
                LinearGradientPaint CHROMEKNOB_BACKFRAME_GRADIENT = new LinearGradientPaint(CHROMEKNOB_BACKFRAME_START, CHROMEKNOB_BACKFRAME_STOP, CHROMEKNOB_BACKFRAME_FRACTIONS, CHROMEKNOB_BACKFRAME_COLORS);
                G2.setPaint(CHROMEKNOB_BACKFRAME_GRADIENT);
                G2.fill(CHROMEKNOB_BACKFRAME);
                Ellipse2D.Double CHROMEKNOB_BACK = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.43457943201065063, (double)IMAGE_HEIGHT * 0.43457943201065063, (double)IMAGE_WIDTH * 0.13084113597869873, (double)IMAGE_HEIGHT * 0.13084113597869873);
                Point2D.Double CHROMEKNOB_BACK_CENTER = new Point2D.Double(CHROMEKNOB_BACK.getCenterX(), CHROMEKNOB_BACK.getCenterY());
                float[] CHROMEKNOB_BACK_FRACTIONS = new float[]{0.0f, 0.09f, 0.12f, 0.16f, 0.25f, 0.29f, 0.33f, 0.38f, 0.48f, 0.52f, 0.65f, 0.69f, 0.8f, 0.83f, 0.87f, 0.97f, 1.0f};
                Color[] CHROMEKNOB_BACK_COLORS = new Color[]{new Color(255, 255, 255, 255), new Color(255, 255, 255, 255), new Color(136, 136, 138, 255), new Color(164, 185, 190, 255), new Color(158, 179, 182, 255), new Color(112, 112, 112, 255), new Color(221, 227, 227, 255), new Color(155, 176, 179, 255), new Color(156, 176, 177, 255), new Color(254, 255, 255, 255), new Color(255, 255, 255, 255), new Color(156, 180, 180, 255), new Color(198, 209, 211, 255), new Color(246, 248, 247, 255), new Color(204, 216, 216, 255), new Color(164, 188, 190, 255), new Color(255, 255, 255, 255)};
                ConicalGradientPaint CHROMEKNOB_BACK_GRADIENT = new ConicalGradientPaint(false, CHROMEKNOB_BACK_CENTER, 0.0f, CHROMEKNOB_BACK_FRACTIONS, CHROMEKNOB_BACK_COLORS);
                G2.setPaint(CHROMEKNOB_BACK_GRADIENT);
                G2.fill(CHROMEKNOB_BACK);
                Ellipse2D.Double CHROMEKNOB_FOREFRAME = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.4672897160053253, (double)IMAGE_HEIGHT * 0.4672897160053253, (double)IMAGE_WIDTH * 0.06542053818702698, (double)IMAGE_HEIGHT * 0.06542053818702698);
                Point2D.Double CHROMEKNOB_FOREFRAME_START = new Point2D.Double(0.48130841121495327 * (double)IMAGE_WIDTH, 0.4719626168224299 * (double)IMAGE_HEIGHT);
                Point2D.Double CHROMEKNOB_FOREFRAME_STOP = new Point2D.Double(0.5152780735753257 * (double)IMAGE_WIDTH, 0.5223247123514745 * (double)IMAGE_HEIGHT);
                float[] CHROMEKNOB_FOREFRAME_FRACTIONS = new float[]{0.0f, 1.0f};
                Color[] CHROMEKNOB_FOREFRAME_COLORS = new Color[]{new Color(225, 235, 232, 255), new Color(196, 207, 207, 255)};
                LinearGradientPaint CHROMEKNOB_FOREFRAME_GRADIENT = new LinearGradientPaint(CHROMEKNOB_FOREFRAME_START, CHROMEKNOB_FOREFRAME_STOP, CHROMEKNOB_FOREFRAME_FRACTIONS, CHROMEKNOB_FOREFRAME_COLORS);
                G2.setPaint(CHROMEKNOB_FOREFRAME_GRADIENT);
                G2.fill(CHROMEKNOB_FOREFRAME);
                Ellipse2D.Double CHROMEKNOB_FORE = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.4719626307487488, (double)IMAGE_HEIGHT * 0.4719626307487488, (double)IMAGE_WIDTH * 0.05607473850250244, (double)IMAGE_HEIGHT * 0.05607473850250244);
                Point2D.Double CHROMEKNOB_FORE_START = new Point2D.Double(0.48130841121495327 * (double)IMAGE_WIDTH, 0.4766355140186916 * (double)IMAGE_HEIGHT);
                Point2D.Double CHROMEKNOB_FORE_STOP = new Point2D.Double(0.5126650226245278 * (double)IMAGE_WIDTH, 0.5231236021993482 * (double)IMAGE_HEIGHT);
                float[] CHROMEKNOB_FORE_FRACTIONS = new float[]{0.0f, 1.0f};
                Color[] CHROMEKNOB_FORE_COLORS = new Color[]{new Color(237, 239, 237, 255), new Color(148, 161, 161, 255)};
                LinearGradientPaint CHROMEKNOB_FORE_GRADIENT = new LinearGradientPaint(CHROMEKNOB_FORE_START, CHROMEKNOB_FORE_STOP, CHROMEKNOB_FORE_FRACTIONS, CHROMEKNOB_FORE_COLORS);
                G2.setPaint(CHROMEKNOB_FORE_GRADIENT);
                G2.fill(CHROMEKNOB_FORE);
                break;
            }
            case METAL_KNOB: {
                Color[] METALKNOB_MAIN_COLORS;
                Ellipse2D.Double METALKNOB_FRAME = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.4579439163208008, (double)IMAGE_HEIGHT * 0.4579439163208008, (double)IMAGE_WIDTH * 0.08411216735839844, (double)IMAGE_HEIGHT * 0.08411216735839844);
                Point2D.Double METALKNOB_FRAME_START = new Point2D.Double(0.0, METALKNOB_FRAME.getBounds2D().getMinY());
                Point2D.Double METALKNOB_FRAME_STOP = new Point2D.Double(0.0, METALKNOB_FRAME.getBounds2D().getMaxY());
                float[] METALKNOB_FRAME_FRACTIONS = new float[]{0.0f, 0.47f, 1.0f};
                Color[] METALKNOB_FRAME_COLORS = new Color[]{new Color(92, 95, 101, 255), new Color(46, 49, 53, 255), new Color(22, 23, 26, 255)};
                LinearGradientPaint METALKNOB_FRAME_GRADIENT = new LinearGradientPaint(METALKNOB_FRAME_START, METALKNOB_FRAME_STOP, METALKNOB_FRAME_FRACTIONS, METALKNOB_FRAME_COLORS);
                G2.setPaint(METALKNOB_FRAME_GRADIENT);
                G2.fill(METALKNOB_FRAME);
                Ellipse2D.Double METALKNOB_MAIN = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.46261683106422424, (double)IMAGE_HEIGHT * 0.46261683106422424, (double)IMAGE_WIDTH * 0.0747663676738739, (double)IMAGE_HEIGHT * 0.0747663676738739);
                Point2D.Double METALKNOB_MAIN_START = new Point2D.Double(0.0, METALKNOB_MAIN.getBounds2D().getMinY());
                Point2D.Double METALKNOB_MAIN_STOP = new Point2D.Double(0.0, METALKNOB_MAIN.getBounds2D().getMaxY());
                float[] METALKNOB_MAIN_FRACTIONS = new float[]{0.0f, 1.0f};
                switch (KNOB_STYLE) {
                    case BLACK: {
                        METALKNOB_MAIN_COLORS = new Color[]{new Color(2828847), new Color(1710880)};
                        break;
                    }
                    case BRASS: {
                        METALKNOB_MAIN_COLORS = new Color[]{new Color(9858614), new Color(8150845)};
                        break;
                    }
                    default: {
                        METALKNOB_MAIN_COLORS = new Color[]{new Color(204, 204, 204, 255), new Color(87, 92, 98, 255)};
                    }
                }
                LinearGradientPaint METALKNOB_MAIN_GRADIENT = new LinearGradientPaint(METALKNOB_MAIN_START, METALKNOB_MAIN_STOP, METALKNOB_MAIN_FRACTIONS, METALKNOB_MAIN_COLORS);
                G2.setPaint(METALKNOB_MAIN_GRADIENT);
                G2.fill(METALKNOB_MAIN);
                GeneralPath METALKNOB_LOWERHL = new GeneralPath();
                METALKNOB_LOWERHL.setWindingRule(0);
                METALKNOB_LOWERHL.moveTo((double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.5280373831775701);
                METALKNOB_LOWERHL.curveTo((double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.5186915887850467, (double)IMAGE_WIDTH * 0.5093457943925234, (double)IMAGE_HEIGHT * 0.514018691588785, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.514018691588785);
                METALKNOB_LOWERHL.curveTo((double)IMAGE_WIDTH * 0.48598130841121495, (double)IMAGE_HEIGHT * 0.514018691588785, (double)IMAGE_WIDTH * 0.4766355140186916, (double)IMAGE_HEIGHT * 0.5186915887850467, (double)IMAGE_WIDTH * 0.4766355140186916, (double)IMAGE_HEIGHT * 0.5280373831775701);
                METALKNOB_LOWERHL.curveTo((double)IMAGE_WIDTH * 0.48130841121495327, (double)IMAGE_HEIGHT * 0.5327102803738317, (double)IMAGE_WIDTH * 0.49065420560747663, (double)IMAGE_HEIGHT * 0.5373831775700935, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.5373831775700935);
                METALKNOB_LOWERHL.curveTo((double)IMAGE_WIDTH * 0.5046728971962616, (double)IMAGE_HEIGHT * 0.5373831775700935, (double)IMAGE_WIDTH * 0.514018691588785, (double)IMAGE_HEIGHT * 0.5327102803738317, (double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.5280373831775701);
                METALKNOB_LOWERHL.closePath();
                Point2D.Double METALKNOB_LOWERHL_CENTER = new Point2D.Double(0.5 * (double)IMAGE_WIDTH, 0.5373831775700935 * (double)IMAGE_HEIGHT);
                float[] METALKNOB_LOWERHL_FRACTIONS = new float[]{0.0f, 1.0f};
                Color[] METALKNOB_LOWERHL_COLORS = new Color[]{new Color(255, 255, 255, 153), new Color(255, 255, 255, 0)};
                RadialGradientPaint METALKNOB_LOWERHL_GRADIENT = new RadialGradientPaint(METALKNOB_LOWERHL_CENTER, (float)(0.03271028037383177 * (double)IMAGE_WIDTH), METALKNOB_LOWERHL_FRACTIONS, METALKNOB_LOWERHL_COLORS);
                G2.setPaint(METALKNOB_LOWERHL_GRADIENT);
                G2.fill(METALKNOB_LOWERHL);
                GeneralPath METALKNOB_UPPERHL = new GeneralPath();
                METALKNOB_UPPERHL.setWindingRule(0);
                METALKNOB_UPPERHL.moveTo((double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.48130841121495327);
                METALKNOB_UPPERHL.curveTo((double)IMAGE_WIDTH * 0.5280373831775701, (double)IMAGE_HEIGHT * 0.4672897196261682, (double)IMAGE_WIDTH * 0.514018691588785, (double)IMAGE_HEIGHT * 0.45794392523364486, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.45794392523364486);
                METALKNOB_UPPERHL.curveTo((double)IMAGE_WIDTH * 0.48130841121495327, (double)IMAGE_HEIGHT * 0.45794392523364486, (double)IMAGE_WIDTH * 0.4672897196261682, (double)IMAGE_HEIGHT * 0.4672897196261682, (double)IMAGE_WIDTH * 0.46261682242990654, (double)IMAGE_HEIGHT * 0.48130841121495327);
                METALKNOB_UPPERHL.curveTo((double)IMAGE_WIDTH * 0.4672897196261682, (double)IMAGE_HEIGHT * 0.48598130841121495, (double)IMAGE_WIDTH * 0.48130841121495327, (double)IMAGE_HEIGHT * 0.49065420560747663, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.49065420560747663);
                METALKNOB_UPPERHL.curveTo((double)IMAGE_WIDTH * 0.514018691588785, (double)IMAGE_HEIGHT * 0.49065420560747663, (double)IMAGE_WIDTH * 0.5280373831775701, (double)IMAGE_HEIGHT * 0.48598130841121495, (double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.48130841121495327);
                METALKNOB_UPPERHL.closePath();
                Point2D.Double METALKNOB_UPPERHL_CENTER = new Point2D.Double(0.4953271028037383 * (double)IMAGE_WIDTH, 0.45794392523364486 * (double)IMAGE_HEIGHT);
                float[] METALKNOB_UPPERHL_FRACTIONS = new float[]{0.0f, 1.0f};
                Color[] METALKNOB_UPPERHL_COLORS = new Color[]{new Color(255, 255, 255, 191), new Color(255, 255, 255, 0)};
                RadialGradientPaint METALKNOB_UPPERHL_GRADIENT = new RadialGradientPaint(METALKNOB_UPPERHL_CENTER, (float)(0.04906542056074766 * (double)IMAGE_WIDTH), METALKNOB_UPPERHL_FRACTIONS, METALKNOB_UPPERHL_COLORS);
                G2.setPaint(METALKNOB_UPPERHL_GRADIENT);
                G2.fill(METALKNOB_UPPERHL);
                Ellipse2D.Double METALKNOB_INNERFRAME = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.47663551568984985, (double)IMAGE_HEIGHT * 0.4813084006309509, (double)IMAGE_WIDTH * 0.04205608367919922, (double)IMAGE_HEIGHT * 0.04205608367919922);
                Point2D.Double METALKNOB_INNERFRAME_START = new Point2D.Double(0.0, METALKNOB_INNERFRAME.getBounds2D().getMinY());
                Point2D.Double METALKNOB_INNERFRAME_STOP = new Point2D.Double(0.0, METALKNOB_INNERFRAME.getBounds2D().getMaxY());
                float[] METALKNOB_INNERFRAME_FRACTIONS = new float[]{0.0f, 1.0f};
                Color[] METALKNOB_INNERFRAME_COLORS = new Color[]{new Color(0, 0, 0, 255), new Color(204, 204, 204, 255)};
                LinearGradientPaint METALKNOB_INNERFRAME_GRADIENT = new LinearGradientPaint(METALKNOB_INNERFRAME_START, METALKNOB_INNERFRAME_STOP, METALKNOB_INNERFRAME_FRACTIONS, METALKNOB_INNERFRAME_COLORS);
                G2.setPaint(METALKNOB_INNERFRAME_GRADIENT);
                G2.fill(METALKNOB_INNERFRAME);
                Ellipse2D.Double METALKNOB_INNERBACKGROUND = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.4813084006309509, (double)IMAGE_HEIGHT * 0.4859813153743744, (double)IMAGE_WIDTH * 0.03271031379699707, (double)IMAGE_HEIGHT * 0.03271028399467468);
                Point2D.Double METALKNOB_INNERBACKGROUND_START = new Point2D.Double(0.0, METALKNOB_INNERBACKGROUND.getBounds2D().getMinY());
                Point2D.Double METALKNOB_INNERBACKGROUND_STOP = new Point2D.Double(0.0, METALKNOB_INNERBACKGROUND.getBounds2D().getMaxY());
                float[] METALKNOB_INNERBACKGROUND_FRACTIONS = new float[]{0.0f, 1.0f};
                Color[] METALKNOB_INNERBACKGROUND_COLORS = new Color[]{new Color(1, 6, 11, 255), new Color(50, 52, 56, 255)};
                LinearGradientPaint METALKNOB_INNERBACKGROUND_GRADIENT = new LinearGradientPaint(METALKNOB_INNERBACKGROUND_START, METALKNOB_INNERBACKGROUND_STOP, METALKNOB_INNERBACKGROUND_FRACTIONS, METALKNOB_INNERBACKGROUND_COLORS);
                G2.setPaint(METALKNOB_INNERBACKGROUND_GRADIENT);
                G2.fill(METALKNOB_INNERBACKGROUND);
            }
        }
        G2.dispose();
        this.sizeBuffer = SIZE;
        this.knobTypeBuffer = KNOB_TYPE;
        this.knobStyleBuffer = KNOB_STYLE;
        return this.knobImageBuffer;
    }
}

