/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.tools;

import eu.hansolo.steelseries.tools.BackgroundColor;
import eu.hansolo.steelseries.tools.GaugeType;
import eu.hansolo.steelseries.tools.NumberFormat;
import eu.hansolo.steelseries.tools.Orientation;
import eu.hansolo.steelseries.tools.Section;
import eu.hansolo.steelseries.tools.TicklabelOrientation;
import eu.hansolo.steelseries.tools.TickmarkType;
import eu.hansolo.steelseries.tools.Util;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;

public enum TickmarkImageFactory {
    INSTANCE;

    private final Util UTIL = Util.INSTANCE;
    private static final BasicStroke MAJOR_TICKMARK_STROKE;
    private static final BasicStroke MEDIUM_TICKMARK_STROKE;
    private static final BasicStroke MINOR_TICKMARK_STROKE;
    private static final int BASE = 10;
    private NumberFormat numberFormat = NumberFormat.STANDARD;
    private BufferedImage imageBufferRad = this.UTIL.createImage(1, 1, 3);
    private int widthBufferRad = 200;
    private double minValueBufferRad = 0.0;
    private double maxValueBufferRad = 100.0;
    private int noOfMinorTicksBufferRad = 0;
    private int noOfMajorTicksBufferRad = 0;
    private double minorTickSpacingBufferRad = 10.0;
    private double majorTickSpacingBufferRad = 10.0;
    private GaugeType gaugeTypeBufferRad = GaugeType.TYPE4;
    private TickmarkType minorTickmarkTypeBufferRad = TickmarkType.LINE;
    private TickmarkType majorTickmarkTypeBufferRad = TickmarkType.LINE;
    private boolean ticksVisibleBufferRad = true;
    private boolean ticklabelsVisibleBufferRad = true;
    private boolean tickmarkSectionsVisibleBufferRad = false;
    private boolean minorTicksVisibleBufferRad = true;
    private boolean majorTicksVisibleBufferRad = true;
    private NumberFormat numberFormatBufferRad = NumberFormat.AUTO;
    private BackgroundColor backgroundColorBufferRad = BackgroundColor.DARK_GRAY;
    private Color tickmarkColorBufferRad;
    private boolean tickmarkColorFromThemeBufferRad;
    private List<Section> tickmarkSectionsBufferRad;
    private boolean sectionTickmarksOnlyBufferRad;
    private List<Section> sectionsBufferRad;
    private float radiusFactorBufferRad;
    private float textDistanceFactorBufferRad;
    private Point2D centerBufferRad;
    private Point2D offsetBufferRad;
    private Orientation orientationBufferRad;
    private TicklabelOrientation ticklabelOrientationBufferRad;
    private boolean niceScaleRad;
    private boolean logScaleRad;
    private BufferedImage imageBufferLin;
    private int widthBufferLin;
    private int heightBufferLin;
    private double minValueBufferLin;
    private double maxValueBufferLin;
    private int noOfMinorTicksBufferLin;
    private int noOfMajorTicksBufferLin;
    private double minorTickSpacingBufferLin;
    private double majorTickSpacingBufferLin;
    private TickmarkType minorTickmarkTypeBufferLin;
    private TickmarkType majorTickmarkTypeBufferLin;
    private boolean ticksVisibleBufferLin;
    private boolean ticklabelsVisibleBufferLin;
    private boolean minorTicksVisibleBufferLin;
    private boolean majorTicksVisibleBufferLin;
    private NumberFormat numberFormatBufferLin;
    private boolean tickmarkSectionsVisibleBufferLin;
    private BackgroundColor backgroundColorBufferLin;
    private Color tickmarkColorBufferLin;
    private boolean tickmarkColorFromThemeBufferLin;
    private List<Section> tickmarkSectionsBufferLin;
    private Point2D offsetBufferLin;
    private Orientation orientationBufferLin;
    private boolean niceScaleLin;
    private boolean logScaleLin;

    private TickmarkImageFactory() {
        this.tickmarkColorBufferRad = this.backgroundColorBufferRad.LABEL_COLOR;
        this.tickmarkColorFromThemeBufferRad = true;
        this.tickmarkSectionsBufferRad = new ArrayList<Section>(10);
        this.sectionTickmarksOnlyBufferRad = false;
        this.sectionsBufferRad = new ArrayList<Section>(10);
        this.radiusFactorBufferRad = 0.38f;
        this.textDistanceFactorBufferRad = 0.09f;
        this.centerBufferRad = new Point2D.Double();
        this.offsetBufferRad = new Point2D.Double();
        this.orientationBufferRad = Orientation.NORTH;
        this.ticklabelOrientationBufferRad = TicklabelOrientation.TANGENT;
        this.niceScaleRad = true;
        this.logScaleRad = false;
        this.imageBufferLin = this.UTIL.createImage(1, 1, 3);
        this.widthBufferLin = 140;
        this.heightBufferLin = 0;
        this.minValueBufferLin = 0.0;
        this.maxValueBufferLin = 100.0;
        this.noOfMinorTicksBufferLin = 0;
        this.noOfMajorTicksBufferLin = 0;
        this.minorTickSpacingBufferLin = 10.0;
        this.majorTickSpacingBufferLin = 10.0;
        this.minorTickmarkTypeBufferLin = TickmarkType.LINE;
        this.majorTickmarkTypeBufferLin = TickmarkType.LINE;
        this.ticksVisibleBufferLin = true;
        this.ticklabelsVisibleBufferLin = true;
        this.minorTicksVisibleBufferLin = true;
        this.majorTicksVisibleBufferLin = true;
        this.numberFormatBufferLin = NumberFormat.AUTO;
        this.tickmarkSectionsVisibleBufferLin = false;
        this.backgroundColorBufferLin = BackgroundColor.DARK_GRAY;
        this.tickmarkColorBufferLin = this.backgroundColorBufferLin.LABEL_COLOR;
        this.tickmarkColorFromThemeBufferLin = true;
        this.tickmarkSectionsBufferLin = new ArrayList<Section>(10);
        this.offsetBufferLin = new Point2D.Double();
        this.orientationBufferLin = Orientation.VERTICAL;
        this.niceScaleLin = true;
        this.logScaleLin = false;
    }

    public BufferedImage create_RADIAL_TICKMARKS_Image(int WIDTH, double MIN_VALUE, double MAX_VALUE, int NO_OF_MINOR_TICKS, int NO_OF_MAJOR_TICKS, double MINOR_TICK_SPACING, double MAJOR_TICK_SPACING, GaugeType GAUGE_TYPE, TickmarkType MINOR_TICKMARK_TYPE, TickmarkType MAJOR_TICKMARK_TYPE, boolean TICKS_VISIBLE, boolean TICKLABELS_VISIBLE, boolean MINOR_TICKS_VISIBLE, boolean MAJOR_TICKS_VISIBLE, NumberFormat NUMBER_FORMAT, boolean TICKMARK_SECTIONS_VISIBLE, BackgroundColor BACKGROUND_COLOR, Color TICKMARK_COLOR, boolean TICKMARK_COLOR_FROM_THEME, List<Section> tickmarkSections, boolean SECTION_TICKMARKS_ONLY, List<Section> sections, float RADIUS_FACTOR, float TEXT_DISTANCE_FACTOR, Point2D CENTER, Point2D OFFSET, Orientation ORIENTATION, TicklabelOrientation TICKLABEL_ORIENTATION, boolean NICE_SCALE, boolean LOG_SCALE, BufferedImage BACKGROUND_IMAGE) {
        double alpha;
        if (WIDTH <= 0) {
            return this.UTIL.createImage(1, 1, 3);
        }
        if (WIDTH == this.widthBufferRad && Double.compare(MIN_VALUE, this.minValueBufferRad) == 0 && Double.compare(MAX_VALUE, this.maxValueBufferRad) == 0 && NO_OF_MINOR_TICKS == this.noOfMinorTicksBufferRad && NO_OF_MAJOR_TICKS == this.noOfMajorTicksBufferRad && Double.compare(MINOR_TICK_SPACING, this.minorTickSpacingBufferRad) == 0 && Double.compare(MAJOR_TICK_SPACING, this.majorTickSpacingBufferRad) == 0 && GAUGE_TYPE == this.gaugeTypeBufferRad && MINOR_TICKMARK_TYPE == this.minorTickmarkTypeBufferRad && MAJOR_TICKMARK_TYPE == this.majorTickmarkTypeBufferRad && TICKS_VISIBLE == this.ticksVisibleBufferRad && TICKLABELS_VISIBLE == this.ticklabelsVisibleBufferRad && MINOR_TICKS_VISIBLE == this.minorTicksVisibleBufferRad && MAJOR_TICKS_VISIBLE == this.majorTicksVisibleBufferRad && SECTION_TICKMARKS_ONLY == this.sectionTickmarksOnlyBufferRad && this.sectionsBufferRad.containsAll(sections) && TICKMARK_SECTIONS_VISIBLE == this.tickmarkSectionsVisibleBufferRad && NUMBER_FORMAT == this.numberFormatBufferRad && BACKGROUND_COLOR == this.backgroundColorBufferRad && TICKMARK_COLOR.equals(this.tickmarkColorBufferRad) && TICKMARK_COLOR_FROM_THEME == this.tickmarkColorFromThemeBufferRad && tickmarkSections.containsAll(this.tickmarkSectionsBufferRad) && Float.compare(RADIUS_FACTOR, this.radiusFactorBufferRad) == 0 && Float.compare(TEXT_DISTANCE_FACTOR, this.textDistanceFactorBufferRad) == 0 && CENTER.equals(this.centerBufferRad) && OFFSET.equals(this.offsetBufferRad) && this.orientationBufferRad == ORIENTATION && this.ticklabelOrientationBufferRad == TICKLABEL_ORIENTATION && this.niceScaleRad == NICE_SCALE && this.logScaleRad == LOG_SCALE && BACKGROUND_IMAGE != null) {
            Graphics2D G = BACKGROUND_IMAGE.createGraphics();
            G.drawImage((Image)this.imageBufferRad, 0, 0, null);
            G.dispose();
            return this.imageBufferRad;
        }
        if (this.imageBufferRad != null) {
            this.imageBufferRad.flush();
        }
        this.imageBufferRad = this.UTIL.createImage(WIDTH, WIDTH, 3);
        this.numberFormat = NUMBER_FORMAT == NumberFormat.AUTO ? (Math.abs(MAJOR_TICK_SPACING) > 1000.0 ? NumberFormat.SCIENTIFIC : (MAJOR_TICK_SPACING % 1.0 != 0.0 ? NumberFormat.FRACTIONAL : NumberFormat.STANDARD)) : NUMBER_FORMAT;
        Font STD_FONT = new Font("Verdana", 0, (int)(0.04 * (double)WIDTH));
        Font SECTION_FONT = new Font("Verdana", 0, (int)(0.05 * (double)WIDTH));
        int TEXT_DISTANCE = (int)(TEXT_DISTANCE_FACTOR * (float)WIDTH);
        double ticklabelRotationOffset = 0.0;
        int MINOR_TICK_LENGTH = (int)(0.0133333333 * (double)WIDTH);
        int MEDIUM_TICK_LENGTH = (int)(0.02 * (double)WIDTH);
        int MAJOR_TICK_LENGTH = (int)(0.03 * (double)WIDTH);
        int MINOR_DIAMETER = (int)(0.0093457944 * (double)WIDTH);
        int MAJOR_DIAMETER = (int)(0.03 * (double)WIDTH);
        Point2D.Double TEXT_POINT = new Point2D.Double(0.0, 0.0);
        Point2D.Double INNER_POINT = new Point2D.Double(0.0, 0.0);
        Point2D.Double OUTER_POINT = new Point2D.Double(0.0, 0.0);
        Point2D.Double OUTER_POINT_LEFT = new Point2D.Double(0.0, 0.0);
        Point2D.Double OUTER_POINT_RIGHT = new Point2D.Double(0.0, 0.0);
        Line2D.Double TICK_LINE = new Line2D.Double(0.0, 0.0, 1.0, 1.0);
        Ellipse2D.Double TICK_CIRCLE = new Ellipse2D.Double(0.0, 0.0, 1.0, 1.0);
        GeneralPath TICK_TRIANGLE = new GeneralPath();
        double ROTATION_OFFSET = GAUGE_TYPE.ROTATION_OFFSET;
        float RADIUS = (float)WIDTH * RADIUS_FACTOR;
        double ANGLE_STEP = GAUGE_TYPE.ANGLE_RANGE / ((MAX_VALUE - MIN_VALUE) / MINOR_TICK_SPACING);
        double valueCounter = MIN_VALUE;
        int majorTickCounter = NO_OF_MINOR_TICKS - 1;
        Graphics2D G2 = this.imageBufferRad.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        G2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        if (OFFSET != null) {
            G2.translate(OFFSET.getX(), OFFSET.getY());
        }
        G2.setFont(STD_FONT);
        G2.rotate(ROTATION_OFFSET - Math.PI, CENTER.getX(), CENTER.getY());
        if (TICKMARK_COLOR_FROM_THEME) {
            G2.setColor(BACKGROUND_COLOR.LABEL_COLOR);
        } else {
            G2.setColor(TICKMARK_COLOR);
        }
        if (SECTION_TICKMARKS_ONLY && sections != null) {
            alpha = 0.0;
            G2.setFont(SECTION_FONT);
            double sinValue = Math.sin(alpha);
            double cosValue = Math.cos(alpha);
            G2.setStroke(MAJOR_TICKMARK_STROKE);
            ((Point2D)INNER_POINT).setLocation(CENTER.getX() + (double)(RADIUS - (float)MAJOR_TICK_LENGTH) * sinValue, CENTER.getY() + (double)(RADIUS - (float)MAJOR_TICK_LENGTH) * cosValue);
            ((Point2D)OUTER_POINT).setLocation(CENTER.getX() + (double)RADIUS * sinValue, CENTER.getY() + (double)RADIUS * cosValue);
            ((Point2D)TEXT_POINT).setLocation(CENTER.getX() + (double)(RADIUS - (float)TEXT_DISTANCE) * sinValue, CENTER.getY() + (double)(RADIUS - (float)TEXT_DISTANCE) * cosValue);
            this.drawRadialTicks(G2, INNER_POINT, OUTER_POINT, CENTER, RADIUS, MAJOR_TICKMARK_TYPE, TICK_LINE, TICK_CIRCLE, TICK_TRIANGLE, MAJOR_TICK_LENGTH, MAJOR_DIAMETER, OUTER_POINT_LEFT, OUTER_POINT_RIGHT, alpha);
            G2.fill(this.UTIL.rotateTextAroundCenter(G2, this.numberFormat.format(MIN_VALUE), (int)((Point2D)TEXT_POINT).getX(), (int)((Point2D)TEXT_POINT).getY(), Math.PI - GAUGE_TYPE.ROTATION_OFFSET));
            alpha = -(MAX_VALUE - MIN_VALUE) * ANGLE_STEP;
            sinValue = Math.sin(alpha);
            cosValue = Math.cos(alpha);
            G2.setStroke(MAJOR_TICKMARK_STROKE);
            ((Point2D)INNER_POINT).setLocation(CENTER.getX() + (double)(RADIUS - (float)MAJOR_TICK_LENGTH) * sinValue, CENTER.getY() + (double)(RADIUS - (float)MAJOR_TICK_LENGTH) * cosValue);
            ((Point2D)OUTER_POINT).setLocation(CENTER.getX() + (double)RADIUS * sinValue, CENTER.getY() + (double)RADIUS * cosValue);
            ((Point2D)TEXT_POINT).setLocation(CENTER.getX() + (double)(RADIUS - (float)TEXT_DISTANCE) * sinValue, CENTER.getY() + (double)(RADIUS - (float)TEXT_DISTANCE) * cosValue);
            this.drawRadialTicks(G2, INNER_POINT, OUTER_POINT, CENTER, RADIUS, MAJOR_TICKMARK_TYPE, TICK_LINE, TICK_CIRCLE, TICK_TRIANGLE, MAJOR_TICK_LENGTH, MAJOR_DIAMETER, OUTER_POINT_LEFT, OUTER_POINT_RIGHT, alpha);
            G2.fill(this.UTIL.rotateTextAroundCenter(G2, this.numberFormat.format(MAX_VALUE), (int)((Point2D)TEXT_POINT).getX(), (int)((Point2D)TEXT_POINT).getY(), Math.PI - GAUGE_TYPE.ROTATION_OFFSET));
            for (Section section : sections) {
                alpha = -(section.getStart() - MIN_VALUE) * ANGLE_STEP;
                sinValue = Math.sin(alpha);
                cosValue = Math.cos(alpha);
                G2.setStroke(MAJOR_TICKMARK_STROKE);
                ((Point2D)INNER_POINT).setLocation(CENTER.getX() + (double)(RADIUS - (float)MAJOR_TICK_LENGTH) * sinValue, CENTER.getY() + (double)(RADIUS - (float)MAJOR_TICK_LENGTH) * cosValue);
                ((Point2D)OUTER_POINT).setLocation(CENTER.getX() + (double)RADIUS * sinValue, CENTER.getY() + (double)RADIUS * cosValue);
                ((Point2D)TEXT_POINT).setLocation(CENTER.getX() + (double)(RADIUS - (float)TEXT_DISTANCE) * sinValue, CENTER.getY() + (double)(RADIUS - (float)TEXT_DISTANCE) * cosValue);
                this.drawRadialTicks(G2, INNER_POINT, OUTER_POINT, CENTER, RADIUS, MAJOR_TICKMARK_TYPE, TICK_LINE, TICK_CIRCLE, TICK_TRIANGLE, MAJOR_TICK_LENGTH, MAJOR_DIAMETER, OUTER_POINT_LEFT, OUTER_POINT_RIGHT, alpha);
                G2.fill(this.UTIL.rotateTextAroundCenter(G2, this.numberFormat.format(section.getStart()), (int)((Point2D)TEXT_POINT).getX(), (int)((Point2D)TEXT_POINT).getY(), Math.PI - GAUGE_TYPE.ROTATION_OFFSET));
                alpha = -(section.getStop() - MIN_VALUE) * ANGLE_STEP;
                sinValue = Math.sin(alpha);
                cosValue = Math.cos(alpha);
                G2.setStroke(MAJOR_TICKMARK_STROKE);
                ((Point2D)INNER_POINT).setLocation(CENTER.getX() + (double)(RADIUS - (float)MAJOR_TICK_LENGTH) * sinValue, CENTER.getY() + (double)(RADIUS - (float)MAJOR_TICK_LENGTH) * cosValue);
                ((Point2D)OUTER_POINT).setLocation(CENTER.getX() + (double)RADIUS * sinValue, CENTER.getY() + (double)RADIUS * cosValue);
                ((Point2D)TEXT_POINT).setLocation(CENTER.getX() + (double)(RADIUS - (float)TEXT_DISTANCE) * sinValue, CENTER.getY() + (double)(RADIUS - (float)TEXT_DISTANCE) * cosValue);
                this.drawRadialTicks(G2, INNER_POINT, OUTER_POINT, CENTER, RADIUS, MAJOR_TICKMARK_TYPE, TICK_LINE, TICK_CIRCLE, TICK_TRIANGLE, MAJOR_TICK_LENGTH, MAJOR_DIAMETER, OUTER_POINT_LEFT, OUTER_POINT_RIGHT, alpha);
                G2.fill(this.UTIL.rotateTextAroundCenter(G2, this.numberFormat.format(section.getStop()), (int)((Point2D)TEXT_POINT).getX(), (int)((Point2D)TEXT_POINT).getY(), Math.PI - GAUGE_TYPE.ROTATION_OFFSET));
            }
        } else if (!LOG_SCALE) {
            alpha = 0.0;
            double counter = MIN_VALUE;
            while (Double.compare(counter, MAX_VALUE) <= 0) {
                if (tickmarkSections != null && !tickmarkSections.isEmpty()) {
                    if (TICKMARK_SECTIONS_VISIBLE) {
                        for (Section section : tickmarkSections) {
                            if (Double.compare(valueCounter, section.getStart()) >= 0 && Double.compare(valueCounter, section.getStop()) <= 0) {
                                G2.setColor(Util.INSTANCE.setAlpha(section.getColor(), 1.0f));
                                break;
                            }
                            if (TICKMARK_COLOR_FROM_THEME) {
                                G2.setColor(BACKGROUND_COLOR.LABEL_COLOR);
                                continue;
                            }
                            G2.setColor(TICKMARK_COLOR);
                        }
                    } else if (TICKMARK_COLOR_FROM_THEME) {
                        G2.setColor(BACKGROUND_COLOR.LABEL_COLOR);
                    } else {
                        G2.setColor(TICKMARK_COLOR);
                    }
                }
                double sinValue = Math.sin(alpha);
                double cosValue = Math.cos(alpha);
                if (++majorTickCounter == NO_OF_MINOR_TICKS) {
                    G2.setStroke(MAJOR_TICKMARK_STROKE);
                    ((Point2D)INNER_POINT).setLocation(CENTER.getX() + (double)(RADIUS - (float)MAJOR_TICK_LENGTH) * sinValue, CENTER.getY() + (double)(RADIUS - (float)MAJOR_TICK_LENGTH) * cosValue);
                    ((Point2D)OUTER_POINT).setLocation(CENTER.getX() + (double)RADIUS * sinValue, CENTER.getY() + (double)RADIUS * cosValue);
                    ((Point2D)TEXT_POINT).setLocation(CENTER.getX() + (double)(RADIUS - (float)TEXT_DISTANCE) * sinValue, CENTER.getY() + (double)(RADIUS - (float)TEXT_DISTANCE) * cosValue);
                    if (TICKS_VISIBLE && MAJOR_TICKS_VISIBLE) {
                        this.drawRadialTicks(G2, INNER_POINT, OUTER_POINT, CENTER, RADIUS, MAJOR_TICKMARK_TYPE, TICK_LINE, TICK_CIRCLE, TICK_TRIANGLE, MAJOR_TICK_LENGTH, MAJOR_DIAMETER, OUTER_POINT_LEFT, OUTER_POINT_RIGHT, alpha);
                    }
                    if (TICKLABELS_VISIBLE) {
                        switch (TICKLABEL_ORIENTATION) {
                            case NORMAL: {
                                if (Double.compare(alpha, -GAUGE_TYPE.TICKLABEL_ORIENTATION_CHANGE_ANGLE) > 0) {
                                    G2.fill(this.UTIL.rotateTextAroundCenter(G2, this.numberFormat.format(valueCounter), (int)((Point2D)TEXT_POINT).getX(), (int)((Point2D)TEXT_POINT).getY(), -1.5707963267948966 - alpha));
                                    break;
                                }
                                G2.fill(this.UTIL.rotateTextAroundCenter(G2, this.numberFormat.format(valueCounter), (int)((Point2D)TEXT_POINT).getX(), (int)((Point2D)TEXT_POINT).getY(), 1.5707963267948966 - alpha));
                                break;
                            }
                            case HORIZONTAL: {
                                double orientationOffset = Orientation.WEST == ORIENTATION ? 1.5707963267948966 : (Orientation.EAST == ORIENTATION ? -1.5707963267948966 : (Orientation.SOUTH == ORIENTATION ? Math.PI : 0.0));
                                G2.fill(this.UTIL.rotateTextAroundCenter(G2, this.numberFormat.format(valueCounter), (int)((Point2D)TEXT_POINT).getX(), (int)((Point2D)TEXT_POINT).getY(), Math.PI - GAUGE_TYPE.ROTATION_OFFSET + orientationOffset));
                                break;
                            }
                            default: {
                                String label = this.numberFormat.format(valueCounter, MAX_VALUE);
                                if (label.isEmpty()) break;
                                G2.fill(this.UTIL.rotateTextAroundCenter(G2, label, (int)((Point2D)TEXT_POINT).getX(), (int)((Point2D)TEXT_POINT).getY(), Math.PI - alpha + ticklabelRotationOffset));
                            }
                        }
                    }
                    valueCounter += MAJOR_TICK_SPACING;
                    majorTickCounter = 0;
                } else {
                    ((Point2D)INNER_POINT).setLocation(CENTER.getX() + (double)(RADIUS - (float)MINOR_TICK_LENGTH) * sinValue, CENTER.getY() + (double)(RADIUS - (float)MINOR_TICK_LENGTH) * cosValue);
                    ((Point2D)OUTER_POINT).setLocation(CENTER.getX() + (double)RADIUS * sinValue, CENTER.getY() + (double)RADIUS * cosValue);
                    G2.setStroke(MINOR_TICKMARK_STROKE);
                    if (NO_OF_MINOR_TICKS % 2 == 0 && majorTickCounter == NO_OF_MINOR_TICKS / 2) {
                        G2.setStroke(MEDIUM_TICKMARK_STROKE);
                        ((Point2D)INNER_POINT).setLocation(CENTER.getX() + (double)(RADIUS - (float)MEDIUM_TICK_LENGTH) * sinValue, CENTER.getY() + (double)(RADIUS - (float)MEDIUM_TICK_LENGTH) * cosValue);
                        ((Point2D)OUTER_POINT).setLocation(CENTER.getX() + (double)RADIUS * sinValue, CENTER.getY() + (double)RADIUS * cosValue);
                    }
                    if (TICKS_VISIBLE && MINOR_TICKS_VISIBLE) {
                        this.drawRadialTicks(G2, INNER_POINT, OUTER_POINT, CENTER, RADIUS, MINOR_TICKMARK_TYPE, TICK_LINE, TICK_CIRCLE, TICK_TRIANGLE, MINOR_TICK_LENGTH, MINOR_DIAMETER, OUTER_POINT_LEFT, OUTER_POINT_RIGHT, alpha);
                    }
                }
                alpha -= ANGLE_STEP;
                counter += MINOR_TICK_SPACING;
            }
        } else {
            double LOG_ANGLE_STEP = Math.abs(GAUGE_TYPE.ANGLE_RANGE / this.UTIL.logOfBase(10.0, MAX_VALUE - MIN_VALUE));
            int exponent = 0;
            double valueStep = 1.0;
            double value = 1.0;
            while (Double.compare(value, MAX_VALUE) <= 0) {
                if (TICKMARK_COLOR_FROM_THEME) {
                    G2.setColor(BACKGROUND_COLOR.LABEL_COLOR);
                } else {
                    G2.setColor(TICKMARK_COLOR);
                }
                double angle = this.UTIL.logOfBase(10.0, Math.abs(value)) * LOG_ANGLE_STEP;
                double sinValue = Math.sin(-angle);
                double cosValue = Math.cos(-angle);
                ((Point2D)INNER_POINT).setLocation(CENTER.getX() + (double)(RADIUS - (float)MINOR_TICK_LENGTH) * sinValue, CENTER.getY() + (double)(RADIUS - (float)MINOR_TICK_LENGTH) * cosValue);
                ((Point2D)OUTER_POINT).setLocation(CENTER.getX() + (double)RADIUS * sinValue, CENTER.getY() + (double)RADIUS * cosValue);
                G2.setStroke(MINOR_TICKMARK_STROKE);
                if (Double.compare(value, Math.pow(10.0, exponent + 1)) == 0) {
                    valueStep = Math.pow(10.0, ++exponent);
                    ((Point2D)INNER_POINT).setLocation(CENTER.getX() + (double)(RADIUS - (float)MAJOR_TICK_LENGTH) * sinValue, CENTER.getY() + (double)(RADIUS - (float)MAJOR_TICK_LENGTH) * cosValue);
                    ((Point2D)OUTER_POINT).setLocation(CENTER.getX() + (double)RADIUS * sinValue, CENTER.getY() + (double)RADIUS * cosValue);
                    ((Point2D)TEXT_POINT).setLocation(CENTER.getX() + (double)(RADIUS - (float)TEXT_DISTANCE) * sinValue, CENTER.getY() + (double)(RADIUS - (float)TEXT_DISTANCE) * cosValue);
                    if (TICKLABELS_VISIBLE) {
                        switch (TICKLABEL_ORIENTATION) {
                            case NORMAL: {
                                if (Double.compare(value, -GAUGE_TYPE.TICKLABEL_ORIENTATION_CHANGE_ANGLE) > 0) {
                                    G2.fill(this.UTIL.rotateTextAroundCenter(G2, this.numberFormat.format(value), (int)((Point2D)TEXT_POINT).getX(), (int)((Point2D)TEXT_POINT).getY(), -1.5707963267948966 + angle));
                                    break;
                                }
                                G2.fill(this.UTIL.rotateTextAroundCenter(G2, this.numberFormat.format(value), (int)((Point2D)TEXT_POINT).getX(), (int)((Point2D)TEXT_POINT).getY(), 1.5707963267948966 + angle));
                                break;
                            }
                            case HORIZONTAL: {
                                double orientationOffset = Orientation.WEST == ORIENTATION ? 1.5707963267948966 : (Orientation.EAST == ORIENTATION ? -1.5707963267948966 : (Orientation.SOUTH == ORIENTATION ? Math.PI : 0.0));
                                G2.fill(this.UTIL.rotateTextAroundCenter(G2, this.numberFormat.format(value), (int)((Point2D)TEXT_POINT).getX(), (int)((Point2D)TEXT_POINT).getY(), Math.PI - GAUGE_TYPE.ROTATION_OFFSET + orientationOffset));
                                break;
                            }
                            default: {
                                G2.fill(this.UTIL.rotateTextAroundCenter(G2, this.numberFormat.format(value), (int)((Point2D)TEXT_POINT).getX(), (int)((Point2D)TEXT_POINT).getY(), Math.PI + angle + ticklabelRotationOffset));
                            }
                        }
                    }
                    G2.setStroke(MAJOR_TICKMARK_STROKE);
                }
                if (TICKS_VISIBLE && MAJOR_TICKS_VISIBLE && MINOR_TICKS_VISIBLE) {
                    TICK_LINE.setLine(INNER_POINT, OUTER_POINT);
                    G2.draw(TICK_LINE);
                }
                value += valueStep;
            }
        }
        G2.dispose();
        if (BACKGROUND_IMAGE != null) {
            Graphics2D G = BACKGROUND_IMAGE.createGraphics();
            G.drawImage((Image)this.imageBufferRad, 0, 0, null);
            G.dispose();
        }
        this.widthBufferRad = WIDTH;
        this.minValueBufferRad = MIN_VALUE;
        this.maxValueBufferRad = MAX_VALUE;
        this.noOfMinorTicksBufferRad = NO_OF_MINOR_TICKS;
        this.noOfMajorTicksBufferRad = NO_OF_MAJOR_TICKS;
        this.minorTickSpacingBufferRad = MINOR_TICK_SPACING;
        this.majorTickSpacingBufferRad = MAJOR_TICK_SPACING;
        this.gaugeTypeBufferRad = GAUGE_TYPE;
        this.minorTickmarkTypeBufferRad = MINOR_TICKMARK_TYPE;
        this.majorTickmarkTypeBufferRad = MAJOR_TICKMARK_TYPE;
        this.ticksVisibleBufferRad = TICKS_VISIBLE;
        this.ticklabelsVisibleBufferRad = TICKLABELS_VISIBLE;
        this.minorTicksVisibleBufferRad = MINOR_TICKS_VISIBLE;
        this.majorTicksVisibleBufferRad = MAJOR_TICKS_VISIBLE;
        this.tickmarkSectionsVisibleBufferRad = TICKMARK_SECTIONS_VISIBLE;
        this.numberFormatBufferRad = NUMBER_FORMAT;
        this.backgroundColorBufferRad = BACKGROUND_COLOR;
        this.tickmarkColorBufferRad = TICKMARK_COLOR;
        this.tickmarkColorFromThemeBufferRad = TICKMARK_COLOR_FROM_THEME;
        if (tickmarkSections != null) {
            this.tickmarkSectionsBufferRad.clear();
            this.tickmarkSectionsBufferRad.addAll(tickmarkSections);
        }
        if (sections != null) {
            this.sectionsBufferRad.clear();
            this.sectionsBufferRad.addAll(sections);
        }
        this.sectionTickmarksOnlyBufferRad = SECTION_TICKMARKS_ONLY;
        this.radiusFactorBufferRad = RADIUS_FACTOR;
        this.textDistanceFactorBufferRad = TEXT_DISTANCE_FACTOR;
        this.centerBufferRad.setLocation(CENTER);
        if (OFFSET != null) {
            this.offsetBufferRad.setLocation(OFFSET);
        }
        this.orientationBufferRad = ORIENTATION;
        this.ticklabelOrientationBufferRad = TICKLABEL_ORIENTATION;
        this.niceScaleRad = NICE_SCALE;
        this.logScaleRad = LOG_SCALE;
        return this.imageBufferRad;
    }

    private void drawRadialTicks(Graphics2D G2, Point2D INNER_POINT, Point2D OUTER_POINT, Point2D CENTER, double RADIUS, TickmarkType TICKMARK_TYPE, Line2D TICK_LINE, Ellipse2D TICK_CIRCLE, GeneralPath TICK_TRIANGLE, double TICK_LENGTH, double DIAMETER, Point2D OUTER_POINT_LEFT, Point2D OUTER_POINT_RIGHT, double ALPHA) {
        switch (TICKMARK_TYPE) {
            case CIRCLE: {
                TICK_CIRCLE.setFrame(OUTER_POINT.getX() - DIAMETER / 2.0, OUTER_POINT.getY() - DIAMETER / 2.0, DIAMETER, DIAMETER);
                G2.fill(TICK_CIRCLE);
                break;
            }
            case TRIANGLE: {
                OUTER_POINT_LEFT.setLocation(CENTER.getX() + RADIUS * Math.sin(ALPHA - Math.toRadians(Math.asin(TICK_LENGTH / 16.0))), CENTER.getY() + RADIUS * Math.cos(ALPHA - Math.toRadians(Math.asin(TICK_LENGTH / 16.0))));
                OUTER_POINT_RIGHT.setLocation(CENTER.getX() + RADIUS * Math.sin(ALPHA + Math.toRadians(Math.asin(TICK_LENGTH / 16.0))), CENTER.getY() + RADIUS * Math.cos(ALPHA + Math.toRadians(Math.asin(TICK_LENGTH / 16.0))));
                TICK_TRIANGLE.reset();
                TICK_TRIANGLE.moveTo(INNER_POINT.getX(), INNER_POINT.getY());
                TICK_TRIANGLE.lineTo(OUTER_POINT_LEFT.getX(), OUTER_POINT_LEFT.getY());
                TICK_TRIANGLE.lineTo(OUTER_POINT_RIGHT.getX(), OUTER_POINT_RIGHT.getY());
                TICK_TRIANGLE.closePath();
                G2.fill(TICK_TRIANGLE);
                break;
            }
            default: {
                TICK_LINE.setLine(INNER_POINT, OUTER_POINT);
                G2.draw(TICK_LINE);
            }
        }
    }

    public BufferedImage create_LINEAR_TICKMARKS_Image(int WIDTH, int HEIGHT, double MIN_VALUE, double MAX_VALUE, int NO_OF_MINOR_TICKS, int NO_OF_MAJOR_TICKS, double MINOR_TICK_SPACING, double MAJOR_TICK_SPACING, TickmarkType MINOR_TICKMARK_TYPE, TickmarkType MAJOR_TICKMARK_TYPE, boolean TICKS_VISIBLE, boolean TICKLABELS_VISIBLE, boolean MINOR_TICKS_VISIBLE, boolean MAJOR_TICKS_VISIBLE, NumberFormat NUMBER_FORMAT, boolean TICKMARK_SECTIONS_VISIBLE, BackgroundColor BACKGROUND_COLOR, Color TICKMARK_COLOR, boolean TICKMARK_COLOR_FROM_THEME, List<Section> tickmarkSections, Point2D OFFSET, Orientation ORIENTATION, boolean NICE_SCALE, boolean LOG_SCALE, BufferedImage BACKGROUND_IMAGE) {
        double tickSpaceScaling;
        int MAJOR_TICK_STOP;
        int MAJOR_TICK_START;
        int MEDIUM_TICK_STOP;
        int MEDIUM_TICK_START;
        int MINOR_TICK_STOP;
        int MINOR_TICK_START;
        int MAJOR_DIAMETER;
        int MINOR_DIAMETER;
        Rectangle2D.Double SCALE_BOUNDS;
        Font STD_FONT;
        if (WIDTH <= 0 || HEIGHT <= 0) {
            return this.UTIL.createImage(1, 1, 3);
        }
        if (WIDTH == this.widthBufferLin && HEIGHT == this.heightBufferLin && Double.compare(MIN_VALUE, this.minValueBufferLin) == 0 && Double.compare(MAX_VALUE, this.maxValueBufferLin) == 0 && NO_OF_MINOR_TICKS == this.noOfMinorTicksBufferLin && NO_OF_MAJOR_TICKS == this.noOfMajorTicksBufferLin && Double.compare(MINOR_TICK_SPACING, this.minorTickSpacingBufferLin) == 0 && Double.compare(MAJOR_TICK_SPACING, this.majorTickSpacingBufferLin) == 0 && MINOR_TICKMARK_TYPE == this.minorTickmarkTypeBufferLin && MAJOR_TICKMARK_TYPE == this.majorTickmarkTypeBufferLin && TICKS_VISIBLE == this.ticksVisibleBufferLin && MINOR_TICKS_VISIBLE == this.minorTicksVisibleBufferLin && MAJOR_TICKS_VISIBLE == this.majorTicksVisibleBufferLin && TICKLABELS_VISIBLE == this.ticklabelsVisibleBufferLin && NUMBER_FORMAT == this.numberFormatBufferLin && TICKMARK_SECTIONS_VISIBLE == this.tickmarkSectionsVisibleBufferLin && BACKGROUND_COLOR == this.backgroundColorBufferLin && TICKMARK_COLOR.equals(this.tickmarkColorBufferLin) && TICKMARK_COLOR_FROM_THEME == this.tickmarkColorFromThemeBufferLin && tickmarkSections.containsAll(this.tickmarkSectionsBufferLin) && OFFSET.equals(this.offsetBufferLin) && ORIENTATION == this.orientationBufferLin && NICE_SCALE == this.niceScaleLin && LOG_SCALE == this.logScaleLin && BACKGROUND_IMAGE != null) {
            Graphics2D G = BACKGROUND_IMAGE.createGraphics();
            G.drawImage((Image)this.imageBufferLin, 0, 0, null);
            G.dispose();
            return this.imageBufferLin;
        }
        if (this.imageBufferLin != null) {
            this.imageBufferLin.flush();
        }
        this.imageBufferLin = this.UTIL.createImage(WIDTH, HEIGHT, 3);
        if (NUMBER_FORMAT == NumberFormat.AUTO) {
            if (Math.abs(MAJOR_TICK_SPACING) > 1000.0) {
                this.numberFormat = NumberFormat.SCIENTIFIC;
            } else if (MAJOR_TICK_SPACING % 1.0 != 0.0) {
                this.numberFormat = NumberFormat.FRACTIONAL;
            }
        } else {
            this.numberFormat = NUMBER_FORMAT;
        }
        if (ORIENTATION == Orientation.VERTICAL) {
            STD_FONT = new Font("Verdana", 0, (int)(0.062 * (double)WIDTH));
            SCALE_BOUNDS = new Rectangle2D.Double(0.0, (double)HEIGHT * 0.12864077669902912, 0.0, (double)HEIGHT * 0.8567961165048543 - (double)HEIGHT * 0.12864077669902912);
            MINOR_DIAMETER = (int)(0.0186915888 * (double)WIDTH);
            MAJOR_DIAMETER = (int)(0.0280373832 * (double)WIDTH);
            MINOR_TICK_START = (int)(0.34 * (double)WIDTH);
            MINOR_TICK_STOP = (int)(0.36 * (double)WIDTH);
            MEDIUM_TICK_START = (int)(0.33 * (double)WIDTH);
            MEDIUM_TICK_STOP = (int)(0.36 * (double)WIDTH);
            MAJOR_TICK_START = (int)(0.32 * (double)WIDTH);
            MAJOR_TICK_STOP = (int)(0.36 * (double)WIDTH);
            tickSpaceScaling = ((RectangularShape)SCALE_BOUNDS).getHeight() / (MAX_VALUE - MIN_VALUE);
        } else {
            STD_FONT = new Font("Verdana", 0, (int)(0.062 * (double)HEIGHT));
            SCALE_BOUNDS = new Rectangle2D.Double((double)WIDTH * 0.14285714285714285, 0.0, (double)WIDTH * 0.8710124827 - (double)WIDTH * 0.14285714285714285, 0.0);
            MINOR_DIAMETER = (int)(0.0186915888 * (double)HEIGHT);
            MAJOR_DIAMETER = (int)(0.0280373832 * (double)HEIGHT);
            MINOR_TICK_START = (int)(0.65 * (double)HEIGHT);
            MINOR_TICK_STOP = (int)(0.63 * (double)HEIGHT);
            MEDIUM_TICK_START = (int)(0.66 * (double)HEIGHT);
            MEDIUM_TICK_STOP = (int)(0.63 * (double)HEIGHT);
            MAJOR_TICK_START = (int)(0.67 * (double)HEIGHT);
            MAJOR_TICK_STOP = (int)(0.63 * (double)HEIGHT);
            tickSpaceScaling = ((RectangularShape)SCALE_BOUNDS).getWidth() / (MAX_VALUE - MIN_VALUE);
        }
        Graphics2D G2 = this.imageBufferLin.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        G2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        if (OFFSET != null) {
            G2.translate(OFFSET.getX(), OFFSET.getY());
        }
        G2.setFont(STD_FONT);
        if (TICKMARK_COLOR_FROM_THEME) {
            G2.setColor(BACKGROUND_COLOR.LABEL_COLOR);
        } else {
            G2.setColor(TICKMARK_COLOR);
        }
        FontRenderContext RENDER_CONTEXT = new FontRenderContext(null, true, true);
        TextLayout TEXT_LAYOUT = new TextLayout(this.numberFormat.format(MAX_VALUE), G2.getFont(), RENDER_CONTEXT);
        Rectangle2D MAX_BOUNDS = TEXT_LAYOUT.getBounds();
        Line2D.Double TICK_LINE = new Line2D.Double(0.0, 0.0, 1.0, 1.0);
        Ellipse2D.Double TICK_CIRCLE = new Ellipse2D.Double(0.0, 0.0, 1.0, 1.0);
        GeneralPath TICK_TRIANGLE = new GeneralPath();
        double valueCounter = MIN_VALUE;
        int majorTickCounter = NO_OF_MINOR_TICKS - 1;
        if (!LOG_SCALE) {
            double labelCounter = MIN_VALUE;
            double tickCounter = 0.0;
            while (Float.compare((float)labelCounter, (float)MAX_VALUE) <= 0) {
                if (tickmarkSections != null && !tickmarkSections.isEmpty()) {
                    if (TICKMARK_SECTIONS_VISIBLE) {
                        for (Section section : tickmarkSections) {
                            if (Double.compare(tickCounter, section.getStart()) >= 0 && Double.compare(tickCounter, section.getStop()) <= 0) {
                                G2.setColor(section.getColor());
                                break;
                            }
                            if (TICKMARK_COLOR_FROM_THEME) {
                                G2.setColor(BACKGROUND_COLOR.LABEL_COLOR);
                                continue;
                            }
                            G2.setColor(TICKMARK_COLOR);
                        }
                    } else if (TICKMARK_COLOR_FROM_THEME) {
                        G2.setColor(BACKGROUND_COLOR.LABEL_COLOR);
                    } else {
                        G2.setColor(TICKMARK_COLOR);
                    }
                } else if (TICKMARK_COLOR_FROM_THEME) {
                    G2.setColor(BACKGROUND_COLOR.LABEL_COLOR);
                } else {
                    G2.setColor(TICKMARK_COLOR);
                }
                double currentPos = ORIENTATION == Orientation.VERTICAL ? SCALE_BOUNDS.getMaxY() - tickCounter * tickSpaceScaling : ((RectangularShape)SCALE_BOUNDS).getX() + tickCounter * tickSpaceScaling;
                if (++majorTickCounter == NO_OF_MINOR_TICKS) {
                    G2.setStroke(MAJOR_TICKMARK_STROKE);
                    if (TICKS_VISIBLE && MAJOR_TICKS_VISIBLE) {
                        this.drawLinearTicks(G2, WIDTH, HEIGHT, ORIENTATION, currentPos, MAJOR_TICKMARK_TYPE, TICK_LINE, TICK_CIRCLE, TICK_TRIANGLE, MAJOR_TICK_START, MAJOR_TICK_STOP, MAJOR_DIAMETER);
                    }
                    if (TICKLABELS_VISIBLE) {
                        TextLayout currentLayout = new TextLayout(this.numberFormat.format(valueCounter), G2.getFont(), RENDER_CONTEXT);
                        Rectangle2D currentBounds = currentLayout.getBounds();
                        if (ORIENTATION == Orientation.VERTICAL) {
                            float textOffset = (float)(MAX_BOUNDS.getWidth() - currentBounds.getWidth());
                            G2.drawString(this.numberFormat.format(valueCounter, MAX_VALUE), 0.18f * (float)WIDTH + textOffset, (float)(currentPos - currentBounds.getHeight() / 2.0 + currentBounds.getHeight()));
                        } else {
                            G2.drawString(this.numberFormat.format(valueCounter, MAX_VALUE), (float)(tickCounter * tickSpaceScaling - currentBounds.getWidth() / 3.0 + ((RectangularShape)SCALE_BOUNDS).getX()), (float)((double)HEIGHT * 0.68 + 1.5 * currentBounds.getHeight()));
                        }
                    }
                    valueCounter += MAJOR_TICK_SPACING;
                    majorTickCounter = 0;
                } else if (TICKS_VISIBLE && MINOR_TICKS_VISIBLE) {
                    G2.setStroke(MINOR_TICKMARK_STROKE);
                    if (NO_OF_MINOR_TICKS % 2 == 0 && majorTickCounter == NO_OF_MINOR_TICKS / 2) {
                        G2.setStroke(MEDIUM_TICKMARK_STROKE);
                        this.drawLinearTicks(G2, WIDTH, HEIGHT, ORIENTATION, currentPos, MINOR_TICKMARK_TYPE, TICK_LINE, TICK_CIRCLE, TICK_TRIANGLE, MEDIUM_TICK_START, MEDIUM_TICK_STOP, MINOR_DIAMETER);
                    } else {
                        this.drawLinearTicks(G2, WIDTH, HEIGHT, ORIENTATION, currentPos, MINOR_TICKMARK_TYPE, TICK_LINE, TICK_CIRCLE, TICK_TRIANGLE, MINOR_TICK_START, MINOR_TICK_STOP, MINOR_DIAMETER);
                    }
                }
                labelCounter += MINOR_TICK_SPACING;
                tickCounter += MINOR_TICK_SPACING;
            }
        } else if (TICKS_VISIBLE) {
            double limit;
            double offset;
            if (ORIENTATION == Orientation.VERTICAL) {
                offset = SCALE_BOUNDS.getMaxY();
                limit = SCALE_BOUNDS.getMinY();
            } else {
                offset = SCALE_BOUNDS.getMinX();
                limit = SCALE_BOUNDS.getMaxX();
            }
            double stepSize = 1.0;
            int exponent = 0;
            double factor = Math.abs(limit - offset) / this.UTIL.logOfBase(10.0, MAX_VALUE);
            Line2D.Double tick = new Line2D.Double();
            if (TICKMARK_COLOR_FROM_THEME) {
                G2.setColor(BACKGROUND_COLOR.LABEL_COLOR);
            } else {
                G2.setColor(TICKMARK_COLOR);
            }
            int counter = 0;
            while ((double)counter <= MAX_VALUE) {
                double pos;
                G2.setStroke(MEDIUM_TICKMARK_STROKE);
                if (ORIENTATION == Orientation.VERTICAL) {
                    pos = offset - factor * this.UTIL.logOfBase(10.0, counter);
                    ((Line2D)tick).setLine(MEDIUM_TICK_START, pos, MEDIUM_TICK_STOP, pos);
                } else {
                    pos = factor * this.UTIL.logOfBase(10.0, counter) + offset;
                    ((Line2D)tick).setLine(pos, MEDIUM_TICK_START, pos, MEDIUM_TICK_STOP);
                }
                if (counter == (int)Math.pow(10.0, exponent + 1)) {
                    stepSize = Math.pow(10.0, ++exponent);
                    G2.setStroke(MAJOR_TICKMARK_STROKE);
                    if (ORIENTATION == Orientation.VERTICAL) {
                        ((Line2D)tick).setLine(MAJOR_TICK_START, pos, MAJOR_TICK_STOP, pos);
                    } else {
                        ((Line2D)tick).setLine(pos, MAJOR_TICK_START, pos, MAJOR_TICK_STOP);
                    }
                    if (TICKLABELS_VISIBLE) {
                        TextLayout currentLayout = new TextLayout(this.numberFormat.format(counter), G2.getFont(), RENDER_CONTEXT);
                        Rectangle2D currentBounds = currentLayout.getBounds();
                        if (ORIENTATION == Orientation.VERTICAL) {
                            float textOffset = (float)(MAX_BOUNDS.getWidth() - currentBounds.getWidth());
                            G2.drawString(this.numberFormat.format(counter), 0.18f * (float)WIDTH + textOffset, (float)(pos - currentBounds.getHeight() / 2.0 + currentBounds.getHeight()));
                        } else {
                            G2.drawString(this.numberFormat.format(counter), (float)(pos - currentBounds.getWidth() / 3.0), (float)((double)HEIGHT * 0.68 + 1.5 * currentBounds.getHeight()));
                        }
                    }
                }
                G2.draw(tick);
                counter = (int)((double)counter + stepSize);
            }
        }
        G2.dispose();
        if (BACKGROUND_IMAGE != null) {
            Graphics2D G = BACKGROUND_IMAGE.createGraphics();
            G.drawImage((Image)this.imageBufferLin, 0, 0, null);
            G.dispose();
        }
        this.widthBufferLin = WIDTH;
        this.heightBufferLin = HEIGHT;
        this.minValueBufferLin = MIN_VALUE;
        this.maxValueBufferLin = MAX_VALUE;
        this.noOfMinorTicksBufferLin = NO_OF_MINOR_TICKS;
        this.noOfMajorTicksBufferLin = NO_OF_MAJOR_TICKS;
        this.minorTickSpacingBufferLin = MINOR_TICK_SPACING;
        this.majorTickSpacingBufferLin = MAJOR_TICK_SPACING;
        this.minorTickmarkTypeBufferLin = MINOR_TICKMARK_TYPE;
        this.majorTickmarkTypeBufferLin = MAJOR_TICKMARK_TYPE;
        this.ticksVisibleBufferLin = TICKS_VISIBLE;
        this.ticklabelsVisibleBufferLin = TICKLABELS_VISIBLE;
        this.minorTicksVisibleBufferLin = MINOR_TICKS_VISIBLE;
        this.majorTicksVisibleBufferLin = MAJOR_TICKS_VISIBLE;
        this.numberFormatBufferLin = NUMBER_FORMAT;
        this.tickmarkSectionsVisibleBufferLin = TICKMARK_SECTIONS_VISIBLE;
        this.backgroundColorBufferLin = BACKGROUND_COLOR;
        this.tickmarkColorBufferLin = TICKMARK_COLOR;
        this.tickmarkColorFromThemeBufferLin = TICKMARK_COLOR_FROM_THEME;
        if (tickmarkSections != null) {
            this.tickmarkSectionsBufferLin.clear();
            this.tickmarkSectionsBufferLin.addAll(tickmarkSections);
        }
        if (OFFSET != null) {
            this.offsetBufferLin.setLocation(OFFSET);
        }
        this.orientationBufferLin = ORIENTATION;
        this.niceScaleLin = NICE_SCALE;
        this.logScaleLin = LOG_SCALE;
        return this.imageBufferLin;
    }

    private void drawLinearTicks(Graphics2D G2, int WIDTH, int HEIGHT, Orientation ORIENTATION, double CURRENT_POS, TickmarkType TICKMARK_TYPE, Line2D TICK_LINE, Ellipse2D TICK_CIRCLE, GeneralPath TICK_TRIANGLE, double TICK_START, double TICK_STOP, double DIAMETER) {
        switch (TICKMARK_TYPE) {
            case CIRCLE: {
                if (ORIENTATION == Orientation.VERTICAL) {
                    TICK_CIRCLE.setFrame(TICK_START, CURRENT_POS - DIAMETER / 2.0, DIAMETER, DIAMETER);
                } else {
                    TICK_CIRCLE.setFrame(CURRENT_POS - DIAMETER / 2.0, TICK_STOP, DIAMETER, DIAMETER);
                }
                G2.fill(TICK_CIRCLE);
                break;
            }
            case TRIANGLE: {
                TICK_TRIANGLE.reset();
                if (ORIENTATION == Orientation.VERTICAL) {
                    TICK_TRIANGLE.moveTo(TICK_START, CURRENT_POS + (double)WIDTH * 0.005);
                    TICK_TRIANGLE.lineTo(TICK_START, CURRENT_POS - (double)WIDTH * 0.005);
                    TICK_TRIANGLE.lineTo(TICK_STOP, CURRENT_POS);
                    TICK_TRIANGLE.closePath();
                } else {
                    TICK_TRIANGLE.moveTo(CURRENT_POS - (double)HEIGHT * 0.005, TICK_START);
                    TICK_TRIANGLE.lineTo(CURRENT_POS + (double)HEIGHT * 0.005, TICK_START);
                    TICK_TRIANGLE.lineTo(CURRENT_POS, TICK_STOP);
                    TICK_TRIANGLE.closePath();
                }
                G2.fill(TICK_TRIANGLE);
                break;
            }
            default: {
                if (ORIENTATION == Orientation.VERTICAL) {
                    TICK_LINE.setLine(TICK_START, CURRENT_POS, TICK_STOP, CURRENT_POS);
                } else {
                    TICK_LINE.setLine(CURRENT_POS, TICK_START, CURRENT_POS, TICK_STOP);
                }
                G2.draw(TICK_LINE);
            }
        }
    }

    static {
        MAJOR_TICKMARK_STROKE = new BasicStroke(1.0f, 1, 2);
        MEDIUM_TICKMARK_STROKE = new BasicStroke(0.5f, 1, 2);
        MINOR_TICKMARK_STROKE = new BasicStroke(0.3f, 1, 2);
    }
}

