/*
 * Decompiled with CFR 0.152.
 */
package tel.schich.javacan;

import java.io.IOException;
import java.net.SocketOption;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import tel.schich.javacan.CanFilter;
import tel.schich.javacan.JavaCAN;
import tel.schich.javacan.SocketCAN;
import tel.schich.javacan.option.CanSocketOption;
import tel.schich.javacan.platform.linux.LinuxSocketOptionHandler;

public class CanSocketOptions {
    public static final int MAX_FILTERS = 512;
    public static final SocketOption<Boolean> JOIN_FILTERS = new CanSocketOption<Boolean>("JOIN_FILTERS", Boolean.class, new LinuxSocketOptionHandler<Boolean>(){

        @Override
        public void set(int sock, Boolean val, boolean validate) throws IOException {
            SocketCAN.setJoinFilters(sock, val);
        }

        @Override
        public Boolean get(int sock) throws IOException {
            int result = SocketCAN.getJoinFilters(sock);
            return result != 0;
        }
    });
    public static final SocketOption<Boolean> LOOPBACK = new CanSocketOption<Boolean>("LOOPBACK", Boolean.class, new LinuxSocketOptionHandler<Boolean>(){

        @Override
        public void set(int sock, Boolean val, boolean validate) throws IOException {
            SocketCAN.setLoopback(sock, val);
        }

        @Override
        public Boolean get(int sock) throws IOException {
            int result = SocketCAN.getLoopback(sock);
            return result != 0;
        }
    });
    public static final SocketOption<Boolean> RECV_OWN_MSGS = new CanSocketOption<Boolean>("RECV_OWN_MSGS", Boolean.class, new LinuxSocketOptionHandler<Boolean>(){

        @Override
        public void set(int sock, Boolean val, boolean validate) throws IOException {
            SocketCAN.setReceiveOwnMessages(sock, val);
        }

        @Override
        public Boolean get(int sock) throws IOException {
            int result = SocketCAN.getReceiveOwnMessages(sock);
            return result != 0;
        }
    });
    public static final SocketOption<Boolean> FD_FRAMES = new CanSocketOption<Boolean>("FD_FRAMES", Boolean.class, new LinuxSocketOptionHandler<Boolean>(){

        @Override
        public void set(int sock, Boolean val, boolean validate) throws IOException {
            SocketCAN.setAllowFDFrames(sock, val);
        }

        @Override
        public Boolean get(int sock) throws IOException {
            int result = SocketCAN.getAllowFDFrames(sock);
            return result != 0;
        }
    });
    public static final SocketOption<Integer> ERR_FILTER = new CanSocketOption<Integer>("ERR_FILTER", Integer.class, new LinuxSocketOptionHandler<Integer>(){

        @Override
        public void set(int sock, Integer val, boolean validate) throws IOException {
            SocketCAN.setErrorFilter(sock, val);
        }

        @Override
        public Integer get(int sock) throws IOException {
            return SocketCAN.getErrorFilter(sock);
        }
    });
    public static final SocketOption<CanFilter[]> FILTER = new CanSocketOption<CanFilter[]>("FILTER", CanFilter[].class, new LinuxSocketOptionHandler<CanFilter[]>(){

        @Override
        public void set(int sock, CanFilter[] val, boolean validate) throws IOException {
            if (validate && val.length > 512) {
                throw new IllegalArgumentException("A maximum of 512 filters are supported!");
            }
            ByteBuffer filterData = JavaCAN.allocateOrdered(val.length * 8);
            for (CanFilter f : val) {
                filterData.putInt(f.getId());
                filterData.putInt(f.getMask());
            }
            SocketCAN.setFilters(sock, filterData);
        }

        @Override
        public CanFilter[] get(int sock) throws IOException {
            ByteBuffer filterData = SocketCAN.getFilters(sock);
            filterData.order(ByteOrder.nativeOrder()).rewind();
            int count = filterData.remaining() / 8;
            CanFilter[] filters = new CanFilter[count];
            for (int i = 0; i < count; ++i) {
                int id = filterData.getInt();
                int mask = filterData.getInt();
                filters[i] = new CanFilter(id, mask);
            }
            return filters;
        }
    });
    public static final SocketOption<Duration> SO_SNDTIMEO = new CanSocketOption<Duration>("SO_SNDTIMEO", Duration.class, new LinuxSocketOptionHandler<Duration>(){

        @Override
        public void set(int sock, Duration val, boolean validate) throws IOException {
            SocketCAN.setWriteTimeout(sock, val.getSeconds(), val.getNano());
        }

        @Override
        public Duration get(int sock) throws IOException {
            long timeout = SocketCAN.getWriteTimeout(sock);
            return Duration.of(timeout, ChronoUnit.MICROS);
        }
    });
    public static final SocketOption<Duration> SO_RCVTIMEO = new CanSocketOption<Duration>("SO_RCVTIMEO", Duration.class, new LinuxSocketOptionHandler<Duration>(){

        @Override
        public void set(int sock, Duration val, boolean validate) throws IOException {
            SocketCAN.setReadTimeout(sock, val.getSeconds(), val.getNano());
        }

        @Override
        public Duration get(int sock) throws IOException {
            long timeout = SocketCAN.getReadTimeout(sock);
            return Duration.of(timeout, ChronoUnit.MICROS);
        }
    });
    public static final SocketOption<Integer> SO_RCVBUF = new CanSocketOption<Integer>("SO_RCVBUF", Integer.class, new LinuxSocketOptionHandler<Integer>(){

        @Override
        public void set(int sock, Integer val, boolean validate) throws IOException {
            if (val <= 0) {
                throw new IllegalArgumentException("Buffer size must be positive!");
            }
            SocketCAN.setReceiveBufferSize(sock, val);
        }

        @Override
        public Integer get(int sock) throws IOException {
            return SocketCAN.getReceiveBufferSize(sock);
        }
    });

    private CanSocketOptions() {
    }
}

