/*
 * Decompiled with CFR 0.152.
 */
package tel.schich.javacan;

import java.io.IOException;
import java.net.SocketOption;
import tel.schich.javacan.IsotpFlowControlOptions;
import tel.schich.javacan.IsotpLinkLayerOptions;
import tel.schich.javacan.IsotpOptions;
import tel.schich.javacan.SocketCAN;
import tel.schich.javacan.option.CanSocketOption;
import tel.schich.javacan.platform.linux.LinuxSocketOptionHandler;
import tel.schich.javacan.util.CanUtils;

public class IsotpCanSocketOptions {
    public static final SocketOption<IsotpOptions> OPTS = new CanSocketOption<IsotpOptions>("OPTS", IsotpOptions.class, new LinuxSocketOptionHandler<IsotpOptions>(){

        @Override
        public void set(int sock, IsotpOptions val, boolean validate) throws IOException {
            SocketCAN.setIsotpOpts(sock, val.getRawFlags(), val.getFrameTransmissionTime(), val.getExtendedTransmissionAddress(), val.getTransmissionPadding(), val.getReceivePadding(), val.getExtendedReceiveAddress());
        }

        @Override
        public IsotpOptions get(int sock) throws IOException {
            return SocketCAN.getIsotpOpts(sock);
        }
    });
    public static final SocketOption<IsotpFlowControlOptions> RECV_FC = new CanSocketOption<IsotpFlowControlOptions>("RECV_FC", IsotpFlowControlOptions.class, new LinuxSocketOptionHandler<IsotpFlowControlOptions>(){

        @Override
        public void set(int sock, IsotpFlowControlOptions val, boolean validate) throws IOException {
            SocketCAN.setIsotpRecvFc(sock, val.getBlockSize(), val.getMinimumSeparationTime(), val.getMaximumWaitFrameTransmission());
        }

        @Override
        public IsotpFlowControlOptions get(int sock) throws IOException {
            return SocketCAN.getIsotpRecvFc(sock);
        }
    });
    public static final SocketOption<Integer> TX_STMIN = new CanSocketOption<Integer>("TX_STMIN", Integer.class, new LinuxSocketOptionHandler<Integer>(){

        @Override
        public void set(int sock, Integer val, boolean validate) throws IOException {
            SocketCAN.setIsotpTxStmin(sock, val);
        }

        @Override
        public Integer get(int sock) throws IOException {
            return SocketCAN.getIsotpTxStmin(sock);
        }
    });
    public static final SocketOption<Integer> RX_STMIN = new CanSocketOption<Integer>("RX_STMIN", Integer.class, new LinuxSocketOptionHandler<Integer>(){

        @Override
        public void set(int sock, Integer val, boolean validate) throws IOException {
            SocketCAN.setIsotpRxStmin(sock, val);
        }

        @Override
        public Integer get(int sock) throws IOException {
            return SocketCAN.getIsotpRxStmin(sock);
        }
    });
    public static final SocketOption<IsotpLinkLayerOptions> LL_OPTS = new CanSocketOption<IsotpLinkLayerOptions>("LL_OPTS", IsotpLinkLayerOptions.class, new LinuxSocketOptionHandler<IsotpLinkLayerOptions>(){

        @Override
        public void set(int sock, IsotpLinkLayerOptions val, boolean validate) throws IOException {
            if (validate) {
                byte mtu = val.getMaximumTransmissionUnit();
                byte txDataLength = val.getTransmissionDataLength();
                if (txDataLength != CanUtils.padDataLength(txDataLength)) {
                    throw new IllegalArgumentException("The transmission data length must be properly padded!");
                }
                if (mtu != 16 && mtu != 72) {
                    throw new IllegalArgumentException("MTU must be either 16 or 72!");
                }
                if (mtu == 16) {
                    if (txDataLength > 8) {
                        throw new IllegalArgumentException("Only FD frames support a data length of " + txDataLength + "!");
                    }
                    if (val.getTransmissionFlags() != 0) {
                        throw new IllegalArgumentException("Only FD frames support transmission flags!");
                    }
                }
            }
            SocketCAN.setIsotpLlOpts(sock, val.getMaximumTransmissionUnit(), val.getTransmissionDataLength(), val.getTransmissionFlags());
        }

        @Override
        public IsotpLinkLayerOptions get(int sock) throws IOException {
            return SocketCAN.getIsotpLlOpts(sock);
        }
    });

    private IsotpCanSocketOptions() {
    }
}

