/*
 * Decompiled with CFR 0.152.
 */
package tel.schich.javacan;

import java.util.Objects;

public class IsotpLinkLayerOptions {
    public static final IsotpLinkLayerOptions DEFAULT = new IsotpLinkLayerOptions(16, 8, 0);
    private final byte maximumTransmissionUnit;
    private final byte transmissionDataLength;
    private final byte transmissionFlags;

    public IsotpLinkLayerOptions(byte maximumTransmissionUnit, byte transmissionDataLength, byte transmissionFlags) {
        this.maximumTransmissionUnit = maximumTransmissionUnit;
        this.transmissionDataLength = transmissionDataLength;
        this.transmissionFlags = transmissionFlags;
    }

    public byte getMaximumTransmissionUnit() {
        return this.maximumTransmissionUnit;
    }

    public IsotpLinkLayerOptions withMaximumTransmissionUnit(byte maximumTransmissionUnit) {
        return new IsotpLinkLayerOptions(maximumTransmissionUnit, this.transmissionDataLength, this.transmissionFlags);
    }

    public IsotpLinkLayerOptions withMaximumTransmissionUnit(int maximumTransmissionUnit) {
        return this.withMaximumTransmissionUnit((byte)maximumTransmissionUnit);
    }

    public byte getTransmissionDataLength() {
        return this.transmissionDataLength;
    }

    public IsotpLinkLayerOptions withTransmissionDataLength(byte transmissionDataLength) {
        return new IsotpLinkLayerOptions(this.maximumTransmissionUnit, transmissionDataLength, this.transmissionFlags);
    }

    public IsotpLinkLayerOptions withTransmissionDataLength(int transmissionDataLength) {
        return this.withTransmissionDataLength((byte)transmissionDataLength);
    }

    public byte getTransmissionFlags() {
        return this.transmissionFlags;
    }

    public IsotpLinkLayerOptions withTransmissionFlags(byte transmissionFlags) {
        return new IsotpLinkLayerOptions(this.maximumTransmissionUnit, this.transmissionDataLength, transmissionFlags);
    }

    public IsotpLinkLayerOptions withTransmissionFlags(int transmissionFlags) {
        return this.withTransmissionFlags((byte)transmissionFlags);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IsotpLinkLayerOptions that = (IsotpLinkLayerOptions)o;
        return this.maximumTransmissionUnit == that.maximumTransmissionUnit && this.transmissionDataLength == that.transmissionDataLength && this.transmissionFlags == that.transmissionFlags;
    }

    public int hashCode() {
        return Objects.hash(this.maximumTransmissionUnit, this.transmissionDataLength, this.transmissionFlags);
    }

    public String toString() {
        return "IsotpLinkLayerOptions(maximumTranmissionUnit=" + this.maximumTransmissionUnit + ", transmissionDataLength=" + this.transmissionDataLength + ", transmissionFlags=" + this.transmissionFlags + ')';
    }
}

