/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ts_plugin;

import com.devexperts.logging.Logging;
import com.efiAnalytics.plugin.ApplicationPlugin;
import com.efiAnalytics.plugin.ecu.ControllerAccess;
import com.rusefi.ts_plugin.TsPluginBodyFetcher;
import com.rusefi.ts_plugin.Updater;
import com.rusefi.ts_plugin.headless.TsHeadlessPlugin;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.putgemin.VerticalFlowLayout;

public class TsPluginLauncher
implements ApplicationPlugin {
    public static final int BUILD_VERSION = 7;
    static final String VERSION = "2025.alpha.7";
    private static final Logging log = Logging.getLogging(TsPluginLauncher.class);
    private static final String HELP_URL = "https://wiki.rusefi.com/TS-Plugin";
    private final JPanel content = new JPanel(new VerticalFlowLayout());

    public TsPluginLauncher() {
        log.info("init " + this);
        Thread pluginFetchThread = new Thread(() -> {
            TsPluginBodyFetcher.downloadLatestIfNeeded();
            TsHeadlessPlugin.start();
        }, "pluginFetchThread");
        pluginFetchThread.start();
    }

    @Override
    public String getIdName() {
        return "rusEFI_plugin";
    }

    @Override
    public int getPluginType() {
        return 2;
    }

    @Override
    public String getDisplayName() {
        return "rusEFI Plugin";
    }

    @Override
    public String getDescription() {
        return "A plugin for rusEFI integration";
    }

    @Override
    public void initialize(ControllerAccess controllerAccess) {
    }

    @Override
    public boolean displayPlugin(String signature) {
        log.info("displayPlugin " + signature);
        TsHeadlessPlugin.displayPlugin(signature);
        return true;
    }

    @Override
    public boolean isMenuEnabled() {
        return true;
    }

    @Override
    public String getAuthor() {
        return "rusEFI LLC";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JComponent getPluginPanel() {
        TsPluginLauncher tsPluginLauncher = this;
        synchronized (tsPluginLauncher) {
            if (this.content.getComponents().length == 0) {
                log.info("Create Updater " + this + " " + 20260115);
                Updater updater = new Updater();
                this.content.add(updater.getContent());
            }
        }
        return this.content;
    }

    @Override
    public void close() {
        log.info("TsPluginLauncher.close " + this);
    }

    @Override
    public String getHelpUrl() {
        return HELP_URL;
    }

    @Override
    public String getVersion() {
        return VERSION;
    }

    @Override
    public double getRequiredPluginSpec() {
        return 1.0;
    }

    public String toString() {
        return super.toString() + " " + this.getVersion();
    }
}

