/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.autoupdate;

import com.devexperts.logging.Logging;
import com.rusefi.core.FileUtil;
import com.rusefi.ts.TsHelper;
import java.io.File;
import java.io.IOException;

public class TsPluginInstaller {
    private static final Logging log = Logging.getLogging(TsPluginInstaller.class);
    private static final String PLUGIN_FOLDER = TsHelper.TS_ROOT + "TunerStudio" + File.separator + "plugins" + File.separator;
    private static final String RUSEFI_TS_PLUGIN_LAUNCHER_JAR = "rusefi_ts_plugin_launcher.jar";

    public static void installTsPlugin() {
        File tsLauncher = new File(RUSEFI_TS_PLUGIN_LAUNCHER_JAR);
        if (!tsLauncher.exists()) {
            log.warn("rusefi_ts_plugin_launcher.jar not found");
            return;
        }
        try {
            new File(PLUGIN_FOLDER).mkdirs();
            FileUtil.copyFile(RUSEFI_TS_PLUGIN_LAUNCHER_JAR, PLUGIN_FOLDER + RUSEFI_TS_PLUGIN_LAUNCHER_JAR);
            log.info("Just installed fresh rusefi_ts_plugin_launcher.jar into " + PLUGIN_FOLDER);
            String legacyPluginFileName = PLUGIN_FOLDER + "rusefi_plugin_launcher.jar";
            File legacyPluginFile = new File(legacyPluginFileName);
            if (legacyPluginFile.exists()) {
                log.info("Removing legacy plugin file " + legacyPluginFileName);
                legacyPluginFile.delete();
            }
        }
        catch (IOException e) {
            log.warn("Error installing rusefi_ts_plugin_launcher.jar" + e, e);
        }
    }
}

