/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.maintenance.migration;

import com.opensr5.ini.IniFileModel;
import com.rusefi.io.UpdateOperationCallbacks;
import com.rusefi.tune.xml.Constant;
import com.rusefi.tune.xml.Msq;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TuneMigrationContext {
    private final IniFileModel prevIniFile;
    private final Msq prevTune;
    private final IniFileModel updatedIniFile;
    private final Msq updatedTune;
    private final Map<String, Constant> migratedConstants = new HashMap<String, Constant>();
    private final Set<String> migratedFields = new HashSet<String>();
    final UpdateOperationCallbacks callbacks;
    final Set<String> additionalIniFieldsToIgnore;

    public TuneMigrationContext(IniFileModel prevIniFile, Msq prevTune, IniFileModel updatedIniFile, Msq updatedTune, UpdateOperationCallbacks callbacks, Set<String> additionalIniFieldsToIgnore) {
        this.prevIniFile = prevIniFile;
        this.prevTune = prevTune;
        this.updatedIniFile = updatedIniFile;
        this.updatedTune = updatedTune;
        this.callbacks = callbacks;
        this.additionalIniFieldsToIgnore = additionalIniFieldsToIgnore;
    }

    public IniFileModel getPrevIniFile() {
        return this.prevIniFile;
    }

    public Msq getPrevTune() {
        return this.prevTune;
    }

    public IniFileModel getUpdatedIniFile() {
        return this.updatedIniFile;
    }

    public Msq getUpdatedTune() {
        return this.updatedTune;
    }

    public boolean isAdditionalIniFieldToIgnore(String iniFieldName) {
        return this.additionalIniFieldsToIgnore.contains(iniFieldName);
    }

    public Map<String, Constant> getMigratedConstants() {
        return Collections.unmodifiableMap(this.migratedConstants);
    }

    public UpdateOperationCallbacks getCallbacks() {
        return this.callbacks;
    }

    public void addMigration(String migratedFieldName, Constant migratedValue) {
        this.addMigration(migratedFieldName, migratedFieldName, migratedValue);
    }

    public boolean isFieldAlreadyMigrated(String fieldName) {
        return this.migratedFields.contains(fieldName);
    }

    public void addMigration(String originalFieldName, String migratedFieldName, Constant migratedValue) {
        this.migratedFields.add(originalFieldName);
        Constant prevMigratedValue = this.migratedConstants.put(migratedFieldName, migratedValue);
        if (prevMigratedValue != null) {
            this.callbacks.logLine(String.format("WARNING!!! We are overwriting already migrated constant `%s`: `%s` -> `%s`", migratedFieldName, prevMigratedValue, migratedValue));
        }
    }

    public void logWarn(String warning) {
        this.callbacks.logLine(String.format("WARNING! %s", warning));
    }
}

