/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.core.ui;

import com.devexperts.logging.Logging;
import com.rusefi.core.io.BundleUtil;
import com.rusefi.core.ui.AutoupdateUtil;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JFrame;
import org.jetbrains.annotations.NotNull;

public class FrameHelper {
    private static final Logging log = Logging.getLogging(FrameHelper.class);
    private final JFrame frame = new JFrame();

    public FrameHelper() {
        this(2);
    }

    public FrameHelper(int operation) {
        AutoupdateUtil.assertAwtThread();
        this.frame.setDefaultCloseOperation(operation);
        AutoupdateUtil.setAppIcon(this.frame);
    }

    @NotNull
    public static String appendBundleName(String title) {
        String bundleName = BundleUtil.readBundleFullNameNotNull().getUiLabel();
        return title + " " + bundleName;
    }

    public static FrameHelper createFrame(String title) {
        FrameHelper frame = new FrameHelper(3);
        frame.frame.setTitle(FrameHelper.appendBundleName(title));
        return frame;
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public void showFrame(JComponent content) {
        this.showFrame(content, true);
    }

    public void showFrame(JComponent content, boolean maximizeOnStart) {
        this.initFrame(content, maximizeOnStart);
        this.frame.setVisible(true);
    }

    public void initFrame(JComponent content, final boolean maximizeOnStart) {
        this.frame.setSize(800, 500);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                FrameHelper.this.onWindowOpened();
                if (maximizeOnStart) {
                    FrameHelper.this.frame.setExtendedState(FrameHelper.this.frame.getExtendedState() | 6);
                }
            }

            @Override
            public void windowClosed(WindowEvent ev) {
                FrameHelper.this.onWindowClosed();
                for (Thread t : Thread.getAllStackTraces().keySet()) {
                    if (t.isDaemon()) continue;
                    log.info("Non-daemon thread: " + t);
                }
                log.info(Arrays.toString(Frame.getFrames()));
            }
        });
        this.frame.add(content);
    }

    protected void onWindowOpened() {
    }

    protected void onWindowClosed() {
    }
}

