/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.autoupdate;

import com.devexperts.logging.Logging;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ObsoleteFilesArchiver {
    INSTANCE;

    private static final Logging log;
    private static final List<Path> OBSOLETE_FILES_TO_DELETE;
    private static final List<String> OBSOLETE_FILE_MASKS_TO_ARCHIVE;
    private static final Path ARCHIVE_FOLDER_PATH;

    public void archiveObsoleteFiles() {
        for (Path fileToRemove : OBSOLETE_FILES_TO_DELETE) {
            try {
                Files.deleteIfExists(fileToRemove);
            }
            catch (IOException e) {
                log.error(String.format("Failed to delete `%s` file", fileToRemove), e);
            }
        }
        for (String fileMaskToArchive : OBSOLETE_FILE_MASKS_TO_ARCHIVE) {
            try {
                DirectoryStream<Path> dirStream = Files.newDirectoryStream(Paths.get(".", new String[0]), fileMaskToArchive);
                try {
                    Files.createDirectories(ARCHIVE_FOLDER_PATH, new FileAttribute[0]);
                    dirStream.forEach(fileToArchive -> {
                        try {
                            Files.move(fileToArchive, ARCHIVE_FOLDER_PATH.resolve((Path)fileToArchive), StandardCopyOption.REPLACE_EXISTING);
                        }
                        catch (IOException e) {
                            log.error(String.format("Failed to move `%s` file to `%s` folder", fileToArchive, ARCHIVE_FOLDER_PATH), e);
                        }
                    });
                }
                finally {
                    if (dirStream == null) continue;
                    dirStream.close();
                }
            }
            catch (IOException e) {
                log.error(String.format("Failed to find files to archive by mask `%s`", fileMaskToArchive), e);
            }
        }
    }

    static {
        log = Logging.getLogging(ObsoleteFilesArchiver.class);
        OBSOLETE_FILES_TO_DELETE = Stream.of("rusefi.bin", "rusefi_update.srec", "rusefi-obfuscated.srec").map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
        OBSOLETE_FILE_MASKS_TO_ARCHIVE = Stream.of("rusefi_*.bin", "rusefi_*.srec", "rusefi-obfuscated_*.srec").collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
        ARCHIVE_FOLDER_PATH = Paths.get("./archive", new String[0]);
    }
}

