/*
 * Decompiled with CFR 0.152.
 */
package com.opensr5.ini;

import com.opensr5.ini.RawIniFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class IniFileReader {
    private IniFileReader() {
    }

    public static String[] splitTokens(String str) {
        ArrayList<String> strings = new ArrayList<String>();
        boolean inQuote = false;
        boolean hadQuote = false;
        int openedBraceCount = 0;
        StringBuilder sb = new StringBuilder();
        block4: for (char c : str.toCharArray()) {
            if (c == '\"' || IniFileReader.isTokenSeparator(c) && !inQuote && openedBraceCount == 0) {
                if (c == '\"') {
                    boolean bl = inQuote = !inQuote;
                    if (!inQuote) {
                        hadQuote = true;
                    }
                }
                if (!inQuote && sb.length() > 0) {
                    strings.add(sb.toString());
                    sb.delete(0, sb.length());
                    hadQuote = false;
                    continue;
                }
                if (!hadQuote) continue;
                strings.add("");
                hadQuote = false;
                continue;
            }
            sb.append(c);
            switch (c) {
                case '{': {
                    ++openedBraceCount;
                    continue block4;
                }
                case '}': {
                    if (0 < openedBraceCount) {
                        --openedBraceCount;
                        continue block4;
                    }
                    throw new IllegalArgumentException(String.format("Unexpected closing brace: %s", str));
                }
            }
        }
        if (sb.length() > 0) {
            strings.add(sb.toString());
        }
        return strings.toArray(new String[strings.size()]);
    }

    private static boolean isTokenSeparator(int c) {
        return c == 32 || c == 9 || c == 61 || c == 44;
    }

    public static RawIniFile read(InputStream in) {
        return IniFileReader.read(in, "unknown");
    }

    public static RawIniFile read(InputStream in, String msg) {
        ArrayList<RawIniFile.Line> lines = new ArrayList<RawIniFile.Line>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.trim().isEmpty()) continue;
                lines.add(new RawIniFile.Line(line));
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return new RawIniFile(lines, msg);
    }

    public static RawIniFile read(File input) throws FileNotFoundException {
        FileInputStream in = new FileInputStream(input);
        return IniFileReader.read(in, input.getAbsolutePath());
    }
}

