/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.maintenance;

import com.devexperts.logging.Logging;
import com.rusefi.io.UpdateOperationCallbacks;
import com.rusefi.maintenance.ErrorExecutingCommand;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class ExecHelper {
    private static final Logging log = Logging.getLogging(ExecHelper.class);

    private static boolean isRunning(Process p) {
        try {
            p.exitValue();
            return false;
        }
        catch (IllegalThreadStateException e) {
            return true;
        }
    }

    private static void startStreamThread(Process p, InputStream stream, StringBuffer buffer, UpdateOperationCallbacks callbacks) {
        Thread t = new Thread(() -> {
            try {
                String line;
                BufferedReader bis = new BufferedReader(new InputStreamReader(stream, StandardCharsets.ISO_8859_1));
                long wasRunningTime = System.currentTimeMillis();
                while ((ExecHelper.isRunning(p) || (double)(System.currentTimeMillis() - wasRunningTime) < 500.0) && (line = bis.readLine()) != null) {
                    callbacks.logLine(line);
                    buffer.append(line);
                    wasRunningTime = System.currentTimeMillis();
                }
            }
            catch (IOException e) {
                callbacks.logLine("Stream " + e);
                callbacks.error();
            }
        });
        t.setDaemon(true);
        t.start();
    }

    @NotNull
    public static String executeCommand(String workingDirPath, String command, String binaryRelativeName, UpdateOperationCallbacks callbacks) throws FileNotFoundException {
        return ExecHelper.executeCommand(workingDirPath, command, binaryRelativeName, callbacks, new StringBuffer());
    }

    @NotNull
    public static String executeCommand(String workingDirPath, String command, String binaryRelativeName, UpdateOperationCallbacks callbacks, StringBuffer output) throws FileNotFoundException {
        StringBuffer error = new StringBuffer();
        String binaryFullName = ExecHelper.getBinaryFullFileName(workingDirPath, binaryRelativeName);
        if (!new File(binaryFullName).exists()) {
            callbacks.logLine(binaryFullName + " not found :(");
            throw new FileNotFoundException(binaryFullName);
        }
        File workingDir = new File(workingDirPath);
        try {
            return ExecHelper.executeCommand(command, callbacks, output, error, workingDir);
        }
        catch (ErrorExecutingCommand e) {
            callbacks.logLine("ErrorExecutingCommand: " + e);
            callbacks.error();
            throw new RuntimeException(e);
        }
    }

    @NotNull
    private static String getBinaryFullFileName(String workingDirPath, String binaryRelativeName) {
        return workingDirPath + File.separator + binaryRelativeName;
    }

    @NotNull
    public static String executeCommand(String command, UpdateOperationCallbacks callbacks, StringBuffer output, StringBuffer error, File workingDir) throws ErrorExecutingCommand {
        callbacks.logLine("Executing command=" + command);
        try {
            Process p = Runtime.getRuntime().exec(command, null, workingDir);
            ExecHelper.startStreamThread(p, p.getInputStream(), output, callbacks);
            ExecHelper.startStreamThread(p, p.getErrorStream(), error, callbacks);
            p.waitFor(3L, TimeUnit.MINUTES);
        }
        catch (IOException e) {
            log.info("executeCommand " + e);
            throw new ErrorExecutingCommand(e);
        }
        catch (InterruptedException e) {
            callbacks.logLine("WaitError: " + e);
            callbacks.error();
        }
        return error.toString();
    }

    public static void submitAction(Runnable runnable, String threadName) {
        Thread thread = new Thread(runnable, threadName);
        thread.setDaemon(true);
        thread.start();
    }

    @NotNull
    public static String getBatchCommand(String batch) {
        return "cmd /c start " + batch;
    }
}

