/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.maintenance.migration.migrators;

import com.devexperts.logging.Logging;
import com.opensr5.ini.field.IniField;
import com.rusefi.maintenance.migration.TuneMigrationContext;
import com.rusefi.maintenance.migration.migrators.TuneMigrator;
import com.rusefi.tune.xml.Constant;
import java.util.Optional;

public enum DisplacementIniFieldMigrator implements TuneMigrator
{
    INSTANCE;

    private static final Logging log;
    public static final String DISPLACEMENT_FIELD_NAME = "displacement";

    @Override
    public void migrateTune(TuneMigrationContext context) {
        Optional<IniField> prevDisplacementIniField = context.getPrevIniFile().findIniField(DISPLACEMENT_FIELD_NAME);
        Optional<IniField> updatedDisplacementIniField = context.getUpdatedIniFile().findIniField(DISPLACEMENT_FIELD_NAME);
        if (!prevDisplacementIniField.isPresent() || !updatedDisplacementIniField.isPresent()) {
            return;
        }
        String prevDisplacementUnits = prevDisplacementIniField.get().getUnits();
        String updatedDisplacementUnits = updatedDisplacementIniField.get().getUnits();
        if (!"L".equals(prevDisplacementUnits) || !"cubic inches".equals(updatedDisplacementUnits)) {
            return;
        }
        Constant prevDisplacementConst = context.getPrevTune().getConstantsAsMap().get(DISPLACEMENT_FIELD_NAME);
        Constant updatedDisplacementConst = context.getUpdatedTune().getConstantsAsMap().get(DISPLACEMENT_FIELD_NAME);
        if (null == prevDisplacementConst || null == updatedDisplacementConst) {
            return;
        }
        String prevDisplacementStringValue = prevDisplacementConst.getValue();
        if (null == prevDisplacementStringValue) {
            log.warn(String.format("Previous `%s` constant has null value - it's strange :(", DISPLACEMENT_FIELD_NAME));
            return;
        }
        try {
            double prevDisplacementValue = Double.parseDouble(prevDisplacementStringValue);
            double migratedDisplacementValue = prevDisplacementValue * 61.0236100347;
            Constant migratedDisplacementConst = updatedDisplacementConst.cloneWithValue(String.valueOf(migratedDisplacementValue));
            context.addMigration(DISPLACEMENT_FIELD_NAME, migratedDisplacementConst);
        }
        catch (NumberFormatException e) {
            log.warn(String.format("Failed to parse previous `%s` constant value: %s", DISPLACEMENT_FIELD_NAME, prevDisplacementStringValue));
        }
    }

    static {
        log = Logging.getLogging(DisplacementIniFieldMigrator.class);
    }
}

