/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.io.commands;

import com.rusefi.binaryprotocol.IoHelper;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class ByteRange {
    private final int offset;
    private final int count;

    private ByteRange(int offset, int count) {
        this.offset = offset;
        this.count = count;
    }

    @NotNull
    private static DataInputStream createPayLoadStream(byte[] payload) {
        return new DataInputStream(new ByteArrayInputStream(payload, 1, payload.length - 1));
    }

    public static void packOffsetAndSize(int offset, int requestSize, byte[] packet) {
        IoHelper.putShort(packet, 0, IoHelper.swap16(offset));
        IoHelper.putShort(packet, 2, IoHelper.swap16(requestSize));
    }

    public static void packPageOffsetAndSize(int offset, int requestSize, byte[] packet) {
        IoHelper.putShort(packet, 0, IoHelper.swap16(0));
        IoHelper.putShort(packet, 2, IoHelper.swap16(offset));
        IoHelper.putShort(packet, 4, IoHelper.swap16(requestSize));
    }

    public int getOffset() {
        return this.offset;
    }

    public int getCount() {
        return this.count;
    }

    public String toString() {
        return "{offset=" + this.offset + ", count=" + this.count + '}';
    }

    public static ByteRange valueOf(byte[] payload) throws IOException {
        try (DataInputStream dis = ByteRange.createPayLoadStream(payload);){
            int offset = IoHelper.swap16(dis.readShort());
            int count = IoHelper.swap16(dis.readShort());
            ByteRange byteRange = new ByteRange(offset, count);
            return byteRange;
        }
    }

    public static ByteRange valueOf2(byte[] payload) throws IOException {
        try (DataInputStream dis = ByteRange.createPayLoadStream(payload);){
            dis.readShort();
            int offset = IoHelper.swap16(dis.readShort());
            int count = IoHelper.swap16(dis.readShort());
            ByteRange byteRange = new ByteRange(offset, count);
            return byteRange;
        }
    }
}

