/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.maintenance;

import com.rusefi.ConnectivityContext;
import com.rusefi.PortResult;
import com.rusefi.io.UpdateOperationCallbacks;
import com.rusefi.maintenance.CalibrationsHelper;
import com.rusefi.maintenance.CalibrationsInfo;
import com.rusefi.maintenance.OutputChannelsHelper;
import com.rusefi.panama.PanamaClient;
import com.rusefi.ui.basic.InstanceNameEditor;
import java.io.File;
import java.util.Optional;

public enum TuneUploader {
    INSTANCE;

    private static final String CALIBRATIONS_TO_UPLOAD_FILE_NAME = "state/calibrations_to_upload";

    public synchronized boolean uploadTune(PortResult ecuPort, String panamaUrl, UpdateOperationCallbacks callbacks, ConnectivityContext connectivityContext) {
        boolean result = false;
        String instanceName = InstanceNameEditor.loadInstanceName();
        if (instanceName == null || instanceName.isEmpty()) {
            callbacks.logLine("Instance name is not defined!");
            callbacks.logLine("Please right-click on logo and use `Instance name` context menu  to specify an instance name.");
            return false;
        }
        Optional<CalibrationsInfo> calibrationsToUpload = CalibrationsHelper.readAndBackupCurrentCalibrationsWithSuspendedPortScanner(ecuPort.port, callbacks, CALIBRATIONS_TO_UPLOAD_FILE_NAME, connectivityContext);
        if (!calibrationsToUpload.isPresent()) {
            callbacks.logLine("Failed to back up current calibrations...");
            return false;
        }
        Optional<Integer> receivedMcuSerial = OutputChannelsHelper.readMcuSerial(ecuPort, callbacks, connectivityContext);
        if (!receivedMcuSerial.isPresent()) {
            callbacks.logLine("Failed to read MCUSERIAL output channel - please update firmware first!");
            return false;
        }
        int mcuSerial = receivedMcuSerial.get();
        String calibrationsToUploadFileName = "state/calibrations_to_upload.msq";
        if (PanamaClient.uploadFile(panamaUrl, new File("state/calibrations_to_upload.msq"), instanceName, mcuSerial)) {
            callbacks.logLine(String.format("File `%s` is successfully uploaded to `%s` for `%s` (MCUSERIAL=%d)", "state/calibrations_to_upload.msq", panamaUrl, instanceName, mcuSerial));
            result = true;
        } else {
            callbacks.logLine(String.format("Failed to upload file `%s` to `%s` for `%s` (MCUSERIAL=%d)", "state/calibrations_to_upload.msq", panamaUrl, instanceName, mcuSerial));
        }
        return result;
    }
}

