/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui.basic;

import com.rusefi.ConnectivityContext;
import com.rusefi.PortResult;
import com.rusefi.core.preferences.storage.PersistentConfiguration;
import com.rusefi.maintenance.jobs.ImportTuneJob;
import com.rusefi.ui.basic.SingleAsyncJobExecutor;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;

public class ImportTuneFileChooser {
    private static final String TUNE_TO_IMPORT_DEFAULT_DIRECTORY_PROPERTY_NAME = "tune_to_import_default_directory";
    private final SingleAsyncJobExecutor singleAsyncJobExecutor;
    private final JFileChooser tuneToImportFileChooser = ImportTuneFileChooser.createTuneToImportFileChooser();

    public ImportTuneFileChooser(SingleAsyncJobExecutor singleAsyncJobExecutor) {
        this.singleAsyncJobExecutor = singleAsyncJobExecutor;
    }

    void showFileChooserToImportTuneAction(PortResult port, JComponent parent, ConnectivityContext connectivityContext) {
        int selectedOption = this.tuneToImportFileChooser.showOpenDialog(parent);
        if (selectedOption == 0) {
            File selectedFile = this.tuneToImportFileChooser.getSelectedFile();
            ImportTuneFileChooser.saveTuneToImportDefaultDirectory(selectedFile.getParent());
            String tuneFileName = selectedFile.getAbsolutePath();
            ImportTuneJob.importTuneIntoDevice(port, parent, connectivityContext, tuneFileName, this.singleAsyncJobExecutor);
        }
    }

    private static JFileChooser createTuneToImportFileChooser() {
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(0);
        fc.setFileFilter(new FileNameExtensionFilter("Tune files (.msq)", "msq"));
        String currentDirectory = ImportTuneFileChooser.loadTuneToImportDefaultDirectory();
        if (currentDirectory != null) {
            fc.setCurrentDirectory(new File(currentDirectory));
        }
        return fc;
    }

    private static void saveTuneToImportDefaultDirectory(String path) {
        PersistentConfiguration.getConfig().getRoot().setProperty(TUNE_TO_IMPORT_DEFAULT_DIRECTORY_PROPERTY_NAME, path);
        PersistentConfiguration.getConfig().save();
    }

    private static String loadTuneToImportDefaultDirectory() {
        return PersistentConfiguration.getConfig().getRoot().getProperty(TUNE_TO_IMPORT_DEFAULT_DIRECTORY_PROPERTY_NAME, "");
    }
}

