/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.core.io;

import com.devexperts.logging.Logging;
import com.rusefi.core.io.BundleInfo;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.util.List;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;

public class BundleUtil {
    private static final Logging log = Logging.getLogging(BundleUtil.class);
    private static final String BRANCH_REF_FILE = "release.txt";

    public static List<@NotNull String> readBundleFullName() {
        File f = new File(BRANCH_REF_FILE);
        if (!f.exists()) {
            log.error("release.txt not found");
            return null;
        }
        try {
            return Files.readAllLines(f.toPath());
        }
        catch (IOException | InvalidPathException e) {
            log.error("Error reading bundle name", e);
            return null;
        }
    }

    @NotNull
    public static BundleInfo readBundleFullNameNotNull() {
        List<@NotNull String> info = BundleUtil.readBundleFullName();
        if (info == null) {
            return BundleInfo.UNKNOWN;
        }
        return BundleUtil.parse(info);
    }

    public static String getBundleTarget() {
        return BundleUtil.readBundleFullNameNotNull().getTarget();
    }

    public static BundleInfo parse(List<@NotNull String> info) {
        TreeMap<String, String> keyValues = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        for (String line : info) {
            String[] pair = line.split("=", 2);
            keyValues.put(pair[0], pair[1]);
        }
        String target = (String)keyValues.get("platform");
        String branchName = (String)keyValues.get("release");
        String nextBranchName = (String)keyValues.get("nextRelease");
        if (target == null || branchName == null) {
            log.info("release.txt says " + keyValues);
            return BundleInfo.UNKNOWN;
        }
        return new BundleInfo(branchName, nextBranchName, target);
    }
}

