/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.io.tcp;

import com.devexperts.logging.Logging;
import java.io.IOException;
import java.net.Socket;
import java.util.Collection;
import java.util.Collections;

public class TcpConnector {
    private static final Logging log = Logging.getLogging(TcpConnector.class);
    public static final int DEFAULT_PORT = 29001;
    public static final String LOCALHOST = "localhost";

    public static boolean isTcpPort(String port) {
        try {
            TcpConnector.getTcpPort(port);
            return true;
        }
        catch (InvalidTcpPort e) {
            return false;
        }
    }

    public static int getTcpPort(String port) throws InvalidTcpPort {
        try {
            String[] portParts = port.split(":");
            int index = portParts.length == 1 ? 0 : 1;
            return Integer.parseInt(portParts[index]);
        }
        catch (NumberFormatException e) {
            throw new InvalidTcpPort();
        }
    }

    public static String getHostname(String port) {
        String[] portParts = port.split(":");
        return portParts.length == 1 ? LOCALHOST : (portParts[0].length() > 0 ? portParts[0] : LOCALHOST);
    }

    public static Collection<String> getAvailablePorts() {
        return TcpConnector.isTcpPortOpened() ? Collections.singletonList("29001") : Collections.emptyList();
    }

    public static boolean isTcpPortOpened() {
        long now = System.currentTimeMillis();
        try {
            Socket s = new Socket(LOCALHOST, 29001);
            s.close();
            return true;
        }
        catch (IOException e) {
            log.info("Connection refused in getAvailablePorts(): simulator not running in " + (System.currentTimeMillis() - now) + "ms");
            return false;
        }
    }

    public static class InvalidTcpPort
    extends IOException {
    }
}

