/*
 * Decompiled with CFR 0.152.
 */
package com.opensr5.ini.field;

import com.opensr5.ini.field.IniField;
import com.opensr5.ini.field.IniFieldVisitor;
import com.rusefi.config.FieldType;
import com.rusefi.ini.reader.EnumIniReaderHelper;
import com.rusefi.ini.reader.IniFileReaderUtil;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import javax.management.ObjectName;

public class EnumIniField
extends IniField {
    private final FieldType type;
    private final EnumKeyValueMap enums;
    private final int bitPosition;
    private final int bitSize0;

    public EnumIniField(String name, int offset, FieldType type, EnumKeyValueMap enums, int bitPosition, int bitSize0) {
        super(name, offset);
        this.type = type;
        this.enums = enums;
        this.bitPosition = bitPosition;
        this.bitSize0 = bitSize0;
    }

    @Override
    public <T> T accept(IniFieldVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public int getSize() {
        return this.type.getStorageSize();
    }

    public int getBitPosition() {
        return this.bitPosition;
    }

    public int getBitSize0() {
        return this.bitSize0;
    }

    public EnumKeyValueMap getEnums() {
        return this.enums;
    }

    public FieldType getType() {
        return this.type;
    }

    public static boolean isQuoted(String q) {
        int len = q.length();
        return len >= 2 && q.charAt(0) == '\"' && q.charAt(len - 1) == '\"';
    }

    @Override
    public String toString() {
        return "EnumIniField{name=" + this.getName() + ", offset=" + this.getOffset() + ", type=" + (Object)((Object)this.type) + ", enums=" + this.enums + ", bitPosition=" + this.bitPosition + ", bitSize=" + this.bitSize0 + '}';
    }

    public static int setBitRange(int value, int ordinal, int bitPosition, int bitSize) {
        if (ordinal >= 1 << bitSize) {
            throw new IllegalArgumentException("Ordinal overflow " + ordinal + " does not fit in " + bitSize + " bit(s)");
        }
        int num = (1 << bitSize) - 1 << bitPosition;
        int clearBitRange = value & ~num;
        return clearBitRange + (ordinal << bitPosition);
    }

    public static class EnumKeyValueMap {
        private final Map<Integer, String> keyValues;

        public EnumKeyValueMap(Map<Integer, String> keyValues) {
            this.keyValues = keyValues;
        }

        public boolean isBitField() {
            return this.keyValues.size() == 2 && this.keyValues.keySet().stream().allMatch(ordinal -> 0 <= ordinal && ordinal <= 1);
        }

        public static EnumKeyValueMap valueOf(String rawText, Map<String, List<String>> defines) {
            TreeMap<Integer, String> keyValues = new TreeMap<Integer, String>();
            boolean isKeyValueSyntax = EnumIniReaderHelper.isKeyValueSyntax(rawText);
            int offset = 5;
            String[] tokens = IniFileReaderUtil.splitTokens(rawText);
            if (isKeyValueSyntax) {
                for (int i = 0; i < tokens.length - offset; i += 2) {
                    keyValues.put(Integer.valueOf(tokens[i + offset]), tokens[i + offset + 1]);
                }
            } else {
                String firstValue = tokens[offset];
                String trimmed = firstValue.trim();
                if (trimmed.startsWith("$")) {
                    String key = trimmed.substring(1);
                    List<String> elements = defines.get(key);
                    Objects.requireNonNull(elements, "Elements for " + key);
                    for (int i = 0; i < elements.size(); ++i) {
                        keyValues.put(i, elements.get(i));
                    }
                } else {
                    for (int i = 0; i < tokens.length - offset; ++i) {
                        keyValues.put(i, tokens[i + offset]);
                    }
                }
            }
            return new EnumKeyValueMap(keyValues);
        }

        public int size() {
            return this.keyValues.size();
        }

        public String get(int ordinal) {
            return this.keyValues.get(ordinal);
        }

        public int indexOf(String value) {
            String valueToSearch = EnumIniField.isQuoted(value) ? ObjectName.unquote(value) : value;
            for (Map.Entry<Integer, String> e : this.keyValues.entrySet()) {
                if (!e.getValue().equals(valueToSearch)) continue;
                return e.getKey();
            }
            return -1;
        }
    }
}

