/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi;

import com.devexperts.logging.Logging;
import com.rusefi.PortResult;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class SerialPortCache {
    private static final Logging log = Logging.getLogging(SerialPortCache.class);
    private static final Duration lifeTime = Duration.ofSeconds(2L);
    private final Map<String, CachedPort> cachedPorts = new HashMap<String, CachedPort>();

    Optional<PortResult> get(String serialPort) {
        CachedPort cachedPort = this.cachedPorts.get(serialPort);
        if (cachedPort != null) {
            if (cachedPort.isExpired()) {
                this.cachedPorts.remove(serialPort);
                log.info("Expired port is removed: " + serialPort);
            } else {
                return Optional.of(cachedPort.port);
            }
        }
        return Optional.empty();
    }

    void put(PortResult port) {
        this.cachedPorts.put(port.port, new CachedPort(port));
    }

    void retainAll(Set<String> serialPortsToRetain) {
        int cachedPortCount = this.cachedPorts.size();
        if (this.cachedPorts.keySet().retainAll(serialPortsToRetain)) {
            log.info(String.format("%d disappeared ports are removed", cachedPortCount - this.cachedPorts.size()));
        }
    }

    private static class CachedPort {
        private final PortResult port;
        private final Instant expirationTimestamp;

        CachedPort(PortResult portToCache) {
            this.port = portToCache;
            this.expirationTimestamp = Instant.now().plus(lifeTime);
        }

        boolean isExpired() {
            return this.expirationTimestamp.isBefore(Instant.now());
        }
    }
}

