/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi;

import com.rusefi.ReaderProvider;
import com.rusefi.RootHolder;
import com.rusefi.VariableRegistry;
import com.rusefi.output.FileJavaFieldsConsumer;
import com.rusefi.util.LazyFile;
import java.io.BufferedReader;
import java.io.IOException;

public class SimpleDefinesProcessor {
    public static void main(String[] args) throws IOException {
        if (args.length != 1) {
            throw new IllegalStateException("Arguments expected");
        }
        VariableRegistry variableRegistry = new VariableRegistry();
        String definitionInputFile = args[0];
        SimpleDefinesProcessor.read(variableRegistry, definitionInputFile);
        String className = "Integration";
        LazyFile javaFields = LazyFile.REAL.create("../java_console/models/src/main/java/com/rusefi/config/generated/" + className + ".java");
        javaFields.write("// generated by " + SimpleDefinesProcessor.class + "\n");
        FileJavaFieldsConsumer.writePackageLine(javaFields);
        FileJavaFieldsConsumer.writeClassOpenLine(javaFields, className);
        javaFields.write(variableRegistry.getJavaConstants());
        javaFields.write("}\n");
        javaFields.close();
    }

    private static void read(VariableRegistry variableRegistry, String definitionInputFile) throws IOException {
        String fileNameWithRoot = RootHolder.ROOT + definitionInputFile;
        try (BufferedReader definitionReader = new BufferedReader(ReaderProvider.REAL.read(fileNameWithRoot));){
            String line;
            while ((line = definitionReader.readLine()) != null) {
                if (!VariableRegistry.looksLikeDefineLine(line)) continue;
                variableRegistry.processLine(line);
            }
        }
    }
}

