/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi;

import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class ValueRangeControl {
    private final JSpinner minSpinner;
    private final JSpinner maxSpinner;
    private final JPanel panel = new JPanel(new FlowLayout());
    private final double increment;

    public ValueRangeControl(String title, double min, double increment, double max) {
        this.increment = increment;
        this.minSpinner = new JSpinner(new SpinnerNumberModel(min, min, max, increment));
        this.maxSpinner = new JSpinner(new SpinnerNumberModel(max, min, max, increment));
        this.panel.add(new JLabel(title + " from"));
        this.panel.add(this.minSpinner);
        this.panel.add(new JLabel("to"));
        this.panel.add(this.maxSpinner);
    }

    public double getFrom() {
        return (Double)this.minSpinner.getModel().getValue();
    }

    public double getTo() {
        return (Double)this.maxSpinner.getModel().getValue();
    }

    public double getStep() {
        return this.increment;
    }

    public Component getContent() {
        return this.panel;
    }
}

