/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.config;

import com.opensr5.ConfigurationImage;
import com.rusefi.config.FieldType;
import com.rusefi.config.StringFormatter;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class Field {
    public static final int NO_BIT_OFFSET = -1;
    private final String name;
    private final int offset;
    private final FieldType type;
    private final int bitOffset;
    private final String[] options;
    private double scale = 1.0;
    private int baseOffset;

    public Field(String name, int offset, FieldType type) {
        this(name, offset, type, -1);
    }

    private Field(String name, int offset, FieldType type, int bitOffset) {
        this(name, offset, type, bitOffset, null);
    }

    public Field(String name, int offset, FieldType type, int bitOffset, String[] options) {
        this.name = Objects.requireNonNull(name);
        if (name.trim().isEmpty()) {
            throw new IllegalStateException("Empty field name");
        }
        this.offset = offset;
        this.type = type;
        this.bitOffset = bitOffset;
        this.options = options;
    }

    public String getName() {
        return this.name;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getTotalOffset() {
        return this.baseOffset + this.offset;
    }

    public String[] getOptions() {
        return this.options;
    }

    public int getBitOffset() {
        return this.bitOffset;
    }

    public FieldType getType() {
        return this.type;
    }

    public String toString() {
        return "Field{" + this.name + ", o=" + this.offset + ", type=" + (Object)((Object)this.type) + '}';
    }

    public String getAnyValue(ConfigurationImage ci, double multiplier) {
        if (this.options == null) {
            return StringFormatter.niceToString(this.getValue(ci, multiplier));
        }
        if (this.type != FieldType.INT8) {
            throw new IllegalStateException("Unsupported enum " + (Object)((Object)this.type));
        }
        byte ordinal = ci.getByteBuffer(this.offset, this.type.getStorageSize()).get();
        return this.options[ordinal];
    }

    @Deprecated
    @NotNull
    public Double getValue(ConfigurationImage ci) {
        return this.getValue(ci, 1.0);
    }

    @NotNull
    public Double getValue(ConfigurationImage ci, double multiplier) {
        Number value;
        ByteBuffer wrapped;
        Objects.requireNonNull(ci, "ConfigurationImage");
        try {
            wrapped = ci.getByteBuffer(this.getOffset(), this.type.getStorageSize());
        }
        catch (IndexOutOfBoundsException e) {
            throw new RuntimeException("while " + this.name + " at " + this.getOffset() + " from " + ci.getSize(), e);
        }
        if (this.bitOffset != -1) {
            int packed = wrapped.getInt();
            value = packed >> this.bitOffset & 1;
        } else if (this.type == FieldType.INT8) {
            value = wrapped.get();
        } else if (this.type == FieldType.UINT8) {
            byte signed = wrapped.get();
            value = signed & 0xFF;
        } else if (this.type == FieldType.INT) {
            value = wrapped.getInt();
        } else if (this.type == FieldType.INT16) {
            value = wrapped.getShort();
        } else if (this.type == FieldType.UINT16) {
            short signed = wrapped.getShort();
            value = signed & 0xFFFF;
        } else if (this.type == FieldType.FLOAT) {
            value = Float.valueOf(wrapped.getFloat());
        } else {
            throw new IllegalStateException("Unexpected " + (Object)((Object)this.type));
        }
        return ((Number)value).doubleValue() * multiplier;
    }

    @NotNull
    public ByteBuffer getByteBuffer(ConfigurationImage ci) {
        return ci.getByteBuffer(this.getOffset(), 4);
    }

    public static Field create(String name, int offset, FieldType type, int bitOffset) {
        return new Field(name, offset, type, bitOffset);
    }

    public static Field create(String name, int offset, FieldType type) {
        return new Field(name, offset, type);
    }

    public Field setScale(double scale) {
        this.scale = scale;
        return this;
    }

    public Field setBaseOffset(int baseOffset) {
        this.baseOffset = baseOffset;
        return this;
    }

    public double getScale() {
        return this.scale;
    }
}

