/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.core;

import com.opensr5.ini.IniFileModel;
import com.opensr5.ini.IniMemberNotFound;
import com.opensr5.ini.field.IniField;
import com.rusefi.core.ByteBufferUtil;
import com.rusefi.core.Sensor;
import java.nio.ByteBuffer;
import org.jetbrains.annotations.NotNull;

public interface ISensorHolder {
    default public void grabSensorValues(byte[] response, @NotNull IniFileModel ini) {
        for (Sensor sensor : Sensor.values()) {
            IniField sensorField;
            if (sensor.getType() == null) continue;
            String sensorInternalName = sensor.name();
            try {
                sensorField = ini.getOutputChannel(sensorInternalName);
            }
            catch (IniMemberNotFound e) {
                throw new RuntimeException("Not found by " + sensorInternalName, e);
            }
            ByteBuffer bb = ISensorHolder.getByteBuffer(response, sensor.toString(), sensorField.getOffset());
            double rawValue = sensor.getValueForChannel(bb);
            double scaledValue = rawValue * sensor.getScale();
            this.setValue(scaledValue, sensor);
        }
    }

    @NotNull
    public static ByteBuffer getByteBuffer(byte[] response, String message, int fieldOffset) {
        int offset = fieldOffset + 1;
        int size = 4;
        if (offset + size > response.length) {
            throw new IllegalArgumentException(message + String.format(" but %d+%d in %d", offset, size, response.length));
        }
        return ByteBufferUtil.littleEndianWrap(response, offset, size);
    }

    public double getValue(Sensor var1);

    public boolean setValue(double var1, Sensor var3);
}

