/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.f4discovery;

import com.devexperts.logging.Logging;
import com.rusefi.IoUtil;
import com.rusefi.RusefiTestBase;
import com.rusefi.binaryprotocol.BinaryProtocol;
import com.rusefi.common.PwmHardwareTestLogic;
import com.rusefi.core.Sensor;
import com.rusefi.core.SensorCentral;
import com.rusefi.enums.engine_type_e;
import com.rusefi.enums.trigger_type_e;
import org.junit.Assert;
import org.junit.Test;

public class DiscoveryPwmHardwareTest
extends RusefiTestBase {
    private static final Logging log = Logging.getLogging(DiscoveryPwmHardwareTest.class);

    @Override
    protected boolean needsHardwareTriggerInput() {
        return true;
    }

    @Test
    public void scheduleBurnDoesNotAffectTriggerIssue2839() {
        this.ecu.setEngineType(engine_type_e.FORD_ASPIRE_1996);
        this.ecu.sendCommand(IoUtil.setTriggerType(trigger_type_e.TT_TOOTHED_WHEEL_60_2));
        this.ecu.sendCommand(IoUtil.getDisableCommand("self_stimulation"));
        this.ecu.sendCommand(IoUtil.getEnableCommand("ext_stimulation"));
        this.ecu.changeRpm(1200);
        this.nextChart();
        this.nextChart();
        int triggerErrors = (int)SensorCentral.getInstance().getValueSource(Sensor.totalTriggerErrorCounter).getValue();
        log.info("triggerErrors " + triggerErrors);
        for (int i = 0; i < 10; ++i) {
            this.ecu.sendCommand("burnconfig");
            BinaryProtocol.sleep(5000L);
        }
        int totalTriggerErrorsNow = (int)SensorCentral.getInstance().getValueSource(Sensor.totalTriggerErrorCounter).getValue();
        log.info("totalTriggerErrorsNow " + totalTriggerErrorsNow);
        Assert.assertEquals("totalTriggerErrorCounter", triggerErrors, totalTriggerErrorsNow);
    }

    @Test
    public void testIdlePin() {
        PwmHardwareTestLogic.runIdlePwmTest(this.ecu, "PD2", "PA5");
    }
}

