/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.io.commands;

import com.rusefi.binaryprotocol.BinaryProtocol;
import com.rusefi.binaryprotocol.IoHelper;
import com.rusefi.tracing.Entry;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PTraceHelper {
    @NotNull
    public static List<Entry> requestWaitAndGetPTrace(BinaryProtocol bp) {
        bp.executeCommand('_', "begin trace");
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
        return PTraceHelper.executeGetPTraceCommand(bp);
    }

    @NotNull
    private static List<Entry> executeGetPTraceCommand(BinaryProtocol bp) {
        byte[] packet = bp.executeCommand('b', "get trace");
        if (!IoHelper.checkResponseCode(packet, (byte)0) || (packet.length - 1) % 8 != 0) {
            throw new IllegalStateException("Unsupported command or error? packet length=" + (packet != null ? 0 : packet.length));
        }
        return Entry.parseBuffer(packet);
    }
}

