/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.maintenance;

import com.devexperts.logging.Logging;
import com.rusefi.libopenblt.XcpLoader;
import com.rusefi.libopenblt.XcpSettings;
import com.rusefi.libopenblt.file.SrecParser;
import com.rusefi.libopenblt.transport.IXcpTransport;
import com.rusefi.libopenblt.transport.XcpNet;
import com.rusefi.libopenblt.transport.XcpSerial;
import com.rusefi.maintenance.OpenbltJni;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class OpenBltFlasher {
    private static final Logging log = Logging.getLogging(OpenBltFlasher.class);
    private final XcpLoader mLoader;
    private final OpenbltJni.OpenbltCallbacks mCallbacks;
    private List<SrecParser.SRecord> mSegments;
    private int mTotalFileSize;

    private OpenBltFlasher(IXcpTransport transport, XcpSettings settings, OpenbltJni.OpenbltCallbacks callbacks) {
        this.mLoader = new XcpLoader(transport, settings);
        this.mCallbacks = callbacks;
    }

    public static OpenBltFlasher makeSerial(String portName, XcpSettings settings, OpenbltJni.OpenbltCallbacks callbacks) {
        log.info("makeSerial " + portName);
        XcpSerial transport = new XcpSerial(portName);
        return new OpenBltFlasher(transport, settings, callbacks);
    }

    public static OpenBltFlasher makeTcp(String hostname, int port, XcpSettings settings, OpenbltJni.OpenbltCallbacks callbacks) {
        XcpNet transport = new XcpNet(hostname, port);
        return new OpenBltFlasher(transport, settings, callbacks);
    }

    public static void flashSerial(String fileName, String port, OpenbltJni.OpenbltCallbacks callbacks) throws IOException {
        OpenBltFlasher f = OpenBltFlasher.makeSerial(port, new XcpSettings(), callbacks);
        f.flash(fileName);
    }

    public void flash(String filename) throws IOException {
        this.loadFile(filename);
        this.mCallbacks.setPhase("Connect to target", false);
        this.mLoader.start();
        this.erase();
        this.write();
        this.mCallbacks.setPhase("Cleanup", false);
        this.mLoader.stop();
    }

    private void loadFile(String filename) throws IOException {
        this.mCallbacks.setPhase("Load firmware file", false);
        SrecParser file = new SrecParser();
        file.parse(new File(filename));
        this.mSegments = file.getSegments();
        this.mTotalFileSize = this.mSegments.stream().map(s -> s.data.length).reduce(0, Integer::sum);
        this.mCallbacks.log("Firmware file parsed:");
        this.mCallbacks.log("\tfirst address: 0x" + Integer.toString(this.mSegments.get((int)0).address, 16));
        this.mCallbacks.log("\ttotal size: " + this.mTotalFileSize);
    }

    private void erase() throws IOException {
        this.mCallbacks.setPhase("Erase", true);
        ProgressUpdater pu = new ProgressUpdater();
        this.forEachFirmwareChunk(4096, c -> {
            this.mLoader.clearMemory(c.address, c.data.length);
            pu.processBytes(c.data.length);
        });
    }

    private void write() throws IOException {
        this.mCallbacks.setPhase("Program", true);
        ProgressUpdater pu = new ProgressUpdater();
        this.forEachFirmwareChunk(1024, c -> {
            this.mLoader.writeData(c.address, c.data);
            pu.processBytes(c.data.length);
        });
    }

    private void forEachFirmwareChunk(int maxChunk, ChunkHandler func) throws IOException {
        for (SrecParser.SRecord segment : this.mSegments) {
            int segmentRemain = segment.data.length;
            int segmentOffset = 0;
            while (segmentRemain > 0) {
                int chunkSize = Math.min(segmentRemain, maxChunk);
                Chunk c = new Chunk();
                c.address = segment.address + segmentOffset;
                c.data = Arrays.copyOfRange(segment.data, segmentOffset, segmentOffset + chunkSize);
                func.handle(c);
                segmentRemain -= chunkSize;
                segmentOffset += chunkSize;
            }
        }
    }

    private static interface ChunkHandler {
        public void handle(Chunk var1) throws IOException;
    }

    private static class Chunk {
        public int address;
        public byte[] data;

        private Chunk() {
        }
    }

    private class ProgressUpdater {
        private int mTotalProcessed = 0;
        private int mLastPercent = -1;

        private ProgressUpdater() {
        }

        void processBytes(int thisChunk) {
            this.mTotalProcessed += thisChunk;
            int percent = (int)(100.0 * (double)this.mTotalProcessed / (double)OpenBltFlasher.this.mTotalFileSize);
            if (percent != this.mLastPercent) {
                this.mLastPercent = percent;
                OpenBltFlasher.this.mCallbacks.updateProgress(percent);
            }
        }
    }
}

