/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.maintenance.migration.migrators;

import java.util.Optional;
import javax.management.ObjectName;

public class BooleanField {
    private String fieldName;
    private String trueValue;
    private String falseValue;

    public BooleanField(String fieldName, String trueValue, String falseValue) {
        this.fieldName = fieldName;
        this.falseValue = ObjectName.quote(falseValue);
        this.trueValue = ObjectName.quote(trueValue);
    }

    public String migrateField(String oldTuneFieldValue) {
        if (oldTuneFieldValue.startsWith(ObjectName.quote("true"))) {
            return this.trueValue;
        }
        return this.falseValue;
    }

    public Optional<Boolean> shouldMigrateField(String oldTuneFieldValue, String newTuneFalseValue) {
        boolean isLegacyValue = oldTuneFieldValue.startsWith(ObjectName.quote("true")) || oldTuneFieldValue.startsWith(ObjectName.quote("false"));
        boolean isMigratedValue = oldTuneFieldValue.startsWith(this.trueValue) || oldTuneFieldValue.startsWith(this.falseValue);
        boolean isValidNewerIni = this.falseValue.startsWith(ObjectName.quote(newTuneFalseValue));
        if (!isLegacyValue && !isMigratedValue || !isValidNewerIni) {
            return Optional.empty();
        }
        return Optional.of(isLegacyValue);
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getTrueValue() {
        return this.trueValue;
    }

    public String getFalseValue() {
        return this.falseValue;
    }
}

