/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.maintenance.migration.migrators;

import com.rusefi.maintenance.migration.migrators.DigitMigrator;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Optional;

class IntDigitField {
    private String fieldName;
    private String expectedPreviousDigits;
    private String expectedNewDigits;
    private DigitMigrator migrator;

    public IntDigitField(String fieldName, DigitMigrator migrator, String expectedPreviousDigits, String expectedNewDigits) {
        this.fieldName = fieldName;
        this.migrator = migrator;
        this.expectedPreviousDigits = expectedPreviousDigits;
        this.expectedNewDigits = expectedNewDigits;
    }

    public Optional<Boolean> shouldMigrateField(String previousDigits, String newDigits) {
        boolean isMigratedValue;
        boolean isValidToMigrate = previousDigits.startsWith(this.expectedPreviousDigits) && newDigits.startsWith(this.expectedNewDigits) && !previousDigits.startsWith(newDigits);
        boolean bl = isMigratedValue = previousDigits == newDigits;
        if (!isValidToMigrate && !isMigratedValue) {
            return Optional.empty();
        }
        return Optional.of(isValidToMigrate);
    }

    public String migrateField(String oldTuneFieldValue) {
        Double fieldValue = Double.parseDouble(oldTuneFieldValue);
        Double migratedField = this.migrator.doMigration(fieldValue);
        String migratedValue = String.format(Locale.ROOT, MessageFormat.format("%.{0}f", this.expectedNewDigits), migratedField);
        return migratedValue;
    }

    public String getFieldName() {
        return this.fieldName;
    }
}

