/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.maintenance.migration.migrators;

import com.opensr5.ini.field.IniField;
import com.rusefi.maintenance.migration.TuneMigrationContext;
import com.rusefi.maintenance.migration.migrators.TableValuesConverter;
import com.rusefi.tune.xml.Constant;
import java.util.Locale;
import java.util.Optional;

public enum MapSamplingValuesConverter implements TableValuesConverter
{
    INSTANCE;

    private static final String MAP_SAMPLING_CURVE_FIELD_NAME = "map_samplingAngle";
    private static final Double MAP_SAMPLING_CORRECTION;

    @Override
    public Optional<String[][]> convertTableValues(String[][] prevValues, TuneMigrationContext context) {
        boolean migrationValid;
        String previousSignature = context.getPrevIniFile().getSignature();
        String updatedSignature = context.getUpdatedIniFile().getSignature();
        Constant prevFieldValue = context.getPrevTune().getConstantsAsMap().get(MAP_SAMPLING_CURVE_FIELD_NAME);
        Constant updatedFieldValue = context.getUpdatedTune().getConstantsAsMap().get(MAP_SAMPLING_CURVE_FIELD_NAME);
        Optional<IniField> prevField = context.getPrevIniFile().findIniField(MAP_SAMPLING_CURVE_FIELD_NAME);
        Optional<IniField> updatedField = context.getUpdatedIniFile().findIniField(MAP_SAMPLING_CURVE_FIELD_NAME);
        boolean bl = migrationValid = previousSignature.contains("lts-25jersey") && !updatedSignature.contains("lts-25jersey");
        if (migrationValid && prevField.isPresent() && updatedField.isPresent()) {
            if (prevFieldValue != null && updatedFieldValue != null) {
                int prevValuesRowCount = prevValues.length;
                int prevValuesColumnCount = prevValues[0].length;
                String[][] convertedValues = new String[prevValuesRowCount][prevValuesColumnCount];
                for (int i = 0; i < prevValuesRowCount; ++i) {
                    for (int j = 0; j < prevValuesColumnCount; ++j) {
                        String prevValue = prevValues[i][j];
                        double prevElement = Double.parseDouble(prevValue) - MAP_SAMPLING_CORRECTION;
                        Optional<String> convertedValue = Optional.of(String.format(Locale.US, "%." + updatedFieldValue.getDigits() + "f", prevElement));
                        convertedValues[i][j] = convertedValue.get();
                    }
                }
                return Optional.of(convertedValues);
            }
        } else if (!migrationValid && prevField.isPresent() && updatedField.isPresent()) {
            return Optional.of(prevValues);
        }
        return Optional.empty();
    }

    static {
        MAP_SAMPLING_CORRECTION = 45.0;
    }
}

